/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.annotation.Interceptor;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.events.partition.cache.EntryProcessorEvent;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.RegistrationBehavior;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NamedEventInterceptor<E extends Event<?>>
implements EventDispatcherAwareInterceptor<E> {
    private final EventInterceptor<E> m_interceptor;
    private final String m_sCacheName;
    private final String m_sServiceName;
    private String m_sName;
    private Interceptor.Order m_order;
    private Set<Enum> m_setEventTypes;
    private RegistrationBehavior m_behavior;

    public NamedEventInterceptor(EventInterceptor<E> interceptor) {
        this(null, interceptor);
    }

    public NamedEventInterceptor(String sName, EventInterceptor<E> interceptor) {
        this(sName, interceptor, null);
    }

    public NamedEventInterceptor(String sName, EventInterceptor<E> interceptor, RegistrationBehavior behavior) {
        this(sName, interceptor, null, null, null, behavior);
    }

    public NamedEventInterceptor(String sName, EventInterceptor<E> interceptor, String sCacheName, String sServiceName, Interceptor.Order order, RegistrationBehavior behavior) {
        this(sName, interceptor, sCacheName, sServiceName, order, behavior, null);
    }

    public NamedEventInterceptor(EventInterceptor<E> interceptor, NamedEventInterceptor<E> incptrNamed) {
        this(incptrNamed.getRegisteredName(), interceptor, incptrNamed.getCacheName(), incptrNamed.getServiceName(), incptrNamed.getOrder(), incptrNamed.getBehavior(), incptrNamed.getEventTypes());
    }

    protected NamedEventInterceptor(String sName, EventInterceptor<E> interceptor, String sCacheName, String sServiceName, Interceptor.Order order, RegistrationBehavior behavior, Set<Enum> setEventTypes) {
        Base.azzert(interceptor != null, "interceptor can not be null");
        this.m_sName = sName;
        this.m_interceptor = interceptor;
        this.m_sCacheName = sCacheName != null && sCacheName.isEmpty() ? null : sCacheName;
        this.m_sServiceName = sServiceName != null && sServiceName.isEmpty() ? null : sServiceName;
        this.m_order = order;
        this.m_setEventTypes = setEventTypes == null || setEventTypes.isEmpty() ? null : setEventTypes;
        this.m_behavior = behavior;
        this.ensureInitialized();
    }

    public String getRegisteredName() {
        return this.m_sName;
    }

    public EventInterceptor<E> getInterceptor() {
        return this.m_interceptor;
    }

    public Set<Enum> getEventTypes() {
        return this.m_setEventTypes == null ? null : Collections.unmodifiableSet(this.m_setEventTypes);
    }

    public String getServiceName() {
        return this.m_sServiceName;
    }

    public String getCacheName() {
        return this.m_sCacheName;
    }

    public boolean isFirst() {
        return this.m_order == Interceptor.Order.HIGH;
    }

    public Interceptor.Order getOrder() {
        return this.m_order;
    }

    public RegistrationBehavior getBehavior() {
        return this.m_behavior;
    }

    @Override
    public void onEvent(E event) {
        this.getInterceptor().onEvent(event);
    }

    @Override
    public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
        EventInterceptor<E> interceptor = this.getInterceptor();
        if (interceptor instanceof EventDispatcherAwareInterceptor && this.isAcceptable(dispatcher)) {
            ((EventDispatcherAwareInterceptor)interceptor).introduceEventDispatcher(sIdentifier, dispatcher);
        } else {
            dispatcher.addEventInterceptor(sIdentifier, this);
        }
    }

    public boolean isAcceptable(EventDispatcher dispatcher) {
        boolean fMatch;
        String sServiceName = this.m_sServiceName;
        String sCacheName = this.m_sCacheName;
        String sActualServiceName = null;
        String sActualCacheName = null;
        if (sServiceName == null && sCacheName == null) {
            return true;
        }
        if (dispatcher instanceof PartitionedCacheDispatcher) {
            PartitionedCacheDispatcher bmd = (PartitionedCacheDispatcher)dispatcher;
            sActualServiceName = bmd.getServiceName();
            sActualCacheName = bmd.getCacheName();
        } else if (dispatcher instanceof PartitionedServiceDispatcher) {
            sActualServiceName = ((PartitionedServiceDispatcher)dispatcher).getService().getInfo().getServiceName();
        }
        boolean bl = fMatch = sServiceName == null || sServiceName.equals(sActualServiceName);
        if (fMatch && sCacheName != null && sActualCacheName != null) {
            fMatch = sCacheName.endsWith("*") ? sActualCacheName.startsWith(sCacheName.substring(0, sCacheName.length() - 1)) : sActualCacheName.equals(sCacheName);
        }
        return fMatch;
    }

    public String generateName() {
        String sName = this.m_sName;
        if (sName == null) {
            sName = (this.m_sCacheName == null || this.m_sCacheName.isEmpty() ? "" : this.m_sCacheName + ":") + (this.m_sServiceName == null || this.m_sServiceName.isEmpty() ? "" : this.m_sServiceName + ":") + this.m_interceptor.getClass().getName();
        } else {
            int iPos = sName.lastIndexOf(36);
            if (iPos == -1) {
                sName = sName + "$1";
            } else {
                int nCurrent = 0;
                try {
                    nCurrent = Integer.parseInt(sName.substring(iPos + 1));
                }
                catch (NumberFormatException e) {
                    sName = sName + "$";
                    iPos = sName.length() - 1;
                }
                sName = sName.substring(0, iPos + 1) + ++nCurrent;
            }
        }
        this.m_sName = sName;
        return this.m_sName;
    }

    public String toString() {
        return "<" + this.m_sName + ", " + this.getInterceptor().getClass().getName() + ">";
    }

    public boolean equals(Object o) {
        return this == o || (o instanceof NamedEventInterceptor ? Base.equals(this.m_interceptor, ((NamedEventInterceptor)o).m_interceptor) : o instanceof EventInterceptor && Base.equals(this.m_interceptor, o));
    }

    public int hashCode() {
        return this.m_interceptor != null ? this.m_interceptor.hashCode() : 0;
    }

    protected final void ensureInitialized() {
        Type[] aTypes;
        Map mapTypes;
        EventInterceptor<E> incptr = this.m_interceptor;
        if (incptr == null) {
            throw new IllegalArgumentException("EventInterceptor can not be null");
        }
        String sName = this.m_sName;
        Interceptor.Order order = Interceptor.Order.LOW;
        Class<?> clzIncptr = incptr.getClass();
        Interceptor anno = clzIncptr.getAnnotation(Interceptor.class);
        HashSet setEventTypes = new HashSet(this.m_setEventTypes == null ? Collections.emptySet() : this.m_setEventTypes);
        if (anno != null) {
            this.m_sName = sName == null ? anno.identifier() : sName;
            sName = this.m_sName;
            order = anno.order();
            if (setEventTypes.isEmpty()) {
                setEventTypes.addAll(Arrays.asList(anno.entryEvents()));
                setEventTypes.addAll(Arrays.asList(anno.entryProcessorEvents()));
                setEventTypes.addAll(Arrays.asList(anno.transactionEvents()));
                setEventTypes.addAll(Arrays.asList(anno.transferEvents()));
                setEventTypes.addAll(Arrays.asList(anno.unsolicitedEvents()));
                setEventTypes.addAll(Arrays.asList(anno.cacheLifecycleEvents()));
            }
        }
        Map<Object, Object> map = mapTypes = setEventTypes.isEmpty() ? ClassHelper.getReifiedTypes(clzIncptr, EventInterceptor.class) : Collections.emptyMap();
        if (mapTypes.containsKey("E") && (aTypes = (Type[])mapTypes.get("E"))[0] instanceof Type) {
            Class<?> clzEvent = ClassHelper.getClass(aTypes[0]);
            if (clzEvent == com.tangosol.net.events.partition.Event.class) {
                setEventTypes.addAll(Arrays.asList(TransactionEvent.Type.values()));
                setEventTypes.addAll(Arrays.asList(TransferEvent.Type.values()));
                setEventTypes.addAll(Arrays.asList(UnsolicitedCommitEvent.Type.values()));
            } else if (clzEvent == com.tangosol.net.events.partition.cache.Event.class) {
                setEventTypes.addAll(Arrays.asList(EntryEvent.Type.values()));
                setEventTypes.addAll(Arrays.asList(EntryProcessorEvent.Type.values()));
                setEventTypes.addAll(Arrays.asList(CacheLifecycleEvent.Type.values()));
            } else {
                for (Class<?> clzInner : clzEvent.getDeclaredClasses()) {
                    if (!clzInner.isEnum()) continue;
                    setEventTypes.addAll(Arrays.asList((Enum[])clzInner.getEnumConstants()));
                    break;
                }
            }
        }
        if (!setEventTypes.isEmpty()) {
            this.m_setEventTypes = setEventTypes;
        }
        if (sName == null || sName.isEmpty()) {
            this.generateName();
            this.m_behavior = this.m_behavior == null ? RegistrationBehavior.ALWAYS : this.m_behavior;
        } else if (this.m_behavior == null) {
            this.m_behavior = RegistrationBehavior.FAIL;
        }
        this.m_order = this.m_order == null ? order : this.m_order;
    }
}

