/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.partition.PartitionSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PartitionVersions
implements ExternalizableLite {
    protected PartitionSet m_parts;
    protected Map<Integer, Integer> m_mapVersions;

    public PartitionVersions() {
    }

    public PartitionVersions(PartitionSet parts, int[] anVersions) {
        if (parts.cardinality() != anVersions.length) {
            throw new IllegalArgumentException("Versions array does not match the partition set");
        }
        HashMap<Integer, Integer> mapVersions = new HashMap<Integer, Integer>();
        int iPart = parts.next(0);
        int iVersion = 0;
        while (iPart >= 0) {
            mapVersions.put(iPart, anVersions[iVersion++]);
            iPart = parts.next(iPart + 1);
        }
        this.m_parts = new PartitionSet(parts);
        this.m_mapVersions = mapVersions;
    }

    public PartitionSet getPartitions() {
        return this.m_parts;
    }

    public int getVersion(int nPartition) {
        Integer NVersion = this.m_mapVersions.get(nPartition);
        return NVersion == null ? -1 : NVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionVersions{");
        PartitionSet parts = this.getPartitions();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            sb.append(iPart).append("=").append(this.getVersion(iPart)).append(", ");
            iPart = parts.next(iPart + 1);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        PartitionSet parts = new PartitionSet();
        parts.readExternal(in);
        this.m_parts = parts;
        this.readSupplemental(in, parts);
    }

    public void readSupplemental(DataInput in, PartitionSet parts) throws IOException {
        HashMap<Integer, Integer> mapVersions = new HashMap<Integer, Integer>();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            mapVersions.put(iPart, in.readInt());
            iPart = parts.next(iPart + 1);
        }
        this.m_mapVersions = mapVersions;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        PartitionSet parts = this.m_parts;
        parts.writeExternal(out);
        this.writeSupplemental(out, parts);
    }

    public void writeSupplemental(DataOutput out, PartitionSet parts) throws IOException {
        Map<Integer, Integer> mapVersions = this.m_mapVersions;
        int iPart = parts.next(0);
        while (iPart >= 0) {
            out.writeInt(mapVersions.get(iPart));
            iPart = parts.next(iPart + 1);
        }
    }
}

