/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.coherence.config.Config;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.management.AnnotatedStandardEmitterMBean;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.DistributionManager;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.net.partition.SimpleStrategyMBean;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SubSet;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.comparator.ChainedComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.filter.AllFilter;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.NotFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;

public class SimpleAssignmentStrategy
implements PartitionAssignmentStrategy,
SimpleStrategyMBean {
    protected static final Comparator MEMBERID_COMPARATOR = (o1, o2) -> ((Member)o1).getId() - ((Member)o2).getId();
    protected static final String MSG_NO_RESULT = "There are no distribution analysis results.";
    protected static final String MSG_NO_PENDING = "No distributions are currently scheduled for this service.";
    protected DistributionManager m_manager;
    protected AnalysisContext m_ctxLast;
    protected Set m_setOwnersLast;
    protected Map<Ownership, PartitionSet> m_mapSuggestLast;
    protected JMXPartitionStats m_statsPartition;
    protected boolean m_fRefresh;
    private boolean m_fTrivialDistribution = Config.getBoolean("coherence.distribution.2server", false);

    public DistributionManager getManager() {
        return this.m_manager;
    }

    public AnalysisContext getLastAnalysisContext() {
        return this.m_ctxLast;
    }

    protected void setLastAnalysisContext(AnalysisContext ctx) {
        this.m_ctxLast = ctx;
    }

    public Set getLastOwnershipMembers() {
        return this.m_setOwnersLast;
    }

    protected void setLastOwnershipMembers(Set setOwners) {
        this.m_setOwnersLast = setOwners;
    }

    protected long getMemberJoinDelay() {
        return 1000L;
    }

    protected long getSuggestionDelay() {
        return 60000L;
    }

    protected long getSuggestionCompletionDelay() {
        return 300000L;
    }

    @Override
    public void init(DistributionManager manager) {
        this.m_manager = manager;
        this.registerMBean();
        class ServiceStoppedListener
        implements ServiceListener,
        SynchronousListener {
            ServiceStoppedListener() {
            }

            @Override
            public void serviceStarting(ServiceEvent evt) {
            }

            @Override
            public void serviceStarted(ServiceEvent evt) {
            }

            @Override
            public void serviceStopping(ServiceEvent evt) {
            }

            @Override
            public void serviceStopped(ServiceEvent evt) {
                SimpleAssignmentStrategy.this.unregisterMBean();
            }
        }
        manager.getService().addServiceListener(new ServiceStoppedListener());
    }

    @Override
    public void analyzeOrphans(Map<Member, PartitionSet> mapConstraints) {
        AnalysisContext ctx = this.instantiateAnalysisContext();
        int cPartitions = this.getPartitionCount();
        PartitionSet partsLost = new PartitionSet(cPartitions);
        Object[] aMember = ctx.getOwnershipMembersList();
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            int iPartition;
            Ownership owners = ctx.getPartitionOwnership(iPart);
            int nOwner = owners.getPrimaryOwner();
            if (nOwner != 0) continue;
            Comparator comparator = SimpleAssignmentStrategy.chainComparators(ctx.instantiateStrengthComparator(owners), ctx.instantiateLoadComparator(true), ctx.instantiateDefaultComparator());
            int cMembers = SimpleAssignmentStrategy.filterSort(aMember, comparator, arg_0 -> SimpleAssignmentStrategy.lambda$analyzeOrphans$887e5f3c$1(mapConstraints, iPartition = iPart, arg_0));
            if (cMembers == 0) {
                partsLost.add(iPart);
                cMembers = SimpleAssignmentStrategy.filterSort(aMember, comparator, AlwaysFilter.INSTANCE);
            }
            if (cMembers <= 0) continue;
            ctx.transitionPartition(iPart, 0, null, (Member)aMember[0]);
        }
        ctx.suggestDistribution();
        if (!partsLost.isEmpty()) {
            this.emitLossNotification(partsLost);
            ctx.setOrphanedPartitions(partsLost);
        }
        ctx.setAnalysisDelay(0L);
        this.setLastAnalysisContext(ctx);
    }

    @Override
    public long analyzeDistribution() {
        AnalysisContext ctx = this.instantiateAnalysisContext();
        ctx.copyTransients(this.getLastAnalysisContext());
        long cDelay = ctx.calculateAnalysisDelay();
        if (cDelay <= 0L) {
            cDelay = this.analyzeDistribution(ctx);
            ctx.resetTransients();
        }
        this.setLastAnalysisContext(ctx);
        this.setLastOwnershipMembers(ctx.getOwnershipMembers());
        this.m_fRefresh = true;
        return cDelay;
    }

    protected long analyzeDistribution(AnalysisContext ctx) {
        this.primeDistribution(ctx);
        long cSuggestDelay = this.analyze(ctx);
        ctx.suggestDistribution();
        ctx.setCompletedTime(Base.getSafeTimeMillis());
        return cSuggestDelay;
    }

    protected void primeDistribution(AnalysisContext ctx) {
        Member memberCoordinator = this.getManager().getService().getCluster().getLocalMember();
        if (!ctx.isInitialDistribution(memberCoordinator)) {
            return;
        }
        if (ctx.getOwnershipMembers().size() <= 2 || ctx.getActualBackupCount() != 1) {
            return;
        }
        Member memberStrong = null;
        for (Member member : ctx.getOwnershipMembers()) {
            if (!ctx.isStrong(memberCoordinator, member)) continue;
            memberStrong = member;
            break;
        }
        assert (memberStrong != null);
        ctx.primeDistribution(memberCoordinator, memberStrong);
        this.analyze(ctx);
        ctx.initialize();
    }

    protected long analyze(AnalysisContext ctx) {
        long cSuggestDelay = this.getSuggestionDelay();
        this.checkLeaving(ctx);
        this.validateBackups(ctx);
        if (this.m_fTrivialDistribution && this.checkSimpleDistribution(ctx)) {
            return cSuggestDelay;
        }
        this.checkPrimaryBalance(ctx);
        BackupStrength strengthOrig = null;
        if (ctx.getActualBackupCount() > 0) {
            this.checkEndangered(ctx);
            int cIters = 0;
            int cIterMax = 10;
            int cVariancePrev = this.getVariance(ctx, false);
            while (true) {
                int cChanges = 0;
                cChanges += this.checkBackupStrong(ctx);
                if ((cChanges += this.checkBackupBalance(ctx)) == 0) {
                    cChanges = this.checkBackupOverloaded(ctx);
                }
                if (cChanges == 0) break;
                int cVarianceCur = this.getVariance(ctx, false);
                if (cIters++ > cIterMax && cVarianceCur >= cVariancePrev) {
                    if (strengthOrig == null) {
                        strengthOrig = ctx.getBackupStrength();
                        this.checkBackupOverloaded(ctx);
                    } else {
                        CacheFactory.log("Failed to find a partition assignment to satisfy " + strengthOrig + " among the member-set " + ctx.getOwnershipMembers() + "; weakening the backup-strength", 1);
                        ctx.setBackupStrength(strengthOrig.getWeaker());
                        strengthOrig = null;
                        cSuggestDelay = 1000L;
                    }
                    cIters = 0;
                }
                cVariancePrev = cVarianceCur;
            }
        }
        return cSuggestDelay;
    }

    protected boolean checkSimpleDistribution(AnalysisContext ctx) {
        DistributionManager manager = this.getManager();
        if (manager.getOwnershipMembers().size() > 2 || this.getBackupCount() == 0) {
            this.m_fTrivialDistribution = false;
            return false;
        }
        if (!manager.getOwnershipLeavingMembers().isEmpty() || ctx.getOwnershipMembers().size() == 1) {
            return false;
        }
        Member member1 = manager.getService().getOwnershipSenior();
        Member member2 = null;
        for (Member member : ctx.getOwnershipMembers()) {
            if (member == member1) continue;
            member2 = member;
            break;
        }
        if (!ctx.getOwnedPartitions(member2, 0).isEmpty()) {
            this.m_fTrivialDistribution = false;
            return false;
        }
        PartitionSet partsBackup2 = ctx.getOwnedPartitions(member2, 1);
        if (!partsBackup2.isFull()) {
            PartitionSet parts = new PartitionSet(partsBackup2);
            parts.invert();
            int iPart = parts.next(0);
            while (iPart >= 0) {
                ctx.transitionPartition(iPart, 1, member1, member2);
                iPart = parts.next(iPart + 1);
            }
        }
        return true;
    }

    @Override
    public String getDescription() {
        AnalysisContext ctxLast = this.getLastAnalysisContext();
        StringBuilder sb = new StringBuilder();
        if (ctxLast != null) {
            sb.append("Fair-Share=").append(ctxLast.getFairShare(true)).append("(primary) ").append(ctxLast.getFairShare(false)).append("(backup)").append(", ").append("Target Backup-Strength=").append(ctxLast.getBackupStrength().getDescription());
        }
        return sb.toString();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '{' + this.getDescription() + '}';
    }

    protected void checkLeaving(AnalysisContext ctx) {
        Set<Member> setLeaving = this.getManager().getOwnershipLeavingMembers();
        Member[] aOwners = ctx.getOwnershipMembersList();
        int cBackupsConfig = this.getBackupCount();
        if (setLeaving.isEmpty()) {
            return;
        }
        for (Member memberLeaving : setLeaving) {
            PartitionSet partsPrime = ctx.getOwnedPartitions(memberLeaving, 0);
            int iPart = partsPrime.next(0);
            while (iPart >= 0) {
                block6: {
                    Ownership owners = ctx.getPartitionOwnership(iPart);
                    for (int iStore = cBackupsConfig; iStore >= 1; --iStore) {
                        int nOwner = owners.getOwner(iStore);
                        if (nOwner == 0) continue;
                        Member memberTo = this.getMember(nOwner);
                        ctx.transitionPartition(iPart, 0, memberLeaving, memberTo);
                        ctx.transitionPartition(iPart, iStore, memberTo, null);
                        break block6;
                    }
                    Arrays.sort(aOwners, ctx.instantiateLoadComparator(true));
                    ctx.transitionPartition(iPart, 0, memberLeaving, aOwners[0]);
                }
                iPart = partsPrime.next(iPart + 1);
            }
            for (int iStore = 1; iStore <= cBackupsConfig; ++iStore) {
                PartitionSet parts = ctx.getOwnedPartitions(memberLeaving, iStore);
                int iPart2 = parts.next(0);
                while (iPart2 >= 0) {
                    ctx.transitionPartition(iPart2, iStore, memberLeaving, null);
                    iPart2 = parts.next(iPart2 + 1);
                }
            }
        }
    }

    protected void validateBackups(AnalysisContext ctx) {
        int cPartitions = this.getPartitionCount();
        int cBackupsActual = ctx.getActualBackupCount();
        int cBackupsConfig = this.getBackupCount();
        if (cBackupsConfig != cBackupsActual) {
            for (int iPart = 0; iPart < cPartitions; ++iPart) {
                Ownership owners = ctx.getPartitionOwnership(iPart);
                int iStoreValid = 1;
                for (int iStore = 1; iStore <= cBackupsConfig; ++iStore) {
                    int nBackupOwner = owners.getOwner(iStore);
                    if (nBackupOwner == 0) continue;
                    if (iStore > iStoreValid) {
                        Member memberThis = this.getMember(nBackupOwner);
                        ctx.transitionPartition(iPart, iStoreValid, null, memberThis);
                        ctx.transitionPartition(iPart, iStore, memberThis, null);
                    }
                    ++iStoreValid;
                }
            }
        }
    }

    protected void checkPrimaryBalance(AnalysisContext ctx) {
        int cChanges;
        Object[] aMembersOverload = ctx.getOwnershipMembersList();
        Member[] aMembersTarget = (Member[])aMembersOverload.clone();
        do {
            cChanges = 0;
            int cOverloaded = SimpleAssignmentStrategy.filterSort(aMembersOverload, new InverseComparator(ctx.instantiateLoadComparator(true)), ctx.instantiateOverloadedFilter(true));
            for (int i = 0; i < cOverloaded; ++i) {
                Object memberFrom = aMembersOverload[i];
                PartitionSet partsAll = new PartitionSet(ctx.getOwnedPartitions((Member)memberFrom, 0));
                PartitionSet partsOrphaned = ctx.collectOrphaned(partsAll);
                partsAll.remove(partsOrphaned);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsOrphaned, aMembersTarget);
                PartitionSet partsEndangered = ctx.collectEndangered(partsAll);
                partsAll.remove(partsEndangered);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsEndangered, aMembersTarget);
                PartitionSet partsWeak = ctx.collectWeak(partsAll);
                partsAll.remove(partsWeak);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsWeak, aMembersTarget);
                cChanges += this.doBalancePrimary(ctx, (Member)memberFrom, partsAll, aMembersTarget);
            }
        } while (cChanges > 0);
    }

    protected int doBalancePrimary(AnalysisContext ctx, Member memberFrom, PartitionSet parts, Member[] aMembersTarget) {
        int cFairShare = ctx.getFairShare(true);
        int cLoadMemberFrom = ctx.getMemberLoad(memberFrom, true);
        int cChanges = 0;
        int iPart = parts.next(0);
        while (iPart >= 0 && cLoadMemberFrom >= cFairShare) {
            int cUnderloaded;
            Ownership owners = (Ownership)ctx.getPartitionOwnership(iPart).clone();
            int cLoad = ctx.getPartitionLoad(iPart, true);
            owners.setOwner(0, 0);
            try {
                cUnderloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, SimpleAssignmentStrategy.chainComparators(ctx.instantiateStrengthComparator(owners), ctx.instantiateLoadComparator(true), ctx.instantiateDefaultComparator()), ctx.instantiateUnderloadedFilter(true));
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder("Member array: [");
                for (Member member : aMembersTarget) {
                    sb.append(member == null ? "null" : Integer.valueOf(member.getId())).append(',');
                }
                sb.replace(sb.length() - 1, sb.length(), "]").append("\nPartition Id: ").append(iPart);
                CacheFactory.log(sb.toString(), 1);
                throw Base.ensureRuntimeException(t);
            }
            for (int i = 0; i < cUnderloaded; ++i) {
                Member memberTo = aMembersTarget[i];
                int cLoadMemberTo = ctx.getMemberLoad(memberTo, true);
                if (cLoadMemberTo + cLoad >= cLoadMemberFrom) continue;
                ctx.transitionPartition(iPart, 0, memberFrom, memberTo);
                cLoadMemberFrom -= cLoad;
                ++cChanges;
                break;
            }
            iPart = parts.next(iPart + 1);
        }
        return cChanges;
    }

    protected void checkEndangered(AnalysisContext ctx) {
        int cBackups = ctx.getActualBackupCount();
        int cPartitions = this.getPartitionCount();
        Object[] aMember = ctx.getOwnershipMembersList();
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            Ownership owners = ctx.getPartitionOwnership(iPart);
            Member memberPrimary = this.getMember(owners.getPrimaryOwner());
            Base.azzert(memberPrimary != null);
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                if (owners.getOwner(iStore) != 0) continue;
                int cSafe = SimpleAssignmentStrategy.filterSort(aMember, SimpleAssignmentStrategy.chainComparators(ctx.instantiateStrengthComparator(owners), ctx.instantiateLoadComparator(false), ctx.instantiateDefaultComparator()), ctx.instantiateNotOwnedFilter(owners));
                Base.azzert(cSafe > 0, "Failed to find a member to receive backup(" + iStore + ") transfer of endangered partition " + iPart + ", " + owners);
                ctx.transitionPartition(iPart, iStore, null, (Member)aMember[0]);
            }
        }
    }

    protected int checkBackupStrong(AnalysisContext ctx) {
        int cPartitions = this.getPartitionCount();
        int cBackups = ctx.getActualBackupCount();
        int cChanges = 0;
        Object[] aMembersTarget = ctx.getOwnershipMembersList();
        for (int iPart = 0; iPart < cPartitions; ++iPart) {
            for (int iStore = 1; !ctx.isPartitionStrong(iPart) && iStore <= cBackups; ++iStore) {
                int cUnderloaded;
                Ownership owners = (Ownership)ctx.getPartitionOwnership(iPart).clone();
                Member memberFrom = this.getMember(owners.getOwner(iStore));
                owners.setOwner(iStore, 0);
                int cCandidate = SimpleAssignmentStrategy.filterArray(aMembersTarget, ctx.instantiateSafetyFilter(owners, iStore));
                if (cCandidate == 0) {
                    cCandidate = aMembersTarget.length;
                }
                if ((cUnderloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, cCandidate, SimpleAssignmentStrategy.chainComparators(ctx.instantiateStrengthComparator(owners), ctx.instantiateLoadComparator(false), ctx.instantiateDefaultComparator()), new AllFilter(new Filter[]{ctx.instantiateUnderloadedFilter(false), ctx.instantiateNotOwnedFilter(owners)}))) > 0) {
                    ctx.transitionPartition(iPart, iStore, memberFrom, (Member)aMembersTarget[0]);
                    ++cChanges;
                    continue;
                }
                int cOverloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, cCandidate, SimpleAssignmentStrategy.chainComparators(ctx.instantiateLoadComparator(false), ctx.instantiateStrengthComparator(owners), ctx.instantiateDefaultComparator()), new AllFilter(new Filter[]{ctx.instantiateOverloadedFilter(false), ctx.instantiateNotOwnedFilter(owners)}));
                if (cOverloaded <= 0) continue;
                ctx.transitionPartition(iPart, iStore, memberFrom, (Member)aMembersTarget[0]);
                ++cChanges;
            }
        }
        return cChanges;
    }

    protected int checkBackupBalance(AnalysisContext ctx) {
        int cBackups = ctx.getActualBackupCount();
        Object[] aMembersOverload = ctx.getOwnershipMembersList();
        Object[] aMembersTarget = (Member[])aMembersOverload.clone();
        int cFairShare = ctx.getFairShare(false);
        int cChanges = 0;
        int cOverloaded = SimpleAssignmentStrategy.filterSort(aMembersOverload, new InverseComparator(ctx.instantiateLoadComparator(false)), ctx.instantiateOverloadedFilter(false));
        block0: for (int i = 0; i < cOverloaded; ++i) {
            Object memberFrom = aMembersOverload[i];
            int cLoadMemberFrom = ctx.getMemberLoad((Member)memberFrom, false);
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                PartitionSet parts = ctx.getOwnedPartitions((Member)memberFrom, iStore);
                int iPart = parts.next(0);
                while (iPart >= 0) {
                    int cLoad = ctx.getPartitionLoad(iPart, false);
                    Ownership owners = (Ownership)ctx.getPartitionOwnership(iPart).clone();
                    owners.setOwner(iStore, 0);
                    int cUnderloaded = SimpleAssignmentStrategy.filterSort(aMembersTarget, SimpleAssignmentStrategy.chainComparators(ctx.instantiateLoadComparator(false), ctx.instantiateStrengthComparator(owners), ctx.instantiateDefaultComparator()), new AllFilter(new Filter[]{ctx.instantiateSafetyFilter(owners, iStore), ctx.instantiateUnderloadedFilter(false), ctx.instantiateNotOwnedFilter(owners)}));
                    for (int j = 0; j < cUnderloaded; ++j) {
                        Object memberTo = aMembersTarget[j];
                        int cLoadMemberTo = ctx.getMemberLoad((Member)memberTo, false);
                        if (cLoadMemberTo + cLoad >= cLoadMemberFrom) continue;
                        ctx.transitionPartition(iPart, iStore, (Member)memberFrom, (Member)memberTo);
                        cLoadMemberFrom -= cLoad;
                        ++cChanges;
                        break;
                    }
                    if (cLoadMemberFrom < cFairShare) continue block0;
                    iPart = parts.next(iPart + 1);
                }
            }
        }
        return cChanges;
    }

    protected int checkBackupOverloaded(AnalysisContext ctx) {
        Member[] aMembers = (Member[])Base.randomize(ctx.getOwnershipMembersList());
        int cFairShareBackup = ctx.getFairShare(false);
        int cBackup = this.getBackupCount();
        int cOverload = 0;
        Member memberOverloaded = null;
        for (int i = 0; i < aMembers.length; ++i) {
            Member memberFrom = aMembers[i];
            int cBackupLoad = ctx.getMemberLoad(memberFrom, false);
            int cLoad = cBackupLoad - cFairShareBackup;
            if (cLoad <= 0) continue;
            cOverload += cLoad;
            memberOverloaded = memberFrom;
            break;
        }
        if (memberOverloaded != null) {
            PartitionSet partsBackup = new PartitionSet(this.getPartitionCount());
            for (int iStore = 1; iStore <= cBackup; ++iStore) {
                partsBackup.add(ctx.getOwnedPartitions(memberOverloaded, iStore));
            }
            block2: for (int i = 0; i < aMembers.length; ++i) {
                Member memberTo = aMembers[i];
                if (memberOverloaded == memberTo) continue;
                PartitionSet partOwned = ctx.getOwnedPartitions(memberTo, 0);
                for (int iStore = 1; iStore <= cBackup; ++iStore) {
                    if (partOwned.intersects(partsBackup) || !ctx.isStrong(memberOverloaded, memberTo)) continue;
                    ctx.transitionPartition(partsBackup.next(0), iStore, memberOverloaded, memberTo);
                    break block2;
                }
            }
        }
        return cOverload;
    }

    protected Member getMember(int nMemberId) {
        return this.getManager().getMember(nMemberId);
    }

    protected int getVariance(AnalysisContext ctx, boolean fPrimary) {
        Member[] aMembers = ctx.getOwnershipMembersList();
        int cMembers = aMembers.length;
        Arrays.sort(aMembers, 0, cMembers, SimpleAssignmentStrategy.chainComparators(ctx.instantiateLoadComparator(fPrimary), ctx.instantiateDefaultComparator()));
        return ctx.getMemberLoad(aMembers[cMembers - 1], fPrimary) - ctx.getMemberLoad(aMembers[0], fPrimary);
    }

    protected static Comparator chainComparators(Comparator comp1, Comparator comp2) {
        return new ChainedComparator(comp1, comp2);
    }

    protected static Comparator chainComparators(Comparator comp1, Comparator comp2, Comparator comp3) {
        return new ChainedComparator(comp1, comp2, comp3);
    }

    protected static int filterSort(Object[] ao, Comparator comparator, Filter filter) {
        return SimpleAssignmentStrategy.filterSort(ao, ao.length, comparator, filter);
    }

    protected static int filterSort(Object[] ao, int cElems, Comparator comparator, Filter filter) {
        if ((cElems = SimpleAssignmentStrategy.filterArray(ao, cElems, filter)) > 1) {
            Arrays.sort(ao, 0, cElems, comparator);
        }
        return cElems;
    }

    protected static int filterArray(Object[] ao, Filter filter) {
        return SimpleAssignmentStrategy.filterArray(ao, ao.length, filter);
    }

    protected static int filterArray(Object[] ao, int cElems, Filter filter) {
        int iShift = 0;
        for (int i = 0; i < cElems; ++i) {
            if (!filter.evaluate(ao[i])) {
                ++iShift;
                continue;
            }
            if (iShift <= 0) continue;
            Object oTemp = ao[i - iShift];
            ao[i - iShift] = ao[i];
            ao[i] = oTemp;
        }
        return cElems - iShift;
    }

    @Override
    public int getPartitionCount() {
        return this.getManager().getService().getPartitionCount();
    }

    @Override
    public int getBackupCount() {
        return this.getManager().getService().getBackupCount();
    }

    @Override
    public int getServiceNodeCount() {
        return this.getManager().getService().getOwnershipEnabledMembers().size();
    }

    @Override
    public int getServiceMachineCount() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? 0 : ctx.getBackupStrength().getMachineCount();
    }

    @Override
    public int getServiceRackCount() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? 0 : ctx.getBackupStrength().getRackCount();
    }

    @Override
    public int getServiceSiteCount() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? 0 : ctx.getBackupStrength().getSiteCount();
    }

    @Override
    public String getHAStatus() {
        try {
            return (String)ClassHelper.invoke(this.getManager().getService(), "getBackupStrengthName", ClassHelper.VOID_PARAMS);
        }
        catch (Exception e) {
            return "<unknown>";
        }
    }

    @Override
    public int getHAStatusCode() {
        try {
            return (Integer)ClassHelper.invoke(this.getManager().getService(), "getBackupStrength", ClassHelper.VOID_PARAMS);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public String getHATarget() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? MSG_NO_RESULT : ctx.getBackupStrength().getDescription();
    }

    @Override
    public int getFairShareBackup() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? 0 : ctx.getFairShare(false);
    }

    @Override
    public int getFairSharePrimary() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? 0 : ctx.getFairShare(true);
    }

    @Override
    public String getStrategyName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Date getLastAnalysisTime() {
        AnalysisContext ctx = this.getLastAnalysisContext();
        return ctx == null ? new Date(0L) : new Date(ctx.getCompletedTime());
    }

    @Override
    public int getCoordinatorId() {
        try {
            return this.getManager().getService().getCluster().getLocalMember().getId();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public int getRemainingDistributionCount() {
        int cScheduled = 0;
        Map<Member, PartitionSet[]> mapScheduled = this.collectScheduledDistributions();
        for (Map.Entry<Member, PartitionSet[]> entry : mapScheduled.entrySet()) {
            for (PartitionSet parts : entry.getValue()) {
                cScheduled += parts == null ? 0 : parts.cardinality();
            }
        }
        return cScheduled;
    }

    @Override
    public long getAveragePartitionSizeKB() {
        return this.updateCompositeStats().getAveragePartitionSize();
    }

    @Override
    public long getMaxPartitionSizeKB() {
        return this.updateCompositeStats().getMaxPartitionSize();
    }

    @Override
    public long getMaxStorageSizeKB() {
        return this.updateCompositeStats().getMaxStorageSize();
    }

    @Override
    public long getAverageStorageSizeKB() {
        return this.updateCompositeStats().getAverageStorageSize();
    }

    @Override
    public int getMaxLoadNodeId() {
        return this.updateCompositeStats().getMaxLoadNodeId();
    }

    protected JMXPartitionStats updateCompositeStats() {
        JMXPartitionStats stats = this.m_statsPartition;
        if (stats == null || this.m_fRefresh) {
            if (stats == null) {
                this.m_statsPartition = stats = new JMXPartitionStats();
            }
            stats.calculateJMXPartitionStats();
            this.m_fRefresh = false;
        }
        return stats;
    }

    @Override
    public String reportScheduledDistributions(boolean fVerbose) {
        Map<Member, PartitionSet[]> mapScheduled = this.collectScheduledDistributions();
        if (mapScheduled.isEmpty()) {
            return this.getLastAnalysisContext() == null ? MSG_NO_RESULT : MSG_NO_PENDING;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Partition Distributions Scheduled for Service \"").append(this.getManager().getService().getInfo().getServiceName()).append("\"\n");
        HashMap<String, ArrayList<Member>> mapByMachine = new HashMap<String, ArrayList<Member>>();
        for (Member member : mapScheduled.keySet()) {
            String sMachine = member.getMachineName();
            sMachine = sMachine == null ? Integer.toString(member.getMachineId()) : sMachine;
            ArrayList<Member> listMembers = (ArrayList<Member>)mapByMachine.get(sMachine);
            if (listMembers == null) {
                listMembers = new ArrayList<Member>();
                mapByMachine.put(sMachine, listMembers);
            }
            listMembers.add(member);
        }
        for (Map.Entry entry : mapByMachine.entrySet()) {
            sb.append("\nMachine ").append((String)entry.getKey());
            for (Member member : (List)entry.getValue()) {
                sb.append("\n    Member ").append(member.getId()).append(":");
                int cBackups = this.getBackupCount();
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    PartitionSet partsScheduled = mapScheduled.get(member)[iStore];
                    if (partsScheduled == null) continue;
                    SortedMap<Integer, PartitionSet> mapOwners = this.splitByOwner(partsScheduled);
                    int cScheduled = partsScheduled.cardinality();
                    if (cScheduled <= 0) continue;
                    String sStore = iStore == 0 ? " Primary" : " Backup" + (cBackups == 1 ? "" : "[" + iStore + "]");
                    sb.append("\n        - scheduled to receive ").append(cScheduled).append(sStore).append(" partitions:");
                    for (Map.Entry entrySource : mapOwners.entrySet()) {
                        Integer IOwner = (Integer)entrySource.getKey();
                        PartitionSet parts = (PartitionSet)entrySource.getValue();
                        sb.append("\n           -- ").append(parts.cardinality()).append(" from member ").append(IOwner);
                        if (!fVerbose) continue;
                        sb.append(": ").append(parts);
                    }
                }
            }
        }
        return sb.toString();
    }

    protected void registerMBean() {
        PartitionedService service = this.getManager().getService();
        Registry registry = service.getCluster().getManagement();
        if (registry != null) {
            try {
                registry.register(registry.ensureGlobalName(this.makeMBeanName(service)), new AnnotatedStandardEmitterMBean(this, SimpleStrategyMBean.class));
            }
            catch (NotCompliantMBeanException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    protected String makeMBeanName(PartitionedService service) {
        return "type=PartitionAssignment,service=" + service.getInfo().getServiceName() + "," + "responsibility=" + "DistributionCoordinator";
    }

    protected void unregisterMBean() {
        PartitionedService service = this.getManager().getService();
        Registry registry = service.getCluster().getManagement();
        if (registry != null) {
            registry.unregister(registry.ensureGlobalName(this.makeMBeanName(service)));
        }
    }

    protected void emitLossNotification(PartitionSet partsLost) {
        PartitionedService service = this.getManager().getService();
        Registry registry = service.getCluster().getManagement();
        if (registry != null) {
            Member memberThis = service.getCluster().getLocalMember();
            Notification note = new Notification("partition.lost", (Object)String.valueOf(memberThis), -1L, partsLost.cardinality() + " partitions have been lost");
            note.setUserData(partsLost.toString());
            registry.getNotificationManager().trigger(registry.ensureGlobalName(this.makeMBeanName(service)), note);
        }
    }

    protected Map<Member, PartitionSet[]> collectScheduledDistributions() {
        Map<Ownership, PartitionSet> mapSuggestion = this.m_mapSuggestLast;
        if (mapSuggestion == null || mapSuggestion.isEmpty()) {
            return Collections.emptyMap();
        }
        int cBackups = this.getBackupCount();
        int cPartitions = this.getPartitionCount();
        ServiceInfo serviceInfo = this.getManager().getService().getInfo();
        HashMap<Member, PartitionSet[]> mapScheduled = new HashMap<Member, PartitionSet[]>();
        for (Map.Entry<Ownership, PartitionSet> entry : mapSuggestion.entrySet()) {
            Ownership ownersSuggest = entry.getKey();
            PartitionSet partsSuggest = entry.getValue();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                PartitionSet partsMember;
                PartitionSet partsScheduled;
                Member member = serviceInfo.getServiceMember(ownersSuggest.getOwner(iStore));
                if (member == null || (partsScheduled = this.getUnownedPartitions(partsSuggest, member.getId())).isEmpty()) continue;
                PartitionSet[] aParts = (PartitionSet[])mapScheduled.get(member);
                if (aParts == null) {
                    aParts = new PartitionSet[cBackups + 1];
                    mapScheduled.put(member, aParts);
                }
                if ((partsMember = aParts[iStore]) == null) {
                    aParts[iStore] = partsMember = new PartitionSet(cPartitions);
                }
                partsMember.add(partsScheduled);
            }
        }
        return mapScheduled;
    }

    protected PartitionSet getUnownedPartitions(PartitionSet parts, int nMember) {
        PartitionSet partsUnowned = new PartitionSet(parts);
        int cBackups = this.getBackupCount();
        DistributionManager mgr = this.getManager();
        int i = parts.next(0);
        while (i >= 0) {
            Ownership owners = mgr.getPartitionOwnership(i);
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                if (owners.getOwner(iStore) != nMember) continue;
                partsUnowned.remove(i);
                break;
            }
            i = parts.next(i + 1);
        }
        return partsUnowned;
    }

    protected SortedMap<Integer, PartitionSet> splitByOwner(PartitionSet parts) {
        TreeMap<Integer, PartitionSet> mapByOwner = new TreeMap<Integer, PartitionSet>();
        int cPartitions = this.getPartitionCount();
        DistributionManager mgr = this.getManager();
        int nPid = parts.next(0);
        while (nPid >= 0) {
            Ownership ownersCurrent = mgr.getPartitionOwnership(nPid);
            int nOwnerCurrent = ownersCurrent.getPrimaryOwner();
            if (nOwnerCurrent != 0) {
                Integer IOwnerCurrent = nOwnerCurrent;
                PartitionSet partsOwned = (PartitionSet)mapByOwner.get(IOwnerCurrent);
                if (partsOwned == null) {
                    partsOwned = new PartitionSet(cPartitions);
                    mapByOwner.put(IOwnerCurrent, partsOwned);
                }
                partsOwned.add(nPid);
            }
            nPid = parts.next(nPid + 1);
        }
        return mapByOwner;
    }

    public LoadCalculator instantiateLoadCalculator(boolean fPrimary) {
        return new SimpleLoadCalculator();
    }

    public AnalysisContext instantiateAnalysisContext() {
        return new AnalysisContext();
    }

    private static /* synthetic */ boolean lambda$analyzeOrphans$887e5f3c$1(Map mapConstraints, int iPartition, Object member) {
        PartitionSet parts = (PartitionSet)mapConstraints.get(member);
        return parts != null && parts.contains(iPartition);
    }

    protected static class BackupStrength {
        protected static final int NODE_SAFE = 1;
        protected static final int MACHINE_SAFE = 2;
        protected static final int RACK_SAFE = 3;
        protected static final int SITE_SAFE = 4;
        protected int m_nStrength;
        protected Set m_setSites;
        protected Set m_setRacks;
        protected Set m_setMachines;

        protected BackupStrength(int nStrength, Set setSites, Set setRacks, Set setMachines) {
            this.m_nStrength = nStrength;
            this.m_setSites = setSites;
            this.m_setRacks = setRacks;
            this.m_setMachines = setMachines;
        }

        protected BackupStrength getWeaker() {
            int nStrength = this.m_nStrength;
            if (nStrength == 1) {
                throw new IllegalStateException("NODE_SAFE is the weakest BackupStrength");
            }
            return new BackupStrength(nStrength - 1, this.m_setSites, this.m_setRacks, this.m_setMachines);
        }

        protected boolean isStrong(Member member1, Member member2) {
            switch (this.m_nStrength) {
                default: {
                    return member1.getId() != member2.getId();
                }
                case 2: {
                    return member1.getMachineId() != member2.getMachineId();
                }
                case 3: {
                    return !Base.equals(member1.getRackName(), member2.getRackName());
                }
                case 4: 
            }
            return !Base.equals(member1.getSiteName(), member2.getSiteName());
        }

        public int getSiteCount() {
            return this.m_setSites.size();
        }

        public int getRackCount() {
            return this.m_setRacks.size();
        }

        public int getMachineCount() {
            return this.m_setMachines.size();
        }

        public String getDescription() {
            switch (this.m_nStrength) {
                default: {
                    return "ENDANGERED";
                }
                case 1: {
                    return "NODE-SAFE";
                }
                case 2: {
                    return "MACHINE-SAFE";
                }
                case 3: {
                    return "RACK-SAFE";
                }
                case 4: 
            }
            return "SITE-SAFE";
        }

        public String toString() {
            return "BackupStrength{" + this.getDescription() + "}";
        }
    }

    protected class AnalysisContext {
        protected LoadCalculator m_calculatorPrimary;
        protected LoadCalculator m_calculatorBackup;
        protected Map<Member, PartitionSet[]> m_mapOwnedPartitions = new HashMap<Member, PartitionSet[]>();
        protected Ownership[] m_aOwners = new Ownership[SimpleAssignmentStrategy.this.getPartitionCount()];
        protected PartitionSet m_partsUpdated;
        protected PartitionSet m_partsOrphaned;
        protected BackupStrength m_strength;
        protected int m_cBackupActual;
        protected int m_cFairSharePrimary;
        protected int m_cFairShareBackup;
        protected Set m_setOwnershipMembers;
        protected Member[] m_aOwnershipMembers;
        protected long m_ldtCompleted;
        protected long m_cDelay = -1L;

        public AnalysisContext() {
            this.initialize();
        }

        protected PartitionSet getUpdatedPartitions() {
            return this.m_partsUpdated;
        }

        protected BackupStrength getBackupStrength() {
            return this.m_strength;
        }

        protected void setBackupStrength(BackupStrength strength) {
            this.m_strength = strength;
        }

        protected Set<Member> getOwnershipMembers() {
            return this.m_setOwnershipMembers;
        }

        protected Member[] getOwnershipMembersList() {
            return this.m_aOwnershipMembers;
        }

        public LoadCalculator getPrimaryLoadCalculator() {
            return this.m_calculatorPrimary;
        }

        public LoadCalculator getBackupLoadCalculator() {
            return this.m_calculatorBackup;
        }

        protected int getActualBackupCount() {
            return this.m_cBackupActual;
        }

        public long getCompletedTime() {
            return this.m_ldtCompleted;
        }

        protected void setCompletedTime(long ldt) {
            this.m_ldtCompleted = ldt;
        }

        protected PartitionSet getOrphanedPartitions() {
            return this.m_partsOrphaned;
        }

        protected void setOrphanedPartitions(PartitionSet parts) {
            this.m_partsOrphaned = parts;
        }

        protected long getAnalysisDelay() {
            return this.m_cDelay;
        }

        protected void setAnalysisDelay(long cDelay) {
            this.m_cDelay = cDelay;
        }

        protected void resetTransients() {
            this.setOrphanedPartitions(null);
            this.setAnalysisDelay(-1L);
        }

        protected void initialize() {
            DistributionManager manager = SimpleAssignmentStrategy.this.getManager();
            Set<Member> setOwners = manager.getOwnershipMembers();
            Set<Member> setLeaving = manager.getOwnershipLeavingMembers();
            if (!setLeaving.isEmpty()) {
                setOwners = new SubSet<Member>(setOwners);
                setOwners.removeAll(setLeaving);
            }
            this.m_setOwnershipMembers = setOwners;
            this.m_aOwnershipMembers = setOwners.toArray(new Member[setOwners.size()]);
            this.m_cBackupActual = Math.min(SimpleAssignmentStrategy.this.getBackupCount(), setOwners.size() - 1);
            this.m_strength = this.instantiateBackupStrength(setOwners);
            this.m_calculatorPrimary = SimpleAssignmentStrategy.this.instantiateLoadCalculator(true);
            this.m_calculatorBackup = SimpleAssignmentStrategy.this.instantiateLoadCalculator(false);
            this.m_cFairSharePrimary = this.calculateFairShare(true);
            this.m_cFairShareBackup = this.calculateFairShare(false);
        }

        protected void copyTransients(AnalysisContext ctxLast) {
            if (ctxLast == null) {
                return;
            }
            PartitionSet partsOrphaned = ctxLast.getOrphanedPartitions();
            long cDelay = ctxLast.getAnalysisDelay();
            if (partsOrphaned != null) {
                this.setOrphanedPartitions(partsOrphaned);
            }
            if (cDelay >= 0L) {
                this.setAnalysisDelay(cDelay);
            }
        }

        protected int getFairShare(boolean fPrimary) {
            return fPrimary ? this.m_cFairSharePrimary : this.m_cFairShareBackup;
        }

        protected int calculateFairShare(boolean fPrimary) {
            Set<Member> setOwners = this.getOwnershipMembers();
            LoadCalculator calculator = fPrimary ? this.getPrimaryLoadCalculator() : this.getBackupLoadCalculator();
            int cMembers = setOwners.size();
            PartitionSet partsAll = new PartitionSet(SimpleAssignmentStrategy.this.getPartitionCount());
            partsAll.fill();
            int cLoadTotal = calculator.getLoad(partsAll);
            if (!fPrimary) {
                cLoadTotal *= this.getActualBackupCount();
            }
            return cMembers <= 1 ? cLoadTotal : cLoadTotal / cMembers + 1;
        }

        protected boolean isMemberLeaving(Member member) {
            return SimpleAssignmentStrategy.this.getManager().getOwnershipLeavingMembers().contains(member);
        }

        protected BackupStrength instantiateBackupStrength(Set setOwners) {
            HashMap<String, HashSet<Member>> mapBySite = new HashMap<String, HashSet<Member>>();
            HashMap<String, HashSet<Member>> mapByRack = new HashMap<String, HashSet<Member>>();
            HashMap<Integer, HashSet<Member>> mapByMachine = new HashMap<Integer, HashSet<Member>>();
            for (Member member : setOwners) {
                String sSite = member.getSiteName();
                String sRack = member.getRackName();
                int nMachine = member.getMachineId();
                HashSet<Member> setSite = (HashSet<Member>)mapBySite.get(sSite);
                if (setSite == null) {
                    setSite = new HashSet<Member>();
                    mapBySite.put(sSite, setSite);
                }
                setSite.add(member);
                HashSet<Member> setRack = (HashSet<Member>)mapByRack.get(sRack);
                if (setRack == null) {
                    setRack = new HashSet<Member>();
                    mapByRack.put(sRack, setRack);
                }
                setRack.add(member);
                HashSet<Member> setMachine = (HashSet<Member>)mapByMachine.get(nMachine);
                if (setMachine == null) {
                    setMachine = new HashSet<Member>();
                    mapByMachine.put(nMachine, setMachine);
                }
                setMachine.add(member);
            }
            int nStrength = 1;
            if (this.isStrongPossible(setOwners, mapBySite)) {
                nStrength = 4;
            } else if (this.isStrongPossible(setOwners, mapByRack)) {
                nStrength = 3;
            } else if (this.isStrongPossible(setOwners, mapByMachine)) {
                nStrength = 2;
            }
            return new BackupStrength(nStrength, new HashSet(mapBySite.keySet()), new HashSet(mapByRack.keySet()), new HashSet(mapByMachine.keySet()));
        }

        protected boolean isStrongPossible(Set setOwners, Map mapSplit) {
            int cMax = 0;
            for (Set setGroup : mapSplit.values()) {
                int cMembers = setGroup.size();
                if (cMembers <= cMax) continue;
                cMax = cMembers;
            }
            return cMax * (SimpleAssignmentStrategy.this.getBackupCount() + 1) <= setOwners.size();
        }

        protected boolean isPartitionStrong(int iPartition) {
            return this.isPartitionStrong(this.getPartitionOwnership(iPartition));
        }

        protected boolean isPartitionStrong(Ownership owners) {
            BackupStrength strength = this.getBackupStrength();
            int cBackups = this.getActualBackupCount();
            Member[] aMembers = new Member[cBackups + 1];
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                Member member = SimpleAssignmentStrategy.this.getMember(owners.getOwner(iStore));
                if (member == null) {
                    return false;
                }
                aMembers[iStore] = member;
            }
            for (int iStoreThis = 0; iStoreThis <= cBackups; ++iStoreThis) {
                for (int iStoreThat = iStoreThis + 1; iStoreThat <= cBackups; ++iStoreThat) {
                    if (strength.isStrong(aMembers[iStoreThis], aMembers[iStoreThat])) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean isTransferStrong(int iPartition, int iStore, Member member) {
            Ownership owners = (Ownership)this.getPartitionOwnership(iPartition).clone();
            owners.setOwner(iStore, member.getId());
            return this.isPartitionStrong(owners);
        }

        protected boolean isStrong(Member member1, Member member2) {
            return this.getBackupStrength().isStrong(member1, member2);
        }

        protected boolean isStrong(Member member, Ownership owners) {
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            for (int iStore = 0; iStore <= cBackups; ++iStore) {
                int nOwner = owners.getOwner(iStore);
                if (nOwner == 0 || !this.isStrong(member, SimpleAssignmentStrategy.this.getMember(nOwner))) continue;
                return true;
            }
            return false;
        }

        protected PartitionSet collectOrphaned(PartitionSet parts) {
            PartitionSet partsOwnedOrphans;
            PartitionSet partsOrphaned = this.getOrphanedPartitions();
            if (partsOrphaned != null && partsOrphaned.intersects(parts)) {
                partsOwnedOrphans = new PartitionSet(partsOrphaned);
                partsOwnedOrphans.retain(parts);
            } else {
                partsOwnedOrphans = new PartitionSet(parts.getPartitionCount());
            }
            return partsOwnedOrphans;
        }

        protected PartitionSet collectWeak(PartitionSet parts) {
            PartitionSet partsWeak = new PartitionSet(parts.getPartitionCount());
            int iPart = parts.next(0);
            while (iPart >= 0) {
                if (!this.isPartitionStrong(iPart)) {
                    partsWeak.add(iPart);
                }
                iPart = parts.next(iPart + 1);
            }
            return partsWeak;
        }

        protected boolean isPartitionEndangered(int iPartition) {
            return this.isPartitionEndangered(this.getPartitionOwnership(iPartition));
        }

        protected boolean isPartitionEndangered(Ownership owners) {
            int cBackups = this.getActualBackupCount();
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                if (owners.getOwner(iStore) != 0) continue;
                return true;
            }
            return false;
        }

        protected PartitionSet collectEndangered(PartitionSet parts) {
            PartitionSet partsEndangered = new PartitionSet(parts.getPartitionCount());
            int iPart = parts.next(0);
            while (iPart >= 0) {
                if (this.isPartitionEndangered(iPart)) {
                    partsEndangered.add(iPart);
                }
                iPart = parts.next(iPart + 1);
            }
            return partsEndangered;
        }

        protected PartitionSet ensureUpdatedPartitions() {
            PartitionSet partsUpdated = this.getUpdatedPartitions();
            if (partsUpdated == null) {
                this.m_partsUpdated = partsUpdated = new PartitionSet(SimpleAssignmentStrategy.this.getPartitionCount());
            }
            return partsUpdated;
        }

        public PartitionSet getOwnedPartitions(Member member, int iStore) {
            PartitionSet parts;
            PartitionSet[] aParts = this.m_mapOwnedPartitions.get(member);
            if (aParts == null) {
                aParts = new PartitionSet[1 + SimpleAssignmentStrategy.this.getBackupCount()];
                this.m_mapOwnedPartitions.put(member, aParts);
            }
            if ((parts = aParts[iStore]) == null) {
                aParts[iStore] = parts = SimpleAssignmentStrategy.this.getManager().getOwnedPartitions(member, iStore);
            }
            return parts;
        }

        public boolean isInitialDistribution(Member memberCoordinator) {
            PartitionedService service = SimpleAssignmentStrategy.this.getManager().getService();
            int cBackups = service.getBackupCount();
            int c = service.getPartitionCount();
            for (int iPart = 0; iPart < c; ++iPart) {
                if (service.getPartitionOwner(iPart) != memberCoordinator) {
                    return false;
                }
                for (int iBackup = 1; iBackup <= cBackups; ++iBackup) {
                    if (service.getBackupOwner(iPart, iBackup) == null) continue;
                    return false;
                }
            }
            return true;
        }

        protected void primeDistribution(Member member1, Member member2) {
            int cFairInitial = SimpleAssignmentStrategy.this.getPartitionCount() / 2 + 1;
            Object[] aMembers = new Member[]{member1, member2};
            this.m_setOwnershipMembers = new ImmutableArrayList(aMembers);
            this.m_aOwnershipMembers = aMembers;
            this.m_cFairSharePrimary = cFairInitial;
            this.m_cFairShareBackup = cFairInitial;
        }

        public Ownership getPartitionOwnership(int iPartition) {
            Ownership owners = this.m_aOwners[iPartition];
            if (owners == null) {
                this.m_aOwners[iPartition] = owners = SimpleAssignmentStrategy.this.getManager().getPartitionOwnership(iPartition);
            }
            return owners;
        }

        protected int getPartitionLoad(int iPartition, boolean fPrimary) {
            return (fPrimary ? this.getPrimaryLoadCalculator() : this.getBackupLoadCalculator()).getLoad(iPartition);
        }

        protected int getMemberLoad(Member member, boolean fPrimary) {
            if (fPrimary) {
                return this.getPrimaryLoadCalculator().getLoad(this.getOwnedPartitions(member, 0));
            }
            LoadCalculator calculator = this.getBackupLoadCalculator();
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            int cLoad = 0;
            for (int iStore = 1; iStore <= cBackups; ++iStore) {
                cLoad += calculator.getLoad(this.getOwnedPartitions(member, iStore));
            }
            return cLoad;
        }

        protected long calculateAnalysisDelay() {
            AnalysisContext ctxLast = SimpleAssignmentStrategy.this.getLastAnalysisContext();
            if (ctxLast == null) {
                return 0L;
            }
            Set setOwnersPrev = SimpleAssignmentStrategy.this.getLastOwnershipMembers();
            Set<Member> setOwnersCur = this.getOwnershipMembers();
            long cDelay = this.m_cDelay;
            if (cDelay >= 0L) {
                this.m_cDelay = -1L;
                return cDelay;
            }
            if (setOwnersCur.equals(setOwnersPrev)) {
                PartitionSet parts = ctxLast.getUpdatedPartitions();
                if (parts == null) {
                    return 0L;
                }
                PartitionSet partsIgnored = SimpleAssignmentStrategy.this.getManager().getIgnoredAdvice();
                if (partsIgnored != null) {
                    parts.remove(partsIgnored);
                }
                int iPart = parts.next(0);
                while (iPart >= 0) {
                    Ownership ownersSuggested = ctxLast.getPartitionOwnership(iPart);
                    Ownership ownersCurrent = this.getPartitionOwnership(iPart);
                    if (!ownersCurrent.equals(ownersSuggested)) {
                        cDelay = Math.max(0L, ctxLast.getCompletedTime() + SimpleAssignmentStrategy.this.getSuggestionCompletionDelay() - Base.getSafeTimeMillis());
                        if (setOwnersCur.equals(ctxLast.getOwnershipMembers())) {
                            return Math.min(cDelay, SimpleAssignmentStrategy.this.getSuggestionDelay());
                        }
                        return Math.min(cDelay, 1000L);
                    }
                    iPart = parts.next(iPart + 1);
                }
                return 0L;
            }
            if (setOwnersCur.containsAll(setOwnersPrev)) {
                return SimpleAssignmentStrategy.this.getMemberJoinDelay();
            }
            return 0L;
        }

        protected void transitionPartition(int iPartition, int iStore, Member memberFrom, Member memberTo) {
            int nMemberTo = memberTo == null ? 0 : memberTo.getId();
            int cBackups = SimpleAssignmentStrategy.this.getBackupCount();
            Ownership owners = this.getPartitionOwnership(iPartition);
            if (memberFrom != null) {
                this.getOwnedPartitions(memberFrom, iStore).remove(iPartition);
            }
            if (memberTo != null) {
                this.getOwnedPartitions(memberTo, iStore).add(iPartition);
            }
            block0: for (int i = 0; i <= cBackups; ++i) {
                if (i == iStore) {
                    owners.setOwner(iStore, nMemberTo);
                    if (iStore != 0 || memberTo == null || memberFrom == null || this.isMemberLeaving(memberFrom)) continue;
                    for (int j = 1; j <= cBackups; ++j) {
                        Member memberBackup = SimpleAssignmentStrategy.this.getMember(owners.getOwner(j));
                        if (memberTo.getMachineId() == memberFrom.getMachineId() || memberBackup != null && memberTo.getMachineId() != memberBackup.getMachineId()) continue;
                        this.getOwnedPartitions(memberFrom, j).add(iPartition);
                        if (memberBackup != null) {
                            this.getOwnedPartitions(memberBackup, j).remove(iPartition);
                        }
                        owners.setOwner(j, memberFrom.getId());
                        continue block0;
                    }
                    continue;
                }
                if (nMemberTo == 0 || owners.getOwner(i) != nMemberTo) continue;
                owners.setOwner(i, 0);
                this.getOwnedPartitions(memberTo, i).remove(iPartition);
            }
            this.ensureUpdatedPartitions().add(iPartition);
        }

        protected boolean suggestDistribution() {
            PartitionSet partsUpdated = this.getUpdatedPartitions();
            if (partsUpdated == null) {
                SimpleAssignmentStrategy.this.m_mapSuggestLast = Collections.emptyMap();
                return false;
            }
            int cPartitions = SimpleAssignmentStrategy.this.getPartitionCount();
            HashMap<Ownership, PartitionSet> mapSuggest = new HashMap<Ownership, PartitionSet>();
            DistributionManager manager = SimpleAssignmentStrategy.this.getManager();
            int iPart = partsUpdated.next(0);
            while (iPart >= 0) {
                Ownership owners = this.getPartitionOwnership(iPart);
                PartitionSet parts = (PartitionSet)mapSuggest.get(owners);
                if (!owners.equals(manager.getPartitionOwnership(iPart))) {
                    if (parts == null) {
                        parts = new PartitionSet(cPartitions);
                        mapSuggest.put(owners, parts);
                    }
                    parts.add(iPart);
                }
                iPart = partsUpdated.next(iPart + 1);
            }
            for (Map.Entry entry : mapSuggest.entrySet()) {
                Ownership owners = (Ownership)entry.getKey();
                PartitionSet parts = (PartitionSet)entry.getValue();
                if (parts.isEmpty()) continue;
                manager.suggest(parts, owners);
            }
            SimpleAssignmentStrategy.this.m_mapSuggestLast = mapSuggest;
            return true;
        }

        public Filter instantiateNotOwnedFilter(Ownership owners) {
            return new NotOwnedFilter(owners);
        }

        public Filter instantiateSafetyFilter(Ownership owners, int iStore) {
            return new SafetyFilter(owners, iStore);
        }

        public Filter instantiateOverloadedFilter(boolean fPrimary) {
            return new NotFilter(new UnderloadedFilter(fPrimary));
        }

        public Filter instantiateUnderloadedFilter(boolean fPrimary) {
            return new UnderloadedFilter(fPrimary);
        }

        public LoadComparator instantiateLoadComparator(boolean fPrimary) {
            return new LoadComparator(fPrimary);
        }

        public StrengthComparator instantiateStrengthComparator(Ownership owners) {
            return new StrengthComparator(owners);
        }

        public Comparator instantiateDefaultComparator() {
            return MEMBERID_COMPARATOR;
        }

        public class StrengthComparator
        implements Comparator {
            protected Ownership m_owners;

            public StrengthComparator(Ownership owners) {
                this.m_owners = owners;
            }

            public Ownership getOwnership() {
                return this.m_owners;
            }

            public int compare(Object o1, Object o2) {
                return this.getDistance((Member)o2) - this.getDistance((Member)o1);
            }

            protected int getDistance(Member member) {
                Ownership owners = this.getOwnership();
                int cBackups = owners.getBackupCount();
                int nDistance = 0;
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    int nOwner = owners.getOwner(iStore);
                    if (nOwner == 0) continue;
                    Member memberBackup = SimpleAssignmentStrategy.this.getMember(nOwner);
                    if (member == null || memberBackup == null) {
                        CacheFactory.log(String.format("%s is null for %s", member == null ? "Slot in member target array" : "Backup owner", owners), 1);
                    }
                    int n = this.getDistance(member, SimpleAssignmentStrategy.this.getMember(nOwner));
                    nDistance += n * n;
                }
                return nDistance;
            }

            protected int getDistance(Member member1, Member member2) {
                if (!Base.equals(member1.getSiteName(), member2.getSiteName())) {
                    return 4;
                }
                if (!Base.equals(member1.getRackName(), member2.getRackName())) {
                    return 3;
                }
                if (member1.getMachineId() != member2.getMachineId()) {
                    return 2;
                }
                if (member1.getId() != member2.getId()) {
                    return 1;
                }
                Base.azzert(member1 == member2);
                return 0;
            }
        }

        public class LoadComparator
        implements Comparator {
            protected boolean m_fPrimary;

            public LoadComparator(boolean fPrimary) {
                this.m_fPrimary = fPrimary;
            }

            public boolean isPrimary() {
                return this.m_fPrimary;
            }

            public int compare(Object o1, Object o2) {
                Member member1 = (Member)o1;
                Member member2 = (Member)o2;
                boolean fPrimary = this.isPrimary();
                int cLoad1 = AnalysisContext.this.getMemberLoad(member1, fPrimary);
                int cLoad2 = AnalysisContext.this.getMemberLoad(member2, fPrimary);
                return cLoad1 - cLoad2;
            }
        }

        public class UnderloadedFilter
        implements Filter {
            protected int m_cFairShare;
            protected boolean m_fPrimary;

            protected UnderloadedFilter(boolean fPrimary) {
                this.m_fPrimary = fPrimary;
                this.m_cFairShare = AnalysisContext.this.getFairShare(fPrimary);
            }

            public boolean isPrimary() {
                return this.m_fPrimary;
            }

            public int getFairShare() {
                return this.m_cFairShare;
            }

            public boolean evaluate(Object o) {
                return AnalysisContext.this.getMemberLoad((Member)o, this.isPrimary()) < this.getFairShare();
            }
        }

        public class SafetyFilter
        implements Filter {
            protected Ownership m_owners;
            protected int m_iStore;

            public SafetyFilter(Ownership owners, int iStore) {
                this.m_owners = (Ownership)owners.clone();
                this.m_iStore = iStore;
            }

            public Ownership getOwnership() {
                return this.m_owners;
            }

            public int getStorageIndex() {
                return this.m_iStore;
            }

            public boolean evaluate(Object o) {
                Ownership owners = this.getOwnership();
                owners.setOwner(this.getStorageIndex(), ((Member)o).getId());
                return AnalysisContext.this.isPartitionStrong(owners);
            }
        }

        public class NotOwnedFilter
        implements Filter {
            protected Ownership m_owners;

            public NotOwnedFilter(Ownership owners) {
                this.m_owners = owners;
            }

            public Ownership getOwnership() {
                return this.m_owners;
            }

            public boolean evaluate(Object o) {
                Ownership owners = this.getOwnership();
                int nMember = ((Member)o).getId();
                int cBackups = AnalysisContext.this.getActualBackupCount();
                for (int iStore = 0; iStore <= cBackups; ++iStore) {
                    if (owners.getOwner(iStore) != nMember) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public static class SimpleLoadCalculator
    implements LoadCalculator {
        @Override
        public int getLoad(int nPartition) {
            return 1;
        }

        @Override
        public int getLoad(PartitionSet parts) {
            return parts.cardinality();
        }
    }

    public static interface LoadCalculator {
        public int getLoad(int var1);

        public int getLoad(PartitionSet var1);
    }

    protected class JMXPartitionStats {
        protected long m_cbMaxStorage;
        protected long m_cbAverageStorage;
        protected long m_cbMaxPartition;
        protected long m_cbAveragePartition;
        protected int m_nMaxLoadId;

        protected JMXPartitionStats() {
        }

        public long getMaxStorageSize() {
            return this.m_cbMaxStorage;
        }

        public long getAverageStorageSize() {
            return this.m_cbAverageStorage;
        }

        public long getMaxPartitionSize() {
            return this.m_cbMaxPartition;
        }

        public long getAveragePartitionSize() {
            return this.m_cbAveragePartition;
        }

        public int getMaxLoadNodeId() {
            return this.m_nMaxLoadId;
        }

        public void calculateJMXPartitionStats() {
            DistributionManager manager = SimpleAssignmentStrategy.this.getManager();
            if (manager == null) {
                return;
            }
            PartitionStatistics[] aStats = manager.getPartitionStats();
            Set<Member> setOwners = manager.getOwnershipMembers();
            if (setOwners == null) {
                return;
            }
            long cbTotalStorage = 0L;
            long cbMaxPartition = 0L;
            long cbMaxStorage = 0L;
            int nMaxNodeId = 0;
            for (Member member : setOwners) {
                PartitionSet parts = manager.getOwnedPartitions(member, 0);
                long cTotalStorageNode = 0L;
                int iPart = parts.next(0);
                while (iPart >= 0) {
                    PartitionStatistics stat = aStats[iPart];
                    if (stat != null) {
                        long cStoragePart = stat.getStorageSize();
                        cTotalStorageNode += cStoragePart;
                        if (cStoragePart > cbMaxPartition) {
                            cbMaxPartition = cStoragePart;
                        }
                    }
                    iPart = parts.next(iPart + 1);
                }
                cbTotalStorage += cTotalStorageNode;
                if (cTotalStorageNode <= cbMaxStorage) continue;
                cbMaxStorage = cTotalStorageNode;
                nMaxNodeId = member.getId();
            }
            this.m_cbAveragePartition = cbTotalStorage / (long)(SimpleAssignmentStrategy.this.getPartitionCount() * 1024);
            this.m_cbAverageStorage = cbTotalStorage / (long)(setOwners.size() * 1024);
            this.m_cbMaxPartition = cbMaxPartition / 1024L;
            this.m_cbMaxStorage = cbMaxStorage / 1024L;
            this.m_nMaxLoadId = nMaxNodeId;
        }
    }
}

