/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.coherence.config.Config;
import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ClusterPermission;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.security.AccessController;
import com.tangosol.net.security.SimpleHandler;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignedObject;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;

public final class DefaultController
extends Base
implements AccessController {
    public static final String PROPERTY_CONFIG = "coherence.security.config";
    public static final String KEYSTORE_TYPE;
    public static final String SIGNATURE_ALGORITHM;
    public static final Signature SIGNATURE_ENGINE;
    private final KeyStore f_store;
    private final XmlElement f_xmlPermits;
    private final Map f_mapPublicKey = new SafeHashMap();
    private final boolean f_fAudit;

    public DefaultController(File fileKeyStore, File filePermits) throws IOException, AccessControlException {
        this(fileKeyStore, filePermits, false);
    }

    public DefaultController(File fileKeyStore, File filePermits, boolean fAudit) throws IOException, AccessControlException {
        this(fileKeyStore, filePermits, fAudit, (char[])null);
    }

    public DefaultController(File fileKeyStore, File filePermits, boolean fAudit, PasswordProvider pwdProvider) throws IOException, AccessControlException {
        this(fileKeyStore, filePermits, fAudit, pwdProvider.get());
    }

    public DefaultController(File fileKeyStore, File filePermits, boolean fAudit, String sPwd) throws IOException, AccessControlException {
        this(fileKeyStore, filePermits, fAudit, sPwd == null || sPwd.isEmpty() ? null : sPwd.toCharArray());
    }

    private DefaultController(File fileKeyStore, File filePermits, boolean fAudit, char[] pwdArray) throws IOException, AccessControlException {
        DefaultController.azzert(fileKeyStore != null && filePermits != null, "Null files");
        if (!filePermits.exists() || !filePermits.canRead()) {
            throw new IOException("Permission file is not accessible: " + filePermits.getAbsolutePath());
        }
        try (FileInputStream inStore = null;){
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE);
            inStore = new FileInputStream(fileKeyStore);
            store.load(inStore, pwdArray);
            this.f_store = store;
        }
        try (FileInputStream inPermits = null;){
            inPermits = new FileInputStream(filePermits);
            this.f_xmlPermits = new SimpleParser().parseXml(inPermits);
        }
        this.f_fAudit = fAudit;
    }

    @Override
    public void checkPermission(ClusterPermission permission, Subject subject) {
        DefaultController.azzert(subject != null, "Null subject");
        Set<Principal> setPrincipals = subject.getPrincipals();
        if (setPrincipals != null) {
            for (Principal principal : setPrincipals) {
                Permissions permits = this.getClusterPermissions(principal);
                if (permits == null || !permits.implies(permission)) continue;
                if (this.f_fAudit) {
                    this.logPermissionRequest(permission, subject, true);
                }
                return;
            }
        }
        if (this.f_fAudit) {
            this.logPermissionRequest(permission, subject, false);
        }
        throw new AccessControlException("Insufficient rights to perform the operation", permission);
    }

    @Override
    public SignedObject encrypt(Object o, Subject subjEncryptor) throws IOException, GeneralSecurityException {
        DefaultController.azzert(o instanceof Serializable, "Not serializable");
        DefaultController.azzert(subjEncryptor != null, "No subject");
        Set<Object> setPrivateCreds = subjEncryptor.getPrivateCredentials();
        if (setPrivateCreds == null) {
            throw new GeneralSecurityException("Subject without private credentials");
        }
        for (Object oCred : setPrivateCreds) {
            PrivateKey keyPrivate = null;
            if (oCred instanceof PrivateKey) {
                keyPrivate = (PrivateKey)oCred;
            } else if (oCred instanceof X500PrivateCredential) {
                keyPrivate = ((X500PrivateCredential)oCred).getPrivateKey();
            }
            if (keyPrivate == null) continue;
            return this.encrypt((Serializable)o, keyPrivate);
        }
        throw new GeneralSecurityException("Not sufficient credentials");
    }

    @Override
    public Object decrypt(SignedObject so, Subject subjEncryptor, Subject subjDecryptor) throws ClassNotFoundException, IOException, GeneralSecurityException {
        Set<Object> setDecryptorCreds;
        DefaultController.azzert(subjEncryptor != null, "Null subject");
        PublicKey keyPublic = (PublicKey)this.f_mapPublicKey.get(subjEncryptor);
        if (keyPublic != null) {
            return this.decrypt(so, keyPublic);
        }
        Set setKeys = null;
        if (subjDecryptor != null && (setDecryptorCreds = subjDecryptor.getPublicCredentials()) != null && this.equalsMostly(subjDecryptor, subjEncryptor)) {
            setKeys = this.extractPublicKeys(setDecryptorCreds);
        }
        if (setKeys == null) {
            setKeys = this.findPublicKeys(subjEncryptor);
        }
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            keyPublic = (PublicKey)iter.next();
            try {
                Object o = this.decrypt(so, keyPublic);
                this.f_mapPublicKey.put(subjEncryptor, keyPublic);
                return o;
            }
            catch (GeneralSecurityException e) {
                if (iter.hasNext()) continue;
                throw e;
            }
        }
        throw new GeneralSecurityException("Failed to match credentials for " + subjEncryptor);
    }

    public XmlElement getPermissionsConfig() {
        return (XmlElement)this.f_xmlPermits.clone();
    }

    protected Permissions getClusterPermissions(Principal principal) {
        XmlElement xmlName = XmlHelper.findElement(this.f_xmlPermits, "/grant/principal/name", principal.getName());
        if (xmlName == null) {
            return null;
        }
        XmlElement xmlPrincipal = xmlName.getSafeElement("../");
        String sPrincipalCls = xmlPrincipal.getSafeElement("class").getString();
        if (sPrincipalCls.length() > 0 && !principal.getClass().getName().equals(sPrincipalCls)) {
            return null;
        }
        XmlElement xmlGrant = xmlPrincipal.getSafeElement("../");
        Permissions permits = new Permissions();
        Iterator iter = xmlGrant.getElements("permission");
        while (iter.hasNext()) {
            XmlElement xmlPermission = (XmlElement)iter.next();
            String sClass = xmlPermission.getSafeElement("class").getString("com.tangosol.net.ClusterPermission");
            String sTarget = xmlPermission.getSafeElement("target").getString();
            String sAction = xmlPermission.getSafeElement("action").getString();
            try {
                ClusterPermission permit = (ClusterPermission)ClassHelper.newInstance(Class.forName(sClass), new Object[]{sTarget, sAction});
                permits.add(permit);
            }
            catch (Throwable e) {
                CacheFactory.log("Invalid permission element: " + xmlPermission + "\nreason: " + e, 2);
            }
        }
        return permits;
    }

    protected synchronized SignedObject encrypt(Serializable o, PrivateKey keyPrivate) throws IOException, GeneralSecurityException {
        return new SignedObject(o, keyPrivate, SIGNATURE_ENGINE);
    }

    protected synchronized Object decrypt(SignedObject so, PublicKey keyPublic) throws ClassNotFoundException, IOException, GeneralSecurityException {
        if (so.verify(keyPublic, SIGNATURE_ENGINE)) {
            return so.getObject();
        }
        throw new SignatureException("Invalid signature");
    }

    protected boolean equalsMostly(Subject subject1, Subject subject2) {
        return DefaultController.equals(subject1.getPrincipals(), subject2.getPrincipals()) && DefaultController.equals(subject1.getPublicCredentials(), subject2.getPublicCredentials());
    }

    protected Set extractPublicKeys(Set setPubCreds) {
        Set setCerts = this.extractCertificates(setPubCreds);
        LiteSet<PublicKey> setKeys = new LiteSet<PublicKey>();
        for (Certificate cert : setCerts) {
            setKeys.add(cert.getPublicKey());
        }
        return setKeys;
    }

    protected Set extractCertificates(Set setPubCreds) {
        LiteSet<Certificate> setCerts = new LiteSet<Certificate>();
        for (Object oCred : setPubCreds) {
            if (oCred instanceof CertPath) {
                CertPath certPath = (CertPath)oCred;
                List<? extends Certificate> listCert = certPath.getCertificates();
                if (listCert.isEmpty()) continue;
                setCerts.add(listCert.get(0));
                continue;
            }
            if (oCred instanceof Certificate) {
                Certificate cert = (Certificate)oCred;
                setCerts.add(cert);
                continue;
            }
            if (oCred instanceof Certificate[]) {
                Certificate[] acert = (Certificate[])oCred;
                if (acert.length <= 0) continue;
                setCerts.add(acert[0]);
                continue;
            }
            CacheFactory.log("Unsupported credentials: " + oCred.getClass(), 2);
        }
        return setCerts;
    }

    protected Set findPublicKeys(Subject subject) throws GeneralSecurityException {
        KeyStore store = this.f_store;
        Set setCerts = this.extractCertificates(subject.getPublicCredentials());
        LiteSet<X500Principal> setPpals = new LiteSet<X500Principal>();
        LiteSet<PublicKey> setKeys = new LiteSet<PublicKey>();
        for (Certificate cert : setCerts) {
            if (store.getCertificateAlias(cert) == null || !(cert instanceof X509Certificate)) continue;
            X509Certificate certX509 = (X509Certificate)cert;
            setPpals.add(new X500Principal(certX509.getIssuerDN().getName()));
            setKeys.add(cert.getPublicKey());
        }
        return setKeys;
    }

    protected void logPermissionRequest(ClusterPermission permission, Subject subject, boolean fAllowed) {
        CacheFactory.log((fAllowed ? "Allowed" : "Denied") + " request for " + permission + " on behalf of " + subject.getPrincipals(), 3);
    }

    public static void main(String[] asArg) throws Exception {
        Subject subjectResponder;
        Subject subject;
        ListMap map;
        if (asArg.length == 0) {
            DefaultController.usage(null);
            return;
        }
        String[] asCmd = new String[]{"keystore", "module", "permits", "responder", "requestor"};
        try {
            map = CommandLineTool.parseArguments(asArg, asCmd, true);
        }
        catch (IllegalArgumentException e) {
            DefaultController.usage(e.getMessage());
            return;
        }
        String sTarget = (String)map.get(0);
        String sAction = (String)map.get(1);
        String sStorePath = (String)map.get("keystore");
        String sModule = (String)map.get("module");
        String sPermitsPath = (String)map.get("permits");
        String sRequestor = (String)map.get("requestor");
        String sResponder = (String)map.get("responder");
        if (sStorePath == null || sRequestor == null) {
            DefaultController.usage("The 'keystore' and 'requestor' must be specified");
            return;
        }
        if (sPermitsPath == null) {
            sPermitsPath = "permissions.xml";
        }
        if (sModule == null) {
            sModule = "Coherence";
        }
        DefaultController authorizer = new DefaultController(new File(sStorePath), new File(sPermitsPath));
        ClusterPermission permission = new ClusterPermission(sTarget, sAction);
        try {
            String[] asAuth = Base.parseDelimitedString(sRequestor, '!');
            SimpleHandler handler = new SimpleHandler(asAuth[0], asAuth[1].toCharArray());
            LoginContext lc = new LoginContext(sModule, handler);
            lc.login();
            subject = lc.getSubject();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DefaultController.usage("Requestor's password is missing");
            return;
        }
        catch (Exception e) {
            throw DefaultController.ensureRuntimeException(e, "Requestor's authentication failed:" + sRequestor);
        }
        if (sResponder == null) {
            subjectResponder = subject;
        } else {
            try {
                String[] asAuth = Base.parseDelimitedString(sResponder, '!');
                SimpleHandler handler = new SimpleHandler(asAuth[0], asAuth[1].toCharArray());
                LoginContext lc = new LoginContext(sModule, handler);
                lc.login();
                subjectResponder = lc.getSubject();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                DefaultController.usage("Responder's password is missing");
                return;
            }
            catch (Exception e) {
                throw DefaultController.ensureRuntimeException(e, "Responder's authentication failed:" + sResponder);
            }
        }
        DefaultController.out("Requestor:");
        for (Principal principal : subject.getPrincipals()) {
            DefaultController.out("  " + principal.getClass().getName() + " " + principal.getName());
        }
        DefaultController.out("Permission:");
        DefaultController.out("  " + permission);
        try {
            DefaultController.out("*** Checking local access permission...");
            authorizer.checkPermission(permission, subject);
            DefaultController.out("*** Encrypting access permission request...");
            SignedObject soPermission = authorizer.encrypt((Object)permission, subject);
            DefaultController.out(">>> Transferring access permission request...");
            Set setPrincipalsRemote = (Set)ExternalizableHelper.fromBinary(ExternalizableHelper.toBinary(subject.getPrincipals()));
            Set setCredentialsRemote = (Set)ExternalizableHelper.fromBinary(ExternalizableHelper.toBinary(subject.getPublicCredentials()));
            Subject subjectRemote = new Subject(true, setPrincipalsRemote, setCredentialsRemote, NullImplementation.getSet());
            SignedObject soPermissionRemote = (SignedObject)ExternalizableHelper.fromBinary(ExternalizableHelper.toBinary(soPermission));
            DefaultController.out("### Decrypting access permission request...");
            ClusterPermission permissionRemote = (ClusterPermission)authorizer.decrypt(soPermissionRemote, subjectRemote, subjectResponder);
            DefaultController.azzert(DefaultController.equals(permission, permissionRemote));
            DefaultController.out("### Checking remote access permission...");
            authorizer.checkPermission(permissionRemote, subjectRemote);
            DefaultController.out("### Encrypting access permission response...");
            soPermission = authorizer.encrypt((Object)permissionRemote, subjectResponder);
            DefaultController.out("<<< Transferring access permission response...");
            Set setPrincipalsResponse = (Set)ExternalizableHelper.fromBinary(ExternalizableHelper.toBinary(subjectResponder.getPrincipals()));
            Set setCredentialsResponse = (Set)ExternalizableHelper.fromBinary(ExternalizableHelper.toBinary(subjectResponder.getPublicCredentials()));
            Subject subjectResponse = new Subject(true, setPrincipalsResponse, setCredentialsResponse, NullImplementation.getSet());
            SignedObject soPermissionResponse = (SignedObject)ExternalizableHelper.fromBinary(ExternalizableHelper.toBinary(soPermission));
            DefaultController.out("*** Decrypting access permission response...");
            ClusterPermission permissionResponse = (ClusterPermission)authorizer.decrypt(soPermissionResponse, subjectResponse, subject);
            DefaultController.azzert(DefaultController.equals(permission, permissionResponse));
            DefaultController.out("Done.");
        }
        catch (Exception e) {
            DefaultController.err("Failed to encrypt/decrypt the permission");
            DefaultController.err(e);
        }
    }

    private static void usage(String sError) {
        if (sError != null) {
            DefaultController.out("\n*** " + sError);
        }
        String sUsage = "\nUsage:\n    java com.tangosol.net.DefaultController <target> <action> -[<option>]*\n\nwhere options include:\n   -keystore <keystore path>   the path to the keystore\n   -module:<name>              the login module name\n   -permits:<permits path>     the path to permissions file\n   -requestor:<name!password>  the requestor's name/password pair\n   -responder:<name!password>  the responder's name/password pair\n";
        DefaultController.out(sUsage);
    }

    static {
        Signature engine;
        String sConfig = Config.getProperty(PROPERTY_CONFIG);
        XmlElement xml = null;
        String sKeystoreType = "JKS";
        String sAlgorithm = "SHA1withDSA";
        if (sConfig != null && sConfig.length() > 0) {
            URL url = Resources.findResource(sConfig, null);
            Throwable e = null;
            if (url != null) {
                try {
                    xml = XmlHelper.loadXml(url.openStream());
                }
                catch (Throwable t) {
                    e = t;
                }
            }
            if (xml == null) {
                DefaultController.err("Unable to load DefaultController configuration file \"" + sConfig + "\";");
                if (e != null) {
                    DefaultController.err(e);
                }
                DefaultController.err("Using default configuration.");
            }
        }
        try {
            if (xml == null) {
                xml = XmlHelper.loadXml(DefaultController.class, "ISO-8859-1");
            }
            sKeystoreType = xml.getSafeElement("keystore-type").getString(sKeystoreType);
            sAlgorithm = xml.getSafeElement("signature-algorithm").getString(sAlgorithm);
        }
        catch (Throwable url) {
            // empty catch block
        }
        try {
            engine = Signature.getInstance(sAlgorithm);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        KEYSTORE_TYPE = sKeystoreType;
        SIGNATURE_ALGORITHM = sAlgorithm;
        SIGNATURE_ENGINE = engine;
    }
}

