/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.topic;

import com.oracle.coherence.common.util.Options;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.FlowControl;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.ToIntFunction;

public interface Publisher<V>
extends AutoCloseable {
    public CompletableFuture<Void> send(V var1);

    public FlowControl getFlowControl();

    public CompletableFuture<Void> flush();

    @Override
    public void close();

    public void onClose(Runnable var1);

    public static class OrderByValue<V>
    extends OrderBy<V> {
        private ToIntFunction<? super V> m_orderIdFunction;

        public OrderByValue() {
        }

        protected OrderByValue(ToIntFunction<? super V> orderIdFunction) {
            this.m_orderIdFunction = orderIdFunction;
        }

        @Override
        public int getOrderId(V value) {
            return this.m_orderIdFunction.applyAsInt(value);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_orderIdFunction = (ToIntFunction)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_orderIdFunction);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_orderIdFunction = (ToIntFunction)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_orderIdFunction);
        }

        public String toString() {
            return "value";
        }
    }

    public static class OrderById<V>
    extends OrderBy<V> {
        private int m_nOrderId;

        public OrderById() {
        }

        protected OrderById(int nOrderId) {
            this.m_nOrderId = nOrderId;
        }

        @Override
        public int getOrderId(V value) {
            return this.m_nOrderId;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_nOrderId = in.readInt();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            out.writeInt(this.m_nOrderId);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nOrderId = in.readInt(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(1, this.m_nOrderId);
        }

        public String toString() {
            return "id(" + this.m_nOrderId + ")";
        }
    }

    public static class OrderByNone<V>
    extends OrderBy<V> {
        protected static final OrderBy<Object> INSTANCE = new OrderByNone<Object>();

        @Override
        public int getOrderId(V value) {
            return ThreadLocalRandom.current().nextInt();
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }

        public String toString() {
            return "none";
        }
    }

    public static class OrderByThread<V>
    extends OrderBy<V> {
        protected static final OrderBy<Object> INSTANCE = new OrderByThread<Object>();

        @Override
        public int getOrderId(V value) {
            return Thread.currentThread().hashCode() ^ Base.getProcessRandom();
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }

        public String toString() {
            return "thread";
        }
    }

    public static abstract class OrderBy<V>
    implements Option<V>,
    ExternalizableLite,
    PortableObject {
        protected OrderBy() {
        }

        public abstract int getOrderId(V var1);

        @Options.Default
        public static OrderBy<Object> thread() {
            return OrderByThread.INSTANCE;
        }

        public static OrderBy<Object> none() {
            return OrderByNone.INSTANCE;
        }

        public static OrderBy<Object> id(int nOrderId) {
            return new OrderById<Object>(nOrderId);
        }

        public static <V> OrderBy<V> value(Remote.ToIntFunction<? super V> supplierOrderId) {
            return OrderBy.value(supplierOrderId);
        }

        public static <V> OrderBy<V> value(ToIntFunction<? super V> supplierOrderId) {
            return new OrderByValue<V>(supplierOrderId);
        }
    }

    public static class FailOnFull
    implements Option<Object>,
    ExternalizableLite,
    PortableObject {
        protected static final FailOnFull INSTANCE = new FailOnFull();

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }

        public static FailOnFull enabled() {
            return INSTANCE;
        }
    }

    public static enum OnFailure implements Option<Object>
    {
        Stop,
        Continue;

    }

    public static interface Option<V> {
    }
}

