/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.datagrid.persistence.PersistenceEnvironment;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.PersistenceEnvironmentInfo;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractPersistenceEnvironment
extends Base
implements PersistenceEnvironment<ReadBuffer>,
PersistenceEnvironmentInfo {
    protected static final String[] NO_STRINGS = new String[0];
    protected static final String DELETED_PREFIX = ".";
    protected final AtomicInteger f_atomicRemovesCounter = new AtomicInteger();
    protected final File f_fileActive;
    protected final File f_fileSnapshot;
    protected final File f_fileTrash;
    protected AbstractPersistenceManager<?> m_managerActive;
    protected final Map<String, AbstractPersistenceManager> f_mapSnapshots = new HashMap<String, AbstractPersistenceManager>();
    protected DaemonPool m_pool;

    public AbstractPersistenceEnvironment(File fileActive, File fileSnapshot, File fileTrash) throws IOException {
        if (fileActive != null && !fileActive.exists()) {
            CacheFactory.log("Creating persistence active directory \"" + fileActive.getAbsolutePath() + '\"', 3);
        }
        this.f_fileActive = fileActive == null ? null : FileHelper.ensureDir(fileActive);
        this.f_fileSnapshot = fileSnapshot;
        this.f_fileTrash = fileTrash;
        if (this.f_fileActive != null && this.f_fileActive.equals(this.f_fileSnapshot)) {
            throw new IllegalArgumentException("active directory \"" + this.f_fileActive + " \"cannot be the same as the snapshot directory");
        }
        if (this.f_fileTrash != null && (this.f_fileTrash.equals(this.f_fileActive) || this.f_fileTrash.equals(this.f_fileSnapshot))) {
            throw new IllegalArgumentException("trash directory \"" + this.f_fileTrash + " \"cannot be the same as the active or snapshot directory");
        }
    }

    @Override
    public synchronized PersistenceManager<ReadBuffer> openActive() {
        if (this.f_fileActive == null) {
            return null;
        }
        AbstractPersistenceManager manager = this.m_managerActive;
        if (manager == null) {
            this.m_managerActive = manager = this.openActiveInternal();
            manager.setPersistenceEnvironment(this);
        }
        return manager;
    }

    @Override
    public synchronized PersistenceManager<ReadBuffer> openSnapshot(String sSnapshot) {
        File fileSnapshot = new File(this.f_fileSnapshot, FileHelper.toFilename(sSnapshot));
        if (!fileSnapshot.isDirectory()) {
            return null;
        }
        AbstractPersistenceManager manager = this.f_mapSnapshots.get(sSnapshot);
        if (manager == null) {
            manager = this.openSnapshotInternal(fileSnapshot, sSnapshot);
            manager.setPersistenceEnvironment(this);
            manager.setDaemonPool(null);
            this.f_mapSnapshots.put(sSnapshot, manager);
        }
        return manager;
    }

    @Override
    public synchronized PersistenceManager<ReadBuffer> createSnapshot(String sSnapshot, PersistenceManager<ReadBuffer> manager) {
        File fileSnapshot;
        if (this.f_mapSnapshots.containsKey(sSnapshot)) {
            throw new IllegalArgumentException("duplicate snapshot: " + sSnapshot);
        }
        String sFilename = FileHelper.toFilename(sSnapshot);
        if (sFilename.startsWith(DELETED_PREFIX)) {
            throw new IllegalArgumentException("snapshot starts with a reserved character: " + sSnapshot);
        }
        if (!this.f_fileSnapshot.exists()) {
            CacheFactory.log("Creating persistence snapshot directory \"" + this.f_fileSnapshot.getAbsolutePath() + '\"', 3);
        }
        try {
            fileSnapshot = FileHelper.ensureDir(new File(this.f_fileSnapshot, sFilename));
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
        AbstractPersistenceManager snapshot = this.createSnapshotInternal(fileSnapshot, sSnapshot, manager);
        snapshot.setPersistenceEnvironment(this);
        snapshot.setDaemonPool(null);
        this.f_mapSnapshots.put(sSnapshot, snapshot);
        return snapshot;
    }

    @Override
    public synchronized boolean removeSnapshot(String sSnapshot) {
        File fileSnapshot;
        AbstractPersistenceManager manager = this.f_mapSnapshots.get(sSnapshot);
        if (manager != null) {
            manager.release();
        }
        return (fileSnapshot = new File(this.f_fileSnapshot, FileHelper.toFilename(sSnapshot))).isDirectory() && this.removeSnapshotInternal(fileSnapshot, sSnapshot);
    }

    @Override
    public String[] listSnapshots() {
        File[] aFiles = this.f_fileSnapshot.listFiles(file -> file.isDirectory() && !file.getName().startsWith(DELETED_PREFIX));
        int cNames = aFiles == null ? 0 : aFiles.length;
        String[] asNames = cNames == 0 ? NO_STRINGS : new String[cNames];
        for (int i = 0; i < cNames; ++i) {
            asNames[i] = aFiles[i].getName();
        }
        return asNames;
    }

    @Override
    public synchronized void release() {
        AbstractPersistenceManager<?> managerActive = this.m_managerActive;
        if (managerActive != null) {
            managerActive.release();
        }
        AbstractPersistenceManager[] aSnapshots = new AbstractPersistenceManager[this.f_mapSnapshots.size()];
        aSnapshots = this.f_mapSnapshots.values().toArray(aSnapshots);
        int c = aSnapshots.length;
        for (int i = 0; i < c; ++i) {
            aSnapshots[i].release();
        }
    }

    @Override
    public File getPersistenceActiveDirectory() {
        return this.f_fileActive;
    }

    @Override
    public File getPersistenceSnapshotDirectory() {
        return this.f_fileSnapshot;
    }

    @Override
    public File getPersistenceTrashDirectory() {
        return this.f_fileTrash;
    }

    @Override
    public long getPersistenceActiveSpaceUsed() {
        long cBytes = 0L;
        if (this.m_managerActive != null && this.f_fileActive != null) {
            for (String sId : this.m_managerActive.f_mapStores.keySet()) {
                File fileDir = new File(this.f_fileActive, sId);
                cBytes += FileHelper.sizeDir(fileDir);
            }
        }
        return cBytes;
    }

    protected PersistenceException ensurePersistenceException(Throwable eCause) {
        return this.ensurePersistenceException(eCause, null);
    }

    protected PersistenceException ensurePersistenceException(Throwable eCause, String sMessage) {
        PersistenceException e = CachePersistenceHelper.ensurePersistenceException(eCause, sMessage);
        e.initPersistenceEnvironment(this);
        return e;
    }

    protected synchronized void onReleased(AbstractPersistenceManager manager) {
        if (manager == this.m_managerActive) {
            this.m_managerActive = null;
        } else {
            this.f_mapSnapshots.remove(manager.getName());
        }
        manager.setPersistenceEnvironment(null);
    }

    protected abstract AbstractPersistenceManager openActiveInternal();

    protected abstract AbstractPersistenceManager openSnapshotInternal(File var1, String var2);

    protected abstract AbstractPersistenceManager createSnapshotInternal(File var1, String var2, PersistenceManager<ReadBuffer> var3);

    protected boolean removeSnapshotInternal(File fileSnapshot, String sSnapshot) {
        File fileLock = new File(fileSnapshot.getParentFile(), fileSnapshot.getName() + ".lck");
        FileLock lock = null;
        if (fileSnapshot.exists()) {
            lock = FileHelper.lockFile(fileLock);
        }
        if (lock == null) {
            return false;
        }
        File fileDest = null;
        try {
            Path pathSnapshot = fileSnapshot.toPath();
            Path pathDest = null;
            int nAttempt = 128;
            IOException error = null;
            do {
                if ((nAttempt & nAttempt - 1) == 0) {
                    pathDest = this.createHiddenSnapshotDirectory(fileSnapshot.getName());
                    fileDest = pathDest.toFile();
                }
                try {
                    Files.move(pathSnapshot, pathDest, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    error = e;
                }
            } while (--nAttempt > 0 && (!fileDest.exists() || !fileDest.isDirectory() || fileSnapshot.exists()));
            if (nAttempt > 0) {
                FileHelper.deleteDir(fileDest);
            } else {
                FileHelper.deleteDir(fileSnapshot);
                if (fileSnapshot.exists()) {
                    fileDest = fileSnapshot;
                    throw error;
                }
            }
        }
        catch (IOException e) {
            String sMsg = "Unable to remove snapshot directory " + FileHelper.getPath(fileDest) + "; subsequent snapshot creations will not succeed with the name: " + sSnapshot + '\n' + e + '\n' + Base.getStackTrace(e);
            CacheFactory.log(sMsg, 1);
            throw CachePersistenceHelper.ensurePersistenceException(e, sMsg);
        }
        finally {
            fileLock.delete();
            FileHelper.unlockFile(lock);
        }
        return false;
    }

    protected Path createHiddenSnapshotDirectory(String sPrefix) {
        Path path;
        while ((path = this.f_fileSnapshot.toPath().resolve(DELETED_PREFIX + sPrefix + '-' + this.f_atomicRemovesCounter.incrementAndGet())).toFile().exists()) {
        }
        return path;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(ActiveDirectory=" + this.f_fileActive + ", SnapshotDirectory=" + this.f_fileSnapshot + ')';
    }

    public DaemonPool getDaemonPool() {
        return this.m_pool;
    }

    public void setDaemonPool(DaemonPool pool) {
        this.m_pool = pool;
    }

    public static class DefaultFailureContinuation
    implements Continuation<Throwable> {
        private final Object f_oSource;

        public DefaultFailureContinuation(Object oSource) {
            this.f_oSource = oSource;
        }

        @Override
        public void proceed(Throwable e) {
            if (e instanceof PersistenceException) {
                throw (PersistenceException)e;
            }
            if (this.f_oSource instanceof AbstractPersistenceEnvironment) {
                throw ((AbstractPersistenceEnvironment)this.f_oSource).ensurePersistenceException(e);
            }
            if (this.f_oSource instanceof AbstractPersistenceManager) {
                throw ((AbstractPersistenceManager)this.f_oSource).ensurePersistenceException(e);
            }
            if (this.f_oSource instanceof AbstractPersistenceManager.AbstractPersistentStore) {
                throw ((AbstractPersistenceManager.AbstractPersistentStore)this.f_oSource).ensurePersistenceException(e);
            }
            PersistenceException ee = new PersistenceException(e);
            if (this.f_oSource instanceof PersistenceEnvironment) {
                ee.initPersistenceEnvironment((PersistenceEnvironment)this.f_oSource);
            } else if (this.f_oSource instanceof PersistenceManager) {
                ee.initPersistenceManager((PersistenceManager)this.f_oSource);
            } else if (this.f_oSource instanceof PersistentStore) {
                ee.initPersistentStore((PersistentStore)this.f_oSource);
            }
            throw ee;
        }
    }
}

