/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.persistence.FatalAccessException;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.datagrid.persistence.PersistenceTools;
import com.tangosol.coherence.config.builder.PersistenceEnvironmentParamBuilder;
import com.tangosol.coherence.config.scheme.AbstractServiceScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.internal.net.service.ServiceDependencies;
import com.tangosol.internal.net.service.grid.PartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.FileHelper;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.internal.QuorumInfo;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.persistence.PersistenceEnvironmentInfo;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.persistence.bdb.BerkeleyDBManager;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LongArray;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SparseArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class CachePersistenceHelper {
    public static final String DEFAULT_BASE_DIR_PROPERTY = "coherence.distributed.persistence.base.dir";
    public static final String META_FILENAME = "meta.properties";
    public static final String META_IMPL_VERSION = "implementation.version";
    public static final String META_STORAGE_FORMAT = "storage.format";
    public static final String META_STORAGE_VERSION = "storage.version";
    public static final String META_PARTITION_COUNT = "partition.count";
    public static final String META_SERVICE_VERSION = "service.version";
    public static final int PERSISTENCE_VERSION = 14;
    public static final String DEFAULT_BASE_DIR = "coherence";
    public static final String DEFAULT_ACTIVE_DIR = "active";
    public static final String DEFAULT_SNAPSHOT_DIR = "snapshots";
    public static final String DEFAULT_TRASH_DIR = "trash";
    public static final String DEFAULT_LOCK_DIR = ".lock";
    public static final long META_EXTENT = 0L;
    public static final int RESERVED_META_EXTENTS = 8;
    private static final byte KEY_TYPE_LISTENER = 0;
    private static final byte KEY_TYPE_LOCK = 1;
    private static final byte KEY_TYPE_INDEX = 2;
    private static final byte KEY_TYPE_TRIGGER = 3;
    private static final Binary BINARY_SEAL = new Binary(new byte[]{83, 69, 65, 76});
    private static final Binary BINARY_QUORUM = new Binary(new byte[]{81, 85, 79, 82, 85, 77});
    private static final Binary BINARY_PARTITION_COUNT = new Binary(new byte[]{80, 65, 82, 84, 73, 84, 73, 79, 78, 95, 67, 79, 85, 78, 84});
    private static final Binary BINARY_PERSISTENCE_VERSION = new Binary(new byte[]{83, 69, 82, 86, 73, 67, 69, 95, 86, 69, 82, 83, 73, 79, 78});
    private static final Binary BINARY_CACHES = new Binary(new byte[]{67, 65, 67, 72, 69, 83});
    private static final Binary BINARY_TRUE = new Binary(new byte[]{1});
    private static final Binary BINARY_FALSE = new Binary(new byte[]{0});

    public static PersistenceException ensurePersistenceException(Throwable eCause) {
        return CachePersistenceHelper.ensurePersistenceException(eCause, null);
    }

    public static PersistenceException ensurePersistenceException(Throwable eCause, String sMessage) {
        PersistenceException e = sMessage == null && eCause instanceof PersistenceException ? (PersistenceException)eCause : (sMessage == null && eCause == null ? new PersistenceException() : (eCause == null ? new PersistenceException(sMessage) : (sMessage == null ? new PersistenceException(eCause) : new PersistenceException(sMessage, eCause))));
        return e;
    }

    public static void seal(PersistentStore<ReadBuffer> store, PartitionedService service, Object oToken) {
        store.ensureExtent(0L);
        boolean fCommit = false;
        if (oToken == null) {
            oToken = store.begin();
            fCommit = true;
        }
        Binary binPartsCount = ExternalizableHelper.toBinary(service.getPartitionCount(), CachePersistenceHelper.serializer());
        Binary binServiceVersion = ExternalizableHelper.toBinary(String.valueOf(14), CachePersistenceHelper.serializer());
        store.store(0L, BINARY_PARTITION_COUNT, binPartsCount, oToken);
        store.store(0L, BINARY_PERSISTENCE_VERSION, binServiceVersion, oToken);
        store.store(0L, BINARY_SEAL, BINARY_SEAL, oToken);
        if (fCommit) {
            store.commit(oToken);
        }
    }

    public static void unseal(PersistentStore<ReadBuffer> store) {
        Object oToken = store.begin();
        store.erase(0L, BINARY_PARTITION_COUNT, oToken);
        store.erase(0L, BINARY_PERSISTENCE_VERSION, oToken);
        store.erase(0L, BINARY_SEAL, oToken);
        store.commit(oToken);
    }

    public static boolean isSealed(PersistentStore<ReadBuffer> store) {
        return store.load(0L, BINARY_SEAL) != null;
    }

    public static void writeQuorumRaw(PersistentStore<ReadBuffer> store, Binary binInfo) {
        store.ensureExtent(0L);
        store.store(0L, BINARY_QUORUM, binInfo, null);
    }

    public static Binary writeQuorum(PersistentStore<ReadBuffer> store, PartitionedService service) {
        QuorumInfo info = new QuorumInfo(service);
        Binary binInfo = ExternalizableHelper.toBinary(info, CachePersistenceHelper.serializer());
        CachePersistenceHelper.writeQuorumRaw(store, binInfo);
        CachePersistenceHelper.seal(store, service, null);
        return binInfo;
    }

    public static Binary readQuorumRaw(PersistentStore<ReadBuffer> store) {
        store.ensureExtent(0L);
        ReadBuffer bufMembers = store.load(0L, BINARY_QUORUM);
        return bufMembers == null ? null : bufMembers.toBinary();
    }

    public static QuorumInfo readQuorum(PersistentStore<ReadBuffer> store) {
        Binary binMembers = CachePersistenceHelper.readQuorumRaw(store);
        return binMembers == null ? null : (QuorumInfo)ExternalizableHelper.fromBinary(binMembers.toBinary(), CachePersistenceHelper.serializer());
    }

    public static void validate(PersistentStore store, PartitionedService service) {
        StringBuilder sb = new StringBuilder();
        try {
            String sConjunction = "";
            int cParts = CachePersistenceHelper.getPartitionCount(store);
            int cPartsService = service.getPartitionCount();
            if (cParts != cPartsService) {
                sb.append("partition-count mismatch ").append(cParts).append("(persisted)").append(" != ").append(cPartsService).append("(service)");
                sConjunction = " and ";
            }
            if (!CachePersistenceHelper.isSealed(store)) {
                sb.append(sConjunction).append("store has not been sealed");
            }
        }
        catch (RuntimeException e) {
            Throwable tCause;
            Throwable throwable = tCause = e instanceof PersistenceException ? e.getCause() : e;
            if (tCause instanceof IllegalArgumentException) {
                sb.append("missing internal extent");
            }
            throw e;
        }
        if (sb.length() > 0) {
            throw CachePersistenceHelper.ensurePersistenceException(new FatalAccessException(sb.toString()));
        }
    }

    public static void storeCacheNames(PersistentStore store, LongArray laCaches) {
        int cCaches = laCaches.getSize();
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(cCaches * 100);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            out.writeInt(cCaches);
            Iterator iter = laCaches.iterator();
            while (iter.hasNext()) {
                String sCache = (String)iter.next();
                long lCacheId = iter.getIndex();
                out.writeLong(lCacheId);
                out.writeSafeUTF(sCache);
            }
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        store.ensureExtent(0L);
        store.store(0L, BINARY_CACHES, buf.getReadBuffer(), null);
    }

    public static LongArray<String> getCacheNames(PersistentStore<ReadBuffer> store) {
        ReadBuffer bufVal = store.load(0L, BINARY_CACHES);
        SparseArray<String> laCaches = new SparseArray<String>();
        if (bufVal != null) {
            try {
                ReadBuffer.BufferInput in = bufVal.getBufferInput();
                int c = in.readInt();
                for (int i = 0; i < c; ++i) {
                    long lCacheId = in.readLong();
                    String sCache = in.readSafeUTF();
                    laCaches.set(lCacheId, sCache);
                }
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return laCaches;
    }

    public static int getPartitionCount(PersistentStore<ReadBuffer> store) {
        ReadBuffer bufPartsCount = store.load(0L, BINARY_PARTITION_COUNT);
        return bufPartsCount == null ? -1 : (Integer)ExternalizableHelper.fromBinary(bufPartsCount.toBinary(), CachePersistenceHelper.serializer());
    }

    @Deprecated
    public static String getServiceVersion(PersistentStore<ReadBuffer> store) {
        int nVersion = CachePersistenceHelper.getPersistenceVersion(store);
        return nVersion == 0 ? "<none>" : String.valueOf(nVersion);
    }

    public static int getPersistenceVersion(PersistentStore<ReadBuffer> store) {
        ReadBuffer bufVersion = store.load(0L, BINARY_PERSISTENCE_VERSION);
        int nVersion = 0;
        if (bufVersion != null) {
            Object oVersion = ExternalizableHelper.fromBinary(bufVersion.toBinary(), CachePersistenceHelper.serializer());
            try {
                nVersion = oVersion instanceof Integer ? (Integer)oVersion : Integer.parseInt((String)oVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nVersion;
    }

    public static boolean isGlobalPartitioningSchemePID(int nPartition) {
        return nPartition == 0;
    }

    public static PartitionSet getGlobalPartitions(PartitionedService service) {
        PartitionSet parts = new PartitionSet(service.getPartitionCount());
        parts.add(0);
        return parts;
    }

    public static void deleteExtents(PersistentStore store, long lExtentId) {
        long lDelExtentId = lExtentId;
        for (int i = 0; i <= 8; ++i) {
            store.deleteExtent(lDelExtentId);
            lDelExtentId = -lExtentId - (long)i;
        }
    }

    public static void moveExtents(PersistentStore store, long lOldExtentId, long lNewExtentId) {
        long lSrcExtent = lOldExtentId;
        long lDestExtent = lNewExtentId;
        for (int i = 0; i <= 8; ++i) {
            store.moveExtent(lSrcExtent, lDestExtent);
            lSrcExtent = -lOldExtentId - (long)i;
            lDestExtent = -lNewExtentId - (long)i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readMetadata(File fileDir) throws IOException {
        FileInputStream in = new FileInputStream(new File(fileDir, META_FILENAME));
        try {
            Properties prop = new Properties();
            prop.load(in);
            Properties properties = prop;
            return properties;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetadata(File fileDir, Properties prop) throws IOException {
        if (!CachePersistenceHelper.isMetadataComplete(prop)) {
            throw new IllegalArgumentException("incomplete metadata");
        }
        FileOutputStream out = new FileOutputStream(new File(fileDir, META_FILENAME));
        try {
            prop.store(out, null);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copyMetadata(File fileDirFrom, File fileDirTo) throws IOException {
        FileHelper.copyFile(new File(fileDirFrom, META_FILENAME), new File(fileDirTo, META_FILENAME));
    }

    public static boolean isMetadataComplete(Properties prop) {
        return prop != null && !prop.getProperty(META_IMPL_VERSION, "").trim().isEmpty() && !prop.getProperty(META_STORAGE_FORMAT, "").trim().isEmpty() && !prop.getProperty(META_STORAGE_VERSION, "").trim().isEmpty();
    }

    public static boolean isMetadataCompatible(Properties prop, int nImplVersion, String sStorageFormat, int nStorageVersion) {
        int nStorageVersionExpect;
        int nImplVersionExpect;
        try {
            nImplVersionExpect = Integer.valueOf(prop.getProperty(META_IMPL_VERSION));
        }
        catch (RuntimeException e) {
            nImplVersionExpect = -1;
        }
        String sStorageFormatExpect = prop.getProperty(META_STORAGE_FORMAT);
        try {
            nStorageVersionExpect = Integer.valueOf(prop.getProperty(META_STORAGE_VERSION));
        }
        catch (RuntimeException e) {
            nStorageVersionExpect = -1;
        }
        return nImplVersionExpect <= nImplVersion && nStorageVersionExpect == nStorageVersion && sStorageFormatExpect.equals(sStorageFormat);
    }

    protected static long getListenerExtentId(long lCacheId) {
        assert (lCacheId > 0L);
        return -lCacheId;
    }

    protected static ReadBuffer createListenerRegistrationKey(long lMemberId, long lCacheId, Binary binKey) {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(17);
        try {
            WriteBuffer.BufferOutput out = buf.getBufferOutput();
            out.writeByte(0);
            out.writeLong(lMemberId);
            out.writeLong(lCacheId);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return new MultiBufferReadBuffer(new ReadBuffer[]{buf.getReadBuffer(), binKey});
    }

    public static void registerListener(PersistentStore<ReadBuffer> store, long lCacheId, Binary binKey, long lListenerId, boolean fLite, Object oToken) {
        ReadBuffer bufListenerKey = CachePersistenceHelper.createListenerRegistrationKey(lListenerId, lCacheId, binKey);
        long lExtentId = CachePersistenceHelper.getListenerExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.store(lExtentId, bufListenerKey, fLite ? BINARY_TRUE : BINARY_FALSE, oToken);
    }

    public static void unregisterListener(PersistentStore<ReadBuffer> store, long lCacheId, Binary binKey, long lListenerId, Object oToken) {
        ReadBuffer bufListenerKey = CachePersistenceHelper.createListenerRegistrationKey(lListenerId, lCacheId, binKey);
        long lExtentId = CachePersistenceHelper.getListenerExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.erase(lExtentId, bufListenerKey, oToken);
    }

    public static void unregisterListeners(PersistentStore<ReadBuffer> store, long lCacheId) {
        store.deleteExtent(CachePersistenceHelper.getListenerExtentId(lCacheId));
    }

    private static Serializer serializer() {
        return ExternalizableHelper.ensureSerializer(NullImplementation.getClassLoader());
    }

    protected static long getLockExtentId(long lCacheId) {
        assert (lCacheId > 0L);
        return -lCacheId - 1L;
    }

    protected static ReadBuffer createLockRegistrationKey(long lHolderId, long lHolderThreadId, long lCacheId, Binary binKey) {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(25);
        try {
            WriteBuffer.BufferOutput out = buf.getBufferOutput();
            out.writeByte(1);
            out.writeLong(lHolderId);
            out.writeLong(lHolderThreadId);
            out.writeLong(lCacheId);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return new MultiBufferReadBuffer(new ReadBuffer[]{buf.getReadBuffer(), binKey});
    }

    public static void registerLock(PersistentStore<ReadBuffer> store, long lCacheId, Binary binKey, long lHolderId, long lHolderThreadId, Object oToken) {
        ReadBuffer bufHolderKey = CachePersistenceHelper.createLockRegistrationKey(lHolderId, lHolderThreadId, lCacheId, binKey);
        long lExtentId = CachePersistenceHelper.getLockExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.store(lExtentId, bufHolderKey, BINARY_TRUE, oToken);
    }

    public static void unregisterLock(PersistentStore<ReadBuffer> store, long lCacheId, Binary binKey, long lHolderId, long lHolderThreadId, Object oToken) {
        ReadBuffer bufHolderKey = CachePersistenceHelper.createLockRegistrationKey(lHolderId, lHolderThreadId, lCacheId, binKey);
        long lExtentId = CachePersistenceHelper.getLockExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.erase(lExtentId, bufHolderKey, oToken);
    }

    public static void unregisterLocks(PersistentStore<ReadBuffer> store, long lCacheId) {
        store.deleteExtent(CachePersistenceHelper.getLockExtentId(lCacheId));
    }

    protected static long getIndexExtentId(long lCacheId) {
        assert (lCacheId > 0L);
        return -lCacheId - 2L;
    }

    protected static ReadBuffer createIndexRegistrationKey(long lCacheId, Binary binExtractor) {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(9);
        try {
            WriteBuffer.BufferOutput out = buf.getBufferOutput();
            out.writeByte(2);
            out.writeLong(lCacheId);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return new MultiBufferReadBuffer(new ReadBuffer[]{buf.getReadBuffer(), binExtractor});
    }

    public static void registerIndex(PersistentStore<ReadBuffer> store, long lCacheId, Binary binExtractor, Binary binComparator, Object oToken) {
        ReadBuffer bufIndex = CachePersistenceHelper.createIndexRegistrationKey(lCacheId, binExtractor);
        long lExtentId = CachePersistenceHelper.getIndexExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.store(lExtentId, bufIndex, binComparator, oToken);
    }

    public static void unregisterIndex(PersistentStore<ReadBuffer> store, long lCacheId, Binary binExtractor, Object oToken) {
        ReadBuffer bufIndex = CachePersistenceHelper.createIndexRegistrationKey(lCacheId, binExtractor);
        long lExtentId = CachePersistenceHelper.getIndexExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.erase(lExtentId, bufIndex, oToken);
    }

    public static void unregisterIndices(PersistentStore<ReadBuffer> store, long lCacheId) {
        store.deleteExtent(CachePersistenceHelper.getIndexExtentId(lCacheId));
    }

    protected static long getTriggerExtentId(long lCacheId) {
        assert (lCacheId > 0L);
        return -lCacheId - 3L;
    }

    protected static ReadBuffer createTriggerRegistrationKey(long lCacheId, Binary binTrigger) {
        ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(9);
        try {
            WriteBuffer.BufferOutput out = buf.getBufferOutput();
            out.writeByte(3);
            out.writeLong(lCacheId);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return new MultiBufferReadBuffer(new ReadBuffer[]{buf.getReadBuffer(), binTrigger});
    }

    public static void registerTrigger(PersistentStore<ReadBuffer> store, long lCacheId, Binary binTrigger, Object oToken) {
        ReadBuffer bufTrigger = CachePersistenceHelper.createTriggerRegistrationKey(lCacheId, binTrigger);
        long lExtentId = CachePersistenceHelper.getTriggerExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.store(lExtentId, bufTrigger, BINARY_TRUE, oToken);
    }

    public static void unregisterTrigger(PersistentStore<ReadBuffer> store, long lCacheId, Binary binTrigger, Object oToken) {
        ReadBuffer bufTrigger = CachePersistenceHelper.createTriggerRegistrationKey(lCacheId, binTrigger);
        long lExtentId = CachePersistenceHelper.getTriggerExtentId(lCacheId);
        store.ensureExtent(lExtentId);
        store.erase(lExtentId, bufTrigger, oToken);
    }

    public static void unregisterTriggers(PersistentStore<ReadBuffer> store, long lCacheId) {
        store.deleteExtent(CachePersistenceHelper.getTriggerExtentId(lCacheId));
    }

    public static void resumeService(Cluster cluster, String sServiceName) {
        new Thread(() -> cluster.resumeService(sServiceName)).start();
    }

    public static PersistenceTools getSnapshotPersistenceTools(File dirSnapshot) {
        PersistenceTools tools;
        if (!(dirSnapshot != null && dirSnapshot.isDirectory() && dirSnapshot.canRead() && dirSnapshot.canExecute())) {
            throw CachePersistenceHelper.ensurePersistenceException(new IllegalArgumentException("The directory " + dirSnapshot + " does not exist or can not be read"));
        }
        File[] aFiles = dirSnapshot.listFiles(file -> {
            String sDirName = file.getName();
            if (file.isDirectory() && !DEFAULT_LOCK_DIR.equals(sDirName)) {
                if (!GUIDHelper.validateGUID(sDirName)) {
                    throw new IllegalStateException("Unexpected directory (" + sDirName + ") in snapshot directory: " + dirSnapshot.getAbsolutePath());
                }
                return true;
            }
            return false;
        });
        if (aFiles == null || aFiles.length == 0) {
            throw CachePersistenceHelper.ensurePersistenceException(new IllegalArgumentException("Directory " + dirSnapshot.getAbsolutePath() + " does not contain any valid snapshot directories"));
        }
        try {
            Properties props = CachePersistenceHelper.readMetadata(aFiles[0]);
            String sPersistenceType = props.getProperty(META_STORAGE_FORMAT);
            if (!"BDB".equals(sPersistenceType)) {
                throw new UnsupportedOperationException("Storage format " + sPersistenceType + " not supported for tools");
            }
            tools = new BerkeleyDBManager(dirSnapshot, null, null).getPersistenceTools();
        }
        catch (IOException ioe) {
            throw CachePersistenceHelper.ensurePersistenceException(ioe, "Error getting persistence tools for snapshot");
        }
        return tools;
    }

    public static PersistenceTools getArchiverPersistenceTools(ExtensibleConfigurableCacheFactory eccf, String sSnapshotName, String sServiceName) {
        PersistenceDependencies depsPersistence = CachePersistenceHelper.getPersistenceDependencies(eccf, sServiceName);
        SnapshotArchiverFactory factory = depsPersistence.getArchiverFactory();
        if (factory == null) {
            throw new PersistenceException("Unable to find archiver for service " + sServiceName + " in operational configuration");
        }
        SnapshotArchiver archiver = factory.createSnapshotArchiver(CachePersistenceHelper.getClusterName(), sServiceName);
        return archiver.getPersistenceTools(sSnapshotName);
    }

    private static PersistenceDependencies getPersistenceDependencies(ExtensibleConfigurableCacheFactory eccf, String sServiceName) {
        PersistenceDependencies depsPersistence;
        ServiceDependencies depsService;
        ServiceScheme scheme = eccf.getCacheConfig().findSchemeByServiceName(sServiceName);
        if (scheme != null && (depsService = (ServiceDependencies)((AbstractServiceScheme)scheme).getServiceDependencies()) instanceof PartitionedServiceDependencies && sServiceName.equals(scheme.getServiceName()) && (depsPersistence = ((PartitionedServiceDependencies)depsService).getPersistenceDependencies()) != null) {
            return depsPersistence;
        }
        throw new IllegalArgumentException("Unable to find caching scheme for service " + sServiceName);
    }

    public static PersistenceEnvironmentInfo getEnvironmentInfo(ExtensibleConfigurableCacheFactory eccf, String sServiceName) {
        PersistenceDependencies depsPersistence = CachePersistenceHelper.getPersistenceDependencies(eccf, sServiceName);
        PersistenceEnvironmentParamBuilder bldr = (PersistenceEnvironmentParamBuilder)depsPersistence.getPersistenceEnvironmentBuilder();
        return bldr.getPersistenceEnvironmentInfo(CachePersistenceHelper.getClusterName(), sServiceName);
    }

    protected static String getClusterName() {
        ClusterDependencies deps = (ClusterDependencies)CacheFactory.getCluster().getDependencies();
        if (deps == null) {
            throw new IllegalArgumentException("Unable to find cluster dependencies");
        }
        return deps.getMemberIdentity().getClusterName();
    }

    public static PersistentStore.Visitor<ReadBuffer> instantiatePersistenceVisitor(Visitor visitorCache) {
        return (lExtentId, bufKey, bufValue) -> {
            if (lExtentId > 0L) {
                return visitorCache.visitCacheEntry(lExtentId, bufKey.toBinary(), bufValue.toBinary());
            }
            if (0L == lExtentId) {
                return true;
            }
            ReadBuffer.BufferInput in = bufKey.getBufferInput();
            try {
                switch (in.readByte()) {
                    case 0: {
                        long lListenerId = in.readLong();
                        long lCacheId = in.readLong();
                        boolean fLite = Base.equals(bufValue, BINARY_TRUE);
                        int cbHeader = 17;
                        Binary binCacheKey = bufKey.toBinary(cbHeader, bufKey.length() - cbHeader);
                        return visitorCache.visitListener(lCacheId, binCacheKey, lListenerId, fLite);
                    }
                    case 1: {
                        long lHolderId = in.readLong();
                        long lThreadId = in.readLong();
                        long lCacheId = in.readLong();
                        int cbHeader = 25;
                        Binary binCacheKey = bufKey.toBinary(cbHeader, bufKey.length() - cbHeader);
                        return visitorCache.visitLock(lCacheId, binCacheKey, lHolderId, lThreadId);
                    }
                    case 2: {
                        long lCacheId = in.readLong();
                        int cbHeader = 9;
                        Binary binExtractor = bufKey.toBinary(cbHeader, bufKey.length() - cbHeader);
                        Binary binComparator = bufValue.toBinary();
                        return visitorCache.visitIndex(lCacheId, binExtractor, binComparator);
                    }
                    case 3: {
                        long lCacheId = in.readLong();
                        int cbHeader = 9;
                        Binary binTrigger = bufKey.toBinary(cbHeader, bufKey.length() - cbHeader);
                        return visitorCache.visitTrigger(lCacheId, binTrigger);
                    }
                }
                return false;
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        };
    }

    public static String getMBeanName(String sService) {
        return "type=Persistence,service=" + sService + "," + "responsibility=" + "PersistenceCoordinator";
    }

    public static interface Visitor {
        public boolean visitCacheEntry(long var1, Binary var3, Binary var4);

        public boolean visitListener(long var1, Binary var3, long var4, boolean var6);

        public boolean visitLock(long var1, Binary var3, long var4, long var6);

        public boolean visitIndex(long var1, Binary var3, Binary var4);

        public boolean visitTrigger(long var1, Binary var3);
    }
}

