/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class SaxParser
extends Base {
    private static Parser s_parser;
    private static final AtomicBoolean ATTEMPT_RESTRICT_EXTERNAL;

    public SaxParser() {
        this(false);
    }

    public SaxParser(boolean fAllowComments) {
        if (fAllowComments) {
            throw new UnsupportedOperationException("XML comments are not supported");
        }
    }

    public static void main(String[] asParam) {
        if (asParam.length > 0) {
            SaxParser parser = new SaxParser();
            try {
                FileInputStream in = new FileInputStream(asParam[0]);
                XmlElement root = parser.parseXml(in);
                root.writeXml(SaxParser.getOut(), true);
                SaxParser.out();
            }
            catch (Exception e) {
                SaxParser.out(e);
            }
        }
    }

    public XmlElement parseXml(String sXml) throws SAXException {
        return this.parseXml(new InputSource(new StringReader(sXml)), null);
    }

    public XmlElement parseXml(String sXml, XmlElement elRoot) throws SAXException {
        return this.parseXml(new InputSource(new StringReader(sXml)), elRoot);
    }

    public XmlElement parseXml(InputStream input) throws SAXException {
        return this.parseXml(new InputSource(input), null);
    }

    public XmlElement parseXml(Reader input) throws SAXException {
        return this.parseXml(new InputSource(input), null);
    }

    public XmlElement parseXml(InputSource input) throws SAXException {
        return this.parseXml(input, null);
    }

    protected XmlElement parseXml(InputSource input, XmlElement xmlRoot) throws SAXException {
        try {
            Parser parser = SaxParser.getParser();
            SimpleHandler handler = new SimpleHandler(xmlRoot);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(input);
            xmlRoot = handler.m_root;
            if (xmlRoot == null) {
                throw new SAXException("Empty document");
            }
            return xmlRoot;
        }
        catch (Exception e) {
            throw e instanceof SAXException ? (SAXException)e : new SAXException(e);
        }
    }

    public void validateXsd(String sXml, XmlDocument xml) throws SAXException, IOException, ParserConfigurationException {
        if (sXml != null) {
            ValidationHandler handler;
            Validator validator;
            StreamSource source;
            block6: {
                List<String> listSchemaURIs = XmlHelper.getSchemaLocations(xml, XmlHelper.getNamespacePrefix(xml, "http://www.w3.org/2001/XMLSchema-instance"));
                if (listSchemaURIs.isEmpty()) {
                    return;
                }
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(this.resolveSchemaSources(listSchemaURIs));
                source = new StreamSource(new StringReader(sXml));
                validator = schema.newValidator();
                handler = new ValidationHandler();
                if (ATTEMPT_RESTRICT_EXTERNAL.get()) {
                    try {
                        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    }
                    catch (Exception e) {
                        if (!ATTEMPT_RESTRICT_EXTERNAL.compareAndSet(true, false)) break block6;
                        CacheFactory.log("Validator does not support JAXP 1.5 properties to restrict access to external XML DTDs and Schemas." + System.lineSeparator() + "To guard against XXE vulnerabilities, ensure provided XML parser is secure." + System.lineSeparator() + "Validator: " + validator.getClass().getCanonicalName() + System.lineSeparator() + "Error: " + e.getLocalizedMessage(), 2);
                    }
                }
            }
            validator.setErrorHandler(handler);
            validator.validate(source);
            if (handler.isError()) {
                throw handler.getException();
            }
        }
    }

    protected Source[] resolveSchemaSources(List<String> listUri) throws IOException {
        ArrayList<StreamSource> listSources = new ArrayList<StreamSource>();
        for (String sUri : listUri) {
            URL url = Resources.findFileOrResource(sUri, this.getClass().getClassLoader());
            if (url != null && ("http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol()))) {
                url = Resources.findFileOrResource(sUri.substring(sUri.lastIndexOf(47) + 1), this.getClass().getClassLoader());
            }
            if (url == null) {
                throw new IOException("The specified schema " + sUri + " cannot be found.");
            }
            try {
                URLConnection con = url.openConnection();
                con.setConnectTimeout(30000);
                StreamSource source = new StreamSource(con.getInputStream());
                source.setSystemId(url.toString());
                listSources.add(source);
            }
            catch (Throwable t) {
                throw new IOException("Unexpected exception resolving schema uri: " + sUri, t);
            }
        }
        return listSources.toArray(new Source[listUri.size()]);
    }

    protected XmlElement instantiateRoot(String sRoot) {
        return new SimpleElement(sRoot, null);
    }

    protected static Parser getParser() throws Exception {
        Parser parser = s_parser;
        if (parser == null) {
            try {
                Class<?> clzFactory = Class.forName("javax.xml.parsers.SAXParserFactory");
                Object factory = ClassHelper.invokeStatic(clzFactory, "newInstance", ClassHelper.VOID);
                ClassHelper.invoke(factory, "setValidating", new Object[]{Boolean.FALSE});
                Object SAXParser = ClassHelper.invoke(factory, "newSAXParser", ClassHelper.VOID);
                parser = (Parser)ClassHelper.invoke(SAXParser, "getParser", ClassHelper.VOID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (parser == null) {
                parser = ParserFactory.makeParser();
            }
            s_parser = parser;
        }
        return parser;
    }

    static {
        ATTEMPT_RESTRICT_EXTERNAL = new AtomicBoolean(true);
    }

    class SimpleHandler
    implements DocumentHandler,
    ErrorHandler {
        private XmlElement m_root;
        private XmlElement m_current;

        SimpleHandler(XmlElement root) {
            Base.azzert(root == null || root.isMutable());
            this.m_root = root;
        }

        @Override
        public void setDocumentLocator(Locator l) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            Base.azzert(this.m_current == null);
        }

        @Override
        public void startElement(String sTag, AttributeList attrs) throws SAXException {
            XmlElement el = this.m_current;
            if (el == null) {
                if (this.m_root == null) {
                    this.m_root = SaxParser.this.instantiateRoot(sTag);
                } else {
                    this.m_root.setName(sTag);
                }
                el = this.m_root;
            } else {
                el = el.addElement(sTag);
            }
            int cAttrs = attrs.getLength();
            for (int i = 0; i < cAttrs; ++i) {
                String sName = attrs.getName(i);
                String sValue = attrs.getValue(i);
                el.addAttribute(sName).setString(sValue);
            }
            this.m_current = el;
        }

        @Override
        public void endElement(String sTag) throws SAXException {
            String sText;
            XmlElement el = this.m_current;
            if (!el.getElementList().isEmpty() && (sText = el.getString()) != null) {
                el.setString(sText.trim());
            }
            this.m_current = el.getParent();
        }

        @Override
        public void characters(char[] ach, int offset, int cnt) throws SAXException {
            if (cnt > 0) {
                XmlElement el = this.m_current;
                String sValue = el.getString();
                String sText = new String(ach, offset, cnt);
                el.setString(sValue + sText);
            }
        }

        @Override
        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    protected class ValidationHandler
    implements ErrorHandler {
        private SAXParseException m_eParser;
        private int m_cError;

        protected ValidationHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            CacheFactory.log("Warning " + e.toString() + " - line  " + e.getLineNumber(), 2);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            CacheFactory.log("Error " + e.toString() + " - line " + e.getLineNumber(), 1);
            ++this.m_cError;
            if (this.m_eParser == null) {
                this.m_eParser = e;
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            CacheFactory.log("Fatal Error " + e.toString() + " - line " + e.getLineNumber(), 1);
            throw e;
        }

        public int getErrorCount() {
            return this.m_cError;
        }

        public SAXParseException getException() {
            return this.m_eParser;
        }

        public boolean isError() {
            return this.m_cError > 0 && this.m_eParser != null;
        }
    }
}

