/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.run.xml.ArrayAdapter;
import com.tangosol.run.xml.CollectionAdapter;
import com.tangosol.run.xml.MapAdapter;
import com.tangosol.run.xml.PrimitiveArrayAdapter;
import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.SerializableAdapter;
import com.tangosol.run.xml.SimpleAdapter;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlElementAdapter;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.run.xml.XmlSerializableAdapter;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SafeHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class XmlBean
extends ExternalizableHelper
implements Cloneable,
Externalizable,
ExternalizableLite,
XmlSerializable {
    private static Map s_mapXml = new SafeHashMap();
    private static Map s_mapInfo = new SafeHashMap();
    private transient XmlBean m_parent;
    private boolean m_fMutable = true;
    private transient int m_nHash;
    private transient BeanInfo m_info;

    protected XmlBean() {
    }

    public XmlBean getParentXmlBean() {
        return this.m_parent;
    }

    protected void setParentXmlBean(XmlBean parent) {
        XmlBean parentOrig = this.m_parent;
        if (parentOrig != null && parentOrig != parent) {
            throw new IllegalStateException("ParentXmlBean is immutable.");
        }
        this.m_parent = parent;
    }

    protected void adopt(Map map) {
        if (map != null && !map.isEmpty()) {
            this.adopt(map.keySet());
            this.adopt(map.entrySet());
        }
    }

    protected void adopt(Collection coll) {
        if (coll != null && !coll.isEmpty()) {
            this.adopt(coll.iterator());
        }
    }

    protected void adopt(Iterator iter) {
        if (iter != null) {
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof XmlBean)) continue;
                this.adopt((XmlBean)o);
            }
        }
    }

    protected void adopt(Object[] ao) {
        if (ao != null) {
            for (Object o : ao) {
                if (!(o instanceof XmlBean)) continue;
                this.adopt((XmlBean)o);
            }
        }
    }

    protected void adopt(XmlBean child) {
        child.setParentXmlBean(this);
    }

    public boolean isMutable() {
        return this.m_fMutable;
    }

    protected void setMutable(boolean fMutable) {
        this.m_fMutable = fMutable;
    }

    public XmlBean ensureMutable() {
        if (this.isMutable()) {
            return this;
        }
        XmlBean that = (XmlBean)this.clone();
        XmlBean.azzert(that.isMutable());
        return that;
    }

    public void ensureReadOnly() {
        this.setMutable(false);
    }

    protected void checkMutable() {
        if (!this.isMutable()) {
            throw new IllegalStateException(this.getBeanInfo().getName() + " is immutable");
        }
        XmlBean parent = this.getParentXmlBean();
        if (parent != null) {
            parent.checkMutable();
        }
    }

    protected int getHashCode() {
        return this.m_nHash;
    }

    protected void setHashCode(int nHash) {
        this.m_nHash = nHash;
    }

    public BeanInfo getBeanInfo() {
        BeanInfo info = this.m_info;
        if (info == null) {
            info = this.findBeanInfo();
            XmlBean.azzert(info != null);
            this.m_info = info;
        }
        return info;
    }

    public PropertyAdapter[] getAdapters() {
        return this.getBeanInfo().getAdapters();
    }

    public boolean equals(Object o) {
        if (!(o instanceof XmlBean)) {
            return false;
        }
        XmlBean that = (XmlBean)o;
        if (this == that) {
            return true;
        }
        int nThis = this.getHashCode();
        int nThat = that.getHashCode();
        if (nThis != 0 && nThat != 0 && nThis != nThat) {
            return false;
        }
        for (PropertyAdapter adapter : this.getAdapters()) {
            Object oThat;
            Object oThis = adapter.get(this);
            if (adapter.equalsValue(oThis, oThat = adapter.get(that))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getHashCode();
        if (n == 0) {
            for (PropertyAdapter adapter : this.getAdapters()) {
                n ^= adapter.hash(adapter.get(this));
            }
            if (n == 0) {
                n = -1;
            }
            this.setHashCode(n);
        }
        return n;
    }

    public String toString() {
        return XmlHelper.toString(this);
    }

    public Object clone() {
        XmlBean that;
        try {
            that = (XmlBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw XmlBean.ensureRuntimeException(e);
        }
        that.m_parent = null;
        that.setMutable(true);
        BeanInfo info = this.getBeanInfo();
        if (info.requiresDeepClone()) {
            for (PropertyAdapter adapter : info.getAdapters()) {
                Object o;
                if (!adapter.isCloneRequired() || adapter.getMutator() == null || (o = adapter.get(this)) == null) continue;
                adapter.set(that, adapter.clone(o));
            }
        }
        return that;
    }

    @Override
    public XmlElement toXml() {
        SimpleElement xml;
        BeanInfo info = this.getBeanInfo();
        PropertyAdapter[] aAdapter = info.getAdapters();
        String sName = info.getName();
        if (sName.length() == 0) {
            SimpleElement xml2 = new SimpleElement(ClassHelper.getSimpleName(info.getType()));
            for (PropertyAdapter adapter : aAdapter) {
                Object o = adapter.get(this);
                if (adapter.isEmpty(o)) continue;
                adapter.writeXml(xml2, o);
                break;
            }
            return xml2;
        }
        String sNmsPrefix = info.getNamespacePrefix();
        if (sNmsPrefix == null) {
            xml = new SimpleElement(sName);
        } else {
            xml = new SimpleElement(sNmsPrefix + ':' + sName);
            XmlHelper.ensureNamespace(xml, sNmsPrefix, info.getNamespaceUri());
        }
        for (PropertyAdapter adapter : aAdapter) {
            Object o = adapter.get(this);
            adapter.writeXml(xml, o);
        }
        if (sNmsPrefix != null) {
            XmlHelper.purgeChildrenNamespace(xml);
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromXml(XmlElement xml) {
        BeanInfo info = this.getBeanInfo();
        PropertyAdapter[] aAdapter = info.getAdapters();
        String sName = info.getName();
        if (sName.length() == 0) {
            for (PropertyAdapter adapter : aAdapter) {
                if (adapter.getMutator() == null || !adapter.isAnonymous() && !adapter.isElementMatch(xml)) continue;
                SimpleElement xmlParent = new SimpleElement(ClassHelper.getSimpleName(this.getClass()));
                xmlParent.getElementList().add(xml);
                List list = xml.getElementList();
                list.add(xmlParent);
                try {
                    Object o = adapter.readXml(xmlParent);
                    if (o == null) break;
                    adapter.set(this, o);
                    break;
                }
                finally {
                    list.remove(xmlParent);
                }
            }
        } else {
            for (PropertyAdapter adapter : aAdapter) {
                Object o;
                if (adapter.getMutator() == null || (o = adapter.readXml(xml)) == null) continue;
                adapter.set(this, o);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int i;
        boolean fMutable = in.readBoolean();
        BeanInfo info = this.getBeanInfo();
        PropertyAdapter[] aAdapter = info.getAdapters();
        while ((i = XmlBean.readInt(in)) >= 0) {
            PropertyAdapter adapter = aAdapter[i];
            Object o = adapter.readExternal(in);
            if (o == null || adapter.getMutator() == null) continue;
            adapter.set(this, o);
        }
        this.m_fMutable = fMutable;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fMutable);
        BeanInfo info = this.getBeanInfo();
        PropertyAdapter[] aAdapter = info.getAdapters();
        int c = aAdapter.length;
        for (int i = 0; i < c; ++i) {
            Object o;
            PropertyAdapter adapter = aAdapter[i];
            if (adapter.getMutator() == null || adapter.isEmpty(o = adapter.get(this))) continue;
            XmlBean.writeInt(out, i);
            adapter.writeExternal(out, o);
        }
        XmlBean.writeInt(out, -1);
    }

    protected static void init(Class clz, String sName, String[] asProp) {
        SimpleElement xml = new SimpleElement("xml-bean");
        xml.addElement("name").setString(sName);
        int c = asProp.length;
        for (int i = 0; i < c; ++i) {
            XmlElement xmlProp = xml.addElement("property");
            String sProp = asProp[i];
            xmlProp.addElement("name").setString(sProp);
            xmlProp.addElement("xml-name").setString(sProp);
        }
        s_mapXml.put(clz, xml);
    }

    private BeanInfo findBeanInfo() {
        Class<?> clz = this.getClass();
        BeanInfo info = (BeanInfo)s_mapInfo.get(clz);
        if (info == null) {
            info = this.initBeanInfo();
            s_mapInfo.put(clz, info);
        }
        return info;
    }

    protected BeanInfo initBeanInfo() {
        Class<?> clzBean = this.getClass();
        XmlElement xml = null;
        for (Class<?> clz = clzBean; clz != null; clz = clz.getSuperclass()) {
            XmlElement xmlClz = (XmlElement)s_mapXml.get(clz);
            if (xmlClz == null) {
                xmlClz = XmlHelper.loadXml(clz);
            }
            if (xml == null) {
                xml = xmlClz;
                continue;
            }
            if (xmlClz == null) continue;
            List list = xml.getElementList();
            int ix = 0;
            Iterator iter = xmlClz.getElements("property");
            while (iter.hasNext()) {
                XmlElement xmlProp = (XmlElement)iter.next();
                String sProp = xmlProp.getElement("name").getName();
                XmlElement xmlSub = XmlHelper.findElement(xml, "/property/name", sProp);
                if (xmlSub != null) {
                    xmlProp = xmlSub.getParent();
                    list.remove(xmlProp);
                }
                list.add(ix++, xmlProp);
            }
        }
        XmlBean.azzert(xml != null, "Cannot find bean info for " + clzBean);
        return new BeanInfo(clzBean, xml);
    }

    public static class BeanInfo {
        protected Class m_clzBean;
        protected String m_sName;
        protected PropertyAdapter[] m_aAdapter;
        protected boolean m_fDeepClone;
        protected String m_sNmsUri;
        protected String m_sNmsPrefix;
        protected int m_nBeanId = -1;
        protected static final Class[] NOPARAMS = new Class[0];
        protected static Class[] ADAPTER_INIT_PARAMS = new Class[]{BeanInfo.class, Class.class, String.class, String.class, XmlElement.class};
        protected static final Map s_mapClassNames = new HashMap();
        protected static final Map s_mapClassAdapters;
        protected static final Map s_mapPrimitiveNames;

        protected BeanInfo(Class clzBean, XmlElement xml) {
            this.m_clzBean = clzBean;
            XmlElement xmlName = xml.getElement("name");
            if (xmlName == null) {
                xmlName = xml.getElement("xml-name");
            }
            String sName = xmlName == null ? ClassHelper.getSimpleName(clzBean) : xmlName.getString();
            Base.azzert(sName != null);
            this.m_sName = sName;
            XmlElement xmlNms = xml.getElement("xmlns");
            if (xmlNms != null) {
                this.m_sNmsUri = xmlNms.getSafeElement("uri").getString(null);
                this.m_sNmsPrefix = xmlNms.getSafeElement("prefix").getString(null);
            }
            ArrayList<PropertyAdapter> list = new ArrayList<PropertyAdapter>();
            Iterator iter = xml.getElements("property");
            while (iter.hasNext()) {
                Class<?> clzProp;
                XmlElement xmlProp = (XmlElement)iter.next();
                String sProp = xmlProp.getSafeElement("name").getString();
                Base.azzert(sProp != null && sProp.length() > 0);
                XmlElement xmlXmlName = xmlProp.getElement("xml-name");
                String sXmlName = xmlXmlName == null ? sProp : xmlXmlName.getString();
                String sClass = xmlProp.getSafeElement("type").getString();
                if (sClass != null && sClass.length() > 0) {
                    clzProp = this.resolveClass(sClass);
                } else {
                    Method method = null;
                    try {
                        method = clzBean.getMethod("get" + sProp, NOPARAMS);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            method = clzBean.getMethod("is" + sProp, NOPARAMS);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method == null) {
                        throw new RuntimeException("Unable to find accessor for " + sProp + " on " + clzBean.getName());
                    }
                    clzProp = method.getReturnType();
                }
                list.add(this.makeAdapter(clzProp, sProp, sXmlName, xmlProp));
            }
            PropertyAdapter[] aAdapter = list.toArray(new PropertyAdapter[list.size()]);
            this.m_aAdapter = aAdapter;
            for (PropertyAdapter adapter : aAdapter) {
                if (!adapter.isCloneRequired() || adapter.getMutator() == null) continue;
                this.m_fDeepClone = true;
                break;
            }
            if (ExternalizableHelper.USE_XMLBEAN_CLASS_CACHE) {
                this.m_nBeanId = ExternalizableHelper.XMLBEAN_CLASS_CACHE.getClassId(clzBean);
            }
        }

        public Class getType() {
            return this.m_clzBean;
        }

        public int getBeanId() {
            return this.m_nBeanId;
        }

        public String getName() {
            return this.m_sName;
        }

        public String getNamespaceUri() {
            return this.m_sNmsUri;
        }

        public String getNamespacePrefix() {
            return this.m_sNmsPrefix;
        }

        public void setNamespacePrefix(String sPrefix) {
            this.m_sNmsPrefix = sPrefix;
        }

        public PropertyAdapter[] getAdapters() {
            return this.m_aAdapter;
        }

        public boolean requiresDeepClone() {
            return this.m_fDeepClone;
        }

        protected PropertyAdapter makeAdapter(Class clz, String sName, String sXmlName, XmlElement xml) {
            Class clzAdapter;
            String sAdapter = xml.getSafeElement("adapter").getString();
            Class clazz = clzAdapter = sAdapter != null && sAdapter.length() > 0 ? this.resolveClass(sAdapter) : (Class<XmlElementAdapter>)s_mapClassAdapters.get(clz);
            if (clzAdapter == null) {
                if (XmlElement.class.isAssignableFrom(clz)) {
                    clzAdapter = XmlElementAdapter.class;
                } else if (XmlSerializable.class.isAssignableFrom(clz)) {
                    clzAdapter = XmlSerializableAdapter.class;
                } else if (Object[].class.isAssignableFrom(clz)) {
                    clzAdapter = ArrayAdapter.class;
                } else if (Collection.class.isAssignableFrom(clz)) {
                    clzAdapter = CollectionAdapter.class;
                } else if (Map.class.isAssignableFrom(clz)) {
                    clzAdapter = MapAdapter.class;
                } else if (Serializable.class.isAssignableFrom(clz)) {
                    clzAdapter = SerializableAdapter.class;
                }
            }
            if (clzAdapter == null) {
                throw new RuntimeException("XmlBean:  No suitable adapter for:  " + clz.getName());
            }
            try {
                Constructor constructor = clzAdapter.getConstructor(ADAPTER_INIT_PARAMS);
                Object[] aoParams = new Object[]{this, clz, sName, sXmlName, xml};
                return (PropertyAdapter)constructor.newInstance(aoParams);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Instantiating adapter: " + clzAdapter.getName());
            }
        }

        public PropertyAdapter findAdapter(String sName) {
            for (PropertyAdapter adapter : this.getAdapters()) {
                if (!adapter.getName().equals(sName)) continue;
                return adapter;
            }
            return null;
        }

        public Class resolveClass(String sClass) {
            Class clz = (Class)s_mapClassNames.get(sClass);
            if (clz != null) {
                return clz;
            }
            if (sClass.endsWith("[]")) {
                clz = this.resolveClass(sClass.substring(0, sClass.length() - 2));
                sClass = clz.isArray() ? '[' + clz.getName() : (clz.isPrimitive() ? "[" + s_mapPrimitiveNames.get(clz) : "[L" + clz.getName() + ';');
            }
            try {
                ClassLoader loader = this.m_clzBean.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                return Class.forName(sClass, false, loader);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("BeanInfo for ").append(this.getName()).append(", type=").append(this.getType().getName()).append(", requiresDeepClone=").append(this.requiresDeepClone()).append(", NamespaceUri=").append(this.getNamespaceUri()).append(", NamespacePrefix=").append(this.getNamespacePrefix());
            return sb.toString();
        }

        static {
            Map map = s_mapClassNames;
            map.put("boolean", Boolean.TYPE);
            map.put("byte", Byte.TYPE);
            map.put("char", Character.TYPE);
            map.put("short", Short.TYPE);
            map.put("int", Integer.TYPE);
            map.put("long", Long.TYPE);
            map.put("float", Float.TYPE);
            map.put("double", Double.TYPE);
            map.put("Boolean", Boolean.class);
            map.put("Byte", Byte.class);
            map.put("Character", Character.class);
            map.put("Short", Short.class);
            map.put("Integer", Integer.class);
            map.put("Long", Long.class);
            map.put("Float", Float.class);
            map.put("Double", Double.class);
            map.put("BigDecimal", BigDecimal.class);
            map.put("BigInteger", BigInteger.class);
            map.put("String", String.class);
            map.put("Date", Date.class);
            map.put("Time", Time.class);
            map.put("Timestamp", Timestamp.class);
            s_mapClassAdapters = new HashMap();
            map = s_mapClassAdapters;
            map.put(Boolean.TYPE, SimpleAdapter.BooleanAdapter.class);
            map.put(Byte.TYPE, SimpleAdapter.ByteAdapter.class);
            map.put(Character.TYPE, SimpleAdapter.CharAdapter.class);
            map.put(Short.TYPE, SimpleAdapter.ShortAdapter.class);
            map.put(Integer.TYPE, SimpleAdapter.IntAdapter.class);
            map.put(Long.TYPE, SimpleAdapter.LongAdapter.class);
            map.put(Float.TYPE, SimpleAdapter.FloatAdapter.class);
            map.put(Double.TYPE, SimpleAdapter.DoubleAdapter.class);
            map.put(Boolean.class, SimpleAdapter.BooleanAdapter.class);
            map.put(Byte.class, SimpleAdapter.ByteAdapter.class);
            map.put(Character.class, SimpleAdapter.CharAdapter.class);
            map.put(Short.class, SimpleAdapter.ShortAdapter.class);
            map.put(Integer.class, SimpleAdapter.IntAdapter.class);
            map.put(Long.class, SimpleAdapter.LongAdapter.class);
            map.put(Float.class, SimpleAdapter.FloatAdapter.class);
            map.put(Double.class, SimpleAdapter.DoubleAdapter.class);
            map.put(boolean[].class, PrimitiveArrayAdapter.BooleanArrayAdapter.class);
            map.put(byte[].class, PrimitiveArrayAdapter.ByteArrayAdapter.class);
            map.put(char[].class, PrimitiveArrayAdapter.CharArrayAdapter.class);
            map.put(short[].class, PrimitiveArrayAdapter.ShortArrayAdapter.class);
            map.put(int[].class, PrimitiveArrayAdapter.IntArrayAdapter.class);
            map.put(long[].class, PrimitiveArrayAdapter.LongArrayAdapter.class);
            map.put(float[].class, PrimitiveArrayAdapter.FloatArrayAdapter.class);
            map.put(double[].class, PrimitiveArrayAdapter.DoubleArrayAdapter.class);
            map.put(String.class, SimpleAdapter.StringAdapter.class);
            map.put(BigDecimal.class, SimpleAdapter.BigDecimalAdapter.class);
            map.put(BigInteger.class, SimpleAdapter.BigIntegerAdapter.class);
            map.put(Date.class, SimpleAdapter.DateAdapter.class);
            map.put(Time.class, SimpleAdapter.TimeAdapter.class);
            map.put(Timestamp.class, SimpleAdapter.TimestampAdapter.class);
            map.put(java.util.Date.class, SimpleAdapter.OldDateAdapter.class);
            s_mapPrimitiveNames = new HashMap();
            map = s_mapPrimitiveNames;
            map.put(Boolean.TYPE, "Z");
            map.put(Byte.TYPE, "B");
            map.put(Character.TYPE, "C");
            map.put(Short.TYPE, "S");
            map.put(Integer.TYPE, "I");
            map.put(Long.TYPE, "J");
            map.put(Float.TYPE, "F");
            map.put(Double.TYPE, "D");
        }
    }
}

