/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.xml.preprocessor.SystemPropertyPreprocessor;
import com.tangosol.io.Base64InputStream;
import com.tangosol.io.Base64OutputStream;
import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.Resources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class XmlHelper
extends Base {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public static XmlDocument loadXml(Class clz) {
        return XmlHelper.loadXml(clz, null);
    }

    public static XmlDocument loadXml(Class clz, String sCharset) {
        String sName = clz.getName();
        sName = sName.substring(sName.lastIndexOf(46) + 1);
        return XmlHelper.loadXml(clz, sName + ".xml", sCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlDocument loadXml(Class clz, String sName, String sCharset) {
        InputStream stream = clz.getResourceAsStream(sName);
        if (stream == null) {
            return null;
        }
        try {
            XmlDocument xmlDocument = sCharset == null ? XmlHelper.loadXml(stream) : XmlHelper.loadXml(stream, sCharset);
            return xmlDocument;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static XmlDocument loadXml(InputStream stream) {
        try {
            return new SimpleParser().parseXml(stream);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static XmlDocument loadXml(InputStream stream, String sCharset) {
        try {
            return new SimpleParser().parseXml(stream, sCharset);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static XmlDocument loadXml(URL url) {
        try {
            return XmlHelper.loadXml(url.openStream());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static XmlDocument loadXml(URL url, String sCharset) {
        try {
            return XmlHelper.loadXml(url.openStream(), sCharset);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static XmlDocument loadXml(String sXml) {
        try {
            return new SimpleParser().parseXml(sXml);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static void loadXml(String sXml, XmlDocument xmlRoot) {
        XmlHelper.loadXml(sXml, xmlRoot, true);
    }

    public static void loadXml(String sXml, XmlDocument xmlRoot, boolean fValidate) {
        try {
            new SimpleParser(fValidate).parseXml(sXml, xmlRoot);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static XmlDocument loadResource(String sName, String sDescr) {
        return XmlHelper.loadResourceInternal(sName, sDescr, null, false, true);
    }

    public static XmlDocument loadResource(String sName, String sDescr, ClassLoader loader) {
        return XmlHelper.loadResourceInternal(sName, sDescr, loader, false, true);
    }

    public static XmlDocument loadResource(URL url, String sDescr, ClassLoader loader) {
        return XmlHelper.loadResourceInternal(url, sDescr, true);
    }

    public static XmlDocument loadFileOrResource(String sName, String sDescr) {
        return XmlHelper.loadResourceInternal(sName, sDescr, null, true, true);
    }

    public static XmlDocument loadFileOrResource(String sName, String sDescr, ClassLoader loader) {
        return XmlHelper.loadResourceInternal(sName, sDescr, loader, true, true);
    }

    public static XmlDocument loadFileOrResource(String sName, String sDescr, ClassLoader loader, boolean fWarnNoSchema) {
        return XmlHelper.loadResourceInternal(sName, sDescr, loader, true, fWarnNoSchema);
    }

    protected static XmlDocument loadResourceInternal(String sName, String sDescr, ClassLoader loader, boolean fFile, boolean fWarnNoSchema) {
        URL url;
        sDescr = sDescr == null ? "configuration" : sDescr;
        URL uRL = url = fFile ? Resources.findFileOrResource(sName, loader) : Resources.findResource(sName, loader);
        if (url == null) {
            throw new RuntimeException("The " + sDescr + " is missing: \"" + sName + "\", loader=" + loader);
        }
        return XmlHelper.loadResourceInternal(url, sDescr, fWarnNoSchema);
    }

    protected static XmlDocument loadResourceInternal(URL url, String sDescr, boolean fWarnNoSchema) {
        String string = sDescr = sDescr == null ? "configuration" : sDescr;
        if (url == null) {
            throw new IllegalArgumentException("The " + sDescr + " URL cannot be null");
        }
        try {
            XmlDocument xml = url.getProtocol().equals("file") ? XmlHelper.loadXml(url) : XmlHelper.loadXml(url, "ISO-8859-1");
            StringBuilder sb = new StringBuilder(256);
            sb.append("Loaded ").append(sDescr).append(" from \"").append(url).append('\"');
            if (fWarnNoSchema && XmlHelper.getSchemaLocations(xml, null).isEmpty()) {
                sb.append("; this document does not refer to any schema definition and has not been validated.");
            }
            CacheFactory.log(sb.toString(), 3);
            return xml;
        }
        catch (RuntimeException e) {
            throw XmlHelper.ensureRuntimeException(e, "Failed to load " + sDescr + ": " + url);
        }
    }

    public static boolean isEncodingValid(String sEncoding) {
        if (sEncoding == null) {
            return false;
        }
        char[] ach = sEncoding.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return false;
        }
        char ch = ach[0];
        if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
            return false;
        }
        block3: for (int of = 1; of < cch; ++of) {
            ch = ach[of];
            switch (ch) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSystemIdentifierValid(String sName) {
        return true;
    }

    public static boolean isPublicIdentifierValid(String sName) {
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        block3: for (int of = 0; of < cch; ++of) {
            switch (ach[of]) {
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isCommentValid(String sComment) {
        return !sComment.contains("--");
    }

    public static boolean isNameValid(String sName) {
        if (sName == null) {
            return false;
        }
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return false;
        }
        char ch = ach[0];
        if (!Character.isLetter(ch) && ch != '_' && ch != ':') {
            return false;
        }
        block3: for (int of = 1; of < cch; ++of) {
            ch = ach[of];
            switch (ch) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    if (Character.isLetter(ch) || Character.isDigit(ch)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static String trim(String s) {
        int ofStart;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        int ofEnd = cch;
        for (ofStart = 0; ofStart < cch && XmlHelper.isWhitespace(ach[ofStart]); ++ofStart) {
        }
        if (ofStart >= cch) {
            return "";
        }
        while (XmlHelper.isWhitespace(ach[ofEnd - 1])) {
            --ofEnd;
        }
        return ofStart > 0 || ofEnd < cch ? s.substring(ofStart, ofEnd) : s;
    }

    public static String trimf(String s) {
        int of;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        for (of = 0; of < cch && XmlHelper.isWhitespace(ach[of]); ++of) {
        }
        if (of >= cch) {
            return "";
        }
        if (of == 0) {
            return s;
        }
        return s.substring(of);
    }

    public static String trimb(String s) {
        int of;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        for (of = cch - 1; of >= 0 && XmlHelper.isWhitespace(ach[of]); --of) {
        }
        if (of < 0) {
            return "";
        }
        if (of == cch - 1) {
            return s;
        }
        return s.substring(0, of + 1);
    }

    public static String encodeAttribute(String sValue, char chQuote) {
        XmlHelper.azzert(chQuote == '\'' || chQuote == '\"', "Invalid quote character");
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return sValue;
        }
        StringBuffer sb = null;
        int ofPrev = 0;
        block11: for (int of = 0; of < cch; ++of) {
            char ch = ach[of];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch != chQuote) continue block11;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '&': 
                case '<': 
                case '>': {
                    if (sb == null) {
                        sb = new StringBuffer(cch + 16);
                    }
                    if (of > ofPrev) {
                        sb.append(ach, ofPrev, of - ofPrev);
                    }
                    switch (ch) {
                        case '>': {
                            sb.append("&gt;");
                            break;
                        }
                        case '<': {
                            sb.append("&lt;");
                            break;
                        }
                        case '&': {
                            sb.append("&amp;");
                            break;
                        }
                        case '\'': {
                            sb.append("&apos;");
                            break;
                        }
                        case '\"': {
                            sb.append("&quot;");
                            break;
                        }
                        default: {
                            sb.append("&#x");
                            char n = ch;
                            if ((n & 0xF000) != 0) {
                                sb.append(HEX[n >>> 12]);
                            }
                            if ((n & 0xFF00) != 0) {
                                sb.append(HEX[n >>> 8 & 0xF]);
                            }
                            if ((n & 0xFFF0) != 0) {
                                sb.append(HEX[n >>> 4 & 0xF]);
                            }
                            sb.append(HEX[n & 0xF]);
                            sb.append(';');
                        }
                    }
                    ofPrev = of + 1;
                }
            }
        }
        if (sb != null && ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb == null ? sValue : sb.toString();
    }

    public static String decodeAttribute(String sValue) {
        if (sValue.indexOf(38) == -1) {
            return sValue;
        }
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        StringBuilder sb = new StringBuilder(cch);
        int ofPrev = 0;
        for (int of = 0; of < cch; ++of) {
            int ofSemi;
            if (ach[of] != '&') continue;
            for (ofSemi = of + 1; ofSemi < cch && ach[ofSemi] != ';'; ++ofSemi) {
            }
            if (ofSemi >= cch || ofSemi == of + 1) {
                throw new IllegalArgumentException("The XML attribute (" + sValue + ") contains an unescaped '&'");
            }
            if (of > ofPrev) {
                sb.append(ach, ofPrev, of - ofPrev);
                ofPrev = of;
            }
            if (ach[of + 1] == '#') {
                boolean fHex = ach[of + 2] == 'x';
                String sEsc = sValue.substring(of + (fHex ? 3 : 2), ofSemi);
                try {
                    if (sEsc.length() < 1) {
                        throw new IllegalArgumentException("not a number");
                    }
                    int n = Integer.parseInt(sEsc, fHex ? 16 : 10);
                    if (n < 0 || n > 65535) {
                        throw new IllegalArgumentException("out of range");
                    }
                    sb.append((char)n);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The XML attribute (" + sValue + ") contains an illegal escape (" + (fHex ? "hex" : "decimal") + ' ' + sEsc + ')');
                }
            } else {
                String sEsc = sValue.substring(of + 1, ofSemi);
                if (sEsc.equals("amp")) {
                    sb.append('&');
                } else if (sEsc.equals("apos")) {
                    sb.append('\'');
                } else if (sEsc.equals("gt")) {
                    sb.append('>');
                } else if (sEsc.equals("lt")) {
                    sb.append('<');
                } else {
                    if (!sEsc.equals("quot")) continue;
                    sb.append('\"');
                }
            }
            of = ofSemi;
            ofPrev = of + 1;
        }
        if (ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb.toString();
    }

    public static String encodeContent(String sValue, boolean fPreferBlockEscape) {
        int cchNonWhite;
        int of;
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return sValue;
        }
        if (fPreferBlockEscape) {
            boolean fUseCdataEscape = true;
            boolean fRequiresEscape = XmlHelper.isWhitespace(ach[0]) || XmlHelper.isWhitespace(ach[cch - 1]);
            block26: for (int of2 = 0; of2 < cch; ++of2) {
                char nch = ach[of2];
                switch (nch) {
                    case '&': 
                    case '<': {
                        fRequiresEscape = true;
                        continue block26;
                    }
                    case ']': {
                        if (of2 + 2 >= cch || ach[of2 + 1] != ']' || ach[of2 + 2] != '>') continue block26;
                        fUseCdataEscape = false;
                    }
                }
            }
            if (!fRequiresEscape) {
                return sValue;
            }
            if (fUseCdataEscape) {
                return "<![CDATA[" + sValue + "]]>";
            }
        }
        StringBuilder sb = new StringBuilder(cch + 16);
        block27: for (of = 0; of < cch; ++of) {
            switch (ach[of]) {
                case '\t': {
                    sb.append("&#x09;");
                    continue block27;
                }
                case '\n': {
                    sb.append("&#x0A;");
                    continue block27;
                }
                case '\r': {
                    sb.append("&#x0D;");
                    continue block27;
                }
                case ' ': {
                    sb.append("&#x20;");
                    continue block27;
                }
            }
        }
        for (cchNonWhite = cch; cchNonWhite > of && XmlHelper.isWhitespace(ach[cchNonWhite - 1]); --cchNonWhite) {
        }
        int ofPrev = of;
        int cBrackets = 0;
        while (of < cchNonWhite) {
            char ch = ach[of];
            switch (ch) {
                case ']': {
                    ++cBrackets;
                    break;
                }
                case '>': {
                    if (cBrackets < 2) {
                        cBrackets = 0;
                        break;
                    }
                }
                case '&': 
                case '<': {
                    if (of > ofPrev) {
                        sb.append(ach, ofPrev, of - ofPrev);
                    }
                    switch (ch) {
                        case '>': {
                            sb.append("&gt;");
                            break;
                        }
                        case '<': {
                            sb.append("&lt;");
                            break;
                        }
                        case '&': {
                            sb.append("&amp;");
                            break;
                        }
                        default: {
                            XmlHelper.azzert();
                        }
                    }
                    ofPrev = of + 1;
                    cBrackets = 0;
                    break;
                }
                default: {
                    cBrackets = 0;
                }
            }
            ++of;
        }
        if (ofPrev < cchNonWhite) {
            sb.append(ach, ofPrev, cchNonWhite - ofPrev);
        }
        while (of < cch) {
            switch (ach[of]) {
                case '\t': {
                    sb.append("&#x09;");
                    break;
                }
                case '\n': {
                    sb.append("&#x0A;");
                    break;
                }
                case '\r': {
                    sb.append("&#x0D;");
                    break;
                }
                case ' ': {
                    sb.append("&#x20;");
                    break;
                }
                default: {
                    XmlHelper.azzert();
                }
            }
            ++of;
        }
        return sb.toString();
    }

    public static String decodeContent(String sValue) {
        return XmlHelper.decodeAttribute(sValue);
    }

    public static String encodeUri(String sUri) {
        int ofPrev;
        char[] ach = sUri.toCharArray();
        int cch = ach.length;
        boolean fEsc = false;
        block8: for (int of = 0; of < cch; ++of) {
            char ch = ach[of];
            switch (ch) {
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    fEsc = true;
                    break block8;
                }
                default: {
                    if (ch > '\u001f' && ch < '\u007f') continue block8;
                    fEsc = true;
                    break block8;
                }
            }
        }
        if (!fEsc) {
            return sUri;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(cch + 32);
        try {
            new DataOutputStream(stream).writeUTF(sUri);
        }
        catch (IOException e) {
            throw XmlHelper.ensureRuntimeException(e);
        }
        ach = stream.toString(0).toCharArray();
        cch = ach.length;
        StringBuilder sb = new StringBuilder(cch + 32);
        block9: for (int ofCur = ofPrev = 2; ofCur < cch; ++ofCur) {
            char ch = ach[ofCur];
            switch (ch) {
                default: {
                    if (ch > '\u001f' && ch < '\u007f') continue block9;
                }
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    if (ofCur > ofPrev) {
                        sb.append(ach, ofPrev, ofCur - ofPrev);
                    }
                    sb.append('%').append(XmlHelper.toHex(ch));
                    ofPrev = ofCur + 1;
                }
            }
        }
        if (sb != null && ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb.toString();
    }

    public static String decodeUri(String sUri) {
        String sOrig = sUri;
        if (sUri.indexOf(37) != -1) {
            char[] ach = sUri.toCharArray();
            int cch = ach.length;
            StringBuilder sb = new StringBuilder(cch + 16);
            int ofPrev = 0;
            for (int of = 0; of < cch; ++of) {
                if (ach[of] != '%') continue;
                if (of + 2 >= cch) {
                    throw new IllegalArgumentException("The URI (" + sOrig + ") contains an unescaped '%'");
                }
                if (of > ofPrev) {
                    sb.append(ach, ofPrev, of - ofPrev);
                }
                try {
                    int n = Integer.parseInt(sUri.substring(of + 1, of + 3), 16);
                    if (n < 0 || n > 255) {
                        throw new IllegalArgumentException("out of range");
                    }
                    sb.append((char)n);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The URI (" + sOrig + ") contains an illegal escape");
                }
                ofPrev = (of += 2) + 1;
            }
            if (ofPrev < cch) {
                sb.append(ach, ofPrev, cch - ofPrev);
            }
            sUri = sb.toString();
        }
        int cch = sUri.length();
        int cb = cch + 2;
        byte[] ab = new byte[cb];
        ab[0] = (byte)(cch >>> 8 & 0xFF);
        ab[1] = (byte)(cch & 0xFF);
        sUri.getBytes(0, cch, ab, 2);
        try {
            return new DataInputStream(new ByteArrayInputStream(ab)).readUTF();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid URI: " + sUri);
        }
    }

    public static String quote(String s) {
        return '\'' + XmlHelper.encodeAttribute(s, '\'') + '\'';
    }

    public static String getAbsolutePath(XmlElement xml) {
        XmlHelper.azzert(xml != null, "Null element");
        StringBuilder sb = new StringBuilder();
        do {
            sb.insert(0, "/" + xml.getName());
        } while ((xml = xml.getParent()) != null);
        return sb.toString();
    }

    public static boolean isEmpty(XmlElement xml) {
        if (!xml.isEmpty()) {
            return false;
        }
        Map mapAttr = xml.getAttributeMap();
        if (!mapAttr.isEmpty()) {
            return false;
        }
        List listEl = xml.getElementList();
        if (!listEl.isEmpty()) {
            return false;
        }
        for (XmlElement xmlEl : listEl) {
            if (XmlHelper.isEmpty(xmlEl)) continue;
            return false;
        }
        return true;
    }

    public static XmlElement getElement(XmlElement xml2, String sName) {
        XmlHelper.azzert(xml2 != null && sName != null && XmlHelper.isNameValid(sName), "Null element or invalid name");
        List list = xml2.getElementList();
        if (list.isEmpty()) {
            return null;
        }
        for (XmlElement xml2 : list) {
            if (!xml2.getName().equals(sName)) continue;
            return xml2;
        }
        return null;
    }

    public static boolean hasElement(XmlElement xml2, String sName) {
        XmlHelper.azzert(xml2 != null && sName != null && XmlHelper.isNameValid(sName), "Null element or invalid name");
        List list = xml2.getElementList();
        for (XmlElement xml2 : list) {
            if (!xml2.getName().equals(sName)) continue;
            return true;
        }
        return false;
    }

    public static XmlElement findElement(XmlElement xml, String sPath) {
        XmlHelper.azzert(xml != null && sPath != null, "Null element or path");
        if (sPath.startsWith("/")) {
            xml = xml.getRoot();
        }
        StringTokenizer tokens = new StringTokenizer(sPath, "/");
        while (xml != null && tokens.hasMoreTokens()) {
            String sName = tokens.nextToken();
            if (sName.equals("..")) {
                if ((xml = xml.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path " + sPath);
            }
            xml = xml.getElement(sName);
        }
        return xml;
    }

    public static XmlElement findElement(XmlElement xml, String sPath, Object oValue) {
        String sName;
        XmlHelper.azzert(xml != null && sPath != null, "Null element or path");
        while (sPath.startsWith("/")) {
            xml = xml.getRoot();
            sPath = sPath.substring(1);
        }
        int ofNext = sPath.indexOf("/");
        if (ofNext == -1) {
            sName = sPath;
            sPath = "";
        } else {
            sName = sPath.substring(0, ofNext);
            sPath = sPath.substring(ofNext + 1);
            while (sPath.startsWith("/")) {
                sPath = sPath.substring(1);
            }
        }
        if (sPath.length() == 0) {
            if (sName.equals("..")) {
                return (xml = xml.getParent()) != null && XmlHelper.equals(xml.getValue(), oValue) ? xml : null;
            }
            Iterator iter = xml.getElements(sName);
            while (iter.hasNext()) {
                xml = (XmlElement)iter.next();
                if (!XmlHelper.equals(xml.getValue(), oValue)) continue;
                return xml;
            }
            return null;
        }
        if (sName.equals("..")) {
            return (xml = xml.getParent()) == null ? null : XmlHelper.findElement(xml, sPath, oValue);
        }
        Iterator iter = xml.getElements(sName);
        while (iter.hasNext()) {
            xml = XmlHelper.findElement((XmlElement)iter.next(), sPath, oValue);
            if (xml == null) continue;
            return xml;
        }
        return null;
    }

    public static XmlElement ensureElement(XmlElement xml, String sPath) {
        XmlHelper.azzert(xml != null && sPath != null, "Null element or path");
        if (sPath.startsWith("/")) {
            xml = xml.getRoot();
        }
        StringTokenizer tokens = new StringTokenizer(sPath, "/");
        while (tokens.hasMoreTokens()) {
            String sName = tokens.nextToken();
            if (sName.equals("..")) {
                if ((xml = xml.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path " + sPath);
            }
            XmlElement child = xml.getElement(sName);
            xml = child == null ? xml.addElement(sName) : child;
        }
        return xml;
    }

    public static void addElements(XmlElement xml, Iterator iter) {
        List list = xml.getElementList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
    }

    public static int removeElement(XmlElement xml, String sName) {
        int cnt = 0;
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            xml = (XmlElement)iter.next();
            if (!xml.getName().equals(sName)) continue;
            iter.remove();
            ++cnt;
        }
        return cnt;
    }

    public static XmlElement removeEmptyElements(XmlElement xml) {
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            XmlElement xmlChild = XmlHelper.removeEmptyElements((XmlElement)iter.next());
            if (!xmlChild.isEmpty() || !xmlChild.getElementList().isEmpty() || !xmlChild.getAttributeMap().isEmpty()) continue;
            iter.remove();
        }
        return xml;
    }

    public static boolean replaceElement(XmlElement xmlParent, XmlElement xmlReplace) {
        List list = xmlParent.getElementList();
        for (XmlElement xml : list) {
            if (!xml.getName().equals(xmlReplace.getName())) continue;
            list.set(list.indexOf(xml), xmlReplace.clone());
            return true;
        }
        list.add(xmlReplace.clone());
        return false;
    }

    public static void overrideElement(XmlElement xmlBase, XmlElement xmlOverride) {
        XmlHelper.overrideElement(xmlBase, xmlOverride, null);
    }

    public static void overrideElement(XmlElement xmlBase, XmlElement xmlOverride, String sIdAttrName) {
        for (XmlElement xmlOver : xmlOverride.getElementList()) {
            if (XmlHelper.isEmpty(xmlOver)) continue;
            String sName = xmlOver.getName();
            Object oAttrId = sIdAttrName == null ? xmlOver.getAttributeMap() : xmlOver.getAttribute(sIdAttrName);
            Iterator iter = xmlOverride.getElements(sName);
            while (iter.hasNext()) {
                Object oAttrTest;
                XmlElement xmlTest = (XmlElement)iter.next();
                if (xmlTest == xmlOver || !XmlHelper.equals(oAttrTest = sIdAttrName == null ? xmlTest.getAttributeMap() : xmlTest.getAttribute(sIdAttrName), oAttrId)) continue;
                throw new UnsupportedOperationException("Override element is not unique:\n" + xmlOver);
            }
            XmlElement xmlMatch = null;
            Iterator iterBase = xmlBase.getElements(sName);
            while (iterBase.hasNext()) {
                XmlElement xmlTest = (XmlElement)iterBase.next();
                Object oAttrTest = sIdAttrName == null ? xmlTest.getAttributeMap() : xmlTest.getAttribute(sIdAttrName);
                if (!XmlHelper.equals(oAttrTest, oAttrId)) continue;
                if (xmlMatch == null) {
                    xmlMatch = xmlTest;
                    continue;
                }
                throw new UnsupportedOperationException("Override element is ambiguous:\n" + xmlOver);
            }
            if (xmlMatch == null) {
                xmlBase.getElementList().add(xmlOver.clone());
                continue;
            }
            String sValue = xmlOver.getString();
            List listChildren = xmlOver.getElementList();
            if (listChildren.isEmpty() && !sValue.isEmpty()) {
                xmlMatch.getElementList().clear();
                xmlMatch.setString(sValue);
            } else if (sValue.isEmpty() && !listChildren.isEmpty()) {
                xmlMatch.setString("");
                if (XmlHelper.isSimpleSequence(listChildren)) {
                    String sChild = ((XmlElement)listChildren.get(0)).getName();
                    List list = xmlMatch.getElementList();
                    ArrayList listOverride = new ArrayList(listChildren);
                    Iterator iter2 = xmlMatch.getElements(sChild);
                    while (iter2.hasNext()) {
                        if (listOverride.size() > 0) {
                            list.set(list.indexOf(iter2.next()), listOverride.get(0));
                            listOverride.remove(0);
                            continue;
                        }
                        iter2.next();
                        iter2.remove();
                    }
                    if (listOverride.size() <= 0) continue;
                    xmlMatch.getElementList().addAll(listOverride);
                    continue;
                }
            }
            XmlHelper.overrideElement(xmlMatch, xmlOver, sIdAttrName);
        }
    }

    public static void replaceSystemProperties(XmlElement xml, String sPropertyAttribute) {
        XmlValue attr = xml.getAttribute(sPropertyAttribute);
        if (attr != null) {
            xml.setAttribute(sPropertyAttribute, null);
            try {
                String sValue = Config.getProperty(attr.getString());
                if (sValue != null) {
                    xml.setString(sValue);
                }
            }
            catch (Exception sValue) {
                // empty catch block
            }
        }
        SystemPropertyPreprocessor.processValueMacro(xml);
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            XmlHelper.replaceSystemProperties((XmlElement)iter.next(), sPropertyAttribute);
        }
    }

    public static List<String> getSchemaLocations(XmlElement xml, String sPrefix) {
        ArrayList<String> listURLs = new ArrayList<String>();
        if (sPrefix == null) {
            sPrefix = XmlHelper.getNamespacePrefix(xml, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (sPrefix != null) {
            XmlValue xmlLocation = xml.getAttribute(sPrefix + ":schemaLocation");
            if (xmlLocation == null) {
                xmlLocation = xml.getAttribute(sPrefix + ":noNamespaceSchemaLocation");
                if (xmlLocation != null) {
                    listURLs.add(xmlLocation.getString());
                }
            } else {
                String[] sURLs = xmlLocation.getString().split("\\s+");
                for (int i = 1; i < sURLs.length; i += 2) {
                    listURLs.add(sURLs[i]);
                }
            }
            Iterator iter = xml.getElementList().iterator();
            while (iter.hasNext()) {
                List<String> listChildURLs = XmlHelper.getSchemaLocations((XmlElement)iter.next(), sPrefix);
                if (listChildURLs.isEmpty()) continue;
                listURLs.addAll(listChildURLs);
            }
        }
        return listURLs;
    }

    public static String getNamespaceUri(XmlElement xml, String sPrefix) {
        String sAttrName = "xmlns:" + sPrefix;
        while (xml != null) {
            XmlValue attrXmlns = xml.getAttribute(sAttrName);
            if (attrXmlns != null) {
                return attrXmlns.getString();
            }
            xml = xml.getParent();
        }
        return null;
    }

    public static String getNamespacePrefix(XmlElement xml, String sUri) {
        while (xml != null) {
            for (Map.Entry entry : xml.getAttributeMap().entrySet()) {
                String sAttr;
                if (!sUri.equals(((XmlValue)entry.getValue()).getString()) || !(sAttr = (String)entry.getKey()).startsWith("xmlns:")) continue;
                return sAttr.substring(6);
            }
            xml = xml.getParent();
        }
        return null;
    }

    public static void ensureNamespace(XmlElement xml, String sPrefix, String sUri) {
        String sNmsUri = XmlHelper.getNamespaceUri(xml, sPrefix);
        if (sNmsUri == null) {
            xml.addAttribute("xmlns:" + sPrefix).setString(sUri);
        } else if (!sNmsUri.equals(sUri)) {
            throw new IllegalStateException("Namespace conflict: prefix=" + sPrefix + ", current URI=" + sNmsUri + ", new URI=" + sUri);
        }
    }

    public static String getUniversalName(String sLocal, String sPrefix) {
        return sPrefix == null || sLocal == null || sLocal.length() == 0 ? sLocal : sPrefix + ':' + sLocal;
    }

    public static boolean isNameMatch(XmlElement xml, String sName, String sLocal, String sUri) {
        if (sUri == null) {
            return sName.equals(sLocal);
        }
        String sSuffix = ':' + sLocal;
        if (sName.endsWith(sSuffix)) {
            String sPrefix = sName.substring(0, sName.length() - sSuffix.length());
            return sUri.equals(XmlHelper.getNamespaceUri(xml, sPrefix));
        }
        return sName.equals(sLocal);
    }

    public static boolean isElementMatch(XmlElement xml, String sLocal, String sUri) {
        return XmlHelper.isNameMatch(xml, xml.getName(), sLocal, sUri);
    }

    public static XmlElement getElement(XmlElement xml, String sLocal, String sUri) {
        if (sUri == null) {
            return xml.getElement(sLocal);
        }
        for (XmlElement el : xml.getElementList()) {
            if (!XmlHelper.isElementMatch(el, sLocal, sUri)) continue;
            return el;
        }
        return null;
    }

    protected static boolean isSimpleSequence(List<XmlElement> listXml) {
        String sName = null;
        for (XmlElement xmlTest : listXml) {
            if (!xmlTest.getAttributeMap().isEmpty() || !xmlTest.getElementList().isEmpty()) {
                return false;
            }
            if (sName == null) {
                sName = xmlTest.getName();
                continue;
            }
            if (sName.equals(xmlTest.getName())) continue;
            return false;
        }
        return true;
    }

    public static XmlValue getAttribute(XmlElement xml, String sLocal, String sUri) {
        if (sUri == null) {
            return xml.getAttribute(sLocal);
        }
        for (Map.Entry entry : xml.getAttributeMap().entrySet()) {
            String sAttr = (String)entry.getKey();
            if (!XmlHelper.isNameMatch(xml, sAttr, sLocal, sUri)) continue;
            return (XmlValue)entry.getValue();
        }
        return null;
    }

    public static Iterator getElements(XmlElement xml, final String sLocal, final String sUri) {
        if (sUri == null) {
            return xml.getElements(sLocal);
        }
        Filter filter = new Filter(){

            public boolean evaluate(Object o) {
                return o instanceof XmlElement && XmlHelper.isElementMatch((XmlElement)o, sLocal, sUri);
            }
        };
        return new FilterEnumerator(xml.getElementList().iterator(), filter);
    }

    public static void purgeNamespace(XmlElement xml) {
        XmlElement xmlParent = xml.getParent();
        if (xmlParent == null) {
            return;
        }
        Iterator iter = xml.getAttributeMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String sAttr = (String)entry.getKey();
            if (!sAttr.startsWith("xmlns:")) continue;
            String sPrefix = sAttr.substring(6);
            String sUri = ((XmlValue)entry.getValue()).getString();
            if (!sUri.equals(XmlHelper.getNamespaceUri(xmlParent, sPrefix))) continue;
            iter.remove();
        }
    }

    public static void purgeChildrenNamespace(XmlElement xml) {
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            XmlHelper.purgeNamespace((XmlElement)iter.next());
        }
    }

    public static Object[] parseInitParams(XmlElement xmlParams) {
        return XmlHelper.parseInitParams(xmlParams, null);
    }

    public static long parseTime(XmlElement xml, String sName, long cDefault) {
        if (xml == null) {
            return cDefault;
        }
        String sTime = xml.getSafeElement(sName).getString().trim();
        if (sTime.length() == 0) {
            return cDefault;
        }
        try {
            return Base.parseTime(sTime);
        }
        catch (RuntimeException e) {
            throw Base.ensureRuntimeException(e, "illegal \"" + sName + "\" value: " + sTime);
        }
    }

    public static Object[] parseInitParams(XmlElement xmlParams, ParameterResolver resolver) {
        ArrayList<Object> listParam = new ArrayList<Object>();
        Iterator iter = xmlParams.getElements("init-param");
        while (iter.hasNext()) {
            Object oResolved;
            XmlElement xmlParam = (XmlElement)iter.next();
            String sType = xmlParam.getSafeElement("param-type").getString();
            XmlElement xmlValue = xmlParam.getSafeElement("param-value");
            String sValue = xmlValue.getString();
            if (resolver != null && (sType.indexOf(123) == 0 && sType.lastIndexOf(125) == sType.length() - 1 || sValue.indexOf(123) >= 0 && sValue.indexOf(123) < sValue.lastIndexOf(125)) && (oResolved = resolver.resolveParameter(sType, sValue)) != ParameterResolver.UNRESOLVED) {
                listParam.add(oResolved);
                continue;
            }
            if (sType.length() == 0) {
                throw new RuntimeException("missing parameter type:\n" + xmlParam);
            }
            if (sType.equalsIgnoreCase("string") || sType.equals("java.lang.String")) {
                listParam.add(sValue);
                continue;
            }
            if (sType.equalsIgnoreCase("int") || sType.equals("java.lang.Integer")) {
                listParam.add(xmlValue.getInt());
                continue;
            }
            if (sType.equalsIgnoreCase("long") || sType.equals("java.lang.Long")) {
                listParam.add(xmlValue.getLong());
                continue;
            }
            if (sType.equalsIgnoreCase("boolean") || sType.equals("java.lang.Boolean")) {
                listParam.add(xmlValue.getBoolean());
                continue;
            }
            if (sType.equalsIgnoreCase("double") || sType.equals("java.lang.Double")) {
                listParam.add(new Double(xmlValue.getDouble()));
                continue;
            }
            if (sType.equalsIgnoreCase("float") || sType.equals("java.lang.Float")) {
                listParam.add(new Float(xmlValue.getDouble()));
                continue;
            }
            if (sType.equalsIgnoreCase("decimal") || sType.equals("java.math.BigDecimal")) {
                listParam.add(xmlValue.getDecimal());
                continue;
            }
            if (sType.equalsIgnoreCase("file") || sType.equals("java.io.File")) {
                listParam.add(new File(xmlValue.getString()));
                continue;
            }
            if (sType.equalsIgnoreCase("date") || sType.equals("java.sql.Date")) {
                listParam.add(xmlValue.getDate());
                continue;
            }
            if (sType.equalsIgnoreCase("time") || sType.equals("java.sql.Time")) {
                listParam.add(xmlValue.getTime());
                continue;
            }
            if (sType.equalsIgnoreCase("datetime") || sType.equals("java.sql.Timestamp")) {
                listParam.add(xmlValue.getDateTime());
                continue;
            }
            if (sType.equalsIgnoreCase("xml") || sType.equals("com.tangosol.run.xml.XmlElement")) {
                listParam.add(xmlValue.clone());
                continue;
            }
            listParam.add(xmlParam.clone());
        }
        return listParam.toArray();
    }

    public static XmlElement transformInitParams(XmlElement xmlParent, XmlElement xmlParams) {
        Iterator iter = xmlParams.getElements("init-param");
        while (iter.hasNext()) {
            XmlElement xmlParam = (XmlElement)iter.next();
            String sName = xmlParam.getSafeElement("param-name").getString();
            String sValue = xmlParam.getSafeElement("param-value").getString();
            if (sName.length() == 0) continue;
            xmlParent.ensureElement(sName).setString(sValue);
        }
        return xmlParent;
    }

    public static XmlElement encodeInitParams(XmlElement xmlParent, XmlElement xmlConfig) {
        for (XmlElement xmlElem : xmlConfig.getElementList()) {
            XmlElement xmlParam = xmlParent.addElement("init-param");
            xmlParam.addElement("param-name").setString(xmlElem.getName());
            xmlParam.addElement("param-value").setString(xmlElem.getString());
        }
        return xmlParent;
    }

    public static String[] parseParamTypes(XmlElement xmlParams) {
        ArrayList<String> listParam = new ArrayList<String>();
        Iterator iter = xmlParams.getElements("init-param");
        while (iter.hasNext()) {
            XmlElement xmlParam = (XmlElement)iter.next();
            String sParamType = xmlParam.getSafeElement("param-type").getString();
            sParamType = sParamType == null || sParamType.trim().equals("") ? null : sParamType;
            listParam.add(sParamType);
        }
        return listParam.toArray(new String[listParam.size()]);
    }

    public static boolean isInstanceConfigEmpty(XmlElement xmlClass) {
        return XmlHelper.isEmpty(xmlClass.getSafeElement("instance")) && XmlHelper.isEmpty(xmlClass.getSafeElement("class-name")) && XmlHelper.isEmpty(xmlClass.getSafeElement("class-factory-name"));
    }

    public static Object createInstance(XmlElement xml, ClassLoader loader, ParameterResolver resolver) {
        return XmlHelper.createInstance(xml, loader, resolver, null);
    }

    public static Object createInstance(XmlElement xml, ClassLoader loader, ParameterResolver resolver, Class clzAssignable) {
        Object oInstance;
        XmlElement xmlInstance = xml.getSafeElement("instance");
        if (xmlInstance.getElementList().isEmpty()) {
            xmlInstance = xml;
        }
        String sClass = xmlInstance.getSafeElement("class-name").getString();
        String sMethod = null;
        Class clz = null;
        if (sClass.length() == 0) {
            sClass = xmlInstance.getSafeElement("class-factory-name").getString();
            sMethod = xmlInstance.getSafeElement("method-name").getString();
            if (sClass.length() == 0) {
                throw new IllegalArgumentException("The configuration element \"" + xmlInstance.getName() + "\" does not specify a \"class-name\" or \"class-factory-name\"\n" + xml);
            }
            if (sMethod.length() == 0) {
                throw new IllegalArgumentException("The configuration element \"" + xmlInstance.getName() + "\" specifies a \"class-factory-name\", but no \"method-name\"\n" + xml);
            }
        }
        XmlElement xmlParams = xmlInstance.getElement("init-params");
        Object[] aoParam = ClassHelper.VOID;
        if (xmlParams != null) {
            try {
                aoParam = XmlHelper.parseInitParams(xmlParams, resolver);
                xmlParams = null;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        try {
            clz = ExternalizableHelper.loadClass(sClass, loader, null);
            oInstance = sMethod == null ? ClassHelper.newInstance(clz, aoParam) : ClassHelper.invokeStatic(clz, sMethod, aoParam);
        }
        catch (Throwable e) {
            String sMsg;
            if (clz == null) {
                sMsg = "Unable to load class \"" + sClass + "\" using " + loader;
            } else {
                StringBuffer sbArgs = new StringBuffer();
                if (aoParam != null) {
                    int c = aoParam.length;
                    for (int i = 0; i < c; ++i) {
                        sbArgs.append(ClassHelper.getSimpleName(aoParam[i].getClass()));
                        if (i >= c - 1) continue;
                        sbArgs.append(',');
                    }
                }
                sMsg = sMethod == null ? "Missing or inaccessible constructor \"" + sClass + "(" + sbArgs + ")\"" : "Failed to instantiate class using factory method \"" + sClass + "." + sMethod + "(" + sbArgs + ")\"";
            }
            throw XmlHelper.ensureRuntimeException(e, sMsg + "\n" + xml);
        }
        if (oInstance == null) {
            throw new IllegalArgumentException("Configuration element \"" + xml.getName() + "\" produced a null object");
        }
        if (clzAssignable != null && !clzAssignable.isInstance(oInstance)) {
            throw new IllegalArgumentException("The instance of class \"" + oInstance.getClass().getName() + "\" produced from configuration element \"" + xml.getName() + "\" is not an instance of \"" + clzAssignable.getName() + '\"');
        }
        if (oInstance instanceof XmlConfigurable && xmlParams != null) {
            ((XmlConfigurable)oInstance).setConfig(XmlHelper.transformInitParams(new SimpleElement("config"), xmlParams));
        }
        return oInstance;
    }

    public static int hashElement(XmlElement xml) {
        int n = XmlHelper.hashValue(xml);
        Iterator iter = xml.getAttributeMap().entrySet().iterator();
        while (iter.hasNext()) {
            n ^= ((Object)iter.next()).hashCode();
        }
        iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            n ^= ((Object)iter.next()).hashCode();
        }
        return n;
    }

    public static int hashValue(XmlValue val) {
        Object o = val.getValue();
        if (o == null) {
            return 0;
        }
        String s = o instanceof String ? (String)o : (String)XmlHelper.convert(o, 6);
        return s.hashCode();
    }

    public static boolean equalsElement(XmlElement xml1, XmlElement xml2) {
        XmlHelper.azzert(xml1 != null && xml2 != null, "Null element");
        if (!XmlHelper.equals(xml1.getName(), xml2.getName())) {
            return false;
        }
        if (!XmlHelper.equals(xml1.getComment(), xml2.getComment())) {
            return false;
        }
        if (!XmlHelper.equalsValue(xml1, xml2)) {
            return false;
        }
        if (!XmlHelper.equals(xml1.getAttributeMap(), xml2.getAttributeMap())) {
            return false;
        }
        return XmlHelper.equals(xml1.getElementList(), xml2.getElementList());
    }

    public static boolean equalsValue(XmlValue val1, XmlValue val2) {
        XmlHelper.azzert(val1 != null && val2 != null, "Null value");
        boolean fEmpty1 = val1.isEmpty();
        boolean fEmpty2 = val2.isEmpty();
        if (fEmpty1 || fEmpty2) {
            return fEmpty1 && fEmpty2;
        }
        Object o1 = val1.getValue();
        Object o2 = val2.getValue();
        XmlHelper.azzert(o1 != null && o2 != null);
        if (o1.getClass() == o2.getClass()) {
            return o1.equals(o2);
        }
        return XmlHelper.convert(o1, 6).equals(XmlHelper.convert(o2, 6));
    }

    public static String toString(XmlSerializable xml) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter out = new PrintWriter(writer);
        xml.toXml().writeXml(out, true);
        out.flush();
        out.close();
        return ((Object)writer).toString();
    }

    public static Object convert(Object o, int nType) {
        if (o == null) {
            return null;
        }
        switch (nType) {
            case 1: {
                if (o instanceof Boolean) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    switch (XmlHelper.trim(s).charAt(0)) {
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            return Boolean.TRUE;
                        }
                        case '1': {
                            if (s.length() != 1) break;
                            return Boolean.TRUE;
                        }
                        case 'F': 
                        case 'N': 
                        case 'f': 
                        case 'n': {
                            return Boolean.FALSE;
                        }
                        case '0': {
                            if (s.length() != 1) break;
                            return Boolean.FALSE;
                        }
                    }
                }
                return null;
            }
            case 2: {
                if (o instanceof Integer) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    return Integer.valueOf(XmlHelper.trim(s));
                }
                return null;
            }
            case 3: {
                if (o instanceof Long) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    return Long.valueOf(XmlHelper.trim(s));
                }
                return null;
            }
            case 4: {
                if (o instanceof Double) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    return Double.valueOf(XmlHelper.trim(s));
                }
                return null;
            }
            case 5: {
                if (o instanceof BigDecimal) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    return new BigDecimal(XmlHelper.trim(s));
                }
                return null;
            }
            case 6: {
                if (o instanceof String) {
                    return o;
                }
                if (o instanceof Binary) {
                    Binary bin = (Binary)o;
                    try {
                        CharArrayWriter writer = new CharArrayWriter((int)((double)bin.length() * 1.35 + 2.0));
                        Base64OutputStream stream = new Base64OutputStream(writer);
                        bin.writeTo(stream);
                        ((OutputStream)stream).close();
                        return writer.toString();
                    }
                    catch (IOException e) {
                        throw XmlHelper.ensureRuntimeException(e);
                    }
                }
                return o.toString();
            }
            case 7: {
                if (o instanceof Binary) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null) {
                    if (s.length() == 0) {
                        return Binary.NO_BINARY;
                    }
                    try {
                        return new Binary(Base64InputStream.decode(s.toCharArray()));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 8: {
                if (o instanceof Date) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    return Date.valueOf(XmlHelper.trim(s));
                }
                return null;
            }
            case 9: {
                if (o instanceof Time) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    return Time.valueOf(XmlHelper.trim(s));
                }
                return null;
            }
            case 10: {
                if (o instanceof Timestamp) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    int ofDelim = (s = XmlHelper.trim(s)).indexOf(84);
                    if (ofDelim >= 0) {
                        s = s.substring(0, ofDelim) + ' ' + s.substring(ofDelim + 1);
                    }
                    return Timestamp.valueOf(s);
                }
                return null;
            }
        }
        XmlHelper.azzert();
        return o;
    }

    public static interface ParameterResolver {
        public static final Object UNRESOLVED = new Object();

        public Object resolveParameter(String var1, String var2);
    }
}

