/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.run.xml.XmlValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class XmlSerializableAdapter
extends PropertyAdapter {
    public XmlSerializableAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
    }

    @Override
    public boolean isCloneRequired() {
        return true;
    }

    @Override
    public Object clone(Object o) {
        if (o != null && this.isCloneRequired()) {
            if (o instanceof XmlBean) {
                return ((XmlBean)o).clone();
            }
            if (this.getCloner() == null) {
                return this.fromXml(this.toXml(o));
            }
        }
        return super.clone(o);
    }

    @Override
    public Object fromXml(XmlElement xml) {
        XmlSerializable xs;
        try {
            Class<?> clz;
            XmlValue xmlAttr = xml.getAttribute("class");
            if (xmlAttr == null) {
                clz = this.getType();
            } else {
                ClassLoader loader = this.getBeanInfo().getType().getClassLoader();
                if (loader == null) {
                    loader = XmlSerializableAdapter.getContextClassLoader();
                }
                clz = Class.forName(xmlAttr.getString(), false, loader);
            }
            xs = (XmlSerializable)clz.newInstance();
        }
        catch (Exception e) {
            throw XmlSerializableAdapter.ensureRuntimeException(e);
        }
        xs.fromXml(xml);
        return xs;
    }

    @Override
    public XmlElement toXml(Object o) {
        if (o == null) {
            return null;
        }
        XmlSerializable xs = (XmlSerializable)o;
        XmlElement xml = xs.toXml();
        if (!this.isAnonymous()) {
            xml.setName(this.getXmlName());
        }
        if (o.getClass() != this.getType()) {
            xml.addAttribute("class").setString(o.getClass().getName());
        }
        return xml;
    }

    @Override
    public Object readExternal(DataInput in) throws IOException {
        return XmlSerializableAdapter.readObject(in, this.getBeanInfo().getType().getClassLoader());
    }

    @Override
    public void writeExternal(DataOutput out, Object o) throws IOException {
        XmlSerializableAdapter.writeObject(out, o);
    }
}

