/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChainedCollection<E>
implements Collection<E> {
    protected final Collection<E>[] f_acol;

    public ChainedCollection(Collection<Collection<E>> col) {
        this(col.toArray(new Collection[col.size()]));
    }

    public ChainedCollection(Collection<E> ... acol) {
        this.f_acol = acol;
    }

    @Override
    public int size() {
        int cSize = 0;
        for (Collection<E> col : this.f_acol) {
            cSize += col.size();
        }
        return cSize;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> col : this.f_acol) {
            if (col.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<E> col : this.f_acol) {
            if (!col.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        for (Collection<E> o : this.f_acol) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> m_iter;
            int m_iCol = -1;

            @Override
            public boolean hasNext() {
                Iterator iter = this.m_iter;
                int iCol = this.m_iCol;
                int cCol = ChainedCollection.this.f_acol.length;
                while (!(iter != null && iter.hasNext() || ++iCol >= cCol)) {
                    this.m_iter = ChainedCollection.this.f_acol[iCol].iterator();
                    iter = this.m_iter;
                    this.m_iCol = iCol;
                }
                if (iCol >= cCol) {
                    this.m_iter = null;
                    return false;
                }
                return true;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.m_iter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.m_iter == null) {
                    throw new NoSuchElementException();
                }
                this.m_iter.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int cSize = this.size();
        if (a == null || cSize > a.length) {
            a = new Object[cSize];
        }
        int of = 0;
        int cArray = this.f_acol.length;
        for (int i = 0; i < cArray; ++i) {
            Object[] aoCol = this.f_acol[i].toArray();
            System.arraycopy(aoCol, 0, a, of, aoCol.length);
            of += aoCol.length;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

