/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.internal.util.extractor.ReflectionAllowedFilter;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Resources;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ClassHelper {
    private static Hashtable tblPrimitives = new Hashtable(10, 1.0f);
    public static final Class[] VOID_PARAMS;
    public static final Object[] VOID;
    public static final String REFLECT_FILTER_SEPARATOR = ";";
    public static final String REFLECT_FILTER_PROPERTY = "coherence.reflect.filter";
    public static final String REFLECT_ALLOW_ALL = "*";
    public static final String DEFAULT_REFLECT_ALLOWED_BLACKLIST = "!java.lang.Class;!java.lang.System;!java.lang.Runtime";
    public static final String DEFAULT_FILTER_LIST = "!java.lang.Class;!java.lang.System;!java.lang.Runtime;*";

    public static boolean isInstanceOf(Object obj, String sClz) {
        try {
            return ClassHelper.isInstanceOf(obj, Class.forName(sClz));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInstanceOf(Object obj, Class clz) {
        return clz.isAssignableFrom(obj.getClass());
    }

    public static String getPackageName(Class clz) {
        String sFullClass = clz.getName();
        int ofDotClass = sFullClass.lastIndexOf(46);
        if (ofDotClass < 0) {
            return "";
        }
        return sFullClass.substring(0, ofDotClass + 1);
    }

    public static String getPackageName(String sName) {
        int ofLastDot = sName.lastIndexOf(46);
        if (ofLastDot < 0) {
            return "";
        }
        if (ofLastDot == sName.length() - 1) {
            return sName;
        }
        if (ofLastDot > 0) {
            return sName.substring(0, ofLastDot + 1);
        }
        return sName + '.';
    }

    public static String getSimpleName(Class clz) {
        String sFullClass = clz.getName();
        int ofDotClass = sFullClass.lastIndexOf(46);
        if (ofDotClass < 0) {
            return sFullClass;
        }
        String sName = sFullClass.substring(ofDotClass + 1);
        int ofInnerClass = sName.lastIndexOf(36);
        return ofInnerClass < 0 ? sName : sName.substring(ofInnerClass + 1);
    }

    public static String getSimpleName(String sName) {
        int ofLastDot = sName.lastIndexOf(46);
        if (ofLastDot < 0) {
            return sName;
        }
        if (ofLastDot == sName.length() - 1) {
            return "";
        }
        if (ofLastDot > 0) {
            return sName.substring(ofLastDot + 1);
        }
        return "";
    }

    public static String getQualifiedName(String pkg, String sName) {
        if (pkg.length() == 0) {
            return sName;
        }
        if (pkg.charAt(0) == '.') {
            pkg = pkg.substring(1);
        }
        if (pkg.charAt(pkg.length() - 1) == '.') {
            return pkg + sName;
        }
        return pkg + '.' + sName;
    }

    public static String getCompositePackage(String pkg1, String pkg2) {
        String sComposite = pkg1.length() == 0 ? pkg2 : (pkg2.length() == 0 ? pkg1 : (pkg2.charAt(0) != '.' ? pkg2 : (pkg1.charAt(pkg1.length() - 1) == '.' ? pkg1 + pkg2.substring(1) : pkg1 + pkg2)));
        if (sComposite.length() > 0 && sComposite.charAt(sComposite.length() - 1) != '.') {
            sComposite = sComposite + '.';
        }
        return sComposite;
    }

    public static String getCompositeName(Class clz, String sName) {
        return ClassHelper.getCompositeName(clz.getName(), sName);
    }

    public static String getCompositeName(String sName1, String sName2) {
        String sPkg = ClassHelper.getCompositePackage(ClassHelper.getPackageName(sName1), ClassHelper.getPackageName(sName2));
        String sClass = ClassHelper.getSimpleName(sName2);
        if (sClass.length() == 0) {
            sClass = ClassHelper.getSimpleName(sName1);
        }
        return ClassHelper.getQualifiedName(sPkg, sClass);
    }

    public static String getDerivedName(Class clz, String sPrefix) {
        return ClassHelper.getDerivedName(clz.getName(), sPrefix);
    }

    public static String getDerivedName(String sName, String sPrefix) {
        String sPkg = ClassHelper.getCompositePackage(ClassHelper.getPackageName(sName), ClassHelper.getPackageName(sPrefix));
        sPrefix = ClassHelper.getSimpleName(sPrefix);
        String sSuffix = ClassHelper.getSimpleName(sName);
        return ClassHelper.getQualifiedName(sPkg, sPrefix + sSuffix);
    }

    public static boolean isPartialNameLegal(String sName) {
        if (sName == null || sName.length() == 0) {
            return false;
        }
        int ofStart = 0;
        int ofEnd = sName.length();
        if (sName.charAt(ofStart) == '.') {
            ++ofStart;
        }
        if (ofEnd > 1 && sName.charAt(ofEnd - 1) == '.') {
            --ofEnd;
        }
        return ClassHelper.isQualifiedNameLegal(sName.substring(ofStart, ofEnd));
    }

    public static boolean isSimpleNameLegal(String sName) {
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        if (cch < 1 || !Character.isJavaIdentifierStart(ach[0])) {
            return false;
        }
        for (int i = 1; i < cch; ++i) {
            if (Character.isJavaIdentifierPart(ach[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedNameLegal(String sName) {
        int cch = sName.length();
        if (cch < 1) {
            return false;
        }
        int ofStart = 0;
        while (ofStart < cch) {
            int ofEnd = sName.indexOf(46, ofStart);
            if (ofEnd == cch - 1) {
                return false;
            }
            if (ofEnd < 0) {
                ofEnd = cch;
            }
            if (!ClassHelper.isSimpleNameLegal(sName.substring(ofStart, ofEnd))) {
                return false;
            }
            ofStart = ofEnd + 1;
        }
        return true;
    }

    public static Class[] getClassArray(Object[] aoParam) {
        int cParams;
        if (aoParam != null && (cParams = aoParam.length) > 0) {
            Class[] aClass = new Class[cParams];
            for (int i = 0; i < cParams; ++i) {
                Object oParam = aoParam[i];
                if (oParam == null) continue;
                aClass[i] = oParam.getClass();
            }
            return aClass;
        }
        return VOID_PARAMS;
    }

    public static Class[] unwrap(Class[] aClasses) {
        for (int i = 0; i < aClasses.length; ++i) {
            Class clz = aClasses[i];
            if (clz == null) {
                aClasses[i] = Object.class;
            }
            if (clz == Boolean.class) {
                aClasses[i] = Integer.TYPE;
            }
            if (clz == Byte.class) {
                aClasses[i] = Byte.TYPE;
            }
            if (clz == Character.class) {
                aClasses[i] = Character.TYPE;
            }
            if (clz == Short.class) {
                aClasses[i] = Short.TYPE;
            }
            if (clz == Integer.class) {
                aClasses[i] = Integer.TYPE;
            }
            if (clz == Long.class) {
                aClasses[i] = Long.TYPE;
            }
            if (clz == Float.class) {
                aClasses[i] = Float.TYPE;
            }
            if (clz != Double.class) continue;
            aClasses[i] = Double.TYPE;
        }
        return aClasses;
    }

    public static Resources getPackageResources(String sClass) throws MissingResourceException {
        return (Resources)ResourceBundle.getBundle(ClassHelper.getCompositeName(sClass, "PackageResources"));
    }

    public static Resources getPackageResources(Class clz) throws MissingResourceException {
        return ClassHelper.getResources(clz, "PackageResources");
    }

    public static Resources getResources(Class clz, String sName) throws MissingResourceException {
        return (Resources)ResourceBundle.getBundle(ClassHelper.getCompositeName(clz, sName));
    }

    public static Object newInstance(Class clz, Object[] aoParam) throws InstantiationException, InvocationTargetException {
        int cParams;
        if (clz == null) {
            throw new InstantiationException("Required class object is null");
        }
        if (aoParam == null) {
            aoParam = VOID;
        }
        if ((cParams = aoParam.length) == 0) {
            try {
                return clz.newInstance();
            }
            catch (InstantiationException e) {
                if (e.getMessage() == null) {
                    throw new InstantiationException(clz.getName());
                }
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(e.toString());
            }
        }
        Class[] aclzParam = cParams == 0 ? VOID_PARAMS : new Class[cParams];
        boolean fExactMatch = true;
        for (int i = 0; i < cParams; ++i) {
            if (aoParam[i] == null) {
                fExactMatch = false;
                continue;
            }
            aclzParam[i] = aoParam[i].getClass();
        }
        Constructor<Object> constrMatch = null;
        if (fExactMatch) {
            try {
                constrMatch = clz.getConstructor(aclzParam);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (constrMatch == null) {
            for (Constructor<?> constr : clz.getConstructors()) {
                Class<?>[] aclzActual = constr.getParameterTypes();
                if (aclzActual.length != cParams) continue;
                boolean fMatch = true;
                for (int i = 0; i < cParams && (fMatch = aoParam[i] == null ? !aclzActual[i].isPrimitive() : (aclzActual[i].isPrimitive() ? aclzActual[i] == (Class)tblPrimitives.get(aclzParam[i]) : aclzActual[i].isAssignableFrom(aclzParam[i]))); ++i) {
                }
                if (!fMatch) continue;
                constrMatch = constr;
                break;
            }
        }
        if (constrMatch != null) {
            try {
                return constrMatch.newInstance(aoParam);
            }
            catch (InstantiationException e) {
                if (e.getMessage() == null) {
                    throw new InstantiationException(clz.getName());
                }
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(e.toString());
            }
            catch (SecurityException e) {
                throw new InstantiationException(e.toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not find a constructor for ");
        sb.append(clz.getName());
        sb.append("(");
        for (int i = 0; i < cParams; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aoParam[i] == null ? "null" : aoParam[i].getClass().getName());
        }
        sb.append(")");
        throw new InstantiationException(sb.toString());
    }

    public static Object invokeStatic(Class clz, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassHelper.invoke(clz, null, sName, aoParam);
    }

    public static Object invoke(Object obj, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassHelper.invoke(obj.getClass(), obj, sName, aoParam);
    }

    public static Object invoke(Class clz, Object obj, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int cParams;
        if (aoParam == null) {
            aoParam = VOID;
        }
        Class[] aclzParam = (cParams = aoParam.length) == 0 ? VOID_PARAMS : new Class[cParams];
        for (int i = 0; i < cParams; ++i) {
            Object oParam = aoParam[i];
            if (oParam == null) continue;
            aclzParam[i] = oParam.getClass();
        }
        IllegalAccessException iae = null;
        boolean fStatic = obj == null;
        Method method = ClassHelper.findMethod(clz, sName, aclzParam, fStatic);
        while (method != null) {
            try {
                return method.invoke(obj, aoParam);
            }
            catch (IllegalAccessException e) {
                if (iae == null) {
                    iae = e;
                }
                Class<?>[] aclzIface = clz.getInterfaces();
                int c = aclzIface.length;
                for (int i = 0; i < c; ++i) {
                    method = ClassHelper.findMethod(aclzIface[i], sName, aclzParam, fStatic);
                    if (method == null) continue;
                    try {
                        return method.invoke(obj, aoParam);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if ((clz = clz.getSuperclass()) == null) {
                    throw iae;
                }
                method = ClassHelper.findMethod(clz, sName, aclzParam, fStatic);
            }
        }
        if (iae == null) {
            throw new NoSuchMethodException(clz.getName() + '.' + sName);
        }
        throw iae;
    }

    public static Method findMethod(Class clz, String sName, Class[] aclzParam, boolean fStatic) {
        if (aclzParam == null) {
            aclzParam = VOID_PARAMS;
        }
        int cParams = aclzParam.length;
        boolean fExactMatch = true;
        for (int i = 0; i < cParams; ++i) {
            if (aclzParam[i] != null) continue;
            fExactMatch = false;
            break;
        }
        if (fExactMatch && !fStatic) {
            try {
                return clz.getMethod(sName, aclzParam);
            }
            catch (NoSuchMethodException i) {
                // empty catch block
            }
        }
        block3: for (Method method : clz.getMethods()) {
            Class<?>[] aclzActual;
            if (!method.getName().equals(sName) || Modifier.isStatic(method.getModifiers()) != fStatic || (aclzActual = method.getParameterTypes()).length != cParams) continue;
            for (int i = 0; i < cParams; ++i) {
                Class clzParam = aclzParam[i];
                Class<?> clzActual = aclzActual[i];
                boolean fMatch = clzParam == null ? !clzActual.isPrimitive() : (clzActual.isPrimitive() ? clzActual == tblPrimitives.get(clzParam) : clzActual.isAssignableFrom(clzParam));
                if (!fMatch) continue block3;
            }
            return method;
        }
        return null;
    }

    public static Class<?> getComponentType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (clz.isArray()) {
                return clz.getComponentType();
            }
            if (Collection.class.isAssignableFrom(clz)) {
                return Object.class;
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ClassHelper.getClass(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType typeParameterized = (ParameterizedType)type;
            Type typeRaw = typeParameterized.getRawType();
            if (typeRaw instanceof Class && Collection.class.isAssignableFrom((Class)typeRaw)) {
                return ClassHelper.getClass(typeParameterized.getActualTypeArguments()[0]);
            }
            return null;
        }
        return null;
    }

    public static Class<?> getClass(Type type) {
        if (type == null) {
            return Object.class;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassHelper.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType || type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        return Object.class;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Type[]> getReifiedTypes(Class<?> clz, Class<?> clzDefiningType) {
        LinkedHashMap<String, Type[]> mapTypes;
        block25: {
            Class<?> clzInspect;
            Type typeRoot;
            TypeVariable<Class<?>>[] aIfaceTypes;
            LinkedList<AbstractMap.SimpleEntry<Class<Object>, Object>> listHier;
            block24: {
                if (clz == null) {
                    throw new IllegalArgumentException("Class must be provided.");
                }
                if (clzDefiningType == null) {
                    throw new IllegalArgumentException("Class that defines the types to reify must be provided.");
                }
                if (!clzDefiningType.isAssignableFrom(clz)) {
                    throw new IllegalArgumentException(clz.getName() + " is not assignable to: " + clzDefiningType);
                }
                mapTypes = new LinkedHashMap<String, Type[]>();
                listHier = new LinkedList<AbstractMap.SimpleEntry<Class<Object>, Object>>();
                aIfaceTypes = clzDefiningType.getTypeParameters();
                typeRoot = null;
                Type type = clzInspect.getGenericSuperclass();
                for (clzInspect = clz; clzInspect != null && typeRoot == null; clzInspect = clzInspect.getSuperclass()) {
                    void var7_8;
                    AbstractMap.SimpleEntry entryHier = new AbstractMap.SimpleEntry(clzInspect, var7_8);
                    listHier.add(entryHier);
                    if (clzInspect.getSuperclass() == clzDefiningType) {
                        typeRoot = var7_8;
                    } else {
                        for (Type type2 : clzInspect.getGenericInterfaces()) {
                            Class<?>[] aclzIfaces;
                            Type typeRaw;
                            Type type3 = type2 instanceof Class ? type2 : (typeRaw = type2 instanceof ParameterizedType ? ((ParameterizedType)type2).getRawType() : null);
                            if (typeRaw == clzDefiningType) {
                                typeRoot = type2;
                                entryHier.setValue((void)typeRoot);
                                break;
                            }
                            if (!(typeRaw instanceof Class) || !clzDefiningType.isAssignableFrom((Class)typeRaw)) continue;
                            Class<?> clzCurIface = (Class<?>)typeRaw;
                            entryHier.setValue((void)type2);
                            block2: while (clzCurIface != clzDefiningType && (aclzIfaces = clzCurIface.getInterfaces()).length > 0) {
                                int c = aclzIfaces.length;
                                for (int i = 0; i < c; ++i) {
                                    if (!clzDefiningType.isAssignableFrom(aclzIfaces[i])) continue;
                                    listHier.add(new AbstractMap.SimpleEntry<Class, Type>(clzCurIface, clzCurIface.getGenericInterfaces()[i]));
                                    clzCurIface = aclzIfaces[i];
                                    continue block2;
                                }
                            }
                            typeRoot = (Type)((Map.Entry)listHier.getLast()).getValue();
                        }
                    }
                    Type type4 = clzInspect.getGenericSuperclass();
                }
                clzInspect = ClassHelper.getClass((Type)((Map.Entry)listHier.removeLast()).getKey());
                if (!(typeRoot instanceof Class)) break block24;
                for (TypeVariable<Class<?>> typeVarIface : aIfaceTypes) {
                    mapTypes.put(typeVarIface.getName(), typeVarIface.getBounds());
                }
                break block25;
            }
            if (!(typeRoot instanceof ParameterizedType)) break block25;
            Type[] typeArray = ((ParameterizedType)typeRoot).getActualTypeArguments();
            HashMap<Integer, AbstractMap.SimpleEntry<String, Type[]>> mapGenericTypes = new HashMap<Integer, AbstractMap.SimpleEntry<String, Type[]>>();
            int c = typeArray.length;
            block5: for (int i = 0; i < c; ++i) {
                Type typeArg = typeArray[i];
                String sOrigTypeName = aIfaceTypes[i].getName();
                if (typeArg instanceof Class || typeArg instanceof ParameterizedType) {
                    mapTypes.put(sOrigTypeName, new Type[]{typeArg});
                    continue;
                }
                if (!(typeArg instanceof TypeVariable)) continue;
                TypeVariable typeVar = (TypeVariable)typeArg;
                String sTypeName = typeVar.getName();
                int iTypePos = 0;
                for (TypeVariable<Class<?>> typeVarClz : clzInspect.getTypeParameters()) {
                    if (sTypeName.equals(typeVarClz.getName())) {
                        if (clzInspect == clz) {
                            mapTypes.put(sOrigTypeName, typeVar.getBounds());
                            continue block5;
                        }
                        mapGenericTypes.put(iTypePos, new AbstractMap.SimpleEntry<String, Type[]>(sOrigTypeName, typeVar.getBounds()));
                        continue block5;
                    }
                    ++iTypePos;
                }
            }
            Iterator iterClzHier = listHier.descendingIterator();
            while (!mapGenericTypes.isEmpty() && iterClzHier.hasNext()) {
                Map.Entry entryHier = (Map.Entry)iterClzHier.next();
                Class clzCurr = (Class)entryHier.getKey();
                Type typeSuper = (Type)entryHier.getValue();
                if (typeSuper instanceof Class) {
                    for (Map.Entry entry : mapGenericTypes.values()) {
                        mapTypes.put((String)entry.getKey(), (Type[])entry.getValue());
                    }
                    mapGenericTypes.clear();
                    continue;
                }
                if (!(typeSuper instanceof ParameterizedType)) continue;
                HashMap<Integer, Map.Entry> mapRemaining = new HashMap<Integer, Map.Entry>();
                block9: for (Map.Entry entryGeneric : mapGenericTypes.entrySet()) {
                    Map.Entry entryGenValue = (Map.Entry)entryGeneric.getValue();
                    Type typeGeneric = ((ParameterizedType)typeSuper).getActualTypeArguments()[(Integer)entryGeneric.getKey()];
                    if (typeGeneric instanceof Class) {
                        mapTypes.put((String)entryGenValue.getKey(), new Type[]{typeGeneric});
                        continue;
                    }
                    if (!(typeGeneric instanceof TypeVariable)) continue;
                    String sGenTypeName = ((TypeVariable)typeGeneric).getName();
                    int iTypePos = 0;
                    for (TypeVariable typeVarClz : clzCurr.getTypeParameters()) {
                        if (sGenTypeName.equals(typeVarClz.getName())) {
                            if (iterClzHier.hasNext()) {
                                entryGenValue.setValue(typeVarClz.getBounds());
                                mapRemaining.put(iTypePos, entryGenValue);
                                continue block9;
                            }
                            mapTypes.put((String)((Map.Entry)entryGeneric.getValue()).getKey(), typeVarClz.getBounds());
                            continue block9;
                        }
                        ++iTypePos;
                    }
                }
                mapGenericTypes = mapRemaining;
            }
        }
        return mapTypes;
    }

    public static String getFullyQualifiedClassNameOf(String sAbbreviatedClassName) {
        if (sAbbreviatedClassName == null) {
            return null;
        }
        String sType = sAbbreviatedClassName.trim();
        if (sType.equalsIgnoreCase("string")) {
            return String.class.getName();
        }
        if (sType.equalsIgnoreCase("boolean")) {
            return Boolean.class.getName();
        }
        if (sType.equalsIgnoreCase("int")) {
            return Integer.class.getName();
        }
        if (sType.equalsIgnoreCase("long")) {
            return Long.class.getName();
        }
        if (sType.equalsIgnoreCase("double")) {
            return Double.class.getName();
        }
        if (sType.equalsIgnoreCase("decimal")) {
            return BigDecimal.class.getName();
        }
        if (sType.equalsIgnoreCase("file")) {
            return File.class.getName();
        }
        if (sType.equalsIgnoreCase("date")) {
            return Date.class.getName();
        }
        if (sType.equalsIgnoreCase("time")) {
            return Time.class.getName();
        }
        if (sType.equalsIgnoreCase("datetime")) {
            return Timestamp.class.getName();
        }
        if (sType.equalsIgnoreCase("xml")) {
            return XmlElement.class.getName();
        }
        if (sType.equalsIgnoreCase("classloader")) {
            return ClassLoader.class.getName();
        }
        return sType.trim();
    }

    public static boolean isReflectionAllowed(Object oTarget) {
        return ReflectionAllowedFilter.INSTANCE.evaluate(oTarget.getClass());
    }

    static {
        tblPrimitives.put(Boolean.class, Boolean.TYPE);
        tblPrimitives.put(Character.class, Character.TYPE);
        tblPrimitives.put(Byte.class, Byte.TYPE);
        tblPrimitives.put(Short.class, Short.TYPE);
        tblPrimitives.put(Integer.class, Integer.TYPE);
        tblPrimitives.put(Long.class, Long.TYPE);
        tblPrimitives.put(Float.class, Float.TYPE);
        tblPrimitives.put(Double.class, Double.TYPE);
        tblPrimitives.put(Void.class, Void.TYPE);
        VOID_PARAMS = new Class[0];
        VOID = new Object[0];
    }
}

