/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.BackingMapContext;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.SimpleMapIndex;
import com.tangosol.util.ValueExtractor;
import java.util.Comparator;
import java.util.Map;

public class ConditionalIndex
extends SimpleMapIndex {
    private Filter m_filter;
    private boolean m_fPartial;

    public ConditionalIndex(Filter filter, ValueExtractor extractor, boolean fOrdered, Comparator comparator, boolean fForwardIndex, BackingMapContext ctx) {
        super(extractor, fOrdered, comparator, false, ctx);
        this.m_filter = filter;
        this.m_fPartial = false;
        this.initialize(fForwardIndex);
    }

    @Override
    public Object get(Object oKey) {
        if (this.isForwardIndexSupported()) {
            Map mapForward = this.m_mapForward;
            Object oValue = mapForward.get(oKey);
            return oValue != null || mapForward.containsKey(oKey) ? oValue : MapIndex.NO_VALUE;
        }
        return MapIndex.NO_VALUE;
    }

    @Override
    protected Map.Entry getForwardEntry(Object oKey) {
        return this.m_fForwardIndex ? super.getForwardEntry(oKey) : null;
    }

    @Override
    protected void removeForwardEntry(Object oKey) {
        if (this.m_fForwardIndex) {
            super.removeForwardEntry(oKey);
        }
    }

    @Override
    protected Map instantiateForwardIndex() {
        return this.m_fForwardIndex ? super.instantiateForwardIndex() : null;
    }

    @Override
    public boolean isPartial() {
        return this.m_fPartial || super.isPartial();
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    protected boolean evaluateEntry(Map.Entry entry) {
        try {
            if (InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.m_fPartial = true;
        return false;
    }

    @Override
    public void update(Map.Entry entry) {
        this.updateInternal(entry);
    }

    @Override
    protected void insertInternal(Map.Entry entry) {
        if (this.evaluateEntry(entry)) {
            super.insertInternal(entry);
        }
    }

    @Override
    protected void updateInternal(Map.Entry entry) {
        if (this.evaluateEntry(entry)) {
            super.updateInternal(entry);
        } else {
            this.deleteInternal(entry);
        }
    }

    @Override
    protected void deleteInternal(Map.Entry entry) {
        try {
            if (entry instanceof MapTrigger.Entry && !InvocableMapHelper.evaluateOriginalEntry(this.getFilter(), (MapTrigger.Entry)entry)) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        super.deleteInternal(entry);
    }

    @Override
    public String toString() {
        return super.toString() + ", Filter=" + this.getFilter() + ", ForwardIndex=" + this.isForwardIndexSupported();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o) || !(o instanceof ConditionalIndex)) {
            return false;
        }
        ConditionalIndex that = (ConditionalIndex)o;
        return ConditionalIndex.equals(this.getFilter(), that.getFilter()) && this.isForwardIndexSupported() == that.isForwardIndexSupported();
    }
}

