/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperCollections;

public class CopyOnWriteLongArray<V>
extends WrapperCollections.AbstractWrapperLongArray<V> {
    protected static final LongArray EMPTY_ARRAY = new SparseArray();
    private volatile LongArray<V> m_arrayInternal;

    public CopyOnWriteLongArray() {
        this.setDelegate(EMPTY_ARRAY);
    }

    public CopyOnWriteLongArray(Class<? extends LongArray<V>> clazz) throws IllegalAccessException, InstantiationException {
        if (!LongArray.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName());
        }
        this.setDelegate(clazz.newInstance());
    }

    public CopyOnWriteLongArray(LongArray<V> array) {
        this.setDelegate(this.copyArray(array));
    }

    @Override
    protected LongArray<V> delegate() {
        return this.m_arrayInternal;
    }

    protected void setDelegate(LongArray<V> array) {
        this.m_arrayInternal = array;
    }

    public LongArray<V> copyArray(LongArray<V> array) {
        return array.clone();
    }

    @Override
    public synchronized V set(long lIndex, V oValue) {
        LongArray<V> arrayNew = this.copyArray(this.delegate());
        V oValueOld = arrayNew.set(lIndex, oValue);
        this.setDelegate(arrayNew);
        return oValueOld;
    }

    @Override
    public synchronized long add(V oValue) {
        LongArray<V> arrayNew = this.copyArray(this.delegate());
        long lIndex = arrayNew.add(oValue);
        this.setDelegate(arrayNew);
        return lIndex;
    }

    @Override
    public synchronized V remove(long lIndex) {
        LongArray<V> arrayNew = this.copyArray(this.delegate());
        V oValueOld = arrayNew.remove(lIndex);
        this.setDelegate(arrayNew);
        return oValueOld;
    }

    @Override
    public synchronized void remove(long lIndexFrom, long lIndexTo) {
        LongArray<V> arrayNew = this.copyArray(this.delegate());
        arrayNew.remove(lIndexFrom, lIndexTo);
        this.setDelegate(arrayNew);
    }

    @Override
    public synchronized void clear() {
        LongArray<V> arrayNew = this.copyArray(this.delegate());
        arrayNew.clear();
        this.setDelegate(arrayNew);
    }

    @Override
    public LongArray.Iterator<V> iterator() {
        return this.instantiateUnmodifiableIterator((LongArray.Iterator<V>)this.delegate().iterator());
    }

    @Override
    public LongArray.Iterator<V> iterator(long lIndex) {
        return this.instantiateUnmodifiableIterator(this.delegate().iterator(lIndex));
    }

    @Override
    public LongArray.Iterator<V> reverseIterator() {
        return this.instantiateUnmodifiableIterator(this.delegate().reverseIterator());
    }

    @Override
    public LongArray.Iterator<V> reverseIterator(long lIndex) {
        return this.instantiateUnmodifiableIterator(this.delegate().reverseIterator(lIndex));
    }

    @Override
    public CopyOnWriteLongArray<V> clone() {
        CopyOnWriteLongArray<V> arrayNew = new CopyOnWriteLongArray<V>();
        arrayNew.setDelegate(this.delegate());
        return arrayNew;
    }

    public LongArray.Iterator<V> instantiateUnmodifiableIterator(LongArray.Iterator<V> iterator) {
        return new UnmodifiableIterator<V>(iterator);
    }

    public static class UnmodifiableIterator<V>
    implements LongArray.Iterator<V> {
        protected LongArray.Iterator<V> m_iteratorInternal;

        public UnmodifiableIterator(LongArray.Iterator<V> iterator) {
            this.m_iteratorInternal = iterator;
        }

        public LongArray.Iterator<V> getInternalIterator() {
            return this.m_iteratorInternal;
        }

        @Override
        public boolean hasNext() {
            return this.getInternalIterator().hasNext();
        }

        @Override
        public V next() {
            return this.getInternalIterator().next();
        }

        @Override
        public long getIndex() {
            return this.getInternalIterator().getIndex();
        }

        @Override
        public V getValue() {
            return this.getInternalIterator().getValue();
        }

        @Override
        public V setValue(V oValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

