/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ObjectStreamFactory;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Resolving;
import com.tangosol.io.ResolvingObjectInputStream;
import com.tangosol.io.ResolvingObjectOutputStream;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerAware;
import com.tangosol.io.Utf8Reader;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperObjectOutputStream;
import com.tangosol.io.WrapperOutputStream;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofInputStream;
import com.tangosol.io.pof.PofOutputStream;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawTime;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.BitHelper;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.Converter;
import com.tangosol.util.HashEncoded;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.Resources;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.WeakHashMap;
import java.util.function.BinaryOperator;

public abstract class ExternalizableHelper
extends BitHelper {
    public static final int FMT_NONE = 255;
    public static final int FMT_UNKNOWN = 255;
    public static final int FMT_NULL = 0;
    public static final int FMT_INT = 1;
    public static final int FMT_LONG = 2;
    public static final int FMT_DOUBLE = 3;
    public static final int FMT_INTEGER = 4;
    public static final int FMT_DECIMAL = 5;
    public static final int FMT_STRING = 6;
    public static final int FMT_BINARY = 7;
    public static final int FMT_B_ARRAY = 8;
    public static final int FMT_XML_SER = 9;
    public static final int FMT_OBJ_EXT = 10;
    public static final int FMT_OBJ_SER = 11;
    public static final int FMT_XML_BEAN = 12;
    public static final int FMT_IDO = 13;
    public static final int FMT_FLOAT = 14;
    public static final int FMT_SHORT = 15;
    public static final int FMT_BYTE = 16;
    public static final int FMT_BOOLEAN = 17;
    public static final int FMT_BIN_DECO = 18;
    public static final int FMT_BIN_EXT_DECO = 19;
    public static final int FMT_EXT = 21;
    public static final int FMT_OPT = 22;
    public static final int FMT_OPT_INT = 23;
    public static final int FMT_OPT_LONG = 24;
    public static final int FMT_OPT_DOUBLE = 25;
    public static final int DECO_ID_MIN = 0;
    public static final int DECO_ID_MAX = 63;
    public static final int DECO_VALUE = 0;
    public static final int DECO_EXPIRY = 1;
    public static final int DECO_STORE = 2;
    public static final int DECO_TX = 3;
    public static final int DECO_PUSHREP = 4;
    public static final int DECO_RSVD_2 = 5;
    public static final int DECO_RSVD_1 = 6;
    public static final int DECO_CUSTOM = 7;
    public static final int DECO_WLS = 9;
    public static final int DECO_APP_1 = 10;
    public static final int DECO_APP_2 = 11;
    public static final int DECO_APP_3 = 12;
    public static final int DECO_MEMCACHED = 13;
    public static final int DECO_JCACHE = 14;
    public static final int DECO_JCACHE_SYNTHETIC = 15;
    public static final int DECO_QUEUE_METADATA = 16;
    protected static final int MAX_DECO_HEADER_BYTES = 7;
    public static final int TRINT_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT_MAX_VARIANCE = 0x800000;
    public static final Binary[] EMPTY_BINARY_ARRAY;
    public static final Converter CONVERTER_TO_BINARY;
    public static final Converter CONVERTER_FROM_BINARY;
    public static final Converter CONVERTER_STRIP_INTDECO;
    public static final String PROPERTY_CONFIG = "coherence.externalizable.config";
    public static final boolean FORCE_RESOLVING_STREAMS;
    public static final boolean USE_XMLBEAN_CLASS_CACHE;
    public static final XmlBeanClassCache XMLBEAN_CLASS_CACHE;
    private static final int MAX_BUFFER;
    public static final boolean USE_POF_STREAMS;
    public static ObjectStreamFactory s_streamfactory;
    private static final MethodHandle HANDLE_GET_FILTER;
    private static final MethodHandle HANDLE_CHECKINPUT;
    private static final MethodHandle HANDLE_CONFIG_GET_FILTER;
    private static final MethodHandle HANDLE_CONFIG_GET_FILTER_FACTORY;
    private static Class<?> s_clzFilterInfo;
    private static final ThreadLocal<DynamicFilterInfo> s_tloHandler;
    public static final int CHUNK_THRESHOLD = 0x7FFFFFF;
    public static final int CHUNK_SIZE = 0x3FFFFFF;
    private static final Stats[] s_astats;
    private static final Map<ClassLoader, Serializer> s_mapSerializerByClassLoader;
    private static final boolean SERIAL_FILTER_LOGGING;
    private static Object m_oFilterSerial;
    private static BinaryOperator m_serialFilterFactory;

    public static byte[] toByteArray(Object o) {
        return ExternalizableHelper.toByteArray(o, ExternalizableHelper.ensureSerializer(null));
    }

    public static byte[] toByteArray(Object o, Serializer serializer) {
        try {
            return ExternalizableHelper.serializeInternal(serializer, o, false).toByteArray();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static byte[] toByteArray(long l, byte[] ab) {
        if (ab == null || ab.length < 8) {
            ab = new byte[8];
        }
        int n = (int)(l >>> 32);
        ab[0] = (byte)(n >>> 24);
        ab[1] = (byte)(n >>> 16);
        ab[2] = (byte)(n >>> 8);
        ab[3] = (byte)n;
        n = (int)l;
        ab[4] = (byte)(n >>> 24);
        ab[5] = (byte)(n >>> 16);
        ab[6] = (byte)(n >>> 8);
        ab[7] = (byte)n;
        return ab;
    }

    public static long toLong(byte[] ab) {
        return Byte.toUnsignedLong(ab[0]) << 56 | Byte.toUnsignedLong(ab[1]) << 48 | Byte.toUnsignedLong(ab[2]) << 40 | Byte.toUnsignedLong(ab[3]) << 32 | Byte.toUnsignedLong(ab[4]) << 24 | (long)(Byte.toUnsignedInt(ab[5]) << 16) | (long)(Byte.toUnsignedInt(ab[6]) << 8) | (long)Byte.toUnsignedInt(ab[7]);
    }

    public static Object fromByteArray(byte[] ab) {
        return ExternalizableHelper.fromByteArray(ab, null);
    }

    public static Object fromByteArray(byte[] ab, ClassLoader loader) {
        try {
            return ExternalizableHelper.deserializeInternal(ExternalizableHelper.ensureSerializer(loader), new ByteArrayReadBuffer(ab), null, Object.class);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary toBinary(Object o) {
        return ExternalizableHelper.toBinary(o, ExternalizableHelper.ensureSerializer(null));
    }

    public static Binary toBinary(Object o, Serializer serializer) {
        try {
            return ExternalizableHelper.serializeInternal(serializer, o, true).toBinary();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary toBinary(Object o, Serializer serializer, WriteBuffer buf) {
        try {
            return ExternalizableHelper.serializeInternal(serializer, o, true, buf).toBinary();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static <T> T fromBinary(Binary bin) {
        return ExternalizableHelper.fromBinary(bin, ExternalizableHelper.ensureSerializer(null));
    }

    public static <T> T fromBinary(Binary bin, ClassLoader loader) {
        return ExternalizableHelper.fromBinary(bin, ExternalizableHelper.ensureSerializer(loader));
    }

    public static <T> T fromBinary(Binary bin, Serializer serializer) {
        return (T)ExternalizableHelper.fromBinary(bin, serializer, null, Object.class);
    }

    public static <T> T fromBinary(Binary bin, Serializer serializer, Class<T> clazz) {
        return ExternalizableHelper.fromBinary(bin, serializer, null, clazz);
    }

    public static <T> T fromBinary(Binary bin, Serializer serializer, Remote.Function<ReadBuffer.BufferInput, ReadBuffer.BufferInput> supplier) {
        try {
            return (T)ExternalizableHelper.deserializeInternal(serializer, bin, supplier, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromBinary(Binary bin, Serializer serializer, Remote.Function<ReadBuffer.BufferInput, ReadBuffer.BufferInput> supplier, Class<T> clazz) {
        try {
            return ExternalizableHelper.deserializeInternal(serializer, bin, supplier, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Serializer ensureSerializer(ClassLoader loader) {
        Map<ClassLoader, Serializer> map = s_mapSerializerByClassLoader;
        Serializer serializer = map.get(loader = ExternalizableHelper.ensureClassLoader(loader));
        if (serializer == null) {
            serializer = USE_POF_STREAMS && loader != NullImplementation.getClassLoader() ? new ConfigurablePofContext() : new DefaultSerializer();
            ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(loader);
            map.put(loader, serializer);
        }
        return serializer;
    }

    public static Binary toLiteBinary(ExternalizableLite o) {
        try {
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(64);
            o.writeExternal(buffer.getBufferOutput());
            return buffer.toBinary();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static boolean isVersionCompatible(DataInput in, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        if (!(in instanceof WrapperBufferInput.VersionAwareBufferInput)) {
            throw new IllegalArgumentException("Unexpected DataInput");
        }
        return ((WrapperBufferInput.VersionAwareBufferInput)in).isVersionCompatible(nMajor, nMinor, nMicro, nPatchSet, nPatch);
    }

    public static boolean isVersionCompatible(DataOutput out, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        if (!(out instanceof WrapperBufferOutput.VersionAwareBufferOutput)) {
            throw new IllegalArgumentException("Unexpected DataOutput");
        }
        return ((WrapperBufferOutput.VersionAwareBufferOutput)out).isVersionCompatible(nMajor, nMinor, nMicro, nPatchSet, nPatch);
    }

    public static int readTrint(DataInput in) throws IOException {
        int n;
        if (in instanceof PofInputStream) {
            n = in.readInt();
        } else {
            n = in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
            if ((n & 0x800000) != 0) {
                n |= 0xFF000000;
            }
        }
        return n;
    }

    public static int readUnsignedTrint(DataInput in) throws IOException {
        int n = in instanceof PofInputStream ? in.readInt() : in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
        return n;
    }

    public static void writeTrint(DataOutput out, int n) throws IOException {
        if (out instanceof PofOutputStream) {
            out.writeInt(n);
        } else {
            out.writeByte(n >>> 16);
            out.writeByte(n >>> 8);
            out.writeByte(n);
        }
    }

    public static void writeTrint(DataOutput out, long l) throws IOException {
        ExternalizableHelper.writeTrint(out, (int)(l & 0xFFFFFFL));
    }

    public static int makeTrint(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public static int readInt(ReadBuffer.BufferInput in) throws IOException {
        return in.readPackedInt();
    }

    public static int readInt(DataInput in) throws IOException {
        int n;
        if (in instanceof ReadBuffer.BufferInput) {
            n = ((ReadBuffer.BufferInput)in).readPackedInt();
        } else if (in instanceof PofInputStream) {
            n = in.readInt();
        } else {
            boolean fNeg;
            int b = in.readUnsignedByte();
            n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = in.readUnsignedByte();
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
        }
        return n;
    }

    public static int calculatePackedLength(int n) {
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        return n < 64 ? 1 : (39 - Integer.numberOfLeadingZeros(n)) / 7;
    }

    public static void writeInt(WriteBuffer.BufferOutput out, int n) throws IOException {
        out.writePackedInt(n);
    }

    public static void writeInt(DataOutput out, int n) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writePackedInt(n);
        } else if (out instanceof PofOutputStream) {
            out.writeInt(n);
        } else {
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                out.writeByte(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            out.writeByte(b);
        }
    }

    public static int[][] readIntArray2d(DataInput in) throws IOException {
        int cSizeOuter = ExternalizableHelper.readInt(in);
        int cSizeInner = ExternalizableHelper.readInt(in);
        int[][] aai = new int[cSizeOuter][cSizeInner];
        for (int i = 0; i < cSizeOuter; ++i) {
            int[] ai = aai[i];
            for (int j = 0; j < cSizeInner; ++j) {
                ai[j] = ExternalizableHelper.readInt(in);
            }
        }
        return aai;
    }

    public static void writeIntArray2d(DataOutput out, int[][] aai) throws IOException {
        int cSizeOuter = aai.length;
        int cSizeInner = cSizeOuter == 0 ? 0 : aai[0].length;
        ExternalizableHelper.writeInt(out, cSizeOuter);
        ExternalizableHelper.writeInt(out, cSizeInner);
        for (int i = 0; i < cSizeOuter; ++i) {
            int[] ai = aai[i];
            for (int j = 0; j < cSizeInner; ++j) {
                ExternalizableHelper.writeInt(out, ai[j]);
            }
        }
    }

    public static long readLong(ReadBuffer.BufferInput in) throws IOException {
        return in.readPackedLong();
    }

    public static long readLong(DataInput in) throws IOException {
        long l;
        if (in instanceof ReadBuffer.BufferInput) {
            l = ((ReadBuffer.BufferInput)in).readPackedLong();
        } else if (in instanceof PofInputStream) {
            l = in.readLong();
        } else {
            boolean fNeg;
            int b = in.readUnsignedByte();
            l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = in.readUnsignedByte();
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return l;
    }

    public static int calculatePackedLength(long l) {
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return l < 64L ? 1 : (71 - Long.numberOfLeadingZeros(l)) / 7;
    }

    public static void writeLong(WriteBuffer.BufferOutput out, long l) throws IOException {
        out.writePackedLong(l);
    }

    public static void writeLong(DataOutput out, long l) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writePackedLong(l);
        } else if (out instanceof PofOutputStream) {
            out.writeLong(l);
        } else {
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                out.writeByte(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            out.writeByte(b);
        }
    }

    public static boolean[] readBooleanArray(DataInput in) throws IOException {
        boolean[] af;
        if (in instanceof PofInputStream) {
            af = (boolean[])((PofInputStream)in).readObject();
        } else {
            int c = ExternalizableHelper.readInt(in);
            ExternalizableHelper.validateLoadArray(boolean[].class, c, in);
            af = c < 0x7FFFFFF ? ExternalizableHelper.readBooleanArray(in, c) : ExternalizableHelper.readLargeBooleanArray(in, c);
        }
        return af;
    }

    public static void writeBooleanArray(DataOutput out, boolean[] af) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(af);
        } else {
            int c = af.length;
            ExternalizableHelper.writeInt(out, c);
            int cb = (c + 7) / 8;
            int i = 0;
            for (int of = 0; of < cb; ++of) {
                int nBits = 0;
                for (int nMask = 1; i < c && nMask <= 255; nMask <<= 1) {
                    if (!af[i++]) continue;
                    nBits |= nMask;
                }
                out.writeByte(nBits);
            }
        }
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        byte[] ab;
        if (in instanceof PofInputStream) {
            ab = (byte[])((PofInputStream)in).readObject();
        } else {
            int cb = ExternalizableHelper.readInt(in);
            ExternalizableHelper.validateLoadArray(byte[].class, cb, in);
            if (cb < 0x7FFFFFF) {
                ab = new byte[cb];
                in.readFully(ab);
            } else {
                ab = ExternalizableHelper.readLargeByteArray(in, cb);
            }
        }
        return ab;
    }

    public static void writeByteArray(DataOutput out, byte[] ab) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(ab);
        } else {
            int cb = ab.length;
            ExternalizableHelper.writeInt(out, cb);
            out.write(ab, 0, cb);
        }
    }

    public static String readUTF(DataInput in) throws IOException {
        String s;
        if (in instanceof ReadBuffer.BufferInput) {
            s = ((ReadBuffer.BufferInput)in).readSafeUTF();
        } else if (in instanceof PofInputStream) {
            s = in.readUTF();
        } else {
            byte[] ab;
            int cb = ExternalizableHelper.readInt(in);
            if (cb < 0) {
                return null;
            }
            if (cb == 0) {
                return "";
            }
            if (cb < 0x7FFFFFF) {
                ab = new byte[cb];
                in.readFully(ab);
            } else {
                ab = ExternalizableHelper.readLargeByteArray(in, cb);
            }
            s = ExternalizableHelper.convertUTF(ab, 0, cb, new char[cb]);
        }
        return s;
    }

    public static String convertUTF(byte[] ab, int of, int cb, char[] ach) throws UTFDataFormatException {
        int ofAsc;
        boolean fAscii = true;
        int ofch = 0;
        int ofEnd = of + cb;
        for (ofAsc = of; ofAsc < ofEnd; ++ofAsc) {
            int n = ab[ofAsc] & 0xFF;
            if (n >= 128) {
                fAscii = false;
                break;
            }
            ach[ofch++] = (char)n;
        }
        if (!fAscii) {
            while (ofAsc < ofEnd) {
                int ch = ab[ofAsc] & 0xFF;
                switch ((ch & 0xF0) >>> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ach[ofch++] = (char)ch;
                        break;
                    }
                    case 12: 
                    case 13: {
                        int ch2 = ab[++ofAsc] & 0xFF;
                        if ((ch2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        ach[ofch++] = (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
                        break;
                    }
                    case 14: {
                        int ch2 = ab[++ofAsc] & 0xFF;
                        int ch3 = ab[++ofAsc] & 0xFF;
                        if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        ach[ofch++] = (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F);
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException("illegal leading UTF byte: " + ch);
                    }
                }
                ++ofAsc;
            }
        }
        return new String(ach, 0, ofch);
    }

    public static void writeUTF(DataOutput out, String s) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writeSafeUTF(s);
        } else if (out instanceof PofOutputStream) {
            out.writeUTF(s);
        } else if (s == null) {
            ExternalizableHelper.writeInt(out, -1);
        } else {
            int cch = s.length();
            if (cch == 0) {
                ExternalizableHelper.writeInt(out, 0);
            } else {
                int cb = cch;
                for (int ofch = 0; ofch < cch; ++ofch) {
                    char ch = s.charAt(ofch);
                    if (ch <= '\u007f') {
                        if (ch != '\u0000') continue;
                        ++cb;
                        continue;
                    }
                    cb += ch <= '\u07ff' ? 1 : 2;
                }
                ExternalizableHelper.writeInt(out, cb);
                byte[] ab = new byte[cb];
                if (cb == cch) {
                    s.getBytes(0, cch, ab, 0);
                } else {
                    int ofb = 0;
                    for (int ofch = 0; ofch < cch; ++ofch) {
                        char ch = s.charAt(ofch);
                        if (ch >= '\u0001' && ch <= '\u007f') {
                            ab[ofb++] = (byte)ch;
                            continue;
                        }
                        if (ch <= '\u07ff') {
                            ab[ofb++] = (byte)(0xC0 | ch >>> 6 & 0x1F);
                            ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                            continue;
                        }
                        ab[ofb++] = (byte)(0xE0 | ch >>> 12 & 0xF);
                        ab[ofb++] = (byte)(0x80 | ch >>> 6 & 0x3F);
                        ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                    }
                }
                out.write(ab, 0, cb);
            }
        }
    }

    public static String readSafeUTF(ReadBuffer.BufferInput in) throws IOException {
        return in.readSafeUTF();
    }

    public static String readSafeUTF(DataInput in) throws IOException {
        return ExternalizableHelper.readUTF(in);
    }

    public static void writeSafeUTF(WriteBuffer.BufferOutput out, String s) throws IOException {
        out.writeSafeUTF(s);
    }

    public static void writeSafeUTF(DataOutput out, String s) throws IOException {
        ExternalizableHelper.writeUTF(out, s);
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        String[] as;
        if (in instanceof PofInputStream) {
            Object[] ao = (Object[])((PofInputStream)in).readObject();
            if (ao == null) {
                as = null;
            } else {
                int co = ao.length;
                as = new String[co];
                System.arraycopy(ao, 0, as, 0, co);
            }
        } else {
            int c = ExternalizableHelper.readInt(in);
            ExternalizableHelper.validateLoadArray(String[].class, c, in);
            as = c < 0xFFFFFF ? ExternalizableHelper.readStringArray(in, c) : ExternalizableHelper.readLargeStringArray(in, c);
        }
        return as;
    }

    public static void writeStringArray(DataOutput out, String[] as) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(as);
        } else {
            int c = as.length;
            ExternalizableHelper.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                ExternalizableHelper.writeSafeUTF(out, as[i]);
            }
        }
    }

    public static BigInteger readBigInteger(DataInput in) throws IOException {
        BigInteger n = in instanceof PofInputStream ? (BigInteger)((PofInputStream)in).readObject() : new BigInteger(ExternalizableHelper.readByteArray(in));
        return n;
    }

    public static void writeBigInteger(DataOutput out, BigInteger bigint) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(bigint);
        } else {
            ExternalizableHelper.writeByteArray(out, bigint.toByteArray());
        }
    }

    public static BigDecimal readBigDecimal(DataInput in) throws IOException {
        BigDecimal dec = in instanceof PofInputStream ? (BigDecimal)((PofInputStream)in).readObject() : new BigDecimal(ExternalizableHelper.readBigInteger(in), ExternalizableHelper.readInt(in));
        return dec;
    }

    public static void writeBigDecimal(DataOutput out, BigDecimal dec) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(dec);
        } else {
            ExternalizableHelper.writeBigInteger(out, dec.unscaledValue());
            ExternalizableHelper.writeInt(out, dec.scale());
        }
    }

    public static Date readDate(DataInput in) throws IOException {
        PofInputStream inPof;
        RawDate dateRaw;
        Date date = in instanceof PofInputStream ? ((dateRaw = (inPof = (PofInputStream)in).getPofReader().readRawDate(inPof.nextIndex())) == null ? null : dateRaw.toSqlDate()) : new Date(ExternalizableHelper.readLong(in));
        return date;
    }

    public static void writeDate(DataOutput out, Date date) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(date);
        } else {
            ExternalizableHelper.writeLong(out, date.getTime());
        }
    }

    public static Time readTime(DataInput in) throws IOException {
        PofInputStream inPof;
        RawTime timeRaw;
        Time time = in instanceof PofInputStream ? ((timeRaw = (inPof = (PofInputStream)in).getPofReader().readRawTime(inPof.nextIndex())) == null ? null : timeRaw.toSqlTime()) : new Time(ExternalizableHelper.readLong(in));
        return time;
    }

    public static void writeTime(DataOutput out, Time time) throws IOException {
        if (out instanceof PofOutputStream) {
            PofOutputStream outPof = (PofOutputStream)out;
            outPof.getPofWriter().writeTimeWithZone(outPof.nextIndex(), time);
        } else {
            ExternalizableHelper.writeLong(out, time.getTime());
        }
    }

    public static Timestamp readTimestamp(DataInput in) throws IOException {
        Timestamp dt;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            RawDateTime dtRaw = inPof.getPofReader().readRawDateTime(inPof.nextIndex());
            dt = dtRaw == null ? null : dtRaw.toSqlTimestamp();
        } else {
            dt = new Timestamp(ExternalizableHelper.readLong(in));
            dt.setNanos(ExternalizableHelper.readInt(in));
        }
        return dt;
    }

    public static void writeTimestamp(DataOutput out, Timestamp dt) throws IOException {
        if (out instanceof PofOutputStream) {
            PofOutputStream outPof = (PofOutputStream)out;
            outPof.getPofWriter().writeDateTimeWithZone(outPof.nextIndex(), dt);
        } else {
            ExternalizableHelper.writeLong(out, dt.getTime());
            ExternalizableHelper.writeInt(out, dt.getNanos());
        }
    }

    public static float[] readFloatArray(DataInput in) throws IOException {
        float[] afl;
        if (in instanceof PofInputStream) {
            afl = (float[])((PofInputStream)in).readObject();
        } else {
            int cfl = in.readInt();
            ExternalizableHelper.validateLoadArray(float[].class, cfl, in);
            afl = cfl < 0x1FFFFFF ? ExternalizableHelper.readFloatArray(in, cfl) : ExternalizableHelper.readLargeFloatArray(in, cfl);
        }
        return afl;
    }

    public static void writeFloatArray(DataOutput out, float[] afl) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(afl);
        } else {
            int cfl = afl.length;
            out.writeInt(cfl);
            if (cfl > 0) {
                byte[] ab = new byte[cfl << 2];
                int of = 0;
                for (int i = 0; i < cfl; ++i) {
                    int iValue = Float.floatToIntBits(afl[i]);
                    ab[of++] = (byte)(iValue >>> 24);
                    ab[of++] = (byte)(iValue >>> 16);
                    ab[of++] = (byte)(iValue >>> 8);
                    ab[of++] = (byte)iValue;
                }
                out.write(ab);
            }
        }
    }

    public static double[] readDoubleArray(DataInput in) throws IOException {
        double[] adbl;
        if (in instanceof PofInputStream) {
            adbl = (double[])((PofInputStream)in).readObject();
        } else {
            int c = in.readInt();
            ExternalizableHelper.validateLoadArray(float[].class, c, in);
            adbl = c <= 0 ? new double[]{} : (c < 0xFFFFFF ? ExternalizableHelper.readDoubleArray(in, c) : ExternalizableHelper.readLargeDoubleArray(in, c));
        }
        return adbl;
    }

    public static void writeDoubleArray(DataOutput out, double[] ad) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(ad);
        } else {
            int cd = ad.length;
            out.writeInt(cd);
            if (cd > 0) {
                byte[] ab = new byte[cd << 3];
                int of = 0;
                for (int i = 0; i < cd; ++i) {
                    long lValue = Double.doubleToLongBits(ad[i]);
                    int iUpper = (int)(lValue >>> 32);
                    int iLower = (int)lValue;
                    ab[of++] = (byte)(iUpper >>> 24);
                    ab[of++] = (byte)(iUpper >>> 16);
                    ab[of++] = (byte)(iUpper >>> 8);
                    ab[of++] = (byte)iUpper;
                    ab[of++] = (byte)(iLower >>> 24);
                    ab[of++] = (byte)(iLower >>> 16);
                    ab[of++] = (byte)(iLower >>> 8);
                    ab[of++] = (byte)iLower;
                }
                out.write(ab);
            }
        }
    }

    public static int readMap(DataInput in, Map map, ClassLoader loader) throws IOException {
        int cEntries;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            inPof.getPofReader().readMap(inPof.nextIndex(), map);
            cEntries = map.size();
        } else {
            cEntries = in.readInt();
            for (int i = 0; i < cEntries; ++i) {
                Object oKey = ExternalizableHelper.readObject(in, loader);
                Object oVal = ExternalizableHelper.readObject(in, loader);
                map.put(oKey, oVal);
            }
        }
        return cEntries;
    }

    public static int readMap(DataInput in, Map map, int cBlock, ClassLoader loader) throws IOException {
        int cEntries;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            Map mapTemp = inPof.getPofReader().readMap(inPof.nextIndex(), null);
            if (mapTemp == null) {
                cEntries = 0;
            } else {
                cEntries = mapTemp.size();
                map.putAll(mapTemp);
            }
        } else {
            if (cBlock <= 0) {
                throw new IllegalArgumentException("Illegal block size: " + cBlock);
            }
            cEntries = in.readInt();
            HashMap mapTmp = new HashMap(Math.min(cEntries, cBlock));
            int cTmp = 0;
            for (int i = 0; i < cEntries; ++i) {
                Object oKey = ExternalizableHelper.readObject(in, loader);
                Object oVal = ExternalizableHelper.readObject(in, loader);
                mapTmp.put(oKey, oVal);
                if (++cTmp != cBlock) continue;
                map.putAll(mapTmp);
                mapTmp.clear();
                cTmp = 0;
            }
            if (cTmp > 0) {
                map.putAll(mapTmp);
            }
        }
        return cEntries;
    }

    public static void writeMap(DataOutput out, Map map) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(map);
        } else {
            int cEntries = map.size();
            int cCheck = 0;
            out.writeInt(cEntries);
            try {
                for (Map.Entry entry : map.entrySet()) {
                    ExternalizableHelper.writeObject(out, entry.getKey());
                    ExternalizableHelper.writeObject(out, entry.getValue());
                    ++cCheck;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (cCheck != cEntries) {
                throw new IOException("Expected to write " + cEntries + " objects but actually wrote " + cCheck);
            }
        }
    }

    public static int readCollection(DataInput in, Collection collection, ClassLoader loader) throws IOException {
        int cItems;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            inPof.getPofReader().readCollection(inPof.nextIndex(), collection);
            cItems = collection.size();
        } else {
            cItems = in.readInt();
            for (int i = 0; i < cItems; ++i) {
                collection.add(ExternalizableHelper.readObject(in, loader));
            }
        }
        return cItems;
    }

    public static void writeCollection(DataOutput out, Collection collection) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(collection);
        } else {
            int cItems = collection.size();
            int cCheck = 0;
            out.writeInt(cItems);
            try {
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    ExternalizableHelper.writeObject(out, iter.next());
                    ++cCheck;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (cCheck != cItems) {
                throw new IOException("Expected to write " + cItems + " objects but actually wrote " + cCheck);
            }
        }
    }

    public static XmlSerializable readXmlSerializable(DataInput in) throws IOException {
        return ExternalizableHelper.readXmlSerializable(in, null);
    }

    public static XmlSerializable readXmlSerializable(DataInput in, ClassLoader loader) throws IOException {
        XmlSerializable value;
        if (in instanceof PofInputStream) {
            value = (XmlSerializable)((PofInputStream)in).readObject();
        } else {
            String sClass = ExternalizableHelper.readUTF(in);
            try {
                value = (XmlSerializable)ExternalizableHelper.loadClass(sClass, loader, null).newInstance();
            }
            catch (Exception e) {
                throw new IOException("Class initialization failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            String sXml = ExternalizableHelper.readUTF(in);
            XmlDocument xml = new SimpleParser(false).parseXml(sXml);
            value.fromXml(xml);
        }
        return value;
    }

    public static void writeXmlSerializable(DataOutput out, XmlSerializable o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            StringWriter writerRaw = new StringWriter();
            PrintWriter writerPrn = new PrintWriter(writerRaw);
            o.toXml().writeXml(writerPrn, false);
            writerPrn.close();
            ExternalizableHelper.writeUTF(out, o.getClass().getName());
            ExternalizableHelper.writeUTF(out, writerRaw.toString());
        }
    }

    public static ExternalizableLite readExternalizableLite(DataInput in) throws IOException {
        return ExternalizableHelper.readExternalizableLite(in, null);
    }

    public static ExternalizableLite readExternalizableLite(DataInput in, ClassLoader loader) throws IOException {
        ExternalizableLite value;
        if (in instanceof PofInputStream) {
            value = (ExternalizableLite)((PofInputStream)in).readObject();
        } else {
            String sClass = ExternalizableHelper.readUTF(in);
            WrapperDataInputStream inWrapper = in instanceof WrapperDataInputStream ? (WrapperDataInputStream)in : null;
            try {
                Class clz = ExternalizableHelper.loadClass(sClass, loader, inWrapper == null ? null : inWrapper.getClassLoader());
                ExternalizableHelper.validateLoadClass(clz, in);
                value = (ExternalizableLite)clz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("Unable to instantiate an instance of class '" + sClass + "'; this is most likely due to a missing public no-args constructor: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            catch (Exception e) {
                throw new IOException("Class initialization failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader(), e);
            }
            if (loader != null) {
                if (inWrapper == null) {
                    in = new WrapperDataInputStream(in, loader);
                } else if (loader != inWrapper.getClassLoader()) {
                    inWrapper.setClassLoader(loader);
                }
            }
            value.readExternal(in);
            if (value instanceof SerializerAware) {
                ((SerializerAware)((Object)value)).setContextSerializer(ExternalizableHelper.ensureSerializer(loader));
            }
        }
        return value;
    }

    protected static void validateLoadClass(Class clz, DataInput in) throws InvalidClassException {
        if (!ExternalizableHelper.checkObjectInputFilter(clz, in)) {
            throw new InvalidClassException("Deserialization of class " + clz.getName() + " was rejected");
        }
    }

    public static void validateLoadArray(Class clz, int cLength, DataInput in) throws InvalidClassException {
        if (!ExternalizableHelper.checkObjectInputFilter(clz, cLength, in)) {
            throw new InvalidClassException("Deserialization of class " + clz.getName() + " with array length " + cLength + " was rejected");
        }
    }

    public static void writeExternalizableLite(DataOutput out, ExternalizableLite o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            ExternalizableHelper.writeUTF(out, o.getClass().getName());
            o.writeExternal(out);
        }
    }

    public static XmlBean readXmlBean(DataInput in, ClassLoader loader) throws IOException {
        XmlBean bean;
        if (in instanceof PofInputStream) {
            bean = (XmlBean)((PofInputStream)in).readObject();
        } else if (USE_XMLBEAN_CLASS_CACHE) {
            int nBeanId = ExternalizableHelper.readInt(in);
            if (nBeanId < 0) {
                bean = (XmlBean)ExternalizableHelper.readExternalizableLite(in, loader);
            } else {
                try {
                    Class clz = XMLBEAN_CLASS_CACHE.getClass(nBeanId, loader);
                    ExternalizableHelper.validateLoadClass(clz, in);
                    bean = (XmlBean)clz.newInstance();
                }
                catch (Exception e) {
                    throw new IOException("Class instantiation failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nXmlBean ID: " + nBeanId + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
                }
                bean.readExternal(in);
            }
        } else {
            bean = (XmlBean)ExternalizableHelper.readExternalizableLite(in, loader);
        }
        return bean;
    }

    public static void writeXmlBean(DataOutput out, XmlBean bean) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(bean);
        } else if (USE_XMLBEAN_CLASS_CACHE) {
            int nBeanId = bean.getBeanInfo().getBeanId();
            ExternalizableHelper.writeInt(out, nBeanId);
            if (nBeanId < 0) {
                ExternalizableHelper.writeExternalizableLite(out, bean);
            } else {
                bean.writeExternal(out);
            }
        } else {
            ExternalizableHelper.writeExternalizableLite(out, bean);
        }
    }

    public static Object readSerializable(DataInput in) throws IOException {
        return ExternalizableHelper.readSerializable(in, null);
    }

    public static Object readSerializable(DataInput in, ClassLoader loader) throws IOException {
        Object o;
        if (in instanceof PofInputStream) {
            o = ((PofInputStream)in).readObject();
        } else {
            ObjectInput streamObj = ExternalizableHelper.getObjectInput(in, loader);
            try {
                o = streamObj.readObject();
                if (o instanceof SerializerAware) {
                    ((SerializerAware)o).setContextSerializer(ExternalizableHelper.ensureSerializer(loader));
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("readObject failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClassLoader: " + loader);
            }
        }
        return o;
    }

    public static void writeSerializable(DataOutput out, Object o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            ObjectOutput streamObj = ExternalizableHelper.getObjectOutput(out);
            streamObj.writeObject(o);
            streamObj.close();
        }
    }

    public static <T> T readObject(DataInput in) throws IOException {
        return ExternalizableHelper.readObject(in, null);
    }

    public static <T> T readObject(DataInput in, ClassLoader loader) throws IOException {
        if (in instanceof PofInputStream) {
            return (T)((PofInputStream)in).readObject();
        }
        Object o = ExternalizableHelper.readObjectInternal(in, in.readUnsignedByte(), loader);
        return ExternalizableHelper.safeRealize(o, ExternalizableHelper.ensureSerializer(loader), in);
    }

    private static <T> T safeRealize(Object o, Serializer serializer, DataInput in) throws IOException {
        T oReplace = ExternalizableHelper.realize(o, serializer);
        if (o != oReplace && oReplace != null && o.getClass() != oReplace.getClass()) {
            if (oReplace.getClass().isArray()) {
                ExternalizableHelper.validateLoadArray(oReplace.getClass(), Array.getLength(oReplace), in);
            } else {
                ExternalizableHelper.validateLoadClass(oReplace.getClass(), in);
            }
        }
        return oReplace;
    }

    private static Object readObjectInternal(DataInput in, int nType, ClassLoader loader) throws IOException {
        switch (nType) {
            default: {
                throw new StreamCorruptedException("invalid type: " + nType);
            }
            case 255: {
                return ExternalizableHelper.readSerializable(in, loader);
            }
            case 0: {
                return null;
            }
            case 1: {
                return ExternalizableHelper.readInt(in);
            }
            case 2: {
                return ExternalizableHelper.readLong(in);
            }
            case 6: {
                return ExternalizableHelper.readUTF(in);
            }
            case 3: {
                return new Double(in.readDouble());
            }
            case 4: {
                return ExternalizableHelper.readBigInteger(in);
            }
            case 5: {
                return ExternalizableHelper.readBigDecimal(in);
            }
            case 7: {
                Binary bin = new Binary();
                bin.readExternal(in);
                return bin;
            }
            case 8: {
                return ExternalizableHelper.readByteArray(in);
            }
            case 9: {
                return ExternalizableHelper.readXmlSerializable(in, loader);
            }
            case 10: {
                return ExternalizableHelper.readExternalizableLite(in, loader);
            }
            case 11: {
                return ExternalizableHelper.readSerializable(in, loader);
            }
            case 22: {
                return in.readBoolean() ? Optional.of(ExternalizableHelper.readObject(in, loader)) : Optional.empty();
            }
            case 23: {
                return in.readBoolean() ? OptionalInt.of(ExternalizableHelper.readInt(in)) : OptionalInt.empty();
            }
            case 24: {
                return in.readBoolean() ? OptionalLong.of(ExternalizableHelper.readLong(in)) : OptionalLong.empty();
            }
            case 25: {
                return in.readBoolean() ? OptionalDouble.of(in.readDouble()) : OptionalDouble.empty();
            }
            case 12: {
                return ExternalizableHelper.readXmlBean(in, loader);
            }
            case 14: {
                return new Float(in.readFloat());
            }
            case 15: {
                return new Short(in.readShort());
            }
            case 16: {
                return new Byte(in.readByte());
            }
            case 17: 
        }
        return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static void writeObject(DataOutput out, Object o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            o = ExternalizableHelper.replace(o);
            int nType = ExternalizableHelper.getStreamFormat(o);
            out.writeByte(nType);
            switch (nType) {
                case 255: {
                    ExternalizableHelper.writeSerializable(out, o);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    ExternalizableHelper.writeInt(out, (int)((Integer)o));
                    break;
                }
                case 2: {
                    ExternalizableHelper.writeLong(out, (long)((Long)o));
                    break;
                }
                case 6: {
                    ExternalizableHelper.writeUTF(out, (String)o);
                    break;
                }
                case 3: {
                    out.writeDouble((Double)o);
                    break;
                }
                case 4: {
                    ExternalizableHelper.writeBigInteger(out, (BigInteger)o);
                    break;
                }
                case 5: {
                    ExternalizableHelper.writeBigDecimal(out, (BigDecimal)o);
                    break;
                }
                case 7: {
                    Binary.writeExternal(out, (ReadBuffer)o);
                    break;
                }
                case 8: {
                    ExternalizableHelper.writeByteArray(out, (byte[])o);
                    break;
                }
                case 9: {
                    ExternalizableHelper.writeXmlSerializable(out, (XmlSerializable)o);
                    break;
                }
                case 10: {
                    ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)o);
                    break;
                }
                case 11: {
                    ExternalizableHelper.writeSerializable(out, o);
                    break;
                }
                case 12: {
                    ExternalizableHelper.writeXmlBean(out, (XmlBean)o);
                    break;
                }
                case 22: {
                    Optional opt = (Optional)o;
                    boolean fPresent = opt.isPresent();
                    out.writeBoolean(fPresent);
                    if (!fPresent) break;
                    ExternalizableHelper.writeObject(out, opt.get());
                    break;
                }
                case 23: {
                    OptionalInt opt = (OptionalInt)o;
                    boolean fPresent = opt.isPresent();
                    out.writeBoolean(fPresent);
                    if (!fPresent) break;
                    ExternalizableHelper.writeInt(out, opt.getAsInt());
                    break;
                }
                case 24: {
                    OptionalLong opt = (OptionalLong)o;
                    boolean fPresent = opt.isPresent();
                    out.writeBoolean(fPresent);
                    if (!fPresent) break;
                    ExternalizableHelper.writeLong(out, opt.getAsLong());
                    break;
                }
                case 25: {
                    OptionalDouble opt = (OptionalDouble)o;
                    boolean fPresent = opt.isPresent();
                    out.writeBoolean(fPresent);
                    if (!fPresent) break;
                    out.writeDouble(opt.getAsDouble());
                    break;
                }
                case 14: {
                    out.writeFloat(((Float)o).floatValue());
                    break;
                }
                case 15: {
                    out.writeShort(((Short)o).shortValue());
                    break;
                }
                case 16: {
                    out.writeByte(((Byte)o).byteValue());
                    break;
                }
                case 17: {
                    out.writeBoolean((Boolean)o);
                    break;
                }
                default: {
                    throw ExternalizableHelper.azzert();
                }
            }
        }
    }

    private static WriteBuffer serializeInternal(Serializer serializer, Object o, boolean fBinary) throws IOException {
        return ExternalizableHelper.serializeInternal(serializer, o, fBinary, null);
    }

    private static WriteBuffer serializeInternal(Serializer serializer, Object o, boolean fBinary, WriteBuffer buf) throws IOException {
        boolean fDeco = false;
        int nDeco = 0;
        int cb = 1;
        boolean fUser = false;
        Stats stats = null;
        if (o instanceof IntDecoratedObject) {
            IntDecoratedObject ido = (IntDecoratedObject)o;
            fDeco = true;
            nDeco = ido.getDecoration();
            cb += 5;
            o = ido.getValue();
        }
        o = ExternalizableHelper.replace(o);
        int nType = serializer instanceof DefaultSerializer ? ExternalizableHelper.getStreamFormat(o) : 21;
        switch (nType) {
            case 0: {
                break;
            }
            case 16: 
            case 17: {
                ++cb;
                break;
            }
            case 15: {
                cb += 2;
                break;
            }
            case 1: {
                cb += 5;
                break;
            }
            case 2: {
                cb += 10;
                break;
            }
            case 4: {
                cb += ((BigInteger)o).bitLength() / 8 + 1;
                break;
            }
            case 14: {
                cb += 4;
                break;
            }
            case 3: {
                cb += 8;
                break;
            }
            case 5: {
                cb += ((BigDecimal)o).unscaledValue().bitLength() / 8 + 2;
                break;
            }
            case 7: {
                cb += ((ReadBuffer)o).length() + 4;
                break;
            }
            case 8: {
                cb += ((byte[])o).length + 5;
                break;
            }
            case 6: {
                cb += ((String)o).length() + 5;
                break;
            }
            case 21: {
                ExternalizableHelper.azzert(serializer != null);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 255: {
                fUser = true;
                stats = ExternalizableHelper.findStats(o);
                if (stats != null) break;
                cb = 64;
                break;
            }
            default: {
                throw ExternalizableHelper.azzert();
            }
        }
        if (buf == null) {
            buf = stats == null ? (fBinary ? new BinaryWriteBuffer(cb) : new ByteArrayWriteBuffer(cb)) : stats.instantiateBuffer(fBinary);
        }
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        if (fDeco) {
            out.writeByte(13);
            out.writePackedInt(nDeco);
        }
        out.writeByte(nType);
        if (nType == 21) {
            serializer.serialize(out, o);
        } else {
            ExternalizableHelper.writeObjectInternal(out, nType, o);
        }
        if (fUser) {
            ExternalizableHelper.updateStats(o, stats, buf.length());
        }
        return buf;
    }

    private static void writeObjectInternal(WriteBuffer.BufferOutput out, int nType, Object o) throws IOException {
        switch (nType) {
            case 0: {
                break;
            }
            case 1: {
                out.writePackedInt((Integer)o);
                break;
            }
            case 2: {
                out.writePackedLong((Long)o);
                break;
            }
            case 6: {
                out.writeSafeUTF((String)o);
                break;
            }
            case 3: {
                out.writeDouble((Double)o);
                break;
            }
            case 4: {
                ExternalizableHelper.writeBigInteger(out, (BigInteger)o);
                break;
            }
            case 5: {
                ExternalizableHelper.writeBigDecimal(out, (BigDecimal)o);
                break;
            }
            case 7: {
                Binary.writeExternal(out, (ReadBuffer)o);
                break;
            }
            case 8: {
                ExternalizableHelper.writeByteArray(out, (byte[])o);
                break;
            }
            case 9: {
                ExternalizableHelper.writeXmlSerializable(out, (XmlSerializable)o);
                break;
            }
            case 10: {
                ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)o);
                break;
            }
            case 11: {
                ExternalizableHelper.writeSerializable(out, o);
                break;
            }
            case 22: {
                Optional opt = (Optional)o;
                boolean fPresent = opt.isPresent();
                out.writeBoolean(fPresent);
                if (!fPresent) break;
                ExternalizableHelper.writeObject(out, opt.get());
                break;
            }
            case 23: {
                OptionalInt opt = (OptionalInt)o;
                boolean fPresent = opt.isPresent();
                out.writeBoolean(fPresent);
                if (!fPresent) break;
                ExternalizableHelper.writeInt(out, opt.getAsInt());
                break;
            }
            case 24: {
                OptionalLong opt = (OptionalLong)o;
                boolean fPresent = opt.isPresent();
                out.writeBoolean(fPresent);
                if (!fPresent) break;
                ExternalizableHelper.writeLong(out, opt.getAsLong());
                break;
            }
            case 25: {
                OptionalDouble opt = (OptionalDouble)o;
                boolean fPresent = opt.isPresent();
                out.writeBoolean(fPresent);
                if (!fPresent) break;
                out.writeDouble(opt.getAsDouble());
                break;
            }
            case 12: {
                ExternalizableHelper.writeXmlBean(out, (XmlBean)o);
                break;
            }
            case 14: {
                out.writeFloat(((Float)o).floatValue());
                break;
            }
            case 15: {
                out.writeShort(((Short)o).shortValue());
                break;
            }
            case 16: {
                out.writeByte(((Byte)o).byteValue());
                break;
            }
            case 17: {
                out.writeBoolean((Boolean)o);
                break;
            }
            case 255: {
                ExternalizableHelper.writeSerializable(out, o);
                break;
            }
            default: {
                throw ExternalizableHelper.azzert();
            }
        }
    }

    private static <T> T deserializeInternal(Serializer serializer, ReadBuffer buf, Remote.Function<ReadBuffer.BufferInput, ReadBuffer.BufferInput> supplierBufferIn, Class<T> clazz) throws IOException {
        ReadBuffer.BufferInput in = buf.getBufferInput();
        int nType = in.readUnsignedByte();
        switch (nType) {
            case 13: {
                ExternalizableHelper.readInt(in);
                nType = in.readUnsignedByte();
                break;
            }
            case 18: 
            case 19: {
                long nMask;
                long l = nMask = nType == 18 ? (long)in.readByte() : in.readPackedLong();
                if ((nMask & 1L) == 0L) {
                    throw new EOFException("Decorated value is missing a value");
                }
                int cb = in.readPackedInt();
                in = buf.getReadBuffer(in.getOffset(), cb).getBufferInput();
                nType = in.readUnsignedByte();
            }
        }
        if (supplierBufferIn != null) {
            in = (ReadBuffer.BufferInput)supplierBufferIn.apply(in);
        }
        T o = nType == 21 ? serializer.deserialize(in, clazz) : ExternalizableHelper.readObjectInternal(in, nType, ((ClassLoaderAware)((Object)serializer)).getContextClassLoader());
        return ExternalizableHelper.safeRealize(o, serializer, in);
    }

    public static void validateBufferSize(int cb) {
        int cbMax = MAX_BUFFER;
        if (cbMax > 0 && cb > cbMax) {
            BufferOverflowException e = new BufferOverflowException();
            e.initCause(new IOException("serialization exceeded maximum size (" + cb + " out of " + cbMax + ")"));
            throw e;
        }
    }

    private static Stats findStats(Object o) {
        return s_astats[ExternalizableHelper.calculateStatsId(o)];
    }

    private static void updateStats(Object o, Stats stats, int cb) {
        if (stats == null) {
            ExternalizableHelper.s_astats[ExternalizableHelper.calculateStatsId((Object)o)] = stats = new Stats();
        }
        stats.update(cb);
    }

    private static int calculateStatsId(Object o) {
        if (o == null) {
            return 0;
        }
        int n = o.getClass().hashCode();
        return ((n >>> 1) + (n & 1)) % s_astats.length;
    }

    public static DeltaCompressor getDeltaCompressor(Serializer serializer, DeltaCompressor compressor) {
        return serializer instanceof DefaultSerializer ? compressor : new FormatAwareCompressor(compressor);
    }

    public static Class loadClass(String sClass, ClassLoader loader1, ClassLoader loader2) throws ClassNotFoundException {
        for (int i = 1; i <= 3; ++i) {
            ClassLoader loader;
            switch (i) {
                case 1: {
                    loader = loader1;
                    break;
                }
                case 2: {
                    loader = loader2;
                    break;
                }
                case 3: {
                    loader = ExternalizableHelper.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            try {
                if (loader == null) continue;
                return Class.forName(sClass, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(sClass);
    }

    public static URL loadResource(String sName, ClassLoader loader1, ClassLoader loader2) {
        for (int i = 1; i <= 3; ++i) {
            URL url;
            ClassLoader loader;
            switch (i) {
                case 1: {
                    loader = loader1;
                    break;
                }
                case 2: {
                    loader = loader2;
                    break;
                }
                case 3: {
                    loader = ExternalizableHelper.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (loader == null || (url = loader.getResource(sName)) == null) continue;
            return url;
        }
        return null;
    }

    public static InputStream getInputStream(final DataInput in) {
        return in instanceof InputStream ? (InputStream)((Object)in) : new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return in.readUnsignedByte();
                }
                catch (EOFException e) {
                    return -1;
                }
            }
        };
    }

    public static OutputStream getOutputStream(DataOutput out) {
        return out instanceof ObjectOutput ? new ShieldedObjectOutputStream((ObjectOutput)out) : new ShieldedDataOutputStream(out);
    }

    public static OutputStream getShieldedOutputStream(OutputStream out) {
        return out instanceof Shielded ? out : (out instanceof ObjectOutput ? new ShieldedObjectOutputStream((ObjectOutput)((Object)out)) : (out instanceof DataOutput ? new ShieldedDataOutputStream((DataOutput)((Object)out)) : new ShieldedOutputStream(out)));
    }

    public static ObjectInput getObjectInput(DataInput in, ClassLoader loader) throws IOException {
        return s_streamfactory.getObjectInput(in, loader, false);
    }

    public static ObjectInput getNewObjectInput(DataInput in, ClassLoader loader) throws IOException {
        return s_streamfactory.getObjectInput(in, loader, true);
    }

    public static ObjectOutput getObjectOutput(DataOutput out) throws IOException {
        return s_streamfactory.getObjectOutput(out);
    }

    public static boolean isResolving(DataOutput out) {
        return out instanceof Resolving || out instanceof ShieldedObjectOutputStream && ((ShieldedObjectOutputStream)out).isResolving();
    }

    public static ObjectStreamFactory getObjectStreamFactory() {
        return s_streamfactory;
    }

    public static void setObjectStreamFactory(ObjectStreamFactory factory) {
        s_streamfactory = factory;
    }

    public static boolean isSerializable(Object o) {
        return ExternalizableHelper.getStreamFormat(o) != 255;
    }

    public static int getStreamFormat(Object o) {
        return o == null ? 0 : (o instanceof String ? 6 : (o instanceof Number ? (o instanceof Integer ? 1 : (o instanceof Long ? 2 : (o instanceof Double ? 3 : (o instanceof BigInteger ? 4 : (o instanceof BigDecimal ? 5 : (o instanceof Float ? 14 : (o instanceof Short ? 15 : (o instanceof Byte ? 16 : 11)))))))) : (o instanceof byte[] ? 8 : (o instanceof ReadBuffer ? 7 : (o instanceof XmlBean ? 12 : (o instanceof IntDecoratedObject ? 13 : (o instanceof ExternalizableLite ? 10 : (o instanceof Boolean ? 17 : (o instanceof Serializable ? 11 : (o instanceof Optional ? 22 : (o instanceof OptionalInt ? 23 : (o instanceof OptionalLong ? 24 : (o instanceof OptionalDouble ? 25 : (o instanceof XmlSerializable ? 9 : 255))))))))))))));
    }

    public static boolean isSerializerCompatible(Serializer serializerThis, Serializer serializerThat) {
        return serializerThis instanceof PofContext ? serializerThat instanceof PofContext : (serializerThis == null || serializerThat == null ? serializerThis == serializerThat : serializerThis.getClass() == serializerThat.getClass());
    }

    public static void reportIncompatibleSerializers(NamedCache cache, String sService, Serializer serializer) {
        CacheFactory.log("The serializer used by cache \"" + cache.getCacheName() + "\" (" + cache.getCacheService().getSerializer() + ") is incompatible with the serializer configured for service \"" + sService + "\" (" + serializer + "); therefore, cached keys and values will be converted via serialization. This will result in increased CPU and memory utilization. If possible, consider reconfiguring either serializer.", 2);
    }

    public static boolean isDecorated(ReadBuffer buf) {
        if (buf != null && buf.length() > 1) {
            byte b = buf.byteAt(0);
            return b == 18 || b == 19;
        }
        return false;
    }

    public static boolean isDecorated(ReadBuffer buf, int nId) {
        if (buf != null && buf.length() > 1) {
            byte b = buf.byteAt(0);
            if (b == 18) {
                long nMask;
                if (nId >= 8) {
                    return false;
                }
                long nBits = buf.byteAt(1) & 0xFF;
                return (nBits & (nMask = 1L << nId)) != 0L;
            }
            if (b == 19) {
                ReadBuffer.BufferInput in = buf.getBufferInput();
                try {
                    int nFmt = in.readUnsignedByte();
                    long nBits = in.readPackedLong();
                    long nMask = 1L << nId;
                    return (nBits & nMask) != 0L;
                }
                catch (IOException e) {
                    throw ExternalizableHelper.ensureRuntimeException(e);
                }
            }
        }
        return false;
    }

    public static Binary decorate(Binary bin, int nId, Binary binDecoration) {
        return ExternalizableHelper.asBinary(ExternalizableHelper.decorate((ReadBuffer)bin, nId, (ReadBuffer)binDecoration));
    }

    public static ReadBuffer decorate(ReadBuffer bufOrig, int nId, ReadBuffer bufDeco) {
        if (bufDeco == null) {
            return ExternalizableHelper.undecorate(bufOrig, nId);
        }
        if (nId < 0 || nId > 63) {
            throw new IndexOutOfBoundsException("decoration index is out of range: index=" + nId + ", min=" + 0 + ", max=" + 63);
        }
        boolean fDecorated = ExternalizableHelper.isDecorated(bufOrig);
        if (!fDecorated && nId == 0 && !ExternalizableHelper.isDecorated(bufDeco)) {
            return bufDeco;
        }
        long nBits = 1L << nId;
        int ofFront = -1;
        int cbFront = 0;
        int ofBack = -1;
        int cbBack = 0;
        boolean fEncodeFrontLength = false;
        boolean fExtended = false;
        if (bufOrig == null) {
            bufOrig = Binary.NO_BINARY;
        } else if (fDecorated) {
            try {
                ReadBuffer.BufferInput in = bufOrig.getBufferInput();
                fExtended = in.readByte() != 18;
                long nPrevBits = fExtended ? in.readPackedLong() : (long)in.readUnsignedByte();
                ofFront = in.getOffset();
                nBits |= nPrevBits;
                int nLastFront = ExternalizableHelper.indexOfMSB(nPrevBits & (1L << nId) - 1L);
                int nFirstBack = ExternalizableHelper.indexOfLSB(nPrevBits & -1L << nId + 1);
                int iCurrentId = 0;
                while (nPrevBits != 0L) {
                    if ((nPrevBits & 1L) != 0L) {
                        if (iCurrentId == nFirstBack) {
                            ofBack = in.getOffset();
                            cbBack = bufOrig.length() - ofBack;
                        }
                        in.skipBytes(in.readPackedInt());
                        if (iCurrentId == nLastFront) {
                            cbFront = in.getOffset() - ofFront;
                        }
                    }
                    nPrevBits >>>= 1;
                    ++iCurrentId;
                }
            }
            catch (IOException e) {
                throw ExternalizableHelper.ensureRuntimeException(e);
            }
        } else {
            nBits |= 1L;
            ofFront = 0;
            cbFront = bufOrig.length();
            fEncodeFrontLength = true;
        }
        fExtended |= nId >= 8;
        int cbNew = bufDeco.length();
        if (cbFront + cbNew + cbBack > 128) {
            ByteArrayWriteBuffer bufWrite = new ByteArrayWriteBuffer(21);
            WriteBuffer.BufferOutput out = bufWrite.getBufferOutput();
            try {
                if (fExtended) {
                    out.writeByte(19);
                    out.writePackedLong(nBits);
                } else {
                    out.writeByte(18);
                    out.writeByte((byte)nBits);
                }
                if (fEncodeFrontLength) {
                    out.writePackedInt(cbFront);
                }
                int cbHead = out.getOffset();
                out.writePackedInt(cbNew);
                int cbTail = out.getOffset() - cbHead;
                Binary bufRead = bufWrite.toBinary();
                ReadBuffer[] abuf = new ReadBuffer[]{bufRead.getReadBuffer(0, cbHead), cbFront > 0 ? bufOrig.getReadBuffer(ofFront, cbFront) : Binary.NO_BINARY, bufRead.getReadBuffer(cbHead, cbTail), bufDeco, cbBack > 0 ? bufOrig.getReadBuffer(ofBack, cbBack) : Binary.NO_BINARY};
                return fEncodeFrontLength ? new DecoratedMultiBufferReadBuffer(bufOrig, abuf) : new MultiBufferReadBuffer(abuf);
            }
            catch (IOException e) {
                throw ExternalizableHelper.ensureRuntimeException(e);
            }
        }
        int cbTotal = 1 + (fExtended ? ExternalizableHelper.calculatePackedLength(nBits) : 1) + cbFront + ExternalizableHelper.calculatePackedLength(cbNew) + cbNew + cbBack;
        if (fEncodeFrontLength) {
            cbTotal += ExternalizableHelper.calculatePackedLength(cbFront);
        }
        BinaryWriteBuffer bufNew = new BinaryWriteBuffer(cbTotal, cbTotal);
        WriteBuffer.BufferOutput out = bufNew.getBufferOutput();
        try {
            if (fExtended) {
                out.writeByte(19);
                out.writePackedLong(nBits);
            } else {
                out.writeByte(18);
                out.writeByte((byte)nBits);
            }
            if (fEncodeFrontLength) {
                out.writePackedInt(cbFront);
            }
            if (cbFront > 0) {
                out.writeBuffer(bufOrig, ofFront, cbFront);
            }
            out.writePackedInt(cbNew);
            out.writeBuffer(bufDeco);
            if (cbBack > 0) {
                out.writeBuffer(bufOrig, ofBack, cbBack);
            }
            assert (out.getOffset() == cbTotal);
            return bufNew.toBinary();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary decorate(Binary bin, Binary[] abinDecorations) {
        return ExternalizableHelper.asBinary(ExternalizableHelper.decorate((ReadBuffer)bin, (ReadBuffer[])abinDecorations));
    }

    public static ReadBuffer decorate(ReadBuffer buf, ReadBuffer[] abufDeco) {
        if (ExternalizableHelper.isDecorated(buf)) {
            int i;
            ReadBuffer[] abufNew;
            int cbufOver;
            ReadBuffer[] abufOrig = ExternalizableHelper.getDecorations(buf);
            int cbufOrig = abufOrig.length;
            if (cbufOrig >= (cbufOver = (abufNew = abufDeco).length)) {
                abufDeco = abufOrig;
                for (i = 0; i < cbufOver; ++i) {
                    if (abufNew[i] == null) continue;
                    abufDeco[i] = abufNew[i];
                }
            } else {
                abufDeco = (ReadBuffer[])abufDeco.clone();
                for (i = 0; i < cbufOrig; ++i) {
                    if (abufDeco[i] != null) continue;
                    abufDeco[i] = abufOrig[i];
                }
            }
        } else if (buf != null && (abufDeco.length < 1 || abufDeco[0] == null)) {
            ReadBuffer[] abufOverride = abufDeco;
            int cbufOverride = abufOverride.length;
            abufDeco = new ReadBuffer[Math.max(1, cbufOverride)];
            if (cbufOverride > 0) {
                System.arraycopy(abufOverride, 0, abufDeco, 0, cbufOverride);
            }
            abufDeco[0] = buf;
        }
        int cbTotal = 1;
        int cDecorations = 0;
        int nLastId = -1;
        long nBits = 0L;
        int cBufDeco = abufDeco.length;
        for (int i = 0; i < cBufDeco; ++i) {
            ReadBuffer bufDeco = abufDeco[i];
            if (bufDeco == null) continue;
            int cb = bufDeco.length();
            cbTotal += ExternalizableHelper.calculatePackedLength(cb) + cb;
            ++cDecorations;
            nLastId = i;
            nBits |= 1L << i;
        }
        if (cDecorations == 0) {
            return null;
        }
        if (cDecorations == 1 && nLastId == 0 && !ExternalizableHelper.isDecorated(abufDeco[0])) {
            return abufDeco[0];
        }
        if (nLastId > 63) {
            throw new IndexOutOfBoundsException("decoration id out of bounds: " + nLastId);
        }
        boolean fExtended = nLastId >= 8;
        BinaryWriteBuffer bufNew = new BinaryWriteBuffer(cbTotal += fExtended ? ExternalizableHelper.calculatePackedLength(nBits) : 1, cbTotal);
        WriteBuffer.BufferOutput out = bufNew.getBufferOutput();
        try {
            out.writeByte(fExtended ? 19 : 18);
            if (fExtended) {
                out.writePackedLong(nBits);
            } else {
                out.write((byte)nBits);
            }
            for (int i = 0; i <= nLastId; ++i) {
                ReadBuffer bufDeco = abufDeco[i];
                if (bufDeco == null) continue;
                out.writePackedInt(bufDeco.length());
                out.writeBuffer(bufDeco);
            }
            assert (out.getOffset() == cbTotal);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return bufNew.toBinary();
    }

    public static Binary getDecoration(Binary bin, int nId) {
        return ExternalizableHelper.asBinary(ExternalizableHelper.getDecoration((ReadBuffer)bin, nId));
    }

    public static ReadBuffer getDecoration(ReadBuffer buf, int nId) {
        if (!ExternalizableHelper.isDecorated(buf) || nId < 0 || nId > 63) {
            return nId == 0 ? buf : null;
        }
        ReadBuffer.BufferInput in = buf.getBufferInput();
        try {
            int nFmt = in.readUnsignedByte();
            long nBits = nFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
            long nMask = 1L << nId;
            if ((nBits & nMask) == 0L) {
                return null;
            }
            for (int i = 0; i < nId; ++i) {
                if ((nBits & 1L) != 0L) {
                    in.skipBytes(in.readPackedInt());
                }
                nBits >>>= 1;
            }
            int cb = in.readPackedInt();
            int of = in.getOffset();
            return buf.getReadBuffer(of, cb);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static ReadBuffer[] getDecorations(ReadBuffer buf) {
        if (!ExternalizableHelper.isDecorated(buf)) {
            return new ReadBuffer[]{buf};
        }
        ReadBuffer.BufferInput in = buf.getBufferInput();
        try {
            int nFmt = in.readUnsignedByte();
            long nBits = nFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
            int ofMSB = ExternalizableHelper.indexOfMSB(nBits);
            assert (ofMSB >= 0 && ofMSB <= 63);
            int cbufDeco = ofMSB + 1;
            ReadBuffer[] abufDeco = new ReadBuffer[cbufDeco];
            for (int i = 0; i < cbufDeco; ++i) {
                if ((nBits & 1L) != 0L) {
                    int cb = in.readPackedInt();
                    int of = in.getOffset();
                    abufDeco[i] = buf.getReadBuffer(of, cb);
                    in.skipBytes(cb);
                }
                nBits >>>= 1;
            }
            return abufDeco;
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary undecorate(Binary bin, int nId) {
        return ExternalizableHelper.asBinary(ExternalizableHelper.undecorate((ReadBuffer)bin, nId));
    }

    public static ReadBuffer undecorate(ReadBuffer buf, int nId) {
        ReadBuffer bufValue;
        long nBits;
        if (!ExternalizableHelper.isDecorated(buf, nId) || nId < 0 || nId > 63) {
            return nId == 0 && !ExternalizableHelper.isDecorated(buf) ? null : buf;
        }
        try {
            ReadBuffer.BufferInput in = buf.getBufferInput();
            int nFmt = in.readUnsignedByte();
            nBits = nFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        long nMask = 1L << nId;
        if ((nBits & nMask) == 0L) {
            return buf;
        }
        long nRemains = nBits & (nMask ^ 0xFFFFFFFFFFFFFFFFL);
        if (nRemains == 0L) {
            return null;
        }
        if (nRemains == 1L && !ExternalizableHelper.isDecorated(bufValue = ExternalizableHelper.getUndecorated(buf))) {
            return bufValue;
        }
        ReadBuffer[] abufDeco = ExternalizableHelper.getDecorations(buf);
        abufDeco[nId] = null;
        return ExternalizableHelper.decorate(null, abufDeco);
    }

    public static Binary getUndecorated(Binary bin) {
        return ExternalizableHelper.asBinary(ExternalizableHelper.getDecoration((ReadBuffer)bin, 0));
    }

    public static ReadBuffer getUndecorated(ReadBuffer buf) {
        return buf instanceof DecoratedMultiBufferReadBuffer ? ((DecoratedMultiBufferReadBuffer)buf).getUndecorated() : ExternalizableHelper.getDecoration(buf, 0);
    }

    public static Binary asBinary(ReadBuffer buf) {
        return buf == null ? null : buf.toBinary();
    }

    public static Object replace(Object o) throws ObjectStreamException {
        if ((o = Lambdas.ensureSerializable(o)) instanceof SerializationSupport) {
            o = ((SerializationSupport)o).writeReplace();
        }
        return o;
    }

    public static <T> T realize(Object o, Serializer serializer) throws ObjectStreamException {
        if (o instanceof SerializerAware) {
            ((SerializerAware)o).setContextSerializer(serializer);
        }
        if (o instanceof SerializationSupport && (o = ((SerializationSupport)o).readResolve()) instanceof SerializerAware) {
            ((SerializerAware)o).setContextSerializer(serializer);
        }
        return (T)o;
    }

    public static void main(String[] asArgs) {
        if (asArgs.length == 0) {
            ExternalizableHelper.out("Usage:");
            ExternalizableHelper.out("java com.tangosol.util.ExternalizableHelper <hex string>");
        } else {
            Object o = ExternalizableHelper.fromByteArray(ExternalizableHelper.parseHex(asArgs[0]));
            if (o != null) {
                ExternalizableHelper.out("Class: " + o.getClass().getName());
            }
            ExternalizableHelper.out("Value: " + o);
        }
    }

    public static ReadBuffer encodeExpiry(ReadBuffer buf, long ldtExpiry) {
        if (ldtExpiry == 0L) {
            return ExternalizableHelper.undecorate(buf, 1);
        }
        BinaryWriteBuffer bufWrite = new BinaryWriteBuffer(8, 8);
        try {
            WriteBuffer.BufferOutput out = bufWrite.getBufferOutput();
            out.writeLong(ldtExpiry < 0L ? -1L : ldtExpiry);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return ExternalizableHelper.decorate(buf, 1, (ReadBuffer)bufWrite.toBinary());
    }

    public static long decodeExpiry(ReadBuffer buf) {
        long ldtExpiry = 0L;
        if (!ExternalizableHelper.isDecorated(buf, 1)) {
            return ldtExpiry;
        }
        ReadBuffer bufExpiry = ExternalizableHelper.getDecoration(buf, 1);
        if (bufExpiry != null) {
            try {
                ldtExpiry = bufExpiry.getBufferInput().readLong();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ldtExpiry;
    }

    public static IntDecoratedObject decorate(Object oValue, int nDecoration) {
        return new IntDecoratedObject(oValue, nDecoration);
    }

    public static ReadBuffer decorateBinary(ReadBuffer bufValue, int nDecoration) {
        try {
            BinaryWriteBuffer buf = new BinaryWriteBuffer(6 + bufValue.length());
            WriteBuffer.BufferOutput out = buf.getBufferOutput();
            assert (nDecoration != Integer.MIN_VALUE);
            out.writeByte(13);
            out.writePackedInt(nDecoration);
            out.writeBuffer(bufValue);
            return buf.toBinary();
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    @Deprecated
    public static boolean isIntDecorated(ReadBuffer buf) {
        return ExternalizableHelper.isIntDecorated((ByteSequence)buf);
    }

    public static boolean isIntDecorated(ByteSequence buf) {
        try {
            return buf.byteAt(0) == 13;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static int extractIntDecoration(ReadBuffer buf) {
        if (buf instanceof HashEncoded) {
            return ((HashEncoded)((Object)buf)).getEncodedHash();
        }
        try {
            ReadBuffer.BufferInput in = buf.getBufferInput();
            in.readUnsignedByte();
            return ExternalizableHelper.readInt((DataInput)in);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid binary");
        }
    }

    public static Binary removeIntDecoration(Binary bin) {
        return ExternalizableHelper.asBinary(ExternalizableHelper.removeIntDecoration((ReadBuffer)bin));
    }

    public static ReadBuffer removeIntDecoration(ReadBuffer buf) {
        try {
            ReadBuffer.BufferInput in = buf.getBufferInput();
            in.readUnsignedByte();
            ExternalizableHelper.readInt(in);
            int of = in.getOffset();
            return buf.getReadBuffer(of, buf.length() - of);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid binary");
        }
    }

    public static char[] readCharArray(DataInput in) throws IOException {
        int cch = in.readInt();
        ExternalizableHelper.validateLoadArray(char[].class, cch, in);
        Utf8Reader reader = new Utf8Reader((InputStream)((Object)in));
        return cch < 0x3FFFFFF ? ExternalizableHelper.readCharArray(reader, cch) : ExternalizableHelper.readLargeCharArray(reader, cch);
    }

    public static long[] readLongArray(DataInput in) throws IOException {
        int c = in.readInt();
        ExternalizableHelper.validateLoadArray(long[].class, c, in);
        return c <= 0 ? new long[]{} : (c < 0xFFFFFF ? ExternalizableHelper.readLongArray(in, c) : ExternalizableHelper.readLargeLongArray(in, c));
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int c = in.readInt();
        ExternalizableHelper.validateLoadArray(int[].class, c, in);
        return c <= 0 ? new int[]{} : (c < 0x1FFFFFF ? ExternalizableHelper.readIntArray(in, c) : ExternalizableHelper.readLargeIntArray(in, c));
    }

    public static Object[] readObjectArray(DataInput in) throws IOException {
        int c = in.readInt();
        ExternalizableHelper.validateLoadArray(Object[].class, c, in);
        return c <= 0 ? new Object[]{} : (c < 0x7FFFFF ? ExternalizableHelper.readObjectArray(in, c) : ExternalizableHelper.readLargeObjectArray(in, c));
    }

    protected static boolean checkObjectInputFilter(Class<?> clz, ObjectInputStream ois) {
        return ExternalizableHelper.checkObjectInputFilter(clz, -1, ois);
    }

    protected static boolean checkObjectInputFilter(Class<?> clz, DataInput in) {
        return ExternalizableHelper.checkObjectInputFilter(clz, -1, in);
    }

    protected static boolean checkObjectInputFilter(Class<?> clz, int cLength, DataInput in) {
        Object oFilter = ExternalizableHelper.getObjectInputFilter(in);
        try {
            if (oFilter == null) {
                return true;
            }
            DynamicFilterInfo dynamic = s_tloHandler.get();
            dynamic.setClass(clz);
            dynamic.setArrayLength(cLength);
            Object oFilterInfo = dynamic.getFilterInfo();
            Enum status = HANDLE_CHECKINPUT.invoke(oFilter, oFilterInfo);
            dynamic.setClass(null);
            dynamic.setArrayLength(-1);
            if (SERIAL_FILTER_LOGGING) {
                int nLogLevel;
                int n = nLogLevel = status.ordinal() > 0 ? 5 : 6;
                if (CacheFactory.isLogEnabled(nLogLevel)) {
                    CacheFactory.log(String.format("ExternalizableHelper checkInput %-9s %s, array length: %s", status, clz, cLength), nLogLevel);
                }
            }
            return !status.name().equals("REJECTED");
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            ExternalizableHelper.err("Unable to invoke checkInput on " + oFilter.getClass().getName() + " due to exception " + e.getClass().getName() + " : " + e.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static Object getObjectInputFilter(DataInput in) {
        try {
            while (in instanceof WrapperDataInputStream) {
                in = ((WrapperDataInputStream)in).getDataInput();
            }
            return in instanceof ReadBuffer.BufferInput ? ((ReadBuffer.BufferInput)in).getObjectInputFilter() : (HANDLE_GET_FILTER != null && in instanceof ObjectInputStream ? HANDLE_GET_FILTER.invoke((ObjectInputStream)in) : null);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            ExternalizableHelper.err("Unable to invoke method handle " + HANDLE_GET_FILTER + " on " + in.getClass().getName() + " due to exception " + e.getClass().getName() + ": " + e.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getConfigSerialFilter() {
        Object oFilter = m_oFilterSerial;
        if (oFilter != null || HANDLE_CONFIG_GET_FILTER == null) {
            return oFilter;
        }
        try {
            oFilter = HANDLE_CONFIG_GET_FILTER.invoke();
            if (oFilter != null) {
                MethodHandle methodHandle = HANDLE_CONFIG_GET_FILTER;
                synchronized (methodHandle) {
                    if (m_oFilterSerial == null) {
                        m_oFilterSerial = oFilter;
                    }
                }
                if (SERIAL_FILTER_LOGGING) {
                    CacheFactory.log("JVM wide ObjectInputFilter=" + oFilter, 3);
                }
            }
            return oFilter;
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            ExternalizableHelper.err("Unable to invoke getSerialFilter on ObjectInputFilter$Config due to exception " + e.getClass().getName() + ": " + e.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryOperator getConfigSerialFilterFactory() {
        BinaryOperator factory = m_serialFilterFactory;
        if (HANDLE_CONFIG_GET_FILTER_FACTORY == null || factory != null) {
            return factory;
        }
        try {
            factory = HANDLE_CONFIG_GET_FILTER_FACTORY.invoke();
            MethodHandle methodHandle = HANDLE_CONFIG_GET_FILTER_FACTORY;
            synchronized (methodHandle) {
                if (m_serialFilterFactory == null) {
                    m_serialFilterFactory = factory;
                }
            }
            return factory;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalStateException | InvocationTargetException e) {
            ExternalizableHelper.err("Unable to invoke getSerialFilterFactory on ObjectInputFilter$Config due to exception " + e.getClass().getName() + ": " + e.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected static int[] readIntArray(DataInput in, int c) throws IOException {
        int[] ai = new int[c];
        for (int i = 0; i < c; ++i) {
            ai[i] = in.readInt();
        }
        return ai;
    }

    protected static int[] readLargeIntArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0xFFFFFF;
        int cBatch = cLength / cBatchMax + 1;
        int[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            int[] ai = ExternalizableHelper.readIntArray(in, cAllocate);
            aMerged = ExternalizableHelper.mergeIntArray(aMerged, ai);
            cAllocate = Math.min(cLength - (cRead += ai.length), cBatchMax);
        }
        return aMerged;
    }

    protected static Object[] readObjectArray(DataInput in, int cLength) throws IOException {
        Object[] ao = new Object[cLength];
        for (int i = 0; i < cLength; ++i) {
            ao[i] = ExternalizableHelper.readObject(in);
        }
        return ao;
    }

    protected static Object[] readLargeObjectArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0x3FFFFF;
        int cBatch = cLength / cBatchMax + 1;
        Object[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            Object[] ao = ExternalizableHelper.readObjectArray(in, cAllocate);
            aMerged = ExternalizableHelper.mergeArray(aMerged, ao);
            cAllocate = Math.min(cLength - (cRead += ao.length), cBatchMax);
        }
        return aMerged;
    }

    protected static long[] readLongArray(DataInput in, int cLength) throws IOException {
        long[] al = new long[cLength];
        for (int i = 0; i < cLength; ++i) {
            al[i] = in.readLong();
        }
        return al;
    }

    protected static long[] readLargeLongArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0x7FFFFF;
        int cBatch = cLength / cBatchMax + 1;
        long[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            long[] al = ExternalizableHelper.readLongArray(in, cAllocate);
            aMerged = ExternalizableHelper.mergeLongArray(aMerged, al);
            cAllocate = Math.min(cLength - (cRead += al.length), cBatchMax);
        }
        return aMerged;
    }

    protected static char[] readCharArray(Utf8Reader reader, int cLength) throws IOException {
        int cchBlock;
        char[] ach = new char[cLength];
        for (int of = 0; of < cLength; of += cchBlock) {
            cchBlock = reader.read(ach, of, cLength - of);
            if (cchBlock >= 0) continue;
            throw new EOFException();
        }
        return ach;
    }

    protected static char[] readLargeCharArray(Utf8Reader reader, int cLength) throws IOException {
        int cBatchMax = 0x1FFFFFF;
        int cBatch = cLength / cBatchMax + 1;
        char[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            char[] ach = ExternalizableHelper.readCharArray(reader, cAllocate);
            aMerged = ExternalizableHelper.mergeCharArray(aMerged, ach);
            cAllocate = Math.min(cLength - (cRead += ach.length), cBatchMax);
        }
        return aMerged;
    }

    protected static byte[] readLargeByteArray(DataInput in, int cb) throws IOException {
        int cBatchMax = 0x3FFFFFF;
        int cBatch = cb / cBatchMax + 1;
        byte[] ab = new byte[cBatchMax];
        byte[] aMerged = null;
        int cbRead = 0;
        for (int i = 0; i < cBatch && cbRead < cb; ++i) {
            in.readFully(ab);
            aMerged = ExternalizableHelper.mergeByteArray(aMerged, ab);
            ab = new byte[Math.min(cb - (cbRead += ab.length), cBatchMax)];
        }
        return aMerged;
    }

    protected static boolean[] readBooleanArray(DataInput in, int cLength) throws IOException {
        boolean[] af = new boolean[cLength];
        int cb = (cLength + 7) / 8;
        int i = 0;
        for (int of = 0; of < cb; ++of) {
            int nBits = in.readUnsignedByte();
            for (int nMask = 1; i < cLength && nMask <= 255; nMask <<= 1) {
                af[i++] = (nBits & nMask) != 0;
            }
        }
        return af;
    }

    protected static boolean[] readLargeBooleanArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0x3FFFFF8;
        int cBatch = cLength / cBatchMax + 1;
        int cRead = 0;
        int cAllocate = cBatchMax;
        boolean[] aMerged = null;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            boolean[] af = ExternalizableHelper.readBooleanArray(in, cAllocate);
            aMerged = ExternalizableHelper.mergeBooleanArray(aMerged, af);
            cAllocate = Math.min(cLength - (cRead += af.length), cBatchMax);
        }
        return aMerged;
    }

    protected static float[] readFloatArray(DataInput in, int cfl) throws IOException {
        byte[] ab = new byte[cfl << 2];
        in.readFully(ab);
        float[] afl = new float[cfl];
        int of = 0;
        for (int i = 0; i < cfl; ++i) {
            int iValue = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
            afl[i] = Float.intBitsToFloat(iValue);
        }
        return afl;
    }

    protected static float[] readLargeFloatArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0xFFFFFF;
        int cBatch = cLength / cBatchMax + 1;
        float[] aflMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            float[] afl = ExternalizableHelper.readFloatArray(in, cAllocate);
            aflMerged = ExternalizableHelper.mergeFloatArray(aflMerged, afl);
            cAllocate = Math.min(cLength - (cRead += afl.length), cBatchMax);
        }
        return aflMerged;
    }

    protected static double[] readDoubleArray(DataInput in, int cdfl) throws IOException {
        byte[] ab = new byte[cdfl << 3];
        in.readFully(ab);
        double[] adfl = new double[cdfl];
        int of = 0;
        for (int i = 0; i < cdfl; ++i) {
            int iUpper = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
            int iLower = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
            adfl[i] = Double.longBitsToDouble(((long)iUpper << 32) + ((long)iLower & 0xFFFFFFFFL));
        }
        return adfl;
    }

    protected static double[] readLargeDoubleArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0x7FFFFF;
        int cBatch = cLength / cBatchMax + 1;
        int cAllocate = cBatchMax;
        double[] adflMerged = null;
        int cdflRead = 0;
        for (int i = 0; i < cBatch && cdflRead < cLength; ++i) {
            double[] adfl = ExternalizableHelper.readDoubleArray(in, cAllocate);
            adflMerged = ExternalizableHelper.mergeDoubleArray(adflMerged, adfl);
            cAllocate = Math.min(cLength - (cdflRead += adfl.length), cBatchMax);
        }
        return adflMerged;
    }

    protected static String[] readStringArray(DataInput in, int c) throws IOException {
        String[] as = new String[c];
        for (int i = 0; i < c; ++i) {
            as[i] = ExternalizableHelper.readSafeUTF(in);
        }
        return as;
    }

    protected static String[] readLargeStringArray(DataInput in, int c) throws IOException {
        int cBatchMax = 0x7FFFFF;
        int cBatch = c / cBatchMax + 1;
        int cRead = 0;
        int cAllocate = cBatchMax;
        String[] asMerged = null;
        for (int i = 0; i < cBatch && cRead < c; ++i) {
            String[] as = ExternalizableHelper.readStringArray(in, cAllocate);
            asMerged = ExternalizableHelper.mergeArray(asMerged, as);
            cAllocate = Math.min(c - (cRead += as.length), cBatchMax);
        }
        return asMerged;
    }

    public static Class getClass(String sClass) {
        try {
            return Class.forName(sClass);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    static {
        MethodHandle handleConfigGetFilterFactory;
        MethodHandle handleConfigGetSerialFilter;
        MethodHandle handleCheckInput;
        MethodHandle handleGetFilter;
        Class<?> clzFilterInfo;
        block13: {
            EMPTY_BINARY_ARRAY = new Binary[0];
            CONVERTER_TO_BINARY = new Converter(){

                @Override
                public Object convert(Object o) {
                    return ExternalizableHelper.toBinary(o, ExternalizableHelper.ensureSerializer(null));
                }
            };
            CONVERTER_FROM_BINARY = new Converter(){

                @Override
                public Object convert(Object o) {
                    return o == null ? null : ExternalizableHelper.fromBinary((Binary)o, ExternalizableHelper.ensureSerializer(null));
                }
            };
            CONVERTER_STRIP_INTDECO = new Converter(){

                @Override
                public Object convert(Object o) {
                    Binary bin;
                    if (o != null && ExternalizableHelper.isIntDecorated(bin = (Binary)o)) {
                        return ExternalizableHelper.removeIntDecoration(bin);
                    }
                    return o;
                }
            };
            s_clzFilterInfo = null;
            s_tloHandler = ThreadLocal.withInitial(DynamicFilterInfo::new);
            boolean fResolve = true;
            boolean fCache = false;
            XmlBeanClassCache cache = null;
            int cbMax = 0;
            boolean fPof = false;
            ObjectStreamFactory factory = null;
            try {
                XmlElement xmlCfg;
                XmlDocument xml = AccessController.doPrivileged(new PrivilegedAction<XmlDocument>(){

                    @Override
                    public XmlDocument run() {
                        String sConfig = Config.getProperty(ExternalizableHelper.PROPERTY_CONFIG);
                        XmlDocument xml = null;
                        if (sConfig != null && sConfig.length() > 0) {
                            URL url = Resources.findResource(sConfig, null);
                            Throwable e = null;
                            if (url != null) {
                                try {
                                    xml = XmlHelper.loadXml(url.openStream());
                                }
                                catch (Throwable t) {
                                    e = t;
                                }
                            }
                            if (xml == null) {
                                Base.err("Unable to load ExternalizableHelper configuration file \"" + sConfig + "\";");
                                if (e != null) {
                                    Base.err(e);
                                }
                                Base.err("Using default configuration.");
                            }
                        }
                        if (xml == null) {
                            xml = XmlHelper.loadXml(ExternalizableHelper.class, "ISO-8859-1");
                        }
                        XmlHelper.replaceSystemProperties(xml, "system-property");
                        return xml;
                    }
                });
                final XmlElement xmlFactory = xml.getSafeElement("object-stream-factory");
                factory = AccessController.doPrivileged(new PrivilegedAction<ObjectStreamFactory>(){

                    @Override
                    public ObjectStreamFactory run() {
                        try {
                            if (!XmlHelper.isInstanceConfigEmpty(xmlFactory)) {
                                return (ObjectStreamFactory)XmlHelper.createInstance(xmlFactory, ExternalizableHelper.class.getClassLoader(), null);
                            }
                        }
                        catch (Exception e) {
                            Base.err("Unable to instantiate an ObjectStreamFactory \"" + xmlFactory + "\":");
                            Base.err(e);
                        }
                        return new DefaultObjectStreamFactory();
                    }
                });
                fResolve = xml.getSafeElement("force-classloader-resolving").getBoolean(fResolve);
                fCache = xml.getSafeElement("enable-xmlbean-class-cache").getBoolean(fCache);
                if (fCache && (xmlCfg = xml.getElement("xmlbean-class-cache-config")) != null) {
                    String sImpl = xml.getSafeElement("cache-class").getString(null);
                    try {
                        cache = sImpl == null ? new SimpleXmlBeanClassCache() : (XmlBeanClassCache)Class.forName(sImpl).newInstance();
                        cache.init(xmlCfg);
                    }
                    catch (Throwable e) {
                        fCache = false;
                        ExternalizableHelper.err("Unable to instantiate and configure class cache \"" + sImpl + "\":");
                        ExternalizableHelper.err(e);
                    }
                }
                String sMax = xml.getSafeElement("serialization-maxbuffer").getString("0");
                cbMax = (int)ExternalizableHelper.parseMemorySize(sMax, 0);
                fPof = xml.getSafeElement("enable-pof-serialization").getBoolean(fPof);
            }
            catch (Throwable xml) {
                // empty catch block
            }
            FORCE_RESOLVING_STREAMS = fResolve;
            USE_XMLBEAN_CLASS_CACHE = fCache;
            XMLBEAN_CLASS_CACHE = cache;
            MAX_BUFFER = cbMax;
            USE_POF_STREAMS = fPof;
            s_streamfactory = factory;
            clzFilterInfo = null;
            handleGetFilter = null;
            handleCheckInput = null;
            handleConfigGetSerialFilter = null;
            handleConfigGetFilterFactory = null;
            Method methodConfigGetSerialFilter = null;
            Method methodConfigGetFilterFactory = null;
            try {
                Class clzFilter = null;
                Class<?> clzFilterStatus = null;
                Class<?> clzConfig = null;
                String sFilterMethod = null;
                Method methodGet = null;
                clzFilter = ExternalizableHelper.getClass("java.io.ObjectInputFilter");
                if (clzFilter != null) {
                    clzFilterInfo = Class.forName("java.io.ObjectInputFilter$FilterInfo");
                    clzFilterStatus = Class.forName("java.io.ObjectInputFilter$Status");
                    sFilterMethod = "getObjectInputFilter";
                    clzConfig = Class.forName("java.io.ObjectInputFilter$Config");
                } else {
                    clzFilter = ExternalizableHelper.getClass("sun.misc.ObjectInputFilter");
                    if (clzFilter != null) {
                        clzFilterInfo = Class.forName("sun.misc.ObjectInputFilter$FilterInfo");
                        clzFilterStatus = Class.forName("sun.misc.ObjectInputFilter$Status");
                        sFilterMethod = "getInternalObjectInputFilter";
                        clzConfig = Class.forName("sun.misc.ObjectInputFilter$Config");
                    }
                }
                if (sFilterMethod == null) break block13;
                Class<ObjectInputStream> clzObjectInputStream = ObjectInputStream.class;
                methodGet = clzObjectInputStream.getDeclaredMethod(sFilterMethod, new Class[0]);
                methodGet.setAccessible(true);
                methodConfigGetSerialFilter = clzConfig.getDeclaredMethod("getSerialFilter", new Class[0]);
                methodConfigGetSerialFilter.setAccessible(true);
                try {
                    methodConfigGetFilterFactory = clzConfig.getDeclaredMethod("getSerialFilterFactory", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Throwable t) {
                    CacheFactory.log("Failed to find method ObjectInputFilter$Config.getSerialFilterFactory() in java version " + System.getProperty("java.version") + " due to: " + t.getMessage(), 3);
                }
                MethodType mtCheckInput = MethodType.methodType(clzFilterStatus, clzFilterInfo);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                handleGetFilter = lookup.unreflect(methodGet);
                handleCheckInput = lookup.findVirtual(clzFilter, "checkInput", mtCheckInput);
                handleConfigGetSerialFilter = lookup.unreflect(methodConfigGetSerialFilter);
                handleConfigGetFilterFactory = methodConfigGetFilterFactory == null ? null : lookup.unreflect(methodConfigGetFilterFactory);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException e) {
                CacheFactory.log("ObjectInputFilter will not be honored due to: " + e.getMessage() + '\n' + Base.printStackTrace(e), 3);
            }
        }
        s_clzFilterInfo = clzFilterInfo;
        HANDLE_GET_FILTER = handleGetFilter;
        HANDLE_CHECKINPUT = handleCheckInput;
        HANDLE_CONFIG_GET_FILTER = handleConfigGetSerialFilter;
        HANDLE_CONFIG_GET_FILTER_FACTORY = handleConfigGetFilterFactory;
        s_astats = new Stats[6451];
        s_mapSerializerByClassLoader = Collections.synchronizedMap(new WeakHashMap());
        SERIAL_FILTER_LOGGING = Config.getBoolean("coherence.serialfilter.logging", false);
    }

    private static class DynamicFilterInfo
    implements InvocationHandler {
        private Class m_clz;
        private int m_cArrayLength = -1;
        private Object m_oProxy;

        public Object getFilterInfo() {
            Object oProxy = this.m_oProxy;
            if (oProxy == null) {
                oProxy = this.m_oProxy = Proxy.newProxyInstance(Base.getContextClassLoader(), new Class[]{s_clzFilterInfo}, (InvocationHandler)this);
            }
            return oProxy;
        }

        public void setClass(Class clz) {
            this.m_clz = clz;
        }

        public void setArrayLength(int cLength) {
            this.m_cArrayLength = cLength;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("serialClass")) {
                return this.m_clz;
            }
            if (method.getName().equals("arrayLength")) {
                return (long)this.m_cArrayLength;
            }
            if (method.getName().equals("depth")) {
                return 1L;
            }
            if (method.getName().equals("references")) {
                return 0L;
            }
            if (method.getName().equals("streamBytes")) {
                return 0L;
            }
            return null;
        }
    }

    public static class SimpleXmlBeanClassCache
    extends Base
    implements XmlBeanClassCache {
        private boolean m_fAware;
        private String[] m_asBeans;
        private Class[] m_aclzBeans;
        private WeakHashMap m_mapBeanClasses;

        @Override
        public void init(XmlElement xml) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = xml.getSafeElement("xmlbean-list").getElements("xmlbean-class");
            while (iter.hasNext()) {
                XmlElement xmlClassName = (XmlElement)iter.next();
                String sClass = xmlClassName.getString(null);
                list.add(sClass == null ? null : sClass.intern());
            }
            this.m_asBeans = list.toArray(new String[list.size()]);
            if (xml.getSafeElement("classloader-aware").getBoolean()) {
                this.m_fAware = true;
                this.m_mapBeanClasses = new WeakHashMap(101, 1000.0f);
            }
        }

        @Override
        public int getClassId(Class clz) {
            String sName = clz.getName();
            String[] asBeans = this.m_asBeans;
            int c = asBeans.length;
            for (int i = 0; i < c; ++i) {
                if (!SimpleXmlBeanClassCache.equals(asBeans[i], sName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Class getClass(int nId, ClassLoader loader) {
            Class clz = null;
            if (this.m_fAware) {
                WeakReference[] aref = (WeakReference[])this.m_mapBeanClasses.get(loader);
                if (aref == null) {
                    aref = this.initClassLoader(loader);
                }
                try {
                    clz = (Class)aref[nId].get();
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                Class[] aclz = this.m_aclzBeans;
                if (aclz == null) {
                    this.m_aclzBeans = aclz = this.initClasses(loader);
                }
                try {
                    clz = aclz[nId];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (clz == null) {
                if (nId < 0) {
                    throw new IndexOutOfBoundsException("Class ID=" + nId + "; a negative XmlBean ID is used to indicate an \"unknown\" XmlBean class");
                }
                throw new IndexOutOfBoundsException("Class ID=" + nId + ", Max ID=" + (this.m_aclzBeans.length - 1));
            }
            return clz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WeakReference[] initClassLoader(ClassLoader loader) {
            WeakHashMap map;
            SimpleXmlBeanClassCache.azzert(this.m_fAware);
            Class[] aclz = this.initClasses(loader);
            int c = aclz.length;
            WeakReference[] aref = new WeakReference[c];
            for (int i = 0; i < c; ++i) {
                aref[i] = new WeakReference<Class>(aclz[i]);
            }
            WeakHashMap weakHashMap = map = this.m_mapBeanClasses;
            synchronized (weakHashMap) {
                map.put(loader, aref);
            }
            return aref;
        }

        private Class[] initClasses(ClassLoader loader) {
            String[] asBeans = this.m_asBeans;
            int cBeans = asBeans.length;
            Class[] aclz = new Class[cBeans];
            for (int i = 0; i < cBeans; ++i) {
                String sBean = asBeans[i];
                if (sBean == null || sBean.length() <= 0) continue;
                try {
                    aclz[i] = ExternalizableHelper.loadClass(sBean, loader, null);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw SimpleXmlBeanClassCache.ensureRuntimeException(e);
                }
            }
            return aclz;
        }
    }

    public static interface XmlBeanClassCache {
        public void init(XmlElement var1);

        public int getClassId(Class var1);

        public Class getClass(int var1, ClassLoader var2);
    }

    protected static final class IntDecoratedObject
    extends ExternalizableHelper
    implements Serializable {
        private Object m_oValue;
        private int m_nDecoration;

        public IntDecoratedObject(Object oValue, int nDecoration) {
            IntDecoratedObject.azzert(!(oValue instanceof IntDecoratedObject));
            this.m_oValue = oValue;
            this.m_nDecoration = nDecoration;
        }

        public Object getValue() {
            return this.m_oValue;
        }

        public int getDecoration() {
            return this.m_nDecoration;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            throw new IOException("not allowed");
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            throw new IOException("not allowed");
        }
    }

    public static class DefaultObjectStreamFactory
    implements ObjectStreamFactory {
        @Override
        public ObjectInput getObjectInput(DataInput in, ClassLoader loader, boolean fForceNew) throws IOException {
            if (!fForceNew && in instanceof ObjectInput && (!FORCE_RESOLVING_STREAMS || in instanceof Resolving)) {
                return (ObjectInput)in;
            }
            InputStream stream = ExternalizableHelper.getInputStream(in);
            loader = Base.ensureClassLoader(loader == null && in instanceof WrapperDataInputStream ? ((WrapperDataInputStream)in).getClassLoader() : loader);
            return new ResolvingObjectInputStream(stream, loader);
        }

        @Override
        public ObjectOutput getObjectOutput(DataOutput out) throws IOException {
            if (out instanceof ObjectOutput && (!FORCE_RESOLVING_STREAMS || ExternalizableHelper.isResolving(out))) {
                return out instanceof Shielded ? (ObjectOutput)out : new ShieldedObjectOutputStream((ObjectOutput)out);
            }
            OutputStream stream = ExternalizableHelper.getOutputStream(out);
            return new ResolvingObjectOutputStream(stream);
        }
    }

    public static class ShieldedObjectOutputStream
    extends WrapperObjectOutputStream
    implements Shielded {
        public ShieldedObjectOutputStream(ObjectOutput out) {
            super(out);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }

        boolean isResolving() {
            return ExternalizableHelper.isResolving(this.getObjectOutput());
        }
    }

    public static class ShieldedDataOutputStream
    extends WrapperDataOutputStream
    implements Shielded {
        public ShieldedDataOutputStream(DataOutput out) {
            super(out);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    public static class ShieldedOutputStream
    extends WrapperOutputStream
    implements Shielded {
        public ShieldedOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    public static class ShieldedInputStream
    extends FilterInputStream
    implements InputStreaming,
    Shielded {
        public ShieldedInputStream(InputStream in) {
            super(in);
        }

        @Override
        public final void close() {
        }
    }

    public static interface Shielded {
    }

    public static class DecoratedMultiBufferReadBuffer
    extends MultiBufferReadBuffer {
        protected final ReadBuffer m_bufValue;

        public DecoratedMultiBufferReadBuffer(ReadBuffer bufValue, ReadBuffer[] abuf) {
            super(abuf);
            this.m_bufValue = bufValue;
        }

        public ReadBuffer getUndecorated() {
            return this.m_bufValue;
        }
    }

    public static class FormatAwareCompressor
    implements DeltaCompressor {
        protected DeltaCompressor m_compressor;

        public FormatAwareCompressor(DeltaCompressor compressor) {
            this.m_compressor = compressor;
        }

        @Override
        public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
            if (bufOld != null) {
                Base.azzert(bufOld.byteAt(0) == 21);
                bufOld = bufOld.getReadBuffer(1, bufOld.length() - 1);
            }
            Base.azzert(bufNew.byteAt(0) == 21);
            bufNew = bufNew.getReadBuffer(1, bufNew.length() - 1);
            return this.m_compressor.extractDelta(bufOld, bufNew);
        }

        @Override
        public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
            if (bufOld != null && bufOld.length() > 0) {
                Base.azzert(bufOld.byteAt(0) == 21);
                bufOld = bufOld.getReadBuffer(1, bufOld.length() - 1);
            }
            ReadBuffer bufNew = this.m_compressor.applyDelta(bufOld, bufDelta);
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(bufNew.length() + 1);
            try {
                WriteBuffer.BufferOutput out = buffer.getBufferOutput();
                out.writeByte(21);
                out.writeBuffer(bufNew);
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            return buffer.toBinary();
        }

        public String toString() {
            return "FormatAwareCompressor {" + this.m_compressor + "}";
        }
    }

    protected static class Stats
    implements MultiBufferWriteBuffer.WriteBufferPool {
        private static final int MIN_ALLOC = 128;
        private static final int MAX_ALLOC = 0x100000;
        private static final int EXPIRY_MILLIS = 600000;
        private volatile long m_lAccum;
        private volatile long m_lStats;
        private volatile long m_ldtCreated;

        protected Stats() {
        }

        void update(int cb) {
            int cbMax = (int)(this.m_lStats >>> 32);
            long lAccum = this.m_lAccum;
            int cItems = (int)(lAccum >>> 48);
            long cbTotal = lAccum & 0xFFFFFFFFFFFFL;
            if (cItems > 0) {
                boolean fResetStats = false;
                int cbOldAvg = (int)cbTotal / cItems;
                long ldtNow = 0L;
                if (Math.abs(cbOldAvg - cb) > cb / 2) {
                    ldtNow = Base.getSafeTimeMillis();
                    fResetStats = true;
                } else if ((cItems & 0x3FF) == 0 && ((ldtNow = Base.getSafeTimeMillis()) > this.m_ldtCreated + 600000L || (cItems & 0xFFFF) == 0)) {
                    fResetStats = true;
                }
                if (fResetStats) {
                    cbMax = 0;
                    lAccum = 0L;
                    cItems = 0;
                    this.m_ldtCreated = ldtNow;
                }
            }
            cbTotal = lAccum + (long)cb & 0xFFFFFFFFFFFFL;
            int cbAvg = (int)(cbTotal / (long)(++cItems));
            if (cb > cbMax) {
                cbMax = cb;
            }
            this.m_lAccum = (long)cItems << 48 | cbTotal;
            this.m_lStats = (long)cbMax << 32 | (long)cbAvg;
        }

        WriteBuffer instantiateBuffer(boolean fBinary) {
            long lStats = this.m_lStats;
            int cbMax = (int)(lStats >>> 32);
            int cbAvg = (int)(lStats & Integer.MAX_VALUE);
            return cbMax > 0x100000 || cbMax > 1024 && cbMax > cbAvg + (cbAvg >>> 3) ? new MultiBufferWriteBuffer(this) : (fBinary ? new BinaryWriteBuffer(cbMax + 15 & 0xFFFFFFF0) : new ByteArrayWriteBuffer(cbMax + 15 & 0xFFFFFFF0));
        }

        @Override
        public int getMaximumCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public WriteBuffer allocate(int cbPreviousTotal) {
            int cb;
            if (cbPreviousTotal <= 0) {
                long lStats = this.m_lStats;
                int cbMax = (int)(lStats >>> 32);
                int cbAvg = (int)(lStats & Integer.MAX_VALUE);
                int cbNew = cbAvg + (cbAvg >>> 3);
                cb = Math.min(0x100000, Math.min(cbMax, cbNew <= 0 ? Integer.MAX_VALUE : cbNew));
            } else {
                cb = cbPreviousTotal <= 1024 ? Math.max(128, cbPreviousTotal) : (cbPreviousTotal <= 4096 ? cbPreviousTotal >>> 1 : Math.min(0x100000, cbPreviousTotal >>> 2));
            }
            ExternalizableHelper.validateBufferSize(cb + cbPreviousTotal);
            return new BinaryWriteBuffer(cb);
        }

        @Override
        public void release(WriteBuffer buffer) {
        }
    }
}

