/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.internal.util.stream.StreamSupport;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.util.Filter;
import com.tangosol.util.LiteMap;
import com.tangosol.util.QueryMap;
import com.tangosol.util.SimpleStreamer;
import com.tangosol.util.Streamer;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public interface InvocableMap<K, V>
extends Map<K, V> {
    public <R> R invoke(K var1, EntryProcessor<K, V, R> var2);

    default public <R> Map<K, R> invokeAll(EntryProcessor<K, V, R> processor) {
        return this.invokeAll(AlwaysFilter.INSTANCE, processor);
    }

    public <R> Map<K, R> invokeAll(Collection<? extends K> var1, EntryProcessor<K, V, R> var2);

    public <R> Map<K, R> invokeAll(Filter var1, EntryProcessor<K, V, R> var2);

    default public <R> R aggregate(EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.aggregate(AlwaysFilter.INSTANCE, aggregator);
    }

    public <R> R aggregate(Collection<? extends K> var1, EntryAggregator<? super K, ? super V, R> var2);

    public <R> R aggregate(Filter var1, EntryAggregator<? super K, ? super V, R> var2);

    @Override
    default public V getOrDefault(Object key, V defaultValue) {
        Object[] aoResult = this.invoke(key, entry -> {
            if (entry.isPresent()) {
                return new Object[]{true, entry.getValue()};
            }
            return new Object[]{false};
        });
        if (Boolean.TRUE.equals(aoResult[0])) {
            return (V)aoResult[1];
        }
        return defaultValue;
    }

    @Override
    default public V putIfAbsent(K key, V value) {
        return this.invoke(key, CacheProcessors.putIfAbsent(value));
    }

    @Override
    default public boolean remove(Object key, Object value) {
        return this.invoke(key, CacheProcessors.remove(value));
    }

    @Override
    default public boolean replace(K key, V oldValue, V newValue) {
        return this.invoke(key, CacheProcessors.replace(oldValue, newValue));
    }

    @Override
    default public V replace(K key, V value) {
        return this.invoke(key, CacheProcessors.replace(value));
    }

    @Override
    default public V computeIfAbsent(K key, Remote.Function<? super K, ? extends V> mappingFunction) {
        return this.invoke(key, CacheProcessors.computeIfAbsent(mappingFunction));
    }

    @Override
    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.invoke(key, CacheProcessors.computeIfAbsent(mappingFunction));
    }

    @Override
    default public V computeIfPresent(K key, Remote.BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.computeIfPresent(remappingFunction));
    }

    @Override
    default public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.computeIfPresent(remappingFunction));
    }

    @Override
    default public V compute(K key, Remote.BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.compute(remappingFunction));
    }

    @Override
    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.compute(remappingFunction));
    }

    @Override
    default public V merge(K key, V value, Remote.BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.merge(value, remappingFunction));
    }

    @Override
    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.invoke(key, CacheProcessors.merge(value, remappingFunction));
    }

    @Override
    default public void replaceAll(Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        this.invokeAll(AlwaysFilter.INSTANCE, CacheProcessors.replace(function));
    }

    @Override
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.invokeAll(AlwaysFilter.INSTANCE, CacheProcessors.replace(function));
    }

    default public void replaceAll(Collection<? extends K> collKeys, Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        this.invokeAll(collKeys, CacheProcessors.replace(function));
    }

    default public void replaceAll(Filter filter, Remote.BiFunction<? super K, ? super V, ? extends V> function) {
        this.invokeAll(filter, CacheProcessors.replace(function));
    }

    default public RemoteStream<Entry<K, V>> stream() {
        return this.stream(AlwaysFilter.INSTANCE);
    }

    default public RemoteStream<Entry<K, V>> stream(Collection<? extends K> collKeys) {
        return StreamSupport.entryStream(this, true, collKeys, null);
    }

    default public RemoteStream<Entry<K, V>> stream(Filter filter) {
        return StreamSupport.entryStream(this, true, null, filter);
    }

    default public <T, E> RemoteStream<E> stream(ValueExtractor<T, ? extends E> extractor) {
        Objects.requireNonNull(extractor, "The extractor cannot be null");
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        return this.stream().map(entry -> entry.extract(ex));
    }

    default public <T, E> RemoteStream<E> stream(Collection<? extends K> collKeys, ValueExtractor<T, ? extends E> extractor) {
        Objects.requireNonNull(extractor, "The extractor cannot be null");
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        return this.stream(collKeys).map(entry -> entry.extract(ex));
    }

    default public <T, E> RemoteStream<E> stream(Filter filter, ValueExtractor<T, ? extends E> extractor) {
        Objects.requireNonNull(extractor, "The extractor cannot be null");
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        return this.stream(filter).map(entry -> entry.extract(ex));
    }

    @Deprecated
    public static interface ParallelAwareAggregator<K, V, P, R>
    extends EntryAggregator<K, V, R> {
        public EntryAggregator<K, V, P> getParallelAggregator();

        public R aggregateResults(Collection<P> var1);

        @Deprecated
        public static interface PartialResultAggregator<P> {
            public P aggregatePartialResults(Collection<P> var1);
        }
    }

    public static interface StreamingAggregator<K, V, P, R>
    extends EntryAggregator<K, V, R> {
        public static final int PARALLEL = 1;
        public static final int SERIAL = 2;
        public static final int BY_MEMBER = 4;
        public static final int BY_PARTITION = 8;
        public static final int RETAINS_ENTRIES = 16;
        public static final int PRESENT_ONLY = 32;
        public static final int ALLOW_INCONSISTENCIES = 64;

        public StreamingAggregator<K, V, P, R> supply();

        default public boolean accumulate(Streamer<? extends Entry<? extends K, ? extends V>> streamer) {
            while (streamer.hasNext()) {
                if (this.accumulate((Entry)streamer.next())) continue;
                return false;
            }
            return true;
        }

        public boolean accumulate(Entry<? extends K, ? extends V> var1);

        public boolean combine(P var1);

        public P getPartialResult();

        public R finalizeResult();

        default public int characteristics() {
            return 17;
        }

        default public boolean isParallel() {
            return (this.characteristics() & 1) != 0;
        }

        default public boolean isSerial() {
            return (this.characteristics() & 2) != 0;
        }

        default public boolean isByMember() {
            return (this.characteristics() & 4) != 0;
        }

        default public boolean isByPartition() {
            return (this.characteristics() & 8) != 0;
        }

        default public boolean isRetainsEntries() {
            return (this.characteristics() & 0x10) != 0;
        }

        default public boolean isPresentOnly() {
            return (this.characteristics() & 0x20) != 0;
        }

        default public boolean isAllowInconsistencies() {
            return (this.characteristics() & 0x40) != 0;
        }

        @Override
        default public R aggregate(Set<? extends Entry<? extends K, ? extends V>> setEntries) {
            StreamingAggregator<K, V, P, R> aggregator = this.supply();
            if (this.isPresentOnly()) {
                Stream<Entry> stream = setEntries.stream().filter(entry -> entry.isPresent());
                aggregator.accumulate(new SimpleStreamer<Entry>(stream));
            } else {
                aggregator.accumulate(new SimpleStreamer<Entry<? extends K, ? extends V>>(setEntries));
            }
            return aggregator.finalizeResult();
        }
    }

    public static interface EntryAggregator<K, V, R>
    extends Serializable {
        public R aggregate(Set<? extends Entry<? extends K, ? extends V>> var1);
    }

    @FunctionalInterface
    public static interface EntryProcessor<K, V, R>
    extends Serializable {
        public R process(Entry<K, V> var1);

        default public Map<K, R> processAll(Set<? extends Entry<K, V>> setEntries) {
            LiteMap<K, R> mapResults = new LiteMap<K, R>();
            Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
            long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
            Iterator<Entry<K, V>> iter = setEntries.iterator();
            while (iter.hasNext()) {
                Entry<K, V> entry = iter.next();
                mapResults.put(entry.getKey(), this.process(entry));
                iter.remove();
                if (ctxGuard == null) continue;
                ctxGuard.heartbeat(cMillis);
            }
            return mapResults;
        }
    }

    public static interface Entry<K, V>
    extends QueryMap.Entry<K, V> {
        @Override
        public K getKey();

        @Override
        public V getValue();

        @Override
        public V setValue(V var1);

        default public V getValue(V defaultValue) {
            V value = this.getValue();
            return value == null ? defaultValue : value;
        }

        public void setValue(V var1, boolean var2);

        public <T> void update(ValueUpdater<V, T> var1, T var2);

        public boolean isPresent();

        public boolean isSynthetic();

        public void remove(boolean var1);
    }
}

