/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.SynchronousListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashSet;

public class Listeners
extends Base
implements Serializable {
    private static final EventListener[] BLANKLIST = new EventListener[0];
    private EventListener[] m_aAsyncListeners = BLANKLIST;
    private EventListener[] m_aSyncListeners = BLANKLIST;
    private String m_sListenerNames;
    private Filter[] m_aFilters;

    public synchronized void add(EventListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.contains(listener)) {
            EventListener[] aOld = this.getListenerListFor(listener);
            int c = aOld.length;
            EventListener[] aNew = new EventListener[c + 1];
            System.arraycopy(aOld, 0, aNew, 0, c);
            aNew[c] = listener;
            this.setListenerListFor(listener, aNew);
            this.m_sListenerNames = null;
        }
    }

    public synchronized void remove(EventListener listener) {
        int i;
        if (listener == null) {
            return;
        }
        this.m_sListenerNames = null;
        EventListener[] aOld = this.getListenerListFor(listener);
        int c = aOld.length;
        if (c == 1) {
            if (listener.equals(aOld[0])) {
                this.setListenerListFor(listener, BLANKLIST);
            }
            return;
        }
        if (c > 0 && (i = this.indexOf(aOld, listener)) >= 0) {
            EventListener[] aNew = new EventListener[c - 1];
            if (i > 0) {
                System.arraycopy(aOld, 0, aNew, 0, i);
            }
            if (i + 1 < c) {
                System.arraycopy(aOld, i + 1, aNew, i, c - i - 1);
            }
            this.setListenerListFor(listener, aNew);
        }
    }

    public synchronized void addAll(Listeners listeners) {
        if (listeners == null) {
            return;
        }
        this.m_aAsyncListeners = Listeners.union(this.m_aAsyncListeners, listeners.m_aAsyncListeners);
        this.m_aSyncListeners = Listeners.union(this.m_aSyncListeners, listeners.m_aSyncListeners);
        this.m_sListenerNames = null;
    }

    private static EventListener[] union(EventListener[] aListener1, EventListener[] aListener2) {
        int i;
        int cListener1 = aListener1.length;
        int cListener2 = aListener2.length;
        if (cListener1 == 0) {
            return aListener2;
        }
        if (cListener2 == 0) {
            return aListener1;
        }
        HashSet<EventListener> setUnion = new HashSet<EventListener>();
        for (i = 0; i < cListener1; ++i) {
            setUnion.add(aListener1[i]);
        }
        for (i = 0; i < cListener2; ++i) {
            setUnion.add(aListener2[i]);
        }
        int cSize = setUnion.size();
        if (cSize == cListener1) {
            return aListener1;
        }
        if (cSize == cListener2) {
            return aListener2;
        }
        return setUnion.toArray(new EventListener[cSize]);
    }

    public synchronized void removeAll() {
        this.m_aAsyncListeners = BLANKLIST;
        this.m_aSyncListeners = BLANKLIST;
        this.m_sListenerNames = null;
    }

    public boolean isEmpty() {
        return this.m_aAsyncListeners.length == 0 && this.m_aSyncListeners.length == 0;
    }

    public boolean contains(EventListener listener) {
        return this.indexOf(this.getListenerListFor(listener), listener) >= 0;
    }

    private EventListener[] getListenerListFor(EventListener listener) {
        return listener instanceof SynchronousListener ? this.m_aSyncListeners : this.m_aAsyncListeners;
    }

    private void setListenerListFor(EventListener listener, EventListener[] aListener) {
        if (listener instanceof SynchronousListener) {
            this.m_aSyncListeners = aListener;
        } else {
            this.m_aAsyncListeners = aListener;
        }
        this.m_sListenerNames = null;
    }

    private int indexOf(EventListener[] aListener, EventListener listener) {
        int cListener = aListener.length;
        for (int i = 0; i < cListener; ++i) {
            if (!listener.equals(aListener[i])) continue;
            return i;
        }
        return -1;
    }

    public EventListener[] listeners() {
        EventListener[] aSync = this.getSynchronousListeners();
        EventListener[] aAsync = this.getAsynchronousListeners();
        int cSync = aSync.length;
        int cAsync = aAsync.length;
        if (cSync == 0) {
            return aAsync;
        }
        if (cAsync == 0) {
            return aSync;
        }
        EventListener[] aNew = new EventListener[cSync + cAsync];
        System.arraycopy(aSync, 0, aNew, 0, cSync);
        System.arraycopy(aAsync, 0, aNew, cSync, cAsync);
        return aNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getListenerClassNames() {
        String sNames = this.m_sListenerNames;
        if (sNames == null && TracingHelper.isEnabled()) {
            Listeners listeners = this;
            synchronized (listeners) {
                StringBuilder sb = new StringBuilder();
                boolean fFirst = true;
                for (EventListener listener : this.listeners()) {
                    String sName = listener.getClass().getName();
                    if (sName == null) continue;
                    if (fFirst) {
                        sb.append(", ");
                        fFirst = false;
                    }
                    sb.append(sName);
                }
                sNames = this.m_sListenerNames = sb.toString();
            }
        }
        return sNames;
    }

    public EventListener[] getAsynchronousListeners() {
        return this.m_aAsyncListeners;
    }

    public EventListener[] getSynchronousListeners() {
        return this.m_aSyncListeners;
    }

    public void setFilters(Filter[] aFilter) {
        this.m_aFilters = aFilter;
    }

    public Filter[] getFilters() {
        return this.m_aFilters;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Listeners{");
        for (int i = 0; i < 2; ++i) {
            EventListener[] a = i == 0 ? this.m_aAsyncListeners : this.m_aSyncListeners;
            int c = a.length;
            for (int j = 0; j < c; ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(a[j]);
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

