/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.OpenHashMap;
import com.tangosol.util.OpenHashSet;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OpenHashMap<K, V>
extends AbstractKeyBasedMap<K, V> {
    static final Object REMOVED = OpenHashSet.REMOVED;
    private static final Object NULL_SUBSTITUTE = OpenHashSet.NULL_SUBSTITUTE;
    static final Object[] EMPTY = OpenHashSet.EMPTY;
    private static final double LOAD_FACTOR = 0.65;
    private static final double PURGE_FACTOR = 0.75;
    private static final int[] PRIME_MODULO = OpenHashSet.PRIME_MODULO;
    Object[] m_aEntry;
    private int m_cEntries;
    private int m_cRemoved;
    private int m_cMaxDepth;
    private int m_cGrowThreshold;
    private int m_cShrinkThreshold;
    private int m_cPurgeThreshold;
    int m_cLiveIterators;

    public OpenHashMap() {
        this.clear();
    }

    public OpenHashMap(int initialCapacity) {
        this();
        if (initialCapacity > 0) {
            long cElements = (long)((double)initialCapacity * 1.5384615384615383);
            if (cElements >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("initialCapacity too large: " + initialCapacity);
            }
            super.checkCapacity(initialCapacity);
        } else if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative initial capacity: " + initialCapacity);
        }
    }

    public OpenHashMap(Map map) {
        this(map == null ? 0 : map.size());
        if (map != null) {
            Object[] aElement = this.m_aEntry;
            int cElements = 0;
            for (Map.Entry entry : map.entrySet()) {
                Object oKey = super.toInternal(entry.getKey());
                int i = super.find(oKey, true);
                if (i < 0) {
                    i = -1 - i;
                    aElement[i] = oKey;
                    aElement[i + 1] = super.toInternal(entry.getValue());
                    ++cElements;
                    continue;
                }
                throw new IllegalArgumentException("duplicate entry for key: " + entry.getKey());
            }
            this.m_cEntries = cElements;
        }
    }

    @Override
    public int size() {
        return this.m_cEntries;
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.find(this.toInternal(oKey), false) >= 0;
    }

    @Override
    public V get(Object oKey) {
        int i = this.find(this.toInternal(oKey), false);
        return i < 0 ? null : (V)this.toExternal(this.m_aEntry[i + 1]);
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        V oOrig;
        oKey = this.toInternal(oKey);
        int i = this.find(oKey, true);
        Object[] aEntry = this.m_aEntry;
        if (i < 0) {
            int cEntries = this.m_cEntries + 1;
            if (this.checkCapacity(cEntries)) {
                aEntry = this.m_aEntry;
                i = this.find(oKey, true);
                assert (i < 0);
            }
            this.m_cEntries = cEntries;
            oOrig = null;
            if (aEntry[i = -1 - i] == REMOVED) {
                --this.m_cRemoved;
            }
        } else {
            oOrig = this.toExternal(aEntry[i + 1]);
        }
        aEntry[i] = oKey;
        aEntry[i + 1] = this.toInternal(oValue);
        return oOrig;
    }

    @Override
    public V remove(Object oKey) {
        int i = this.find(this.toInternal(oKey), false);
        if (i < 0) {
            return null;
        }
        Object[] aEntry = this.m_aEntry;
        Object oValue = aEntry[i + 1];
        aEntry[i] = REMOVED;
        aEntry[i + 1] = null;
        --this.m_cEntries;
        ++this.m_cRemoved;
        return this.toExternal(oValue);
    }

    @Override
    public void clear() {
        this.m_aEntry = EMPTY;
        this.m_cEntries = 0;
        this.m_cRemoved = 0;
        this.m_cMaxDepth = 0;
        this.m_cGrowThreshold = -1;
        this.m_cShrinkThreshold = -1;
        this.m_cPurgeThreshold = Integer.MAX_VALUE;
    }

    @Override
    protected Set instantiateKeySet() {
        return new KeySet();
    }

    @Override
    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    private Object toInternal(Object oValue) {
        return oValue == null ? NULL_SUBSTITUTE : oValue;
    }

    V toExternal(Object o) {
        return (V)(o == NULL_SUBSTITUTE ? null : o);
    }

    @Override
    protected Iterator iterateKeys() {
        final Object[] aEntry = this.m_aEntry;
        ++this.m_cLiveIterators;
        return new AbstractStableIterator(){
            private int iNext;

            @Override
            protected void advance() {
                int cLimit = aEntry.length;
                while (this.iNext < cLimit) {
                    Object o = aEntry[this.iNext];
                    this.iNext += 2;
                    if (o == null || o == REMOVED) continue;
                    this.setNext(OpenHashMap.this.toExternal(o));
                    return;
                }
                --OpenHashMap.this.m_cLiveIterators;
            }

            protected void remove(Object oPrev) {
                OpenHashMap.this.remove(oPrev);
            }
        };
    }

    private boolean checkCapacity(int c) {
        int BIGGEST_MODULO;
        if (c >= this.m_cShrinkThreshold && c <= this.m_cGrowThreshold) {
            if (c + this.m_cRemoved > this.m_cPurgeThreshold) {
                this.purgeRemoves();
                return true;
            }
            return false;
        }
        boolean fGrowing = c > this.m_cGrowThreshold;
        long cTarget = (long)((double)c * (fGrowing ? 1.5 : 1.25) * 1.5384615384615383);
        if (cTarget > (long)(BIGGEST_MODULO = PRIME_MODULO[PRIME_MODULO.length - 1])) {
            throw new IllegalStateException("maximum size (" + BIGGEST_MODULO + ") exceeded (" + cTarget + ")");
        }
        int iModulo = Arrays.binarySearch(PRIME_MODULO, (int)cTarget);
        if (iModulo < 0) {
            iModulo = -1 - iModulo;
        }
        assert (!fGrowing || this.m_aEntry.length == 0 || Arrays.binarySearch(PRIME_MODULO, this.m_aEntry.length >>> 1) >= 0 && iModulo > Arrays.binarySearch(PRIME_MODULO, this.m_aEntry.length >>> 1));
        assert (fGrowing || Arrays.binarySearch(PRIME_MODULO, this.m_aEntry.length >>> 1) >= 0 && iModulo < Arrays.binarySearch(PRIME_MODULO, this.m_aEntry.length >>> 1));
        Object[] aOld = this.m_aEntry;
        int cNew = PRIME_MODULO[iModulo];
        if (cNew > 0x3FFFFFFF) {
            throw new IllegalStateException("maximum array size exceeded (modulo=" + cNew + ")");
        }
        Object[] aNew = new Object[cNew << 1];
        this.m_cGrowThreshold = (int)((double)cNew * 0.65);
        this.m_cShrinkThreshold = iModulo == 0 ? -1 : (int)((double)PRIME_MODULO[iModulo - 1] * 0.65 * 0.65);
        this.m_cPurgeThreshold = (int)((double)cNew * 0.75);
        assert (this.m_cGrowThreshold > c);
        assert (this.m_cShrinkThreshold < c);
        assert (this.m_cPurgeThreshold > this.m_cGrowThreshold);
        this.m_aEntry = aNew;
        this.m_cMaxDepth = 0;
        this.m_cRemoved = 0;
        int cOld = aOld.length;
        for (int iOld = 0; iOld < cOld; iOld += 2) {
            Object oKey = aOld[iOld];
            if (oKey == null || oKey == REMOVED) continue;
            int iNew = this.find(oKey, true);
            if (iNew < 0) {
                iNew = -1 - iNew;
                aNew[iNew] = oKey;
                aNew[iNew + 1] = aOld[iOld + 1];
                continue;
            }
            throw new IllegalStateException("duplicate found during rehash: " + oKey + " and " + aNew[iNew]);
        }
        return true;
    }

    private int find(Object o, boolean fAdd) {
        Object[] aEntry = this.m_aEntry;
        int cElements = aEntry.length;
        if (cElements == 0) {
            return -1;
        }
        int nHash = o.hashCode();
        long nNextHash = (long)nHash & 0xFFFFFFFFL;
        int cModulo = cElements >>> 1;
        long nHashInc = 0L;
        int iInsert = -1;
        int cDepth = 0;
        int MAX_DEPTH = this.m_cMaxDepth;
        while (true) {
            int iTest;
            Object oTest;
            if (fAdd) {
                if (iInsert < 0) {
                    ++cDepth;
                }
            } else if (++cDepth > MAX_DEPTH) {
                return -1;
            }
            if ((oTest = aEntry[iTest = (int)(nNextHash % (long)cModulo) << 1]) == null) {
                if (iInsert < 0) {
                    iInsert = iTest;
                }
                if (fAdd && cDepth > MAX_DEPTH) {
                    this.m_cMaxDepth = cDepth;
                }
                return -1 - iInsert;
            }
            if (oTest == REMOVED) {
                if (iInsert < 0) {
                    iInsert = iTest;
                }
            } else {
                try {
                    if (o == oTest || nHash == oTest.hashCode() && o.equals(oTest)) {
                        if (iInsert >= 0 && this.m_cLiveIterators == 0) {
                            aEntry[iInsert] = oTest;
                            aEntry[iInsert + 1] = aEntry[iTest + 1];
                            aEntry[iTest] = REMOVED;
                            aEntry[iTest + 1] = null;
                            return iInsert;
                        }
                        return iTest;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            nNextHash += nHashInc == 0L ? (long)OpenHashMap.calculateHashIncrement(nHash) : nHashInc;
        }
    }

    private void purgeRemoves() {
        Object[] aEntry = this.m_aEntry;
        int cElements = aEntry.length;
        for (int i = 0; i < cElements; i += 2) {
            if (aEntry[i] != REMOVED) continue;
            aEntry[i] = null;
        }
        int cRemoved = 0;
        int cMaxDepth = this.m_cEntries == 0 ? 0 : 1;
        int cModulo = cElements >>> 1;
        Object oRemoved = null;
        for (int i = 0; i < cElements; i += 2) {
            int nHash;
            long nNextHash;
            int iTarget;
            Object oKey = aEntry[i];
            if (oKey == null || oKey == REMOVED || i == (iTarget = (int)((nNextHash = (long)(nHash = oKey.hashCode()) & 0xFFFFFFFFL) % (long)cModulo) << 1)) continue;
            int cDepth = 1;
            int nHashInc = 0;
            do {
                long l;
                Object oTarget;
                if ((oTarget = aEntry[iTarget]) == null || oTarget == REMOVED) {
                    aEntry[iTarget] = oKey;
                    aEntry[iTarget + 1] = aEntry[i + 1];
                    aEntry[i] = oRemoved;
                    aEntry[i + 1] = null;
                    if (oRemoved != REMOVED || oTarget == REMOVED) break;
                    ++cRemoved;
                    break;
                }
                if (nHashInc == 0) {
                    nHashInc = OpenHashMap.calculateHashIncrement(nHash);
                    l = nHashInc;
                } else {
                    l = nHashInc;
                }
                iTarget = (int)((nNextHash += l) % (long)cModulo) << 1;
                ++cDepth;
            } while (i != iTarget);
            if (cDepth <= cMaxDepth) continue;
            cMaxDepth = cDepth;
            oRemoved = REMOVED;
        }
        this.m_cMaxDepth = cMaxDepth;
        this.m_cRemoved = cRemoved;
    }

    private static int calculateHashIncrement(int nHash) {
        return OpenHashSet.calculateHashIncrement(nHash);
    }

    public class EntrySet
    extends AbstractKeyBasedMap.EntrySet {
        public EntrySet() {
            super(OpenHashMap.this);
        }

        @Override
        public Object[] toArray() {
            int c = this.size();
            if (c == 0) {
                return EMPTY;
            }
            Object[] aSrc = OpenHashMap.this.m_aEntry;
            Object[] aDest = new Object[c];
            int iDest = 0;
            int cSrc = aSrc.length;
            for (int iSrc = 0; iSrc < cSrc; iSrc += 2) {
                Object o = aSrc[iSrc];
                if (o == null || o == REMOVED) continue;
                aDest[iDest++] = this.instantiateEntry(OpenHashMap.this.toExternal(o), OpenHashMap.this.toExternal(aSrc[iSrc + 1]));
            }
            assert (iDest == c);
            return aDest;
        }

        @Override
        public Object[] toArray(Object[] a) {
            int c = this.size();
            if (a == null) {
                a = c == 0 ? EMPTY : new Object[c];
            } else if (a.length < c) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
            } else if (a.length > c) {
                a[c] = null;
            }
            if (c == 0) {
                return a;
            }
            Object[] aSrc = OpenHashMap.this.m_aEntry;
            int iDest = 0;
            int cSrc = aSrc.length;
            for (int iSrc = 0; iSrc < cSrc; iSrc += 2) {
                Object o = aSrc[iSrc];
                if (o == null || o == REMOVED) continue;
                a[iDest++] = this.instantiateEntry(OpenHashMap.this.toExternal(o), OpenHashMap.this.toExternal(aSrc[iSrc + 1]));
            }
            assert (iDest == c);
            return a;
        }

        protected Map.Entry instantiateEntry(Object oKey, Object oValue) {
            return new Entry(oKey, oValue);
        }

        protected Iterator instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        extends AbstractKeyBasedMap.EntrySet.EntrySetIterator {
            com.tangosol.util.OpenHashMap$EntrySet.Entry m_entry;

            protected EntrySetIterator() {
                super(EntrySet.this);
            }

            @Override
            public Map.Entry<K, V> next() {
                Object oKey = this.m_iterKeys.next();
                Object entry = this.m_entry;
                if (entry == null) {
                    this.m_entry = entry = (Entry)EntrySet.this.instantiateEntry(oKey, (Object)null);
                } else {
                    entry.reuse(oKey, null);
                }
                return entry;
            }
        }

        protected class Entry
        extends AbstractKeyBasedMap.EntrySet.Entry {
            protected Entry(Object oKey, Object oValue) {
                super(EntrySet.this, oKey, oValue);
            }

            protected void reuse(Object oKey, Object oValue) {
                this.m_oKey = oKey;
                this.m_oValue = oValue;
            }
        }
    }

    protected class KeySet
    extends AbstractKeyBasedMap.KeySet {
        protected KeySet() {
            super(OpenHashMap.this);
        }

        @Override
        public Object[] toArray() {
            int c = this.size();
            if (c == 0) {
                return EMPTY;
            }
            Object[] aSrc = OpenHashMap.this.m_aEntry;
            Object[] aDest = new Object[c];
            int iDest = 0;
            int cSrc = aSrc.length;
            for (int iSrc = 0; iSrc < cSrc; iSrc += 2) {
                Object o = aSrc[iSrc];
                if (o == null || o == REMOVED) continue;
                aDest[iDest++] = OpenHashMap.this.toExternal(o);
            }
            assert (iDest == c);
            return aDest;
        }

        @Override
        public Object[] toArray(Object[] a) {
            int c = this.size();
            if (a == null) {
                a = c == 0 ? EMPTY : new Object[c];
            } else if (a.length < c) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
            } else if (a.length > c) {
                a[c] = null;
            }
            if (c == 0) {
                return a;
            }
            Object[] aSrc = OpenHashMap.this.m_aEntry;
            int iDest = 0;
            int cSrc = aSrc.length;
            for (int iSrc = 0; iSrc < cSrc; iSrc += 2) {
                Object o = aSrc[iSrc];
                if (o == null || o == REMOVED) continue;
                a[iDest++] = OpenHashMap.this.toExternal(o);
            }
            assert (iDest == c);
            return a;
        }
    }
}

