/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.FilterBuilder;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterBuildingException;
import com.tangosol.util.ValueExtractor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class QueryHelper {
    protected static final CoherenceQueryLanguage f_language = new CoherenceQueryLanguage();

    public static Filter createFilter(String sWhereClause) {
        return QueryHelper.createFilter(sWhereClause, new Object[0], new HashMap(), f_language);
    }

    public static Filter createFilter(String sWhereClause, Object[] aBindings) {
        return QueryHelper.createFilter(sWhereClause, aBindings, new HashMap(), f_language);
    }

    public static Filter createFilter(String sWhereClause, Map mapBindings) {
        return QueryHelper.createFilter(sWhereClause, new Object[0], mapBindings, f_language);
    }

    public static Filter createFilter(String sWhereClause, Object[] aBindings, Map mapBindings) {
        return QueryHelper.createFilter(sWhereClause, aBindings, mapBindings, f_language);
    }

    public static Filter createFilter(String sWhereClause, Object[] aBindings, Map mapBindings, CoherenceQueryLanguage language) {
        try {
            FilterBuilder filterBuilder = new FilterBuilder(aBindings == null ? Collections.emptyList() : Arrays.asList(aBindings), new ResolvableParameterList(mapBindings), language);
            return filterBuilder.makeFilter(QueryHelper.parse(sWhereClause));
        }
        catch (RuntimeException e) {
            throw new FilterBuildingException(e.getMessage(), sWhereClause, e);
        }
    }

    public static ValueExtractor createExtractor(String s) {
        return QueryHelper.createExtractor(s, f_language);
    }

    public static ValueExtractor createExtractor(String sQuery, CoherenceQueryLanguage language) {
        try {
            return new FilterBuilder(language).makeExtractor((NodeTerm)QueryHelper.parse(sQuery));
        }
        catch (RuntimeException e) {
            throw new FilterBuildingException(e.getMessage(), sQuery, e);
        }
    }

    protected static Term parse(String sQuery) {
        return QueryHelper.parse(sQuery, f_language);
    }

    protected static Term parse(String sQuery, CoherenceQueryLanguage language) {
        OPParser parser = new OPParser(sQuery, language.filtersTokenTable(), language.getOperators());
        return parser.parse();
    }

    public static Object executeStatement(String sStatement) {
        PrintWriter out = new PrintWriter(System.out);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        ExecutionContext ctx = new ExecutionContext();
        ctx.setWriter(out);
        ctx.setReader(in);
        ctx.setSilentMode(true);
        ctx.setSanityCheckingEnabled(true);
        ctx.setCoherenceQueryLanguage(f_language);
        ctx.setCacheFactory(CacheFactory.getConfigurableCacheFactory());
        ctx.setCluster(CacheFactory.ensureCluster());
        return QueryHelper.executeStatement(sStatement, ctx);
    }

    public static Object executeStatement(String sStatement, ExecutionContext context) {
        if (sStatement == null || sStatement.length() == 0) {
            return null;
        }
        CoherenceQueryLanguage language = context.getCoherenceQueryLanguage();
        TokenTable toks = language.extendedSqlTokenTable();
        OPParser parser = new OPParser(sStatement, toks, language.getOperators());
        Object term = parser.parse();
        Statement statement = language.prepareStatement((NodeTerm)term, context, null, null);
        if (context.isSanityChecking()) {
            statement.sanityCheck(context);
        }
        StatementResult result = statement.execute(context);
        return result.getResult();
    }
}

