/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.SafeLinkedList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;

public class RecyclingLinkedList
extends SafeLinkedList
implements Cloneable,
Serializable {
    protected transient Node[] m_anodeRecycled;
    protected transient int m_cRecycleNodes;
    protected int m_cRecycleMax;
    protected static final int DEFAULT_RECYCLE_MAX = 256;

    public RecyclingLinkedList() {
        this.initRecycling(256);
    }

    public RecyclingLinkedList(int cMaxRecycle) {
        this.initRecycling(cMaxRecycle);
    }

    public RecyclingLinkedList(Collection collection) {
        super(collection);
        this.initRecycling(256);
    }

    public RecyclingLinkedList(Collection collection, int cMaxRecycle) {
        super(collection);
        this.initRecycling(cMaxRecycle);
    }

    protected void initRecycling(int cMaxRecycle) {
        this.m_anodeRecycled = new Node[cMaxRecycle];
        this.m_cRecycleMax = cMaxRecycle;
        this.m_cRecycleNodes = 0;
    }

    @Override
    protected SafeLinkedList.Node instantiateNode(Object o) {
        Node node;
        int cRecycleNodes = this.m_cRecycleNodes;
        if (cRecycleNodes > 0) {
            this.m_cRecycleNodes = --cRecycleNodes;
            Node[] anodeRecycled = this.m_anodeRecycled;
            node = anodeRecycled[cRecycleNodes];
            anodeRecycled[cRecycleNodes] = null;
            node.setObject(o);
        } else {
            node = new Node(o);
        }
        return node;
    }

    protected void recycleNode(Node node) {
        int cRecycleNodes = this.m_cRecycleNodes;
        if (cRecycleNodes < this.m_cRecycleMax) {
            this.m_anodeRecycled[cRecycleNodes] = node;
            this.m_cRecycleNodes = cRecycleNodes + 1;
        }
    }

    @Override
    public Object clone() {
        RecyclingLinkedList that = (RecyclingLinkedList)super.clone();
        that.initRecycling(this.m_cRecycleMax);
        return that;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.m_cRecycleMax);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_cRecycleMax = in.readInt();
        this.initRecycling(this.m_cRecycleMax);
    }

    protected class Node
    extends SafeLinkedList.Node {
        public Node() {
        }

        public Node(Object o) {
            super(o);
        }

        @Override
        protected Object discard() {
            Object o = super.discard();
            RecyclingLinkedList.this.recycleNode(this);
            return o;
        }
    }
}

