/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.IllegalStringException;
import com.tangosol.util.StringTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class StringMap
extends Base
implements Cloneable,
Serializable {
    private static final String CLASS = "StringMap";
    private StringTable m_tblPrimary = new StringTable();
    private Hashtable m_tblCache = new Hashtable();

    public StringMap() {
    }

    public StringMap(Enumeration enmrStrings) {
        while (enmrStrings.hasMoreElements()) {
            String sPrimary = (String)enmrStrings.nextElement();
            this.m_tblPrimary.put(sPrimary, sPrimary);
        }
    }

    public StringMap(DataInput stream) throws IOException {
        int cStrings = stream.readInt();
        for (int i = 0; i < cStrings; ++i) {
            String sPrimary = stream.readUTF();
            String sSecondary = null;
            if (stream.readBoolean()) {
                if (stream.readBoolean()) {
                    sSecondary = stream.readUTF();
                    this.m_tblCache.put(sSecondary, sPrimary);
                } else {
                    sSecondary = sPrimary;
                }
            }
            this.m_tblPrimary.put(sPrimary, sSecondary);
        }
    }

    public synchronized void save(DataOutput stream) throws IOException {
        stream.writeInt(this.m_tblPrimary.getSize());
        Enumeration enmrPrimary = this.primaryStrings();
        Enumeration enmrSecondary = this.secondaryStrings();
        while (enmrPrimary.hasMoreElements()) {
            String sPrimary = (String)enmrPrimary.nextElement();
            String sSecondary = (String)enmrSecondary.nextElement();
            stream.writeUTF(sPrimary);
            boolean fExists = sSecondary != null;
            stream.writeBoolean(fExists);
            if (!fExists) continue;
            boolean fDifferent = !sPrimary.equals(sSecondary);
            stream.writeBoolean(fDifferent);
            if (!fDifferent) continue;
            stream.writeUTF(sSecondary);
        }
    }

    public synchronized Enumeration primaryStrings() {
        return this.m_tblPrimary.keys();
    }

    public synchronized Enumeration secondaryStrings() {
        return this.m_tblPrimary.elements();
    }

    public int getSize() {
        return this.m_tblPrimary.getSize();
    }

    public boolean isEmpty() {
        return this.m_tblPrimary.isEmpty();
    }

    public boolean contains(String string) {
        return this.m_tblPrimary.contains(string);
    }

    public String get(String sPrimary) {
        return (String)this.m_tblPrimary.get(sPrimary);
    }

    public synchronized void add(String sPrimary) throws IllegalStringException {
        if (sPrimary == null) {
            throw new IllegalArgumentException("StringMap.add:  Primary string is required.");
        }
        if (this.m_tblPrimary.contains(sPrimary)) {
            throw new IllegalStringException(sPrimary);
        }
        this.put(sPrimary, sPrimary);
    }

    public void put(String sPrimary, String sSecondary) throws IllegalStringException {
        String sCurPrimary;
        if (sPrimary == null) {
            throw new IllegalArgumentException("StringMap.put:  Primary strings is required.");
        }
        if (sSecondary != null && (sCurPrimary = this.getPrimary(sSecondary)) != null && !sPrimary.equals(sCurPrimary)) {
            throw new IllegalStringException(sSecondary);
        }
        String sCurSecondary = this.get(sPrimary);
        if (sCurSecondary != null) {
            this.m_tblCache.remove(sCurSecondary);
        }
        if (sSecondary != null && !sPrimary.equals(sSecondary)) {
            this.m_tblCache.put(sSecondary, sPrimary);
        }
        this.m_tblPrimary.put(sPrimary, sSecondary);
    }

    public synchronized void remove(String sPrimary) throws IllegalStringException {
        if (sPrimary == null) {
            throw new IllegalArgumentException("StringMap.remove:  Primary string is required.");
        }
        if (!this.m_tblPrimary.contains(sPrimary)) {
            throw new IllegalStringException(sPrimary);
        }
        String sSecondary = (String)this.m_tblPrimary.get(sPrimary);
        if (sSecondary != null && !sPrimary.equals(sSecondary)) {
            this.m_tblCache.remove(sSecondary);
        }
        this.m_tblPrimary.remove(sPrimary);
    }

    public synchronized String getPrimary(String sSecondary) {
        String sPrimary = (String)this.m_tblCache.get(sSecondary);
        if (sPrimary == null && sSecondary.equals(this.m_tblPrimary.get(sSecondary))) {
            sPrimary = sSecondary;
        }
        return sPrimary;
    }

    public boolean addAll(StringMap that) throws IllegalStringException {
        block6: {
            if (!that.m_tblCache.isEmpty()) {
                throw new IllegalArgumentException("StringMap.addAll:  Specified map must be trivial.");
            }
            if (this.m_tblCache.isEmpty()) break block6;
            StringMap mapTest = (StringMap)that.clone();
            mapTest.removeAll(this);
            StringTable tblTest = mapTest.m_tblPrimary;
            if (!tblTest.isEmpty()) {
                if (tblTest.getSize() < this.m_tblCache.size()) {
                    Enumeration e = tblTest.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        if (!this.m_tblCache.containsKey(key)) continue;
                        throw new IllegalStringException(key);
                    }
                } else {
                    Enumeration e = this.m_tblCache.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        if (!tblTest.contains(key)) continue;
                        throw new IllegalStringException(key);
                    }
                }
            }
        }
        return this.m_tblPrimary.addAll(that.m_tblPrimary);
    }

    public boolean retainAll(StringMap that) {
        if (!this.m_tblCache.isEmpty()) {
            throw new IllegalArgumentException("StringMap.retainAll:  This map must be trivial.");
        }
        return this.m_tblPrimary.retainAll(that.m_tblPrimary);
    }

    public boolean removeAll(StringMap that) {
        if (!this.m_tblCache.isEmpty()) {
            throw new IllegalArgumentException("StringMap.removeAll:  This map must be trivial.");
        }
        return this.m_tblPrimary.removeAll(that.m_tblPrimary);
    }

    public synchronized StringMap cloneTrivial(boolean fInit) {
        StringMap that = new StringMap();
        String[] keys = this.m_tblPrimary.strings();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            that.m_tblPrimary.put(key, fInit ? key : null);
        }
        return that;
    }

    public synchronized Object clone() {
        StringMap that = new StringMap();
        that.m_tblPrimary = (StringTable)this.m_tblPrimary.clone();
        that.m_tblCache = (Hashtable)this.m_tblCache.clone();
        return that;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringMap)) {
            return false;
        }
        StringMap that = (StringMap)obj;
        return this.m_tblPrimary.equals(that.m_tblPrimary);
    }
}

