/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;

public class Tree
extends Base
implements Cloneable,
Serializable {
    protected TreeMap m_tree = new TreeMap();

    public void add(Comparable key) {
        this.put(key, null);
    }

    public synchronized void put(Comparable key, Object value) {
        this.m_tree.put(key, value);
    }

    public synchronized Object get(Comparable key) {
        return this.m_tree.get(key);
    }

    public synchronized boolean contains(Comparable key) {
        return this.m_tree.containsKey(key);
    }

    public synchronized Object remove(Comparable key) {
        return this.m_tree.remove(key);
    }

    public synchronized void clear() {
        this.m_tree.clear();
    }

    public int getSize() {
        return this.m_tree.size();
    }

    public boolean isEmpty() {
        return this.m_tree.isEmpty();
    }

    public synchronized Enumeration keys() {
        if (this.m_tree.isEmpty()) {
            return NullImplementation.getEnumeration();
        }
        Comparable[] aoKey = new Comparable[this.m_tree.size()];
        int cElements = 0;
        Iterator iter = this.m_tree.keySet().iterator();
        while (iter.hasNext()) {
            aoKey[cElements++] = iter.next();
        }
        return new SimpleEnumerator<Comparable>(aoKey);
    }

    public synchronized Enumeration elements() {
        if (this.m_tree.isEmpty()) {
            return NullImplementation.getEnumeration();
        }
        Object[] aoValue = new Object[this.m_tree.size()];
        int cElements = 0;
        Iterator iter = this.m_tree.values().iterator();
        while (iter.hasNext()) {
            aoValue[cElements++] = iter.next();
        }
        return new SimpleEnumerator<Object>(aoValue);
    }

    public boolean addAll(Tree that) {
        TreeMap mapDelta = (TreeMap)that.m_tree.clone();
        TreeMap mapThis = this.m_tree;
        mapDelta.keySet().removeAll(mapThis.keySet());
        if (mapDelta.isEmpty()) {
            return false;
        }
        mapThis.putAll(mapDelta);
        return true;
    }

    public void putAll(Tree that) {
        this.m_tree.putAll(that.m_tree);
    }

    public boolean retainAll(Tree that) {
        return this.m_tree.keySet().retainAll(that.m_tree.keySet());
    }

    public boolean removeAll(Tree that) {
        return this.m_tree.keySet().removeAll(that.m_tree.keySet());
    }

    public synchronized String toString() {
        return "Tree" + this.m_tree.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        if (obj instanceof Tree) {
            Tree that;
            Tree tree = that = (Tree)obj;
            synchronized (tree) {
                return this.m_tree.equals(that.m_tree);
            }
        }
        return false;
    }

    public synchronized Object clone() {
        Tree that = new Tree();
        that.m_tree = (TreeMap)this.m_tree.clone();
        return that;
    }

    public synchronized void print() {
        System.out.println(this.toString());
    }

    protected Enumeration getUnsynchronizedKeyEnumerator() {
        return new IteratorEnumerator(this.m_tree.keySet().iterator());
    }

    protected Enumeration getUnsynchronizedKeyEnumerator(Comparable key) {
        return new IteratorEnumerator(this.m_tree.tailMap(key).keySet().iterator());
    }
}

