/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.coherence.config.Config;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;

public class Unsafe {
    private static final Unsafe INSTANCE = new Unsafe();
    private Binary.Unsafe m_unsafeBinary;

    private Unsafe() {
    }

    public static Unsafe getUnsafe() {
        Class<?> clzCaller;
        SecurityException eUnsafe = new SecurityException("Unsafe");
        StackTraceElement[] aStack = eUnsafe.getStackTrace();
        String sCallingClass = null;
        int c = aStack.length;
        for (int i = 1; i < c; ++i) {
            String sClassName = aStack[i].getClassName();
            if (sClassName.startsWith("java.security")) continue;
            sCallingClass = sClassName;
            break;
        }
        if (sCallingClass == null) {
            return INSTANCE;
        }
        try {
            clzCaller = Thread.currentThread().getContextClassLoader().loadClass(sCallingClass);
        }
        catch (ClassNotFoundException e) {
            try {
                clzCaller = Class.forName(sCallingClass);
            }
            catch (ClassNotFoundException e2) {
                return INSTANCE;
            }
        }
        if (Base.equals(clzCaller.getProtectionDomain().getCodeSource(), Unsafe.class.getProtectionDomain().getCodeSource())) {
            return INSTANCE;
        }
        if (Config.getBoolean("coherence.unsafe")) {
            CacheFactory.log("Usage of the Unsafe class is not supported  and may result in corrupted or lost data,  and other non-deterministic behavior. \n" + Base.getStackTrace(), 2);
            return INSTANCE;
        }
        throw eUnsafe;
    }

    void register(Binary.Unsafe unsafe) {
        this.m_unsafeBinary = unsafe;
    }

    public byte[] getByteArray(Binary bin) {
        return this.m_unsafeBinary.getByteArray(bin);
    }

    public int getArrayOffset(Binary bin) {
        return this.m_unsafeBinary.getArrayOffset(bin);
    }

    public Binary newBinary(byte[] ab, int of, int cb) {
        return this.m_unsafeBinary.newBinary(ab, of, cb);
    }

    static {
        Binary.registerUnsafe(INSTANCE);
    }
}

