/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.util.Arrays;

public class VersionHelper {
    public static final int VERSION_23_09 = VersionHelper.encodeVersion(23, 9, 0);
    public static final int VERSION_14_1_1_2206 = VersionHelper.encodeVersion(14, 1, 1, 2206, 0);
    public static final int VERSION_14_1_1_2206_6 = VersionHelper.encodeVersion(14, 1, 1, 2206, 6);
    public static final int VERSION_14_1_2_0 = VersionHelper.encodeVersion(14, 1, 2, 0, 0);
    public static final int VERSION_14_1_1_0 = VersionHelper.encodeVersion(14, 1, 1, 0, 0);
    public static final int VERSION_14_1_1_0_15 = VersionHelper.encodeVersion(14, 1, 1, 0, 15);
    public static final int VERSION_12_2_1_4 = VersionHelper.encodeVersion(12, 2, 1, 4, 0);
    public static final int VERSION_12_2_1_4_19 = VersionHelper.encodeVersion(12, 2, 1, 4, 19);
    public static final int VERSION_12_2_1_6 = VersionHelper.encodeVersion(12, 2, 1, 6, 0);
    public static final int VERSION_12_2_1_6_5 = VersionHelper.encodeVersion(12, 2, 1, 6, 5);

    public static int encodeVersion(int nYear, int nMonth, int nPatch) {
        nPatch = (nMonth > 6 ? 32 : 0) | nPatch & 0x1F;
        return VersionHelper.getVersionPrefix(nYear, nMonth) | (nYear & 0x3F) << 6 | nPatch & 0x3F;
    }

    public static int encodeVersion(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        if (nPatchSet > 2000) {
            int nPrefix = VersionHelper.encodeVersion(nMajor, nMinor, nMicro, 0, 0);
            int nYear = nPatchSet / 100;
            return nPrefix | (nYear & 0x3F) << 6 | nPatch & 0x3F;
        }
        return (nMajor & 0x3F) << 24 | (nMinor & 0x3F) << 18 | (nMicro & 0x3F) << 12 | (nPatchSet & 0x3F) << 6 | nPatch & 0x3F;
    }

    public static int getVersionPrefix(int nYear, int nMonth) {
        if (nYear > 23) {
            return VersionHelper.encodeVersion(14, 1, 2, 0, 0);
        }
        return VersionHelper.encodeVersion(14, 1, 1, 0, 0);
    }

    public static boolean isCalendarVersion(int nVersion) {
        return nVersion >= 20;
    }

    public static int parseVersion(String sVersion) {
        String sYear;
        if (sVersion == null || sVersion.isEmpty()) {
            return 0;
        }
        int ofSuffix = sVersion.indexOf(" ");
        if (ofSuffix > 0) {
            sVersion = sVersion.substring(0, ofSuffix);
        }
        int INDEX_YEAR = 3;
        int INDEX_MONTH = 4;
        String[] asVersions = sVersion.split("\\.");
        int[] an = new int[5];
        String string = sYear = asVersions.length > 3 ? asVersions[3] : "";
        if (sYear.length() >= 4) {
            asVersions = Arrays.copyOf(asVersions, asVersions.length + 1);
            for (int i = asVersions.length - 2; i > 3; --i) {
                asVersions[i + 1] = asVersions[i];
                asVersions[i] = null;
            }
            asVersions[3] = sYear.substring(0, 2);
            asVersions[4] = sYear.substring(2);
        }
        int c = Math.min(an.length, asVersions.length);
        for (int i = 0; i < c; ++i) {
            try {
                int nVersion = Integer.parseInt(asVersions[i]);
                if (i == 4 && VersionHelper.isCalendarVersion(an[i - 1])) {
                    nVersion = nVersion > 6 ? 32 : 0;
                    nVersion |= i + 1 < asVersions.length ? Integer.parseInt(asVersions[i + 1]) : 0;
                }
                an[i] = Math.min(63, nVersion);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return VersionHelper.encodeVersion(an[0], an[1], an[2], an[3], an[4]);
    }

    public static int[] toVersionArray(String sVersion) {
        int nVersion = VersionHelper.parseVersion(sVersion);
        return new int[]{(nVersion & 0x3F000000) >> 24, (nVersion & 0xFC0000) >> 18, (nVersion & 0x3F000) >> 12, (nVersion & 0xFC0) >> 6, nVersion & 0x3F};
    }

    public static String toVersionString(int nVersion, boolean fIncludePrefix) {
        int nYear = (nVersion & 0xFC0) >> 6;
        int nPatch = nVersion & 0x3F;
        String sVersion = (fIncludePrefix || !VersionHelper.isCalendarVersion(nYear) ? ((nVersion & 0x3F000000) >> 24) + "." + ((nVersion & 0xFC0000) >> 18) + "." + ((nVersion & 0x3F000) >> 12) + "." : "") + nYear;
        if (VersionHelper.isCalendarVersion(nYear)) {
            int nPatchActual = nPatch & 0xFFFFFFDF;
            sVersion = sVersion + (fIncludePrefix ? "" : ".");
            sVersion = (nPatch & 0x20) == 0 ? sVersion + (nYear <= 22 ? "06" : "03") : sVersion + (nYear <= 21 ? "12" : "09");
            sVersion = sVersion + "." + nPatchActual;
        } else {
            sVersion = sVersion + "." + nPatch;
        }
        return sVersion;
    }

    public static boolean isVersionCompatible(int nRequired, int nActual) {
        return nRequired <= nActual;
    }

    public static boolean isPatchCompatible(int nRequired, int nActual) {
        return (nRequired & 0xFFFFFFC0) == (nActual & 0xFFFFFFC0) && (nRequired & 0x3F) <= (nActual & 0x3F);
    }
}

