/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapIndex;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.Streamer;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractAggregator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DistinctValues<K, V, T, E>
extends AbstractAggregator<K, V, T, E, Collection<E>> {
    protected transient Set<E> m_set;

    public DistinctValues() {
    }

    public DistinctValues(ValueExtractor<? super T, ? extends E> extractor) {
        super(extractor);
    }

    public DistinctValues(String sMethod) {
        super(sMethod);
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, Object, Collection<E>> supply() {
        return new DistinctValues(this.getValueExtractor());
    }

    @Override
    public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
        if (streamer.isAllInclusive()) {
            if (streamer.hasNext()) {
                Map mapContents;
                BinaryEntry binEntry;
                MapIndex index;
                InvocableMap.Entry entry = (InvocableMap.Entry)streamer.next();
                if (entry instanceof BinaryEntry && (index = (binEntry = (BinaryEntry)entry).getBackingMapContext().getIndexMap().get(this.getValueExtractor())) != null && !index.isPartial() && (mapContents = index.getIndexContents()) != null && !mapContents.isEmpty()) {
                    this.m_set = Collections.unmodifiableSet(mapContents.keySet());
                    return false;
                }
                super.accumulate(entry);
            } else {
                this.m_set = Collections.emptySet();
                return false;
            }
        }
        return super.accumulate(streamer);
    }

    @Override
    public int characteristics() {
        return 33;
    }

    @Override
    protected void init(boolean fFinal) {
        Set<E> set = this.m_set;
        if (set != null) {
            set.clear();
        }
    }

    @Override
    protected void process(Object o, boolean fFinal) {
        if (o != null) {
            if (fFinal) {
                Collection colPartial = (Collection)o;
                if (!colPartial.isEmpty()) {
                    this.ensureSet().addAll(colPartial);
                }
            } else {
                this.ensureSet().add(o);
            }
        }
    }

    @Override
    protected Set<E> finalizeResult(boolean fFinal) {
        Set<E> set = this.m_set;
        this.m_set = null;
        return set == null ? (fFinal ? NullImplementation.getSet() : null) : set;
    }

    protected Set<E> ensureSet() {
        Set<E> set = this.m_set;
        if (set == null) {
            set = this.m_set = new LiteSet();
        }
        return set;
    }
}

