/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SortedBag;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;

public class TopNAggregator<K, V, T, E>
implements InvocableMap.StreamingAggregator<K, V, PartialResult<E>, E[]>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="parallel")
    protected boolean m_fParallel;
    @JsonbProperty(value="extractor")
    protected ValueExtractor<? super T, ? extends E> m_extractor;
    @JsonbProperty(value="comparator")
    protected Comparator<? super E> m_comparator;
    @JsonbProperty(value="results")
    protected int m_cResults;
    private transient boolean m_fInit;
    private transient PartialResult<E> m_result;

    public TopNAggregator() {
    }

    public TopNAggregator(ValueExtractor<? super T, ? extends E> extractor, Comparator<? super E> comparator, int cResults) {
        this.m_extractor = Lambdas.ensureRemotable(extractor);
        this.m_cResults = cResults;
        this.m_comparator = comparator == null ? SafeComparator.INSTANCE : comparator;
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, PartialResult<E>, E[]> supply() {
        return new TopNAggregator<K, V, T, E>(this.m_extractor, this.m_comparator, this.m_cResults);
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        this.ensureInitialized();
        this.m_result.add(entry.extract(this.m_extractor));
        return true;
    }

    @Override
    public boolean combine(PartialResult<E> partialResult) {
        this.ensureInitialized();
        this.m_result.merge(partialResult);
        return true;
    }

    @Override
    public PartialResult<E> getPartialResult() {
        this.ensureInitialized();
        return this.m_result;
    }

    @Override
    public E[] finalizeResult() {
        this.ensureInitialized();
        Object[] aResult = this.m_result.toArray();
        Collections.reverse(Arrays.asList(aResult));
        this.m_fInit = false;
        return aResult;
    }

    @Override
    public int characteristics() {
        return 33;
    }

    protected void ensureInitialized() {
        if (!this.m_fInit) {
            this.m_result = new PartialResult<E>(this.m_comparator, this.m_cResults);
            this.m_fInit = true;
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fParallel = in.readBoolean();
        this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject(in);
        this.m_comparator = (Comparator)ExternalizableHelper.readObject(in);
        this.m_cResults = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fParallel);
        ExternalizableHelper.writeObject(out, this.m_extractor);
        ExternalizableHelper.writeObject(out, this.m_comparator);
        out.writeInt(this.m_cResults);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fParallel = in.readBoolean(0);
        this.m_extractor = (ValueExtractor)in.readObject(1);
        this.m_comparator = (Comparator)in.readObject(2);
        this.m_cResults = in.readInt(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fParallel);
        out.writeObject(1, this.m_extractor);
        out.writeObject(2, this.m_comparator);
        out.writeInt(3, this.m_cResults);
    }

    public static class PartialResult<E>
    extends SortedBag<E>
    implements ExternalizableLite,
    PortableObject {
        @JsonbTransient
        protected int m_cMaxSize;
        @JsonbTransient
        protected Comparator<? super E> m_comparator_copy;

        public PartialResult() {
        }

        public PartialResult(Comparator<? super E> comparator, int cMaxSize) {
            super(comparator);
            this.m_comparator_copy = comparator;
            this.m_cMaxSize = cMaxSize;
        }

        public PartialResult<E> merge(PartialResult<E> result) {
            Iterator iterValues = this.size() >= this.m_cMaxSize ? result.tailBag(this.first()).iterator() : result.iterator();
            this.addAll(iterValues);
            return this;
        }

        public void addAll(Iterator<E> iterValues) {
            int cCurSize = this.size();
            Object elemFirst = null;
            while (iterValues.hasNext()) {
                E value = iterValues.next();
                if (value == null) continue;
                if (cCurSize < this.m_cMaxSize) {
                    super.add(value);
                } else {
                    if (elemFirst == null) {
                        elemFirst = this.first();
                    }
                    if (this.m_comparator.compare(value, elemFirst) > 0) {
                        super.add(value);
                        this.removeFirst();
                        elemFirst = null;
                    }
                }
                ++cCurSize;
            }
        }

        @Override
        public boolean add(E value) {
            if (this.size() < this.m_cMaxSize) {
                return super.add(value);
            }
            if (this.m_comparator.compare(value, this.first()) > 0) {
                this.removeFirst();
                super.add(value);
                return true;
            }
            return false;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_comparator = (Comparator)ExternalizableHelper.readObject(in);
            this.m_cMaxSize = ExternalizableHelper.readInt(in);
            this.m_map = this.instantiateInternalMap(this.m_comparator);
            int cElems = in.readInt();
            for (int i = 0; i < cElems; ++i) {
                this.add(ExternalizableHelper.readObject(in));
            }
            this.m_comparator_copy = this.m_comparator;
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_comparator);
            ExternalizableHelper.writeInt(out, this.m_cMaxSize);
            out.writeInt(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ExternalizableHelper.writeObject(out, iter.next());
            }
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_comparator = (Comparator)in.readObject(0);
            this.m_cMaxSize = in.readInt(1);
            this.m_map = this.instantiateInternalMap(this.m_comparator);
            in.readCollection(2, this);
            this.m_comparator_copy = this.m_comparator;
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_comparator);
            out.writeInt(1, this.m_cMaxSize);
            out.writeCollection(2, this);
        }
    }
}

