/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.pof.PofReader;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractCompositeExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class ChainedExtractor<T, E>
extends AbstractCompositeExtractor<T, E> {
    public ChainedExtractor() {
    }

    @JsonbCreator
    public ChainedExtractor(@JsonbProperty(value="extractors") ValueExtractor[] aExtractor) {
        super(aExtractor);
        this.m_nTarget = this.computeTarget();
    }

    public <U> ChainedExtractor(ValueExtractor<? super T, ? extends U> extractor1, ValueExtractor<? super U, ? extends E> extractor2) {
        super(new ValueExtractor[]{ValueExtractor.of(extractor1), ValueExtractor.of(extractor2)});
        this.m_nTarget = this.computeTarget();
    }

    public ChainedExtractor(String sName) {
        super(ChainedExtractor.createExtractors(sName));
        this.m_nTarget = this.computeTarget();
    }

    public void ensureTarget() {
        this.m_nTarget = this.computeTarget();
    }

    @Override
    public E extract(Object oTarget) {
        ValueExtractor[] aExtractor = this.getExtractors();
        int c = aExtractor.length;
        for (int i = 0; i < c && oTarget != null; ++i) {
            oTarget = aExtractor[i].extract(oTarget);
        }
        return (E)oTarget;
    }

    @Override
    public E extractFromEntry(Map.Entry entry) {
        ValueExtractor[] aExtractor = this.getExtractors();
        Object oTarget = InvocableMapHelper.extractFromEntry(aExtractor[0], entry);
        int c = aExtractor.length;
        for (int i = 1; i < c && oTarget != null; ++i) {
            oTarget = aExtractor[i].extract(oTarget);
        }
        return oTarget;
    }

    @Override
    public E extractOriginalFromEntry(MapTrigger.Entry entry) {
        ValueExtractor[] aExtractor = this.getExtractors();
        Object oTarget = InvocableMapHelper.extractOriginalFromEntry(aExtractor[0], entry);
        int c = aExtractor.length;
        for (int i = 1; i < c && oTarget != null; ++i) {
            oTarget = aExtractor[i].extract(oTarget);
        }
        return (E)oTarget;
    }

    @Override
    public <V> ValueExtractor<V, E> compose(ValueExtractor<? super V, ? extends T> before) {
        ValueExtractor[] valueExtractorArray;
        Objects.requireNonNull(before);
        if (before instanceof ChainedExtractor) {
            valueExtractorArray = ((ChainedExtractor)before).getExtractors();
        } else {
            ValueExtractor[] valueExtractorArray2 = new ValueExtractor[1];
            valueExtractorArray = valueExtractorArray2;
            valueExtractorArray2[0] = before;
        }
        ValueExtractor[] aBefore = valueExtractorArray;
        this.m_sNameCanon = null;
        this.m_aExtractor = ChainedExtractor.merge(aBefore, this.m_aExtractor);
        this.m_nTarget = this.computeTarget();
        return this;
    }

    @Override
    public <V> ValueExtractor<T, V> andThen(ValueExtractor<? super E, ? extends V> after) {
        ValueExtractor[] valueExtractorArray;
        Objects.requireNonNull(after);
        if (after instanceof ChainedExtractor) {
            valueExtractorArray = ((ChainedExtractor)after).getExtractors();
        } else {
            ValueExtractor[] valueExtractorArray2 = new ValueExtractor[1];
            valueExtractorArray = valueExtractorArray2;
            valueExtractorArray2[0] = after;
        }
        ValueExtractor[] aAfter = valueExtractorArray;
        this.m_sNameCanon = null;
        this.m_aExtractor = ChainedExtractor.merge(this.m_aExtractor, aAfter);
        return this;
    }

    @Override
    public String getCanonicalName() {
        String sCName = super.getCanonicalName();
        if (sCName == null) {
            ValueExtractor[] aExtractor;
            StringBuilder sb = null;
            for (ValueExtractor extractor : aExtractor = this.m_aExtractor) {
                String sCNCur = extractor.getCanonicalName();
                if (sCNCur == null) {
                    return null;
                }
                sb = sb == null ? new StringBuilder(sCNCur) : sb.append('.').append(sCNCur);
            }
            this.m_sNameCanon = sb == null ? null : sb.toString();
            sCName = this.m_sNameCanon;
        }
        return sCName;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_nTarget = this.computeTarget();
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_nTarget = this.computeTarget();
    }

    public static ValueExtractor[] createExtractors(String sName) {
        String[] asMethod = ChainedExtractor.parseDelimitedString(sName, '.');
        int cMethods = asMethod.length;
        ValueExtractor[] aExtractor = new ReflectionExtractor[cMethods];
        for (int i = 0; i < cMethods; ++i) {
            aExtractor[i] = new ReflectionExtractor(asMethod[i]);
        }
        return aExtractor;
    }

    protected static ValueExtractor[] merge(ValueExtractor[] aHead, ValueExtractor[] aTail) {
        int cHead = aHead.length;
        int cTail = aTail.length;
        ValueExtractor[] aExtractorsNew = new ValueExtractor[cHead + cTail];
        System.arraycopy(aHead, 0, aExtractorsNew, 0, cHead);
        System.arraycopy(aTail, 0, aExtractorsNew, cHead, cTail);
        return aExtractorsNew;
    }

    protected int computeTarget() {
        ValueExtractor[] aExtractor = this.m_aExtractor;
        return aExtractor != null && aExtractor.length > 0 && aExtractor[0] instanceof AbstractExtractor ? aExtractor[0].getTarget() : 0;
    }
}

