/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.oracle.coherence.common.internal.util.CanonicalNames;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.lang.reflect.Method;
import javax.json.bind.annotation.JsonbProperty;

public class ReflectionExtractor<T, E>
extends AbstractExtractor<T, E>
implements ValueExtractor<T, E>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="method")
    protected String m_sMethod;
    @JsonbProperty(value="args")
    protected Object[] m_aoParam;
    private transient Method m_methodPrev;

    public ReflectionExtractor() {
    }

    public ReflectionExtractor(String sMethod) {
        this(sMethod, null, 0);
    }

    public ReflectionExtractor(String sMethod, Object[] aoParam) {
        this(sMethod, aoParam, 0);
    }

    public ReflectionExtractor(String sMethod, Object[] aoParam, int nTarget) {
        ReflectionExtractor.azzert(sMethod != null);
        this.m_sMethod = sMethod;
        this.m_aoParam = aoParam;
        this.m_nTarget = nTarget;
    }

    @Override
    public E extract(T oTarget) {
        if (oTarget == null) {
            return null;
        }
        Class<?> clz = oTarget.getClass();
        try {
            Method method = this.m_methodPrev;
            if (method == null || method.getDeclaringClass() != clz) {
                if (!ClassHelper.isReflectionAllowed(oTarget)) {
                    throw new IllegalArgumentException(this.suggestExtractFailureCause(clz, true));
                }
                this.m_methodPrev = method = ClassHelper.findMethod(clz, this.getMethodName(), ClassHelper.getClassArray(this.m_aoParam), false);
            }
            return (E)method.invoke(oTarget, this.m_aoParam);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(this.suggestExtractFailureCause(clz, false));
        }
        catch (Exception e) {
            throw ReflectionExtractor.ensureRuntimeException(e, clz.getName() + this + '(' + oTarget + ')');
        }
    }

    @Override
    public String getCanonicalName() {
        String sCName = super.getCanonicalName();
        if (sCName == null) {
            sCName = this.m_sNameCanon = this.computeCanonicalName(this.m_sMethod, this.m_aoParam);
        }
        return sCName;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (this.isCanonicallyEquatable(o)) {
            return false;
        }
        if (o instanceof ReflectionExtractor) {
            ReflectionExtractor that = (ReflectionExtractor)o;
            return this.m_nTarget == that.m_nTarget && Base.equals(this.m_sMethod, that.m_sMethod) && ReflectionExtractor.equalsDeep(this.m_aoParam, that.m_aoParam);
        }
        return false;
    }

    @Override
    public int hashCode() {
        String sCName = this.getCanonicalName();
        return sCName == null ? this.m_sMethod.hashCode() : sCName.hashCode();
    }

    public String toString() {
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        Method methodPrev = this.m_methodPrev;
        String sName = methodPrev == null ? this.m_sMethod : methodPrev.getName();
        StringBuilder sb = new StringBuilder();
        if (this.m_nTarget == 1) {
            sb.append(".getKey()");
        }
        sb.append('.').append(sName).append('(');
        for (int i = 0; i < cParams; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(aoParam[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public String getMethodName() {
        return this.m_sMethod;
    }

    public Object[] getParameters() {
        return this.m_aoParam;
    }

    private String suggestExtractFailureCause(Class clzTarget, boolean fFiltered) {
        String sMsg = "Missing or inaccessible method: " + clzTarget.getName() + this;
        if (MapEvent.class.isAssignableFrom(clzTarget)) {
            sMsg = sMsg + " (the object is a com.tangosol.util.MapEvent, which may suggest that a raw com.tangosol.util.Filter is being used to filter map events rather than a com.tangosol.util.filter.MapEventFilter)";
        }
        if (fFiltered) {
            sMsg = sMsg + " (The type, " + clzTarget.getName() + ", is disallowed as a reflection target by the current reflection filter configuration)";
        }
        return sMsg;
    }

    protected String computeCanonicalName(String sName, Object[] aoParam) {
        String sNameCanonical = null;
        int nNameLength = sName == null ? 0 : sName.length();
        String[] accessorPrefixes = CanonicalNames.VALUE_EXTRACTOR_BEAN_ACCESSOR_PREFIXES;
        if (aoParam == null || aoParam.length == 0) {
            int len = accessorPrefixes.length;
            for (int cchPrefix = 0; cchPrefix < len && sNameCanonical == null; ++cchPrefix) {
                int nPrefixLength = accessorPrefixes[cchPrefix].length();
                if (nNameLength <= nPrefixLength || nNameLength <= 0 || !sName.startsWith(accessorPrefixes[cchPrefix])) continue;
                sNameCanonical = Character.toLowerCase(sName.charAt(nPrefixLength)) + sName.substring(nPrefixLength + 1);
            }
            if (sNameCanonical == null) {
                sNameCanonical = sName + "()";
            }
        }
        return sNameCanonical;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sMethod = ReflectionExtractor.readUTF(in);
        int cParams = ReflectionExtractor.readInt(in);
        ReflectionExtractor.azzert(cParams < 256, "Unexpected number of method parameters");
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = ReflectionExtractor.readObject(in);
        }
        this.m_aoParam = aoParam;
        this.m_nTarget = ReflectionExtractor.readInt(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        String sMethod = this.m_sMethod;
        if (sMethod == null) {
            throw new NotActiveException("ReflectionExtractor was constructed without a method name");
        }
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        ReflectionExtractor.writeUTF(out, sMethod);
        ReflectionExtractor.writeInt(out, cParams);
        for (int i = 0; i < cParams; ++i) {
            ReflectionExtractor.writeObject(out, aoParam[i]);
        }
        ReflectionExtractor.writeInt(out, this.m_nTarget);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sMethod = in.readString(0);
        int cParams = in.readInt(1);
        if (cParams > 0) {
            Object[] aoParam = new Object[cParams];
            for (int i = 0; i < cParams; ++i) {
                aoParam[i] = in.readObject(i + 2);
            }
            this.m_aoParam = aoParam;
        } else {
            this.m_aoParam = in.readArray(2, Object[]::new);
            this.m_nTarget = in.readInt(3);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        String sMethod = this.m_sMethod;
        if (sMethod == null) {
            throw new NotActiveException("ReflectionExtractor was constructed without a method name");
        }
        out.writeString(0, sMethod);
        out.writeObjectArray(2, this.m_aoParam);
        out.writeInt(3, this.m_nTarget);
    }
}

