/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.internal.util.extractor.TargetReflectionDescriptor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.AbstractUpdater;
import com.tangosol.util.extractor.CompositeUpdater;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

public class UniversalUpdater
extends AbstractUpdater
implements ExternalizableLite,
PortableObject {
    public static final String BEAN_MODIFIER_PREFIX = "set";
    public static final String METHOD_SUFFIX = "()";
    @JsonbProperty(value="name")
    protected String m_sName;
    private transient String m_sNameCanon;
    private transient TargetReflectionDescriptor m_targetPrev;

    public UniversalUpdater() {
    }

    public UniversalUpdater(String sName) {
        UniversalUpdater.azzert(sName != null);
        this.m_sName = sName;
    }

    @Override
    public void update(Object oTarget, Object oValue) {
        if (oTarget == null) {
            throw new IllegalArgumentException("Target object is missing for the Updater: " + this);
        }
        Class<?> clzTarget = oTarget.getClass();
        TargetReflectionDescriptor targetPrev = this.m_targetPrev;
        try {
            if (targetPrev != null && clzTarget == targetPrev.getTargetClass()) {
                if (targetPrev.isMap()) {
                    ((Map)oTarget).put(this.getCanonicalName(), oValue);
                } else {
                    targetPrev.getMethod().invoke(oTarget, oValue);
                }
            } else {
                this.updateComplex(oTarget, oValue);
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Missing or inaccessible method: " + clzTarget.getName() + '#' + this.m_sName);
        }
        catch (Exception e) {
            throw UniversalUpdater.ensureRuntimeException(e, clzTarget.getName() + '#' + this.m_sName + '(' + oTarget + ')');
        }
    }

    public boolean isMethodUpdater() {
        return this.m_sName.endsWith(METHOD_SUFFIX);
    }

    public String getMethodName() {
        int METHOD_SUFFIX_LENGTH = METHOD_SUFFIX.length();
        String sName = this.m_sName;
        return this.isMethodUpdater() ? sName.substring(0, sName.length() - METHOD_SUFFIX_LENGTH) : BEAN_MODIFIER_PREFIX + Character.toUpperCase(sName.charAt(0)) + (sName.length() > 1 ? sName.substring(1) : "");
    }

    public String getCanonicalName() {
        String sCName = this.m_sNameCanon;
        if (sCName == null) {
            sCName = this.m_sNameCanon = UniversalUpdater.computeCanonicalName(this.m_sName);
        }
        return sCName;
    }

    protected void updateComplex(Object oTarget, Object oValue) throws InvocationTargetException, IllegalAccessException {
        Method method;
        String sCName = this.getCanonicalName();
        Class<?> clzTarget = oTarget.getClass();
        Class[] aclzParam = new Class[]{oValue == null ? Object.class : oValue.getClass()};
        Method method2 = method = this.isMethodUpdater() ? ClassHelper.findMethod(clzTarget, this.getMethodName(), aclzParam, false) : null;
        if (method == null) {
            String sBeanAttribute = sCName.length() == 0 ? sCName : Character.toUpperCase(sCName.charAt(0)) + sCName.substring(1);
            String sBeanSetter = BEAN_MODIFIER_PREFIX + sBeanAttribute;
            method = ClassHelper.findMethod(clzTarget, sBeanSetter, aclzParam, false);
        }
        if (method == null) {
            if (oTarget instanceof Map) {
                this.m_targetPrev = new TargetReflectionDescriptor(clzTarget);
                ((Map)oTarget).put(sCName, oValue);
                return;
            }
        } else {
            if (!ClassHelper.isReflectionAllowed(oTarget)) {
                throw new IllegalArgumentException("The type, " + clzTarget.getName() + ", is disallowed as a reflection target by the current reflection filter configuration");
            }
            this.m_targetPrev = new TargetReflectionDescriptor(clzTarget, method);
        }
        method.invoke(oTarget, oValue);
    }

    public static String computeCanonicalName(String sName) {
        int nNameLength;
        int PREFIX_LEN = BEAN_MODIFIER_PREFIX.length();
        int SUFFIX_LEN = METHOD_SUFFIX.length();
        String sNameCanonical = null;
        int n = nNameLength = sName == null ? 0 : sName.length();
        if (nNameLength > PREFIX_LEN + SUFFIX_LEN && sName.startsWith(BEAN_MODIFIER_PREFIX) && sName.endsWith(METHOD_SUFFIX)) {
            sNameCanonical = Character.toLowerCase(sName.charAt(PREFIX_LEN)) + sName.substring(PREFIX_LEN + 1, nNameLength - SUFFIX_LEN);
        }
        if (sNameCanonical == null) {
            sNameCanonical = sName;
        }
        return sNameCanonical;
    }

    public static ValueUpdater createUpdater(String sNames) {
        return sNames.indexOf(46) < 0 ? new UniversalUpdater(sNames) : new CompositeUpdater(sNames);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UniversalUpdater) {
            String sCNameThat = ((UniversalUpdater)o).getCanonicalName();
            String sCNameThis = this.getCanonicalName();
            if (sCNameThis == sCNameThat) {
                return true;
            }
            if (Base.equals(sCNameThis, sCNameThat)) {
                this.m_sNameCanon = sCNameThat;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getCanonicalName().hashCode();
    }

    public String toString() {
        return this.getCanonicalName();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sName = in.readUTF();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sName);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sName = in.readString(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sName);
    }
}

