/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class ContainsAllFilter<T, E>
extends ComparisonFilter<T, E, Set<?>>
implements IndexAwareFilter<Object, T> {
    public ContainsAllFilter() {
    }

    @JsonbCreator
    public ContainsAllFilter(@JsonbProperty(value="extractor") ValueExtractor<? super T, ? extends E> extractor, @JsonbProperty(value="value") Set<?> setValues) {
        super(extractor, new HashSet(setValues));
    }

    public ContainsAllFilter(String sMethod, Set<?> setValues) {
        super(sMethod, new HashSet(setValues));
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Collection collValues = (Collection)this.getValue();
        if (extracted instanceof Collection) {
            return ((Collection)extracted).containsAll(collValues);
        }
        if (extracted instanceof Object[]) {
            Object[] aoExtracted = (Object[])extracted;
            int cExtracted = aoExtracted.length;
            block0: for (Object oValue : collValues) {
                for (int i = 0; i < cExtracted; ++i) {
                    if (ContainsAllFilter.equals(aoExtracted[i], oValue)) continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toStringValue() {
        return Base.truncateString((Collection)this.getValue(), 255);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? ContainsAllFilter.calculateIteratorEffectiveness(setKeys.size()) : ((Collection)this.getValue()).size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        for (Object oValue : (Collection)this.getValue()) {
            Set setEQ = index.getIndexContents().get(oValue);
            if (setEQ == null) {
                setKeys.clear();
                break;
            }
            setKeys.retainAll(setEQ);
            if (!setKeys.isEmpty()) continue;
            break;
        }
        return null;
    }
}

