/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Base;
import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class InFilter<T, E>
extends ComparisonFilter<T, E, Set<? extends E>>
implements IndexAwareFilter<Object, T> {
    public InFilter() {
    }

    public InFilter(ValueExtractor<? super T, ? extends E> extractor, Set<? extends E> setValues) {
        super(extractor, new HashSet<E>(setValues));
    }

    public InFilter(String sMethod, Set<? extends E> setValues) {
        super(sMethod, new HashSet<E>(setValues));
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        return ((Collection)this.getValue()).contains(extracted);
    }

    @Override
    public String toStringValue() {
        return Base.truncateString((Collection)this.getValue(), 255);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? InFilter.calculateIteratorEffectiveness(setKeys.size()) : ((Collection)this.getValue()).size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Collection colValues;
        MapIndex index;
        block7: {
            index = (MapIndex)mapIndexes.get(this.getValueExtractor());
            if (index == null) {
                return this;
            }
            colValues = (Collection)this.getValue();
            int cValues = colValues.size();
            int cKeys = setKeys.size();
            int FACTOR = 128;
            if (cKeys < Math.min(1000, cValues) * 128) {
                Iterator iter = setKeys.iterator();
                while (iter.hasNext()) {
                    Object oValue = index.get(iter.next());
                    if (oValue != MapIndex.NO_VALUE) {
                        if (colValues.contains(oValue)) continue;
                        iter.remove();
                        continue;
                    }
                    break block7;
                }
                return null;
            }
        }
        ArrayList listInverseKeys = new ArrayList(colValues.size());
        for (Object oValue : colValues) {
            Set setEQ = index.getIndexContents().get(oValue);
            if (setEQ == null || setEQ.isEmpty()) continue;
            listInverseKeys.add(setEQ);
        }
        if (listInverseKeys.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(new ChainedCollection(listInverseKeys));
        }
        return null;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_value = in.readCollection(1, new HashSet());
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeCollection(1, (Collection)this.m_value);
    }
}

