/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.filter.AbstractQueryRecorderFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public class InKeySetFilter<T>
extends AbstractQueryRecorderFilter<T>
implements EntryFilter<Object, T>,
IndexAwareFilter<Object, T>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    private Filter<T> m_filter;
    @JsonbProperty(value="keys")
    private Set<?> m_setKeys;
    private transient boolean m_fConverted;

    public InKeySetFilter() {
    }

    public <K> InKeySetFilter(Filter<T> filter, Set<K> setKeys) {
        this.m_filter = filter;
        this.m_setKeys = setKeys;
    }

    @Override
    public boolean evaluate(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        Filter<T> filter = this.m_filter;
        return this.m_setKeys.contains(entry.getKey()) && (filter == null || InvocableMapHelper.evaluateEntry(filter, entry));
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        Filter<T> filter = this.m_filter;
        if (filter == null) {
            return 1;
        }
        if (this.m_setKeys.size() < setKeys.size()) {
            setKeys = this.m_setKeys;
        }
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        setKeys.retainAll(this.m_setKeys);
        Filter<T> filter = this.m_filter;
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys) : null;
    }

    public Filter<T> getFilter() {
        return this.m_filter;
    }

    public Set<?> getKeys() {
        return this.m_setKeys;
    }

    public synchronized void ensureConverted(Converter converter) {
        if (!this.m_fConverted) {
            HashSet setConv = new HashSet(this.m_setKeys.size());
            Iterator<?> iter = this.m_setKeys.iterator();
            while (iter.hasNext()) {
                setConv.add(converter.convert(iter.next()));
            }
            this.m_setKeys = setConv;
            this.m_fConverted = true;
        }
    }

    public synchronized void ensureUnconverted(Converter converter) {
        if (this.m_fConverted) {
            HashSet setConv = new HashSet(this.m_setKeys.size());
            Iterator<?> iter = this.m_setKeys.iterator();
            while (iter.hasNext()) {
                setConv.add(converter.convert(iter.next()));
            }
            this.m_setKeys = setConv;
            this.m_fConverted = false;
        }
    }

    public boolean isConverted() {
        return this.m_fConverted;
    }

    public void markConverted() {
        this.m_fConverted = true;
    }

    public String toString() {
        return "InKeySetFilter(" + this.m_filter + ", keys=" + Base.truncateString(this.m_setKeys, 255) + ')';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)InKeySetFilter.readObject(in);
        this.m_setKeys = new HashSet();
        ExternalizableHelper.readCollection(in, this.m_setKeys, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        InKeySetFilter.writeObject(out, this.m_filter);
        ExternalizableHelper.writeCollection(out, this.m_setKeys);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_setKeys = in.readCollection(1, new HashSet());
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeCollection(1, this.m_setKeys);
    }
}

