/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class LessEqualsFilter<T, E extends Comparable<? super E>>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public LessEqualsFilter() {
    }

    public LessEqualsFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public LessEqualsFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Comparable value = (Comparable)this.getValue();
        return extracted != null && value != null && extracted.compareTo((Comparable)value) <= 0;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateRangeEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Object oValue = this.getValue();
        if (oValue == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.isOrdered()) {
            boolean fHeadHeavy;
            SortedMap mapContents = (SortedMap)index.getIndexContents();
            Set setEQ = (Set)mapContents.get(oValue);
            Set setNULL = (Set)mapContents.get(null);
            SortedMap mapLT = mapContents.headMap(oValue);
            SortedMap mapGE = mapContents.tailMap(oValue);
            boolean bl = fHeadHeavy = mapLT.size() > mapContents.size() / 2;
            if (fHeadHeavy && !index.isPartial()) {
                for (Set set : mapGE.values()) {
                    if (set == setEQ) continue;
                    setKeys.removeAll(LessEqualsFilter.ensureSafeSet(set));
                }
                if (setNULL != null) {
                    setKeys.removeAll(setNULL);
                }
            } else {
                HashSet setLE = new HashSet();
                for (Set set : mapLT.values()) {
                    if (set == setNULL) continue;
                    setLE.addAll(LessEqualsFilter.ensureSafeSet(set));
                }
                setLE.addAll(LessEqualsFilter.ensureSafeSet(setEQ));
                setKeys.retainAll(setLE);
            }
        } else {
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                HashSet setLE = new HashSet();
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest == null || oTest.compareTo(oValue) > 0) continue;
                    setLE.addAll(entry.getValue());
                }
                setKeys.retainAll(setLE);
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest != null && oTest.compareTo(oValue) <= 0) continue;
                    setKeys.removeAll(entry.getValue());
                }
            }
        }
        return null;
    }
}

