/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class LessFilter<T, E extends Comparable<? super E>>
extends ComparisonFilter<T, E, E>
implements IndexAwareFilter<Object, T> {
    public LessFilter() {
    }

    public LessFilter(ValueExtractor<? super T, ? extends E> extractor, E value) {
        super(extractor, value);
    }

    public LessFilter(String sMethod, E value) {
        super(sMethod, value);
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        Comparable value = (Comparable)this.getValue();
        return extracted != null && value != null && extracted.compareTo((Comparable)value) < 0;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        return this.calculateRangeEffectiveness(mapIndexes, setKeys);
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Object oValue = this.getValue();
        if (oValue == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.isOrdered()) {
            boolean fHeadHeavy;
            SortedMap mapContents = (SortedMap)index.getIndexContents();
            Set setNULL = (Set)mapContents.get(null);
            SortedMap mapLT = mapContents.headMap(oValue);
            SortedMap mapGE = mapContents.tailMap(oValue);
            boolean bl = fHeadHeavy = mapLT.size() > mapContents.size() / 2;
            if (fHeadHeavy && !index.isPartial()) {
                Iterator iterGE = mapGE.values().iterator();
                while (iterGE.hasNext()) {
                    setKeys.removeAll(LessFilter.ensureSafeSet((Set)iterGE.next()));
                }
                setKeys.removeAll(LessFilter.ensureSafeSet(setNULL));
            } else {
                HashSet setLT = new HashSet();
                for (Set set : mapLT.values()) {
                    if (set == setNULL) continue;
                    setLT.addAll(LessFilter.ensureSafeSet(set));
                }
                setKeys.retainAll(setLT);
            }
        } else {
            Map mapContents = index.getIndexContents();
            if (index.isPartial()) {
                HashSet setLT = new HashSet();
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest == null || oTest.compareTo(oValue) >= 0) continue;
                    setLT.addAll(LessFilter.ensureSafeSet(entry.getValue()));
                }
                setKeys.retainAll(setLT);
            } else {
                for (Map.Entry entry : mapContents.entrySet()) {
                    Comparable oTest = (Comparable)entry.getKey();
                    if (oTest != null && oTest.compareTo(oValue) < 0) continue;
                    setKeys.removeAll(LessFilter.ensureSafeSet(entry.getValue()));
                }
            }
        }
        return null;
    }
}

