/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ExtractorFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Predicate;
import javax.json.bind.annotation.JsonbProperty;

public class PredicateFilter<T, E>
extends ExtractorFilter<T, E> {
    @JsonbProperty(value="predicate")
    protected Predicate<? super E> m_predicate;

    public PredicateFilter() {
    }

    public PredicateFilter(Predicate<? super E> predicate) {
        super(ValueExtractor.identityCast());
        this.m_predicate = predicate;
    }

    public PredicateFilter(ValueExtractor<? super T, ? extends E> extractor, Predicate<? super E> predicate) {
        super(extractor);
        this.m_predicate = predicate;
    }

    public PredicateFilter(String sMethodName, Predicate<? super E> predicate) {
        super(sMethodName);
        this.m_predicate = predicate;
    }

    @Override
    protected boolean evaluateExtracted(E extracted) {
        return this.m_predicate.test(extracted);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_predicate = (Predicate)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeObject(out, this.m_predicate);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        super.readExternal(reader);
        this.m_predicate = (Predicate)reader.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        super.writeExternal(writer);
        writer.writeObject(1, this.m_predicate);
    }
}

