/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.fsm;

import com.tangosol.util.fsm.Model;
import com.tangosol.util.fsm.StateEntryAction;
import com.tangosol.util.fsm.StateExitAction;
import com.tangosol.util.fsm.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SimpleModel<S extends Enum<S>>
implements Model<S> {
    private Class<S> m_stateClass;
    private S[] m_states;
    private ArrayList<Transition<S>> m_transitions;
    private HashMap<S, StateEntryAction<S>> m_mapStateEntryActions;
    private HashMap<S, StateExitAction<S>> m_mapStateExitActions;

    public SimpleModel(Class<S> stateClass) {
        this.m_stateClass = stateClass;
        this.m_states = (Enum[])stateClass.getEnumConstants();
        this.m_transitions = new ArrayList();
        this.m_mapStateEntryActions = new HashMap();
        this.m_mapStateExitActions = new HashMap();
    }

    @Override
    public Class<S> getStateClass() {
        return this.m_stateClass;
    }

    @Override
    public S[] getStates() {
        return this.m_states;
    }

    @Override
    public Map<S, StateEntryAction<S>> getStateEntryActions() {
        return this.m_mapStateEntryActions;
    }

    public void addStateEntryAction(S state, StateEntryAction<S> stateEntryAction) {
        this.m_mapStateEntryActions.put(state, stateEntryAction);
    }

    @Override
    public Map<S, StateExitAction<S>> getStateExitActions() {
        return this.m_mapStateExitActions;
    }

    @Override
    public Iterable<Transition<S>> getTransitions() {
        return this.m_transitions;
    }

    public S getState(String sName) {
        sName = sName.trim().toUpperCase();
        for (S state : this.m_states) {
            if (!((Enum)state).name().toUpperCase().equals(sName)) continue;
            return state;
        }
        return null;
    }

    public void addStateExitAction(S state, StateExitAction<S> stateExitAction) {
        this.m_mapStateExitActions.put(state, stateExitAction);
    }

    public void addTransition(Transition<S> transition) {
        this.m_transitions.add(transition);
    }
}

