/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.json.bind.annotation.JsonbProperty;

public class ConditionalPutAll<K, V>
extends AbstractProcessor<K, V, V>
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="filter")
    protected Filter m_filter;
    @JsonbProperty(value="entries")
    protected Map<? extends K, ? extends V> m_map;

    public ConditionalPutAll() {
    }

    public ConditionalPutAll(Filter filter, Map<? extends K, ? extends V> map) {
        ConditionalPutAll.azzert(filter != null, "Filter is null");
        ConditionalPutAll.azzert(map != null, "Map is null");
        this.m_filter = filter;
        this.m_map = new LiteMap<K, V>(map);
    }

    @Override
    public V process(InvocableMap.Entry<K, V> entry) {
        Map<K, V> map = this.m_map;
        K key = entry.getKey();
        if (map.containsKey(key) && InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            entry.setValue(map.get(key), false);
        }
        return null;
    }

    @Override
    public Map<K, V> processAll(Set<? extends InvocableMap.Entry<K, V>> setEntries) {
        Map<K, V> map = this.m_map;
        Filter filter = this.m_filter;
        for (InvocableMap.Entry<K, V> entry : setEntries) {
            K oKey = entry.getKey();
            if (!map.containsKey(oKey) || !InvocableMapHelper.evaluateEntry(filter, entry)) continue;
            entry.setValue(map.get(oKey), false);
        }
        return NullImplementation.getMap();
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalPutAll) {
            ConditionalPutAll that = (ConditionalPutAll)o;
            return ConditionalPutAll.equals(this.m_filter, that.m_filter) && ConditionalPutAll.equals(this.m_map, that.m_map);
        }
        return false;
    }

    public int hashCode() {
        return this.m_filter.hashCode() + this.m_map.hashCode();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Filter = " + this.m_filter + ", Map=" + this.m_map + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_map = new LiteMap<K, V>();
        LiteMap<? extends K, ? extends V> map = this.m_map;
        ExternalizableHelper.readMap(in, map, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        ExternalizableHelper.writeMap(out, this.m_map);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_map = (Map)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_map);
    }
}

