/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.stream;

import com.tangosol.internal.util.DoubleSummaryStatistics;
import com.tangosol.internal.util.IntSummaryStatistics;
import com.tangosol.internal.util.LongSummaryStatistics;
import com.tangosol.internal.util.collection.PortableCollection;
import com.tangosol.internal.util.collection.PortableList;
import com.tangosol.internal.util.collection.PortableMap;
import com.tangosol.internal.util.collection.PortableSet;
import com.tangosol.internal.util.collection.PortableSortedSet;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.stream.collectors.AveragingDoubleCollector;
import com.tangosol.internal.util.stream.collectors.AveragingIntCollector;
import com.tangosol.internal.util.stream.collectors.AveragingLongCollector;
import com.tangosol.internal.util.stream.collectors.BiReducingCollector;
import com.tangosol.internal.util.stream.collectors.CollectingAndThenCollector;
import com.tangosol.internal.util.stream.collectors.CollectionCollector;
import com.tangosol.internal.util.stream.collectors.GroupingByCollector;
import com.tangosol.internal.util.stream.collectors.MapCollector;
import com.tangosol.internal.util.stream.collectors.MappingCollector;
import com.tangosol.internal.util.stream.collectors.ReducingCollector;
import com.tangosol.internal.util.stream.collectors.SummarizingDoubleCollector;
import com.tangosol.internal.util.stream.collectors.SummarizingIntCollector;
import com.tangosol.internal.util.stream.collectors.SummarizingLongCollector;
import com.tangosol.internal.util.stream.collectors.SummingDoubleCollector;
import com.tangosol.internal.util.stream.collectors.SummingIntCollector;
import com.tangosol.internal.util.stream.collectors.SummingLongCollector;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SimpleHolder;
import com.tangosol.util.SortedBag;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;

public abstract class RemoteCollectors {
    public static <T, C extends Collection<T>> RemoteCollector<T, ?, C> toCollection(Remote.Supplier<C> supplier) {
        return new CollectionCollector(supplier);
    }

    public static <T> RemoteCollector<T, ?, List<T>> toList() {
        return RemoteCollectors.toCollection(PortableList::new);
    }

    public static <T> RemoteCollector<T, ?, Collection<T>> toSortedBag() {
        return RemoteCollectors.toSortedBag(SafeComparator.INSTANCE);
    }

    public static <T> RemoteCollector<T, ?, Collection<T>> toSortedBag(Comparator<? super T> comparator) {
        Remote.Supplier supplier = () -> new SortedBag(comparator);
        return RemoteCollectors.toCollection(() -> new PortableCollection(supplier));
    }

    public static <T> RemoteCollector<T, ?, Collection<T>> toSortedBag(Remote.Comparator<? super T> comparator) {
        Remote.Supplier supplier = () -> new SortedBag(comparator);
        return RemoteCollectors.toCollection(() -> new PortableCollection(supplier));
    }

    public static <T> RemoteCollector<T, ?, Set<T>> toSet() {
        return RemoteCollectors.toCollection(PortableSet::new);
    }

    public static <T> RemoteCollector<T, ?, SortedSet<T>> toSortedSet() {
        return RemoteCollectors.toCollection(PortableSortedSet::new);
    }

    public static <T> RemoteCollector<T, ?, SortedSet<T>> toSortedSet(Comparator<? super T> comparator) {
        return RemoteCollectors.toCollection(() -> new PortableSortedSet(comparator));
    }

    public static <T> RemoteCollector<T, ?, SortedSet<T>> toSortedSet(Remote.Comparator<? super T> comparator) {
        return RemoteCollectors.toCollection(() -> new PortableSortedSet(comparator));
    }

    public static <T, U, A, R> RemoteCollector<T, A, R> mapping(Remote.Function<? super T, ? extends U> mapper, RemoteCollector<? super U, A, R> downstream) {
        return new MappingCollector<T, U, A, R>(mapper, downstream);
    }

    public static <T, A, R, RR> RemoteCollector<T, A, RR> collectingAndThen(RemoteCollector<T, A, R> downstream, Remote.Function<R, RR> finisher) {
        return new CollectingAndThenCollector<T, A, R, RR>(downstream, finisher);
    }

    public static <T> RemoteCollector<T, ?, Long> counting() {
        return RemoteCollectors.reducing(Long.valueOf(0L), e -> 1L, Long::sum);
    }

    public static <T> RemoteCollector<T, ?, Optional<T>> minBy(Remote.Comparator<? super T> comparator) {
        return RemoteCollectors.reducing(Remote.BinaryOperator.minBy(comparator));
    }

    public static <T> RemoteCollector<T, ?, Optional<T>> maxBy(Remote.Comparator<? super T> comparator) {
        return RemoteCollectors.reducing(Remote.BinaryOperator.maxBy(comparator));
    }

    public static <T, U> RemoteCollector<T, ?, Integer> summingInt(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToIntFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).intValue() : ((Number)ex.extract((Object)t)).intValue();
        return new SummingIntCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, Long> summingLong(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToLongFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).longValue() : ((Number)ex.extract((Object)t)).longValue();
        return new SummingLongCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, Double> summingDouble(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToDoubleFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).doubleValue() : ((Number)ex.extract((Object)t)).doubleValue();
        return new SummingDoubleCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, Double> averagingInt(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToIntFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).intValue() : ((Number)ex.extract((Object)t)).intValue();
        return new AveragingIntCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, Double> averagingLong(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToLongFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).longValue() : ((Number)ex.extract((Object)t)).longValue();
        return new AveragingLongCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, Double> averagingDouble(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToDoubleFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).doubleValue() : ((Number)ex.extract((Object)t)).doubleValue();
        return new AveragingDoubleCollector(mapper);
    }

    public static <T> RemoteCollector<T, SimpleHolder<T>, T> reducing(T identity, Remote.BinaryOperator<T> op) {
        return new ReducingCollector<T>(identity, op);
    }

    public static <T> RemoteCollector<T, ?, Optional<T>> reducing(Remote.BinaryOperator<T> op) {
        return RemoteCollectors.collectingAndThen(RemoteCollectors.reducing(null, op), Optional::ofNullable);
    }

    public static <T, U> RemoteCollector<T, ?, U> reducing(U identity, Remote.Function<? super T, ? extends U> mapper, Remote.BinaryOperator<U> op) {
        return RemoteCollectors.mapping(mapper, RemoteCollectors.reducing(identity, op));
    }

    public static <T, U> RemoteCollector<T, ?, U> reducing(U identity, Remote.BiFunction<? super U, ? super T, ? extends U> mapper, Remote.BinaryOperator<U> op) {
        return new BiReducingCollector<T, U>(identity, mapper, op);
    }

    public static <T, U, K> RemoteCollector<T, ?, Map<K, List<T>>> groupingBy(ValueExtractor<? super U, ? extends K> classifier) {
        return RemoteCollectors.groupingBy(classifier, RemoteCollectors.toList());
    }

    public static <T, U, K, A, D> RemoteCollector<T, ?, Map<K, D>> groupingBy(ValueExtractor<? super U, ? extends K> classifier, RemoteCollector<? super T, A, D> downstream) {
        return RemoteCollectors.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, U, K, D, A, M extends Map<K, D>> RemoteCollector<T, ?, M> groupingBy(ValueExtractor<? super U, ? extends K> extractor, Remote.Supplier<M> mapFactory, RemoteCollector<? super T, A, D> downstream) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.Function classifier = t -> t instanceof InvocableMap.Entry ? ((InvocableMap.Entry)t).extract(ex) : ex.extract((Object)t);
        return new GroupingByCollector(classifier, downstream, mapFactory);
    }

    public static <T, U1, U2, K, V> RemoteCollector<T, ?, Map<K, V>> toMap(ValueExtractor<? super U1, ? extends K> keyMapper, ValueExtractor<? super U2, ? extends V> valueMapper) {
        return RemoteCollectors.toMap(keyMapper, valueMapper, null, PortableMap::new);
    }

    public static <T, U1, U2, K, V> RemoteCollector<T, ?, Map<K, V>> toMap(ValueExtractor<? super U1, ? extends K> keyMapper, ValueExtractor<? super U2, ? extends V> valueMapper, Remote.BinaryOperator<V> mergeFunction) {
        return RemoteCollectors.toMap(keyMapper, valueMapper, mergeFunction, PortableMap::new);
    }

    public static <T, U1, U2, K, V, M extends Map<K, V>> RemoteCollector<T, ?, M> toMap(ValueExtractor<? super U1, ? extends K> keyExtractor, ValueExtractor<? super U2, ? extends V> valueExtractor, Remote.BinaryOperator<V> mergeFunction, Remote.Supplier<M> mapSupplier) {
        ValueExtractor keyEx = Lambdas.ensureRemotable(keyExtractor);
        ValueExtractor valueEx = Lambdas.ensureRemotable(valueExtractor);
        Remote.Function keyMapper = t -> t instanceof InvocableMap.Entry ? ((InvocableMap.Entry)t).extract(keyEx) : keyEx.extract((Object)t);
        Remote.Function valueMapper = t -> t instanceof InvocableMap.Entry ? ((InvocableMap.Entry)t).extract(valueEx) : valueEx.extract((Object)t);
        return new MapCollector(keyMapper, valueMapper, mergeFunction, mapSupplier);
    }

    public static <T, U> RemoteCollector<T, ?, IntSummaryStatistics> summarizingInt(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToIntFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).intValue() : ((Number)ex.extract((Object)t)).intValue();
        return new SummarizingIntCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, LongSummaryStatistics> summarizingLong(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToLongFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).longValue() : ((Number)ex.extract((Object)t)).longValue();
        return new SummarizingLongCollector(mapper);
    }

    public static <T, U> RemoteCollector<T, ?, DoubleSummaryStatistics> summarizingDouble(ValueExtractor<? super U, ? extends Number> extractor) {
        ValueExtractor ex = Lambdas.ensureRemotable(extractor);
        Remote.ToDoubleFunction mapper = t -> t instanceof InvocableMap.Entry ? ((Number)((InvocableMap.Entry)t).extract(ex)).doubleValue() : ((Number)ex.extract((Object)t)).doubleValue();
        return new SummarizingDoubleCollector(mapper);
    }
}

