/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected OracleClob clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    protected boolean asciiStrictConversion;
    boolean internalClob;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    public OracleClobInputStream(OracleClob clob, int chunkSize) throws SQLException {
        this(clob, chunkSize, 1L, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$10, null, clob, chunkSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobInputStream(OracleClob clob, int chunkSize, boolean isInternal) throws SQLException {
        this(clob, chunkSize, 1L, isInternal);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$11, null, clob, chunkSize, isInternal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobInputStream(OracleClob clob, int chunkSize, long beginOffset) throws SQLException {
        this(clob, chunkSize, beginOffset, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$12, null, clob, chunkSize, beginOffset);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleClobInputStream(OracleClob clob, int chunkSize, long beginOffset, boolean isInternal) throws SQLException {
        super(chunkSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$13, null, clob, chunkSize, beginOffset, isInternal);
            }
            this.internalClob = false;
            if (clob == null || chunkSize <= 0 || beginOffset < 1L) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$13, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.lobOffset = beginOffset;
            this.clob = clob;
            this.markedByte = -1L;
            this.endOfStream = false;
            this.internalClob = isInternal;
            this.asciiStrictConversion = ((PhysicalConnection)clob.getInternalConnection()).isStrictAsciiConversion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean needBytes(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, n2);
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block20: {
                    if (!this.endOfStream) {
                        boolean bl2;
                        block21: {
                            boolean bl3;
                            try {
                                void howMany;
                                if (howMany > this.currentBufferSize || howMany == false) {
                                    this.currentBufferSize = Math.max((int)howMany, this.initialBufferSize);
                                    PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                                    Monitor.CloseableLock lock = pConnection.acquireCloseableLock();
                                    try {
                                        this.resizableBuffer = pConnection.getByteBuffer(this.currentBufferSize);
                                        this.charBuf = pConnection.getCharBuffer(this.currentBufferSize);
                                        if (lock != null) {
                                            lock.close();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (lock != null) {
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        Throwable throwable3 = throwable;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, throwable3);
                                        }
                                        throw throwable3;
                                    }
                                }
                                this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                                CharacterSet.convertJavaCharsToASCIIBytes(this.charBuf, 0, this.resizableBuffer, 0, this.count, this.asciiStrictConversion);
                                if (this.count < this.currentBufferSize) {
                                    this.endOfStream = true;
                                }
                                if (this.count <= 0) break block20;
                                this.pos = 0;
                                this.lobOffset += (long)this.count;
                                bl2 = bl3 = true;
                                if (!bl) break block21;
                            }
                            catch (SQLException e2) {
                                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, iOException);
                                }
                                throw iOException;
                            }
                            ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, bl3);
                            ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, null);
                        }
                        return bl2;
                    }
                }
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, null);
                }
                return false;
            }
            boolean bl5 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$0, this, throwable4);
            }
            throw throwable;
        }
    }

    protected void ensureOpen() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$1, this, new Object[0]);
            }
            try {
                if (this.closed) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$1, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mark(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void readLimit;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$3, this, n2);
            }
            if (readLimit < 0) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(DatabaseError.findMessage(196, null));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$3, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public void markInternal(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$4, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reset() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                IOException iOException = new IOException(DatabaseError.findMessage(195, null));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$5, this, iOException);
                }
                throw iOException;
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long l2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$6, this, l2);
            }
            this.ensureOpen();
            long start = 0L;
            if ((long)(this.count - this.pos) >= n2) {
                this.pos = (int)((long)this.pos + n2);
                start += n2;
            } else {
                start += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long remainLen = 0L;
                    remainLen = this.clob.length() - this.lobOffset + 1L;
                    if (remainLen >= n2 - start) {
                        this.lobOffset += n2 - start;
                        start += n2 - start;
                    } else {
                        this.lobOffset += remainLen;
                        start += remainLen;
                    }
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$6, this, iOException);
                    }
                    throw iOException;
                }
            }
            long l3 = start;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$6, this, l3);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$6, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, new Object[0]);
            }
            if (this.closed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, null);
                }
                return;
            }
            try {
                PhysicalConnection pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                Monitor.CloseableLock lock = pConnection.acquireCloseableLock();
                try {
                    if (this.charBuf != null) {
                        pConnection.cacheBuffer(this.charBuf);
                        this.charBuf = null;
                    }
                    if (this.resizableBuffer != null) {
                        pConnection.cacheBuffer(this.resizableBuffer);
                        this.resizableBuffer = null;
                    }
                    this.currentBufferSize = 0;
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, throwable3);
                    }
                    throw throwable3;
                }
                if (this.clob != null && this.internalClob) {
                    this.clob.free();
                    this.internalClob = false;
                }
            }
            catch (SQLException e2) {
                try {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, iOException);
                    }
                    throw iOException;
                }
                catch (Throwable throwable) {
                    super.close();
                    Throwable throwable4 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, throwable4);
                    }
                    throw throwable4;
                }
            }
            super.close();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable5 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$7, this, throwable5);
            }
            throw throwable;
        }
    }

    @Override
    public int available() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int prefetchSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.ensureOpen();
            if (this.clob.isActivePrefetch() && (prefetchSize = this.clob.getPrefetchedDataSize()) > 0) {
                if (this.lobOffset == 1L) {
                    int n2 = prefetchSize;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, n2);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, null);
                    }
                    return n2;
                }
                if (this.lobOffset - 1L < (long)prefetchSize) {
                    int n3 = prefetchSize - this.pos;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, null);
                    }
                    return n3;
                }
            }
            int n4 = super.available();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, n4);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$9, this, new Object[0]);
                }
                try {
                    oracleConnection = this.clob.getInternalConnection();
                    if (!bl) break block7;
                }
                catch (Exception exc) {
                    OracleConnection oracleConnection2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$9, this, oracleConnection2);
                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$9, this, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$9, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$9, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleClobInputStream.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$13 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleClobInputStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleClobInputStream.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleClobInputStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleClobInputStream.class.getDeclaredMethod("skip", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleClobInputStream.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleClobInputStream.class.getDeclaredMethod("markInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleClobInputStream.class.getDeclaredMethod("mark", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleClobInputStream.class.getDeclaredMethod("markSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleClobInputStream.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleClobInputStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

