/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class SensitiveScrollableResultSet
extends InsensitiveScrollableResultSet {
    protected long beginLastFetchedIndex;
    protected long endLastFetchedIndex;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    SensitiveScrollableResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$10, null, conn, stmt);
            }
            if (this.fetchedRowCount > 0L) {
                this.beginLastFetchedIndex = 0L;
                this.endLastFetchedIndex = this.fetchedRowCount - 1L;
            } else {
                this.beginLastFetchedIndex = -1L;
                this.endLastFetchedIndex = -1L;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getType() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$0, this, new Object[0]);
            }
            this.ensureOpen("getType");
            int n2 = 1005;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$0, this, n2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$0, this, null);
            }
            return 1005;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            if (!super.next()) break block13;
                            this.handleRefetch();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean first() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            if (!super.first()) break block13;
                            this.handleRefetch();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean last() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            if (!super.last()) break block13;
                            this.handleRefetch();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, n2);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            void row;
                            if (!super.absolute((int)row)) break block13;
                            this.handleRefetch();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$4, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, n2);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            void rows;
                            if (!super.relative((int)rows)) break block13;
                            this.handleRefetch();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$5, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            if (!super.previous()) break block13;
                            this.handleRefetch();
                            boolean bl4 = true;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, null);
                    }
                    return bl3;
                }
                boolean bl5 = false;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$6, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void numberOfRows;
            void firstRow;
            int n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$7, this, l2, n2);
            }
            if ((n3 = super.refreshRows((long)firstRow, (int)numberOfRows)) != 0) {
                this.beginLastFetchedIndex = firstRow;
                this.endLastFetchedIndex = firstRow + (long)n3 - 1L;
            }
            int n4 = n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$7, this, n4);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$7, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$8, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
            try {
                long index = this.currentRow;
                super.removeCurrentRowFromCache();
                if (!this.isEmptyResultSet()) {
                    if (index < this.beginLastFetchedIndex) {
                        --this.beginLastFetchedIndex;
                    }
                    if (index <= this.endLastFetchedIndex) {
                        --this.endLastFetchedIndex;
                    }
                    if (!this.isAfterLast()) {
                        this.handleRefetch();
                    }
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$8, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$8, this, throwable4);
            }
            throw throwable;
        }
    }

    protected boolean handleRefetch() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    boolean bl3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, new Object[0]);
                        }
                        lock = this.connection.acquireCloseableLock();
                        try {
                            if (this.beginLastFetchedIndex > this.currentRow || this.currentRow > this.endLastFetchedIndex) break block13;
                            boolean bl4 = false;
                            if (lock != null) {
                                lock.close();
                            }
                            bl3 = bl4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, null);
                    }
                    return bl3;
                }
                this.refreshRow();
                boolean bl5 = true;
                if (lock != null) {
                    lock.close();
                }
                bl2 = bl5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SensitiveScrollableResultSet.class, $$$methodRef$$$9, this, throwable4);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$10 = SensitiveScrollableResultSet.class.getDeclaredConstructor(PhysicalConnection.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SensitiveScrollableResultSet.class.getDeclaredMethod("handleRefetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SensitiveScrollableResultSet.class.getDeclaredMethod("removeCurrentRowFromCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SensitiveScrollableResultSet.class.getDeclaredMethod("refreshRows", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SensitiveScrollableResultSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SensitiveScrollableResultSet.class.getDeclaredMethod("relative", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SensitiveScrollableResultSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SensitiveScrollableResultSet.class.getDeclaredMethod("last", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SensitiveScrollableResultSet.class.getDeclaredMethod("first", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SensitiveScrollableResultSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SensitiveScrollableResultSet.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

