/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NIOControlPacket;
import oracle.net.ns.NIODataDescriptorPacket;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.NetworkCompressionCodec;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpsNTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class SessionAtts
implements SQLnetDef {
    private static final Predicate<String> IS_PASSWORD;
    private static final Predicate<String> IS_VALID_CONNECTION_ID_PREFIX;
    protected NSProtocol ns;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    private int sdu;
    private int tdu;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;
    boolean noAnoServices;
    int negotiatedOptions;
    public boolean poolEnabled;
    protected byte[] sessionId;
    protected int timeout;
    protected int tick;
    protected byte[] reconnectAddress;
    protected long timestampLastIO;
    protected boolean attemptingReconnect;
    protected String connectData;
    public boolean anoActive;
    protected boolean isLargeSDU;
    protected int negotiatedSDU;
    protected boolean redirecting;
    protected boolean isJavaNetNIO;
    SocketChannel socketChannel;
    public NIONSDataChannel dataChannel;
    NIOMarkerPacket markerPacket;
    NIODataDescriptorPacket ddPacket;
    NIOControlPacket controlPacket;
    NTAdapter.NetworkAdapterType networkType;
    public ByteBuffer readBuffer;
    public ByteBuffer payloadDataBufferForRead;
    ByteBuffer payloadBufferForRead;
    ByteBuffer headerBufferForRead;
    public ByteBuffer writeBuffer;
    public ByteBuffer payloadDataBufferForWrite;
    ByteBuffer payloadBufferForWrite;
    ByteBuffer headerBufferForWrite;
    boolean useNativeBuffers;
    boolean needToReleaseMSGQBuffer;
    private final Properties netProperties;
    String networkCompression;
    ArrayList<String> networkCompressionLevelsArray;
    int networkCompressionThreshold;
    String negotiatedNetworkCompression;
    boolean networkCompressionEnabled;
    int negotiatedNetworkCompressionScheme;
    NetworkCompressionCodec compressionCodec;
    private ByteOrder byteOrder;
    boolean needsToBeClosed;
    boolean isPollAndCheckEnabled;
    static int DEFAULT_POLL_AND_CHECK_TIME_MILLIS;
    final Monitor ntOutputStreamMonitor;
    private final SecuredLogger securedLogger;
    private final String uniqueConnectionId;
    private String netConnectionId;
    private String netConnectionIdPrefix;
    String traceId;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;

    public SessionAtts(NSProtocol nsp, int sdu, int tdu, boolean useNIO, boolean _useNativeBuffers, SecuredLogger securedLogger) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, SessionAtts.class, $$$methodRef$$$41, null, nsp, sdu, tdu, useNIO, _useNativeBuffers, securedLogger);
            }
            this.poolEnabled = false;
            this.attemptingReconnect = false;
            this.isLargeSDU = false;
            this.negotiatedSDU = -1;
            this.redirecting = false;
            this.isJavaNetNIO = false;
            this.readBuffer = null;
            this.payloadDataBufferForRead = null;
            this.payloadBufferForRead = null;
            this.headerBufferForRead = null;
            this.writeBuffer = null;
            this.payloadDataBufferForWrite = null;
            this.payloadBufferForWrite = null;
            this.headerBufferForWrite = null;
            this.useNativeBuffers = false;
            this.needToReleaseMSGQBuffer = false;
            this.netProperties = new Properties();
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            this.ntOutputStreamMonitor = Monitor.newInstance();
            this.sdu = sdu;
            this.tdu = tdu;
            this.ns = nsp;
            this.securedLogger = securedLogger;
            this.anoActive = false;
            this.connected = false;
            this.netConnectionId = this.uniqueConnectionId = this.createUniqueConnectionId();
            if (useNIO) {
                this.dataChannel = new NIONSDataChannel(this);
                this.markerPacket = new NIOMarkerPacket(this);
                this.ddPacket = new NIODataDescriptorPacket(this);
                this.controlPacket = new NIOControlPacket(this);
                this.useNativeBuffers = _useNativeBuffers;
                this.isJavaNetNIO = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, SessionAtts.class, $$$methodRef$$$41, null);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, SessionAtts.class, $$$methodRef$$$41, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, SessionAtts.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    public SecuredLogger getSecuredLogger() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, SessionAtts.class, $$$methodRef$$$0, this, new Object[0]);
            }
            SecuredLogger securedLogger = this.securedLogger;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, SessionAtts.class, $$$methodRef$$$0, this, securedLogger);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SessionAtts.class, $$$methodRef$$$0, this, null);
            }
            return securedLogger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, SessionAtts.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isConnected() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, SessionAtts.class, $$$methodRef$$$1, this, new Object[0]);
            }
            boolean bl2 = this.connected;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, SessionAtts.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SessionAtts.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, SessionAtts.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setNetProperty(String string, String string2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void propertyKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, SessionAtts.class, $$$methodRef$$$2, this, string, string2);
            }
            this.netProperties.setProperty((String)propertyKey, (String)value);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, SessionAtts.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SessionAtts.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, SessionAtts.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getNetProperty(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void propertyKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, SessionAtts.class, $$$methodRef$$$3, this, string);
            }
            String string2 = this.netProperties.getProperty((String)propertyKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, SessionAtts.class, $$$methodRef$$$3, this, string2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SessionAtts.class, $$$methodRef$$$3, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, SessionAtts.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getNetConnectionId() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, SessionAtts.class, $$$methodRef$$$4, this, new Object[0]);
            }
            String string = this.netConnectionId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, SessionAtts.class, $$$methodRef$$$4, this, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SessionAtts.class, $$$methodRef$$$4, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, SessionAtts.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    private String createUniqueConnectionId() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, SessionAtts.class, $$$methodRef$$$5, this, new Object[0]);
                }
                try {
                    UUID uuid = UUID.randomUUID();
                    ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
                    bb.putLong(uuid.getMostSignificantBits());
                    bb.putLong(uuid.getLeastSignificantBits());
                    string = Base64.getEncoder().encodeToString(bb.array());
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    RuntimeException runtimeException = new RuntimeException("Unable to generate ConnectionID to establish Connection", e2);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, SessionAtts.class, $$$methodRef$$$5, this, runtimeException);
                    }
                    throw runtimeException;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, SessionAtts.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SessionAtts.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, SessionAtts.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setNetConnectionIdPrefix(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prefix;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, SessionAtts.class, $$$methodRef$$$6, this, string);
            }
            if (!this.isValidNetConnectionIdPrefix((String)prefix)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid ConnectionId prefix : " + (String)prefix);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, SessionAtts.class, $$$methodRef$$$6, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.netConnectionIdPrefix = prefix;
            this.netConnectionId = prefix == null ? this.uniqueConnectionId : this.netConnectionIdPrefix + this.uniqueConnectionId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, SessionAtts.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SessionAtts.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, SessionAtts.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidNetConnectionIdPrefix(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prefix;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, SessionAtts.class, $$$methodRef$$$7, this, string);
            }
            boolean bl3 = bl2 = prefix == null || IS_VALID_CONNECTION_ID_PREFIX.test((String)prefix);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, SessionAtts.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SessionAtts.class, $$$methodRef$$$7, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, SessionAtts.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getNetProperties() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, SessionAtts.class, $$$methodRef$$$8, this, new Object[0]);
            }
            Properties properties = (Properties)this.netProperties.clone();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, SessionAtts.class, $$$methodRef$$$8, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SessionAtts.class, $$$methodRef$$$8, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, SessionAtts.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initializeNetProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws NetException, IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nsProperties;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, SessionAtts.class, $$$methodRef$$$9, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            nsProperties.stringPropertyNames().stream().filter(IS_PASSWORD.negate()).forEach(arg_0 -> this.lambda$initializeNetProperties$0((Properties)nsProperties, arg_0));
            this.setNetProperty("oracle.jdbc.negotiatedCompressionStatus", "" + this.networkCompressionEnabled);
            this.setNetProperty("oracle.jdbc.negotiatedSDU", "" + this.getSDU());
            this.setNetProperty("oracle.jdbc.negotiatedTDU", "" + this.getTDU());
            this.setNetProperty("oracle.jdbc.connectedNetworkAddress", this.cOption.addr);
            this.setNetProperty("oracle.net.CONNECT_TIMEOUT", "" + this.cOption.transportConnectTimeout);
            this.setNetProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", "" + this.cOption.connectTimeout);
            if (this.nt.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS) {
                this.setNetProperty("oracle.jdbc.negotiatedCipherSuite", (String)this.nt.getOption(105));
            }
            if (this.ano != null) {
                if (this.isChecksumActive) {
                    this.setNetProperty("oracle.jdbc.negotiatedChecksumAlgorithm", this.ano.getDataIntegrityName());
                }
                if (this.isEncryptionActive) {
                    this.setNetProperty("oracle.jdbc.negotiatedEncryptionAlgorithm", this.ano.getEncryptionName());
                }
                if (!this.ano.getAuthenticationAdaptorName().equals("")) {
                    this.setNetProperty("oracle.jdbc.negotiatedAuthenticationAdaptor", this.ano.getAuthenticationAdaptorName());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, SessionAtts.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SessionAtts.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, SessionAtts.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeBuffer(int n2) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, SessionAtts.class, $$$methodRef$$$10, this, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "networkType=" + this.networkType);
            }
            if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                this.initializeBufferForMSGQ();
            } else {
                void sdu;
                if (this.socketChannel instanceof SocketChannelWrapper) {
                    ((SocketChannelWrapper)this.socketChannel).setBufferSize(this.getSDU());
                }
                if (this.useNativeBuffers) {
                    this.setWriteBuffer(ByteBuffer.allocateDirect((int)sdu));
                    this.setReadBuffer(ByteBuffer.allocateDirect((int)sdu));
                } else {
                    this.setWriteBuffer(ByteBuffer.allocate((int)sdu));
                    this.setReadBuffer(ByteBuffer.allocate((int)sdu));
                }
            }
            if (bl) {
                this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "Buffers are initialized. WriteBuffer : " + this.writeBuffer + ", Read Buffer : " + this.readBuffer);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, SessionAtts.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SessionAtts.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, SessionAtts.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initializeBufferForMSGQ() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, SessionAtts.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.writeBuffer != null) {
                MQLNTAdapter.getBufferManager().release(this.writeBuffer);
            }
            this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
            ((MQLNTAdapter)this.nt).setNegotiatedSDUAndTDU(this.sdu, this.tdu);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, SessionAtts.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SessionAtts.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, SessionAtts.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetWriteBuffersForMSGQ() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, SessionAtts.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.writeBuffer = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, SessionAtts.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SessionAtts.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, SessionAtts.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setWriteBuffer(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, SessionAtts.class, $$$methodRef$$$13, this, byteBuffer);
            }
            this.writeBuffer = buffer;
            this.sliceWriteBuffers();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, SessionAtts.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SessionAtts.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, SessionAtts.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setReadBuffer(ByteBuffer byteBuffer) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, SessionAtts.class, $$$methodRef$$$14, this, byteBuffer);
            }
            this.readBuffer = buffer;
            this.sliceReadBuffers();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, SessionAtts.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SessionAtts.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, SessionAtts.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    void releaseWriteBuffer() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, SessionAtts.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (this.writeBuffer == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, SessionAtts.class, $$$methodRef$$$15, this);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SessionAtts.class, $$$methodRef$$$15, this, null);
                }
                return;
            }
            if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                MQLNTAdapter.getBufferManager().release(this.writeBuffer);
            }
            this.writeBuffer = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, SessionAtts.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SessionAtts.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, SessionAtts.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    void sliceWriteBuffers() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, SessionAtts.class, $$$methodRef$$$16, this, new Object[0]);
            }
            this.writeBuffer.clear();
            this.writeBuffer.limit(8);
            this.headerBufferForWrite = this.writeBuffer.slice();
            this.writeBuffer.position(8);
            this.writeBuffer.limit(this.sdu);
            this.payloadBufferForWrite = this.writeBuffer.slice();
            this.writeBuffer.position(10);
            this.payloadDataBufferForWrite = this.writeBuffer.slice();
            this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
            this.payloadDataBufferForWrite.order(this.byteOrder);
            this.writeBuffer.rewind();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, SessionAtts.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, SessionAtts.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, SessionAtts.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    void sliceReadBuffers() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, SessionAtts.class, $$$methodRef$$$17, this, new Object[0]);
            }
            this.readBuffer.position(0);
            this.headerBufferForRead = this.readBuffer.slice();
            if (this.readBuffer.limit() >= 8) {
                this.readBuffer.position(8);
                this.payloadBufferForRead = this.readBuffer.slice();
            }
            if (this.readBuffer.limit() >= 10) {
                this.readBuffer.position(10);
                this.payloadDataBufferForRead = this.readBuffer.slice();
                this.payloadDataBufferForRead.order(this.byteOrder);
                this.payloadBufferForRead.rewind();
            }
            this.readBuffer.rewind();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, SessionAtts.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, SessionAtts.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, SessionAtts.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    public void prepareWriteBuffer() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, SessionAtts.class, $$$methodRef$$$18, this, new Object[0]);
            }
            if (this.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                if (this.writeBuffer != null) {
                    this.sliceWriteBuffers();
                } else {
                    this.setWriteBuffer(MQLNTAdapter.getBufferManager().acquire(this.sdu));
                }
            } else {
                this.payloadDataBufferForWrite.clear();
                this.payloadBufferForWrite.clear();
                this.payloadDataBufferForWrite.limit(this.payloadDataBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
                this.payloadBufferForWrite.limit(this.payloadBufferForWrite.capacity() - this.dataChannel.getDataExpansionByteSize());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, SessionAtts.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, SessionAtts.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, SessionAtts.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public ByteOrder getByteOrder() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, SessionAtts.class, $$$methodRef$$$19, this, new Object[0]);
            }
            ByteOrder byteOrder = this.byteOrder;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, SessionAtts.class, $$$methodRef$$$19, this, byteOrder);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SessionAtts.class, $$$methodRef$$$19, this, null);
            }
            return byteOrder;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, SessionAtts.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setByteOrder(ByteOrder byteOrder) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newByteOrder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, SessionAtts.class, $$$methodRef$$$20, this, byteOrder);
            }
            this.byteOrder = newByteOrder;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, SessionAtts.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, SessionAtts.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, SessionAtts.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSDU(int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sdu;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, SessionAtts.class, $$$methodRef$$$21, this, n2);
            }
            this.sdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (sdu <= 0 ? 65518 : (sdu > 65518 ? 65518 : (sdu < 512 ? 512 : sdu))) : (sdu <= 0 ? 8192 : (sdu > 0x200000 ? 0x200000 : (sdu < 512 ? 512 : sdu)));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, SessionAtts.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, SessionAtts.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, SessionAtts.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getSDU() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, SessionAtts.class, $$$methodRef$$$22, this, new Object[0]);
            }
            int n2 = this.sdu;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, SessionAtts.class, $$$methodRef$$$22, this, n2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, SessionAtts.class, $$$methodRef$$$22, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, SessionAtts.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTDU(int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tdu;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, SessionAtts.class, $$$methodRef$$$23, this, n2);
            }
            this.tdu = this.networkType == NTAdapter.NetworkAdapterType.MSGQ ? (tdu <= 0 ? 65518 : (tdu > 65518 ? 65518 : (tdu < 255 ? 255 : tdu))) : (tdu <= 0 ? 0x200000 : (tdu > 0x200000 ? 0x200000 : (tdu < 255 ? 255 : tdu)));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, SessionAtts.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, SessionAtts.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, SessionAtts.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getTDU() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, SessionAtts.class, $$$methodRef$$$24, this, new Object[0]);
            }
            int n2 = this.tdu;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, SessionAtts.class, $$$methodRef$$$24, this, n2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, SessionAtts.class, $$$methodRef$$$24, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, SessionAtts.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setNegotiatedSDUAndTDU(int n2, int n3) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sdu;
            void tdu;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, SessionAtts.class, $$$methodRef$$$25, this, n2, n3);
            }
            this.setTDU((int)tdu);
            if (tdu < sdu) {
                this.setSDU((int)tdu);
            } else {
                this.setSDU((int)sdu);
            }
            this.negotiatedSDU = this.sdu;
            this.initializeBuffer(this.getSDU());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, SessionAtts.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, SessionAtts.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, SessionAtts.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    public NTAdapter getNTAdapter() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, SessionAtts.class, $$$methodRef$$$26, this, new Object[0]);
            }
            NTAdapter nTAdapter = this.nt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, SessionAtts.class, $$$methodRef$$$26, this, nTAdapter);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, SessionAtts.class, $$$methodRef$$$26, this, null);
            }
            return nTAdapter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, SessionAtts.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    void renegotiateSSLSession() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, SessionAtts.class, $$$methodRef$$$27, this, new Object[0]);
            }
            ((TcpsNTAdapter)this.nt).renegotiateSession();
            if (this.isJavaNetNIO) {
                this.socketChannel = this.nt.getSocketChannel();
            } else {
                this.ntInputStream = this.nt.getInputStream();
                this.ntOutputStream = this.nt.getOutputStream();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, SessionAtts.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, SessionAtts.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, SessionAtts.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
    }

    /*
     * WARNING - void declaration
     */
    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void anoOut;
            void anoIn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, SessionAtts.class, $$$methodRef$$$28, this, netInputStream, netOutputStream);
            }
            if (anoIn == null || anoOut == null) {
                NetException netException = new NetException(300);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, SessionAtts.class, $$$methodRef$$$28, this, netException);
                }
                throw netException;
            }
            this.nsInputStream = anoIn;
            this.nsOutputStream = anoOut;
            this.anoActive = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, SessionAtts.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, SessionAtts.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, SessionAtts.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void turnEncryptionOn(NIONSDataChannel nIONSDataChannel) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dataChannel;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, SessionAtts.class, $$$methodRef$$$29, this, nIONSDataChannel);
            }
            if (dataChannel == null) {
                NetException netException = new NetException(300);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, SessionAtts.class, $$$methodRef$$$29, this, netException);
                }
                throw netException;
            }
            this.dataChannel = dataChannel;
            this.anoActive = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, SessionAtts.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, SessionAtts.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, SessionAtts.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getANOFlags() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, SessionAtts.class, $$$methodRef$$$30, this, new Object[0]);
            }
            int flags = 1;
            if (this.ano != null) {
                flags = this.ano.getNAFlags();
            }
            int n2 = flags;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, SessionAtts.class, $$$methodRef$$$30, this, n2);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, SessionAtts.class, $$$methodRef$$$30, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, SessionAtts.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    public OutputStream getOutputStream() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, SessionAtts.class, $$$methodRef$$$31, this, new Object[0]);
            }
            NetOutputStream netOutputStream = this.nsOutputStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, SessionAtts.class, $$$methodRef$$$31, this, netOutputStream);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, SessionAtts.class, $$$methodRef$$$31, this, null);
            }
            return netOutputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, SessionAtts.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    public InputStream getInputStream() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, SessionAtts.class, $$$methodRef$$$32, this, new Object[0]);
            }
            NetInputStream netInputStream = this.nsInputStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, SessionAtts.class, $$$methodRef$$$32, this, netInputStream);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, SessionAtts.class, $$$methodRef$$$32, this, null);
            }
            return netInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, SessionAtts.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setNegotiatedOptions(int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, SessionAtts.class, $$$methodRef$$$33, this, n2);
            }
            this.negotiatedOptions = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, SessionAtts.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, SessionAtts.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, SessionAtts.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getNegotiatedOptions() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, SessionAtts.class, $$$methodRef$$$34, this, new Object[0]);
            }
            int n2 = this.negotiatedOptions;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, SessionAtts.class, $$$methodRef$$$34, this, n2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, SessionAtts.class, $$$methodRef$$$34, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, SessionAtts.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public ConnOption getcOption() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, SessionAtts.class, $$$methodRef$$$35, this, new Object[0]);
            }
            ConnOption connOption = this.cOption;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, SessionAtts.class, $$$methodRef$$$35, this, connOption);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, SessionAtts.class, $$$methodRef$$$35, this, null);
            }
            return connOption;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, SessionAtts.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setConnectData(String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, SessionAtts.class, $$$methodRef$$$36, this, string);
            }
            this.connectData = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, SessionAtts.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, SessionAtts.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, SessionAtts.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    String getConnectData() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, SessionAtts.class, $$$methodRef$$$37, this, new Object[0]);
            }
            String string = this.connectData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, SessionAtts.class, $$$methodRef$$$37, this, string);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, SessionAtts.class, $$$methodRef$$$37, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, SessionAtts.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isExpediatedAttentionEnabled() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, SessionAtts.class, $$$methodRef$$$38, this, new Object[0]);
            }
            boolean bl3 = bl2 = (this.negotiatedOptions & 0x400) == 1024;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, SessionAtts.class, $$$methodRef$$$38, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, SessionAtts.class, $$$methodRef$$$38, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, SessionAtts.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean isAttentionProcessingEnabled() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, SessionAtts.class, $$$methodRef$$$39, this, new Object[0]);
            }
            boolean bl3 = bl2 = (this.negotiatedOptions & 0x800) != 2048;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, SessionAtts.class, $$$methodRef$$$39, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, SessionAtts.class, $$$methodRef$$$39, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, SessionAtts.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$initializeNetProperties$0(Properties properties, String string) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nsProperties;
            void key;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, SessionAtts.class, $$$methodRef$$$40, this, properties, string);
            }
            this.netProperties.put((Object)key, nsProperties.get(key));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, SessionAtts.class, $$$methodRef$$$40, this);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, SessionAtts.class, $$$methodRef$$$40, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, SessionAtts.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$41 = SessionAtts.class.getDeclaredConstructor(NSProtocol.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$40 = SessionAtts.class.getDeclaredMethod("lambda$initializeNetProperties$0", Properties.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$39 = SessionAtts.class.getDeclaredMethod("isAttentionProcessingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$38 = SessionAtts.class.getDeclaredMethod("isExpediatedAttentionEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$37 = SessionAtts.class.getDeclaredMethod("getConnectData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$36 = SessionAtts.class.getDeclaredMethod("setConnectData", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$35 = SessionAtts.class.getDeclaredMethod("getcOption", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$34 = SessionAtts.class.getDeclaredMethod("getNegotiatedOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$33 = SessionAtts.class.getDeclaredMethod("setNegotiatedOptions", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$32 = SessionAtts.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$31 = SessionAtts.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$30 = SessionAtts.class.getDeclaredMethod("getANOFlags", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$29 = SessionAtts.class.getDeclaredMethod("turnEncryptionOn", NIONSDataChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$28 = SessionAtts.class.getDeclaredMethod("turnEncryptionOn", NetInputStream.class, NetOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$27 = SessionAtts.class.getDeclaredMethod("renegotiateSSLSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$26 = SessionAtts.class.getDeclaredMethod("getNTAdapter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$25 = SessionAtts.class.getDeclaredMethod("setNegotiatedSDUAndTDU", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$24 = SessionAtts.class.getDeclaredMethod("getTDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$23 = SessionAtts.class.getDeclaredMethod("setTDU", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$22 = SessionAtts.class.getDeclaredMethod("getSDU", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$21 = SessionAtts.class.getDeclaredMethod("setSDU", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$20 = SessionAtts.class.getDeclaredMethod("setByteOrder", ByteOrder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = SessionAtts.class.getDeclaredMethod("getByteOrder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = SessionAtts.class.getDeclaredMethod("prepareWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = SessionAtts.class.getDeclaredMethod("sliceReadBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = SessionAtts.class.getDeclaredMethod("sliceWriteBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = SessionAtts.class.getDeclaredMethod("releaseWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = SessionAtts.class.getDeclaredMethod("setReadBuffer", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = SessionAtts.class.getDeclaredMethod("setWriteBuffer", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = SessionAtts.class.getDeclaredMethod("resetWriteBuffersForMSGQ", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = SessionAtts.class.getDeclaredMethod("initializeBufferForMSGQ", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = SessionAtts.class.getDeclaredMethod("initializeBuffer", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = SessionAtts.class.getDeclaredMethod("initializeNetProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = SessionAtts.class.getDeclaredMethod("getNetProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = SessionAtts.class.getDeclaredMethod("isValidNetConnectionIdPrefix", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = SessionAtts.class.getDeclaredMethod("setNetConnectionIdPrefix", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = SessionAtts.class.getDeclaredMethod("createUniqueConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = SessionAtts.class.getDeclaredMethod("getNetConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = SessionAtts.class.getDeclaredMethod("getNetProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = SessionAtts.class.getDeclaredMethod("setNetProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = SessionAtts.class.getDeclaredMethod("isConnected", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = SessionAtts.class.getDeclaredMethod("getSecuredLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        IS_PASSWORD = Pattern.compile(".*password.*", 2).asPredicate();
        IS_VALID_CONNECTION_ID_PREFIX = Pattern.compile("[A-z0-9,_]{8}").asPredicate();
        DEFAULT_POLL_AND_CHECK_TIME_MILLIS = 60000;
    }
}

