/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetFactory;
import oracle.sql.CharacterSetFactoryDefault;
import oracle.sql.CharacterSetFactoryThin;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverterFactoryOGS;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_DATUM})
public abstract class CharacterSet {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short US7ASCII_CHARSET = 1;
    public static final short WE8DEC_CHARSET = 2;
    public static final short WE8HP_CHARSET = 3;
    public static final short US8PC437_CHARSET = 4;
    public static final short WE8EBCDIC37_CHARSET = 5;
    public static final short WE8EBCDIC500_CHARSET = 6;
    public static final short WE8EBCDIC285_CHARSET = 8;
    public static final short WE8PC850_CHARSET = 10;
    public static final short D7DEC_CHARSET = 11;
    public static final short F7DEC_CHARSET = 12;
    public static final short S7DEC_CHARSET = 13;
    public static final short E7DEC_CHARSET = 14;
    public static final short SF7ASCII_CHARSET = 15;
    public static final short NDK7DEC_CHARSET = 16;
    public static final short I7DEC_CHARSET = 17;
    public static final short NL7DEC_CHARSET = 18;
    public static final short CH7DEC_CHARSET = 19;
    public static final short YUG7ASCII_CHARSET = 20;
    public static final short SF7DEC_CHARSET = 21;
    public static final short TR7DEC_CHARSET = 22;
    public static final short IW7IS960_CHARSET = 23;
    public static final short IN8ISCII_CHARSET = 25;
    public static final short WE8ISO8859P1_CHARSET = 31;
    public static final short EE8ISO8859P2_CHARSET = 32;
    public static final short SE8ISO8859P3_CHARSET = 33;
    public static final short NEE8ISO8859P4_CHARSET = 34;
    public static final short CL8ISO8859P5_CHARSET = 35;
    public static final short AR8ISO8859P6_CHARSET = 36;
    public static final short EL8ISO8859P7_CHARSET = 37;
    public static final short IW8ISO8859P8_CHARSET = 38;
    public static final short WE8ISO8859P9_CHARSET = 39;
    public static final short NE8ISO8859P10_CHARSET = 40;
    public static final short TH8TISASCII_CHARSET = 41;
    public static final short TH8TISEBCDIC_CHARSET = 42;
    public static final short BN8BSCII_CHARSET = 43;
    public static final short VN8VN3_CHARSET = 44;
    public static final short VN8MSWIN1258_CHARSET = 45;
    public static final short WE8ISO8859P15_CHARSET = 46;
    public static final short WE8NEXTSTEP_CHARSET = 50;
    public static final short AR8ASMO708PLUS_CHARSET = 61;
    public static final short AR8EBCDICX_CHARSET = 70;
    public static final short AR8XBASIC_CHARSET = 72;
    public static final short EL8DEC_CHARSET = 81;
    public static final short TR8DEC_CHARSET = 82;
    public static final short WE8EBCDIC37C_CHARSET = 90;
    public static final short WE8EBCDIC500C_CHARSET = 91;
    public static final short IW8EBCDIC424_CHARSET = 92;
    public static final short TR8EBCDIC1026_CHARSET = 93;
    public static final short WE8EBCDIC871_CHARSET = 94;
    public static final short WE8EBCDIC284_CHARSET = 95;
    public static final short WE8EBCDIC1047_CHARSET = 96;
    public static final short EEC8EUROASCI_CHARSET = 110;
    public static final short EEC8EUROPA3_CHARSET = 113;
    public static final short LA8PASSPORT_CHARSET = 114;
    public static final short BG8PC437S_CHARSET = 140;
    public static final short EE8PC852_CHARSET = 150;
    public static final short RU8PC866_CHARSET = 152;
    public static final short RU8BESTA_CHARSET = 153;
    public static final short IW8PC1507_CHARSET = 154;
    public static final short RU8PC855_CHARSET = 155;
    public static final short TR8PC857_CHARSET = 156;
    public static final short CL8MACCYRILLIC_CHARSET = 158;
    public static final short CL8MACCYRILLICS_CHARSET = 159;
    public static final short WE8PC860_CHARSET = 160;
    public static final short IS8PC861_CHARSET = 161;
    public static final short EE8MACCES_CHARSET = 162;
    public static final short EE8MACCROATIANS_CHARSET = 163;
    public static final short TR8MACTURKISHS_CHARSET = 164;
    public static final short IS8MACICELANDICS_CHARSET = 165;
    public static final short EL8MACGREEKS_CHARSET = 166;
    public static final short IW8MACHEBREWS_CHARSET = 167;
    public static final short EE8MSWIN1250_CHARSET = 170;
    public static final short CL8MSWIN1251_CHARSET = 171;
    public static final short ET8MSWIN923_CHARSET = 172;
    public static final short BG8MSWIN_CHARSET = 173;
    public static final short EL8MSWIN1253_CHARSET = 174;
    public static final short IW8MSWIN1255_CHARSET = 175;
    public static final short LT8MSWIN921_CHARSET = 176;
    public static final short TR8MSWIN1254_CHARSET = 177;
    public static final short WE8MSWIN1252_CHARSET = 178;
    public static final short BLT8MSWIN1257_CHARSET = 179;
    public static final short D8EBCDIC273_CHARSET = 180;
    public static final short I8EBCDIC280_CHARSET = 181;
    public static final short DK8EBCDIC277_CHARSET = 182;
    public static final short S8EBCDIC278_CHARSET = 183;
    public static final short EE8EBCDIC870_CHARSET = 184;
    public static final short CL8EBCDIC1025_CHARSET = 185;
    public static final short F8EBCDIC297_CHARSET = 186;
    public static final short IW8EBCDIC1086_CHARSET = 187;
    public static final short CL8EBCDIC1025X_CHARSET = 188;
    public static final short N8PC865_CHARSET = 190;
    public static final short BLT8CP921_CHARSET = 191;
    public static final short LV8PC1117_CHARSET = 192;
    public static final short LV8PC8LR_CHARSET = 193;
    public static final short BLT8EBCDIC1112_CHARSET = 194;
    public static final short LV8RST104090_CHARSET = 195;
    public static final short CL8KOI8R_CHARSET = 196;
    public static final short BLT8PC775_CHARSET = 197;
    public static final short F7SIEMENS9780X_CHARSET = 201;
    public static final short E7SIEMENS9780X_CHARSET = 202;
    public static final short S7SIEMENS9780X_CHARSET = 203;
    public static final short DK7SIEMENS9780X_CHARSET = 204;
    public static final short N7SIEMENS9780X_CHARSET = 205;
    public static final short I7SIEMENS9780X_CHARSET = 206;
    public static final short D7SIEMENS9780X_CHARSET = 207;
    public static final short WE8GCOS7_CHARSET = 210;
    public static final short EL8GCOS7_CHARSET = 211;
    public static final short US8BS2000_CHARSET = 221;
    public static final short D8BS2000_CHARSET = 222;
    public static final short F8BS2000_CHARSET = 223;
    public static final short E8BS2000_CHARSET = 224;
    public static final short DK8BS2000_CHARSET = 225;
    public static final short S8BS2000_CHARSET = 226;
    public static final short WE8BS2000_CHARSET = 231;
    public static final short CL8BS2000_CHARSET = 235;
    public static final short WE8BS2000L5_CHARSET = 239;
    public static final short WE8DG_CHARSET = 241;
    public static final short WE8NCR4970_CHARSET = 251;
    public static final short WE8ROMAN8_CHARSET = 261;
    public static final short EE8MACCE_CHARSET = 262;
    public static final short EE8MACCROATIAN_CHARSET = 263;
    public static final short TR8MACTURKISH_CHARSET = 264;
    public static final short IS8MACICELANDIC_CHARSET = 265;
    public static final short EL8MACGREEK_CHARSET = 266;
    public static final short IW8MACHEBREW_CHARSET = 267;
    public static final short US8ICL_CHARSET = 277;
    public static final short WE8ICL_CHARSET = 278;
    public static final short WE8ISOICLUK_CHARSET = 279;
    public static final short WE8MACROMAN8_CHARSET = 351;
    public static final short WE8MACROMAN8S_CHARSET = 352;
    public static final short TH8MACTHAI_CHARSET = 353;
    public static final short TH8MACTHAIS_CHARSET = 354;
    public static final short HU8CWI2_CHARSET = 368;
    public static final short EL8PC437S_CHARSET = 380;
    public static final short EL8EBCDIC875_CHARSET = 381;
    public static final short EL8PC737_CHARSET = 382;
    public static final short LT8PC772_CHARSET = 383;
    public static final short LT8PC774_CHARSET = 384;
    public static final short EL8PC869_CHARSET = 385;
    public static final short EL8PC851_CHARSET = 386;
    public static final short CDN8PC863_CHARSET = 390;
    public static final short HU8ABMOD_CHARSET = 401;
    public static final short AR8ASMO8X_CHARSET = 500;
    public static final short AR8NAFITHA711T_CHARSET = 504;
    public static final short AR8SAKHR707T_CHARSET = 505;
    public static final short AR8MUSSAD768T_CHARSET = 506;
    public static final short AR8ADOS710T_CHARSET = 507;
    public static final short AR8ADOS720T_CHARSET = 508;
    public static final short AR8APTEC715T_CHARSET = 509;
    public static final short AR8NAFITHA721T_CHARSET = 511;
    public static final short AR8HPARABIC8T_CHARSET = 514;
    public static final short AR8NAFITHA711_CHARSET = 554;
    public static final short AR8SAKHR707_CHARSET = 555;
    public static final short AR8MUSSAD768_CHARSET = 556;
    public static final short AR8ADOS710_CHARSET = 557;
    public static final short AR8ADOS720_CHARSET = 558;
    public static final short AR8APTEC715_CHARSET = 559;
    public static final short AR8MSAWIN_CHARSET = 560;
    public static final short AR8NAFITHA721_CHARSET = 561;
    public static final short AR8SAKHR706_CHARSET = 563;
    public static final short AR8ARABICMAC_CHARSET = 565;
    public static final short AR8ARABICMACS_CHARSET = 566;
    public static final short AR8ARABICMACT_CHARSET = 567;
    public static final short LA8ISO6937_CHARSET = 590;
    public static final short US8NOOP_CHARSET = 797;
    public static final short WE8DECTST_CHARSET = 798;
    public static final short JA16VMS_CHARSET = 829;
    public static final short JA16EUC_CHARSET = 830;
    public static final short JA16EUCYEN_CHARSET = 831;
    public static final short JA16SJIS_CHARSET = 832;
    public static final short JA16DBCS_CHARSET = 833;
    public static final short JA16SJISYEN_CHARSET = 834;
    public static final short JA16EBCDIC930_CHARSET = 835;
    public static final short JA16MACSJIS_CHARSET = 836;
    public static final short JA16EUCTILDE_CHARSET = 837;
    public static final short JA16SJISTILDE_CHARSET = 838;
    public static final short KO16KSC5601_CHARSET = 840;
    public static final short KO16DBCS_CHARSET = 842;
    public static final short KO16KSCCS_CHARSET = 845;
    public static final short KO16MSWIN949_CHARSET = 846;
    public static final short ZHS16CGB231280_CHARSET = 850;
    public static final short ZHS16MACCGB231280_CHARSET = 851;
    public static final short ZHS16GBK_CHARSET = 852;
    public static final short ZHS16DBCS_CHARSET = 853;
    public static final short ZHS32GB18030_CHARSET = 854;
    public static final short ZHT32EUC_CHARSET = 860;
    public static final short ZHT32SOPS_CHARSET = 861;
    public static final short ZHT16DBT_CHARSET = 862;
    public static final short ZHT32TRIS_CHARSET = 863;
    public static final short ZHT16DBCS_CHARSET = 864;
    public static final short ZHT16BIG5_CHARSET = 865;
    public static final short ZHT16CCDC_CHARSET = 866;
    public static final short ZHT16MSWIN950_CHARSET = 867;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short UTFE_CHARSET = 872;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short KO16TSTSET_CHARSET = 996;
    public static final short JA16TSTSET2_CHARSET = 997;
    public static final short JA16TSTSET_CHARSET = 998;
    public static final short US16TSTFIXED_CHARSET = 1001;
    public static final short AL16UTF16_CHARSET = 2000;
    public static final short AL16UTF16LE_CHARSET = 2002;
    public static final short TH8TISEBCDICS_CHARSET = 319;
    public static final short BLT8EBCDIC1112S_CHARSET = 314;
    public static final short CE8BS2000_CHARSET = 233;
    public static final short CL8EBCDIC1025R_CHARSET = 323;
    public static final short CL8EBCDIC1158R_CHARSET = 326;
    public static final short D8EBCDIC1141_CHARSET = 189;
    public static final short DK8EBCDIC1142_CHARSET = 198;
    public static final short EE8BS2000_CHARSET = 232;
    public static final short EE8EBCDIC870S_CHARSET = 316;
    public static final short EL8EBCDIC423R_CHARSET = 327;
    public static final short EL8EBCDIC875S_CHARSET = 311;
    public static final short EL8EBCDIC875R_CHARSET = 324;
    public static final short F8EBCDIC1147_CHARSET = 208;
    public static final short I8EBCDIC1144_CHARSET = 200;
    public static final short WE8BS2000E_CHARSET = 230;
    public static final short WE8EBCDIC1047E_CHARSET = 100;
    public static final short WE8EBCDIC1140_CHARSET = 7;
    public static final short WE8EBCDIC1145_CHARSET = 98;
    public static final short WE8EBCDIC1146_CHARSET = 9;
    public static final short WE8EBCDIC1148_CHARSET = 27;
    public static final short AR8EBCDIC420S_CHARSET = 320;
    public static final short IW8EBCDIC424S_CHARSET = 315;
    public static final short TR8EBCDIC1026S_CHARSET = 312;
    public static final short ZHT16HKSCS_CHARSET = 868;
    public static final short BLT8ISO8859P13_CHARSET = 47;
    public static final short AR8MSWIN1256_CHARSET = 560;
    public static final short S8EBCDIC1143_CHARSET = 199;
    public static final short ZHT16HKSCS31_CHARSET = 992;
    public static final short AZ8ISO8859P9E_CHARSET = 52;
    public static final short CEL8ISO8859P14_CHARSET = 48;
    public static final short CL8ISOIR111_CHARSET = 49;
    public static final short CL8KOI8U_CHARSET = 51;
    public static final short WE8PC858_CHARSET = 28;
    public static final short CL8EBCDIC1025C_CHARSET = 322;
    public static final short CL8EBCDIC1025S_CHARSET = 317;
    public static final short CL8EBCDIC1158_CHARSET = 325;
    public static final short EE8EBCDIC870C_CHARSET = 301;
    public static final short WE8EBCDIC924_CHARSET = 101;
    public static final short WE8EBCDIC1140C_CHARSET = 97;
    public static final short WE8EBCDIC1148C_CHARSET = 99;
    public static final short UNICODE_2_CHARSET = 871;
    private static CharacterSet asciiCharSet;
    static CharacterSetFactory factory;
    private int oracleId;
    int rep;
    static final ConcurrentHashMap<Integer, CharacterSet> CHARACTERSET_MAP;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;

    CharacterSet(int oracleId) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, CharacterSet.class, $$$methodRef$$$65, null, oracleId);
            }
            this.oracleId = oracleId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, CharacterSet.class, $$$methodRef$$$65, null);
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, CharacterSet.class, $$$methodRef$$$65, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, CharacterSet.class, $$$methodRef$$$65, null, throwable2);
            }
            throw throwable;
        }
    }

    public static CharacterSet make(int n2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int oracleId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSet.class, $$$methodRef$$$0, null, n2);
            }
            if (factory instanceof CharacterSetFactoryThin) {
                CharacterSet characterSet = CHARACTERSET_MAP.computeIfAbsent(oracleId, factory::make);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSet.class, $$$methodRef$$$0, null, characterSet);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSet.class, $$$methodRef$$$0, null, null);
                }
                return characterSet;
            }
            CharacterSet characterSet = factory.make(oracleId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSet.class, $$$methodRef$$$0, null, characterSet);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSet.class, $$$methodRef$$$0, null, null);
            }
            return characterSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSet.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return CharacterSetNamesMapHolder.ID_TO_NAME_MAP.get((short)this.oracleId);
    }

    public abstract boolean isLossyFrom(CharacterSet var1);

    public abstract boolean isConvertibleFrom(CharacterSet var1);

    public boolean isUnicode() {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSet.class, $$$methodRef$$$1, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSet.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSet.class, $$$methodRef$$$1, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isWellFormed(byte[] byArray, int n2, int n3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSet.class, $$$methodRef$$$2, this, byArray, n2, n3);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSet.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSet.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getOracleId() {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSet.class, $$$methodRef$$$3, this, new Object[0]);
            }
            int n2 = this.oracleId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSet.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSet.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSet.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    int getRep() {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CharacterSet.class, $$$methodRef$$$4, this, new Object[0]);
            }
            int n2 = this.rep;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CharacterSet.class, $$$methodRef$$$4, this, n2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSet.class, $$$methodRef$$$4, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSet.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getRatioTo(CharacterSet characterSet) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CharacterSet.class, $$$methodRef$$$5, this, characterSet);
            }
            Error error = new Error("oracle.sql.CharacterSet.getRationTo Not Implemented");
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, CharacterSet.class, $$$methodRef$$$5, this, error);
            }
            throw error;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public boolean equals(Object rhs) {
        return rhs == this || rhs instanceof CharacterSet && this.oracleId == ((CharacterSet)rhs).oracleId;
    }

    @DisableTrace
    public int hashCode() {
        return this.oracleId;
    }

    public abstract String toStringWithReplacement(byte[] var1, int var2, int var3);

    @DisableTrace
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        String str = this.toStringWithReplacement(bytes, offset, count);
        byte[] copy = this.convert(str);
        if (count != copy.length) {
            CharacterSet.failCharacterConversion(this);
        }
        for (int x2 = 0; x2 < count; ++x2) {
            if (copy[x2] == bytes[offset + x2]) continue;
            CharacterSet.failCharacterConversion(this);
        }
        return null;
    }

    public abstract byte[] convert(String var1) throws SQLException;

    public abstract byte[] convertWithReplacement(String var1);

    /*
     * WARNING - void declaration
     */
    public byte[] convertWithReplacement(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void charOffset;
            void chars;
            byte[] tempBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CharacterSet.class, $$$methodRef$$$6, this, cArray, n2, byArray, n3, nArray);
            }
            if ((tempBytes = this.convertWithReplacement(new String((char[])chars, (int)charOffset, (int)nchars[0]))) != null) {
                void bytes;
                nchars[0] = tempBytes.length;
                if (bytes != null) {
                    void byteOffset;
                    System.arraycopy(tempBytes, 0, bytes, (int)byteOffset, tempBytes.length);
                    void var8_8 = bytes;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterSet.class, $$$methodRef$$$6, this, var8_8);
                        ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSet.class, $$$methodRef$$$6, this, null);
                    }
                    return var8_8;
                }
            }
            byte[] byArray2 = tempBytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterSet.class, $$$methodRef$$$6, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSet.class, $$$methodRef$$$6, this, null);
            }
            return tempBytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSet.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public abstract byte[] convert(CharacterSet var1, byte[] var2, int var3, int var4) throws SQLException;

    /*
     * WARNING - void declaration
     */
    public byte[] convertUnshared(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            void source;
            void from;
            byte[] result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, CharacterSet.class, $$$methodRef$$$7, this, characterSet, byArray, n2, n3);
            }
            if ((result = this.convert((CharacterSet)from, (byte[])source, (int)offset, (int)count)) == source) {
                result = new byte[((void)source).length];
                System.arraycopy(source, 0, result, 0, (int)count);
            }
            byte[] byArray2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, CharacterSet.class, $$$methodRef$$$7, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterSet.class, $$$methodRef$$$7, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterSet.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract int decode(CharacterWalker var1) throws SQLException;

    abstract void encode(CharacterBuffer var1, int var2) throws SQLException;

    static final void failCharacterConversion(CharacterSet characterSet) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            CharacterSet which;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, CharacterSet.class, $$$methodRef$$$8, null, characterSet);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(55, which).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, CharacterSet.class, $$$methodRef$$$8, null, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterSet.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] useOrCopy(byte[] byArray, int n2, int n3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] result;
            void offset;
            void count;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, CharacterSet.class, $$$methodRef$$$9, null, byArray, n2, n3);
            }
            if (bytes.length == count && offset == false) {
                result = bytes;
            } else {
                result = new byte[count];
                System.arraycopy(bytes, (int)offset, result, 0, (int)count);
            }
            byte[] byArray2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CharacterSet.class, $$$methodRef$$$9, null, byArray2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterSet.class, $$$methodRef$$$9, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterSet.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final void need(CharacterBuffer characterBuffer, int n2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int wanted;
            CharacterBuffer buffer;
            void n3;
            void needed;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, CharacterSet.class, $$$methodRef$$$10, null, characterBuffer, n2);
            }
            if ((needed = n3 + buffer.next) <= (wanted = buffer.bytes.length)) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CharacterSet.class, $$$methodRef$$$10, null);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSet.class, $$$methodRef$$$10, null, null);
                }
                return;
            }
            while (needed > wanted) {
                wanted = 2 * wanted;
            }
            byte[] old = buffer.bytes;
            buffer.bytes = new byte[wanted];
            System.arraycopy(old, 0, buffer.bytes, 0, buffer.next);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CharacterSet.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSet.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSet.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String UTFToString(byte[] byArray, int n2, int n3, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void useReplacementChar;
            void nbytes;
            void offset;
            byte[] bytes;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, CharacterSet.class, $$$methodRef$$$11, null, byArray, n2, n3, bl);
            }
            String string = new String(CharacterSet.UTFToJavaChar(bytes, (int)offset, (int)nbytes, (boolean)useReplacementChar));
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, CharacterSet.class, $$$methodRef$$$11, null, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterSet.class, $$$methodRef$$$11, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterSet.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String UTFToString(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nbytes;
            void offset;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, CharacterSet.class, $$$methodRef$$$12, null, byArray, n2, n3);
            }
            String string = CharacterSet.UTFToString(bytes, (int)offset, (int)nbytes, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, CharacterSet.class, $$$methodRef$$$12, null, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CharacterSet.class, $$$methodRef$$$12, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CharacterSet.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final char[] UTFToJavaChar(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, CharacterSet.class, $$$methodRef$$$13, null, byArray, n2, n3);
            }
            char[] cArray = CharacterSet.UTFToJavaChar(bytes, (int)offset, (int)count, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, CharacterSet.class, $$$methodRef$$$13, null, cArray);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, CharacterSet.class, $$$methodRef$$$13, null, null);
            }
            return cArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, CharacterSet.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final char[] UTFToJavaChar(byte[] byArray, int n2, int n3, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void useReplacementChar;
            void offset;
            byte[] bytes;
            void count;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, CharacterSet.class, $$$methodRef$$$14, null, byArray, n2, n3, bl);
            }
            char[] chars = null;
            chars = new char[count];
            int[] countArr = new int[]{count};
            int chars_index = CharacterSet.convertUTFBytesToJavaChars(bytes, (int)offset, chars, 0, countArr, (boolean)useReplacementChar);
            char[] rchars = new char[chars_index];
            System.arraycopy(chars, 0, rchars, 0, chars_index);
            chars = null;
            char[] cArray = rchars;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, CharacterSet.class, $$$methodRef$$$14, null, cArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CharacterSet.class, $$$methodRef$$$14, null, null);
            }
            return rchars;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, CharacterSet.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final char[] UTFToJavaCharWithReplacement(byte[] byArray, int n2, int n3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char[] rchars;
            block7: {
                char[] cArray;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, CharacterSet.class, $$$methodRef$$$15, null, byArray, n2, n3);
                }
                char[] chars = null;
                try {
                    void offset;
                    byte[] bytes;
                    void count;
                    chars = new char[count];
                    int[] countArr = new int[]{count};
                    int chars_index = CharacterSet.convertUTFBytesToJavaChars(bytes, (int)offset, chars, 0, countArr, true);
                    rchars = new char[chars_index];
                    System.arraycopy(chars, 0, rchars, 0, chars_index);
                    chars = null;
                    cArray = rchars;
                    if (!bl) break block7;
                }
                catch (SQLException e2) {
                    IllegalStateException illegalStateException = new IllegalStateException(e2.getMessage());
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, CharacterSet.class, $$$methodRef$$$15, null, illegalStateException);
                    }
                    throw illegalStateException;
                }
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, CharacterSet.class, $$$methodRef$$$15, null, cArray);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, CharacterSet.class, $$$methodRef$$$15, null, null);
            }
            return rchars;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, CharacterSet.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertUTFBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void convertWithReplacement;
            void countArr;
            void chars_offset;
            void chars;
            void offset;
            byte[] bytes;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, CharacterSet.class, $$$methodRef$$$16, null, byArray, n2, cArray, n3, nArray, bl);
            }
            int n4 = CharacterSet.convertUTFBytesToJavaChars(bytes, (int)offset, (char[])chars, (int)chars_offset, (int[])countArr, (boolean)convertWithReplacement, ((void)chars).length - chars_offset);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, CharacterSet.class, $$$methodRef$$$16, null, n4);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, CharacterSet.class, $$$methodRef$$$16, null, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, CharacterSet.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertUTFBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl, int n4) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int b2;
            void charSize;
            void chars_offset;
            void offset;
            void countArr;
            void convertWithReplacement;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, CharacterSet.class, $$$methodRef$$$17, null, byArray, n2, cArray, n3, nArray, bl, n4);
            }
            CharacterConverterBehavior ccb = convertWithReplacement != false ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            void count = countArr[0];
            countArr[0] = false;
            void bytes_index = offset;
            void bytes_end = offset + count;
            void chars_index = chars_offset;
            void charsLength = chars_offset + charSize;
            while (bytes_index < bytes_end) {
                char c2;
                byte bb;
                byte[] bytes;
                byte c3 = bytes[bytes_index++];
                b2 = c3 & 0xF0;
                if (c3 >= 0) {
                    if (chars_index < charsLength) {
                        void chars;
                        chars[chars_index++] = (char)(c3 & 0xFFFFFFFF);
                        if (bytes_end > bytes.length || charsLength > ((void)chars).length || bytes_index >= bytes_end || chars_index >= charsLength || bytes_index < 0 || chars_index < 0) continue;
                        while (bytes_index < bytes_end && chars_index < charsLength && (bb = bytes[bytes_index]) >= 0) {
                            chars[chars_index] = (char)(bb & 0xFFFFFFFF);
                            ++chars_index;
                            ++bytes_index;
                        }
                        continue;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                bb = c3;
                if ((bb = (byte)(bb << 2)) >= 0) {
                    if (bytes_index >= bytes_end) {
                        countArr[0] = true;
                        ccb.onFailConversion();
                        break;
                    }
                    c2 = CharacterSet.conv2ByteUTFtoUTF16(c3, bytes[bytes_index++]);
                    if (chars_index >= charsLength) {
                        countArr[0] = bytes_end - bytes_index + 3;
                        break;
                    }
                    chars[chars_index++] = c2;
                    ccb.onFailConversion(c2);
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (bytes_index + true >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + true;
                        ccb.onFailConversion();
                        break;
                    }
                    char c1 = CharacterSet.conv3ByteUTFtoUTF16(c3, bytes[bytes_index++], bytes[bytes_index++]);
                    if (b2 != 244 && bytes[bytes_index - 2] != -65 && bytes[bytes_index - true] != -67) {
                        ccb.onFailConversion(c1);
                    }
                    if (CharacterSet.isHiSurrogate(c1)) {
                        if (chars_index > charsLength - 2) {
                            countArr[0] = bytes_end - bytes_index + 4;
                            break;
                        }
                        if (bytes_index >= bytes_end) continue;
                        c3 = bytes[bytes_index];
                        if ((byte)(c3 & 0xF0) != -32) {
                            chars[chars_index++] = 65533;
                            ccb.onFailConversion();
                            continue;
                        }
                        if (++bytes_index + true >= bytes_end) {
                            countArr[0] = bytes_end - bytes_index + true;
                            ccb.onFailConversion();
                            break;
                        }
                        if (CharacterSet.isLoSurrogate(c2 = CharacterSet.conv3ByteUTFtoUTF16(c3, bytes[bytes_index++], bytes[bytes_index++]))) {
                            chars[chars_index++] = c1;
                        } else {
                            chars[chars_index++] = 65533;
                            ccb.onFailConversion();
                        }
                        chars[chars_index++] = c2;
                        continue;
                    }
                    if (chars_index < charsLength) {
                        chars[chars_index++] = c1;
                        continue;
                    }
                    countArr[0] = bytes_end - bytes_index + 4;
                    break;
                }
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                chars[chars_index++] = 65533;
                ccb.onFailConversion();
            }
            b2 = chars_index - chars_offset;
            void var19_19 = b2;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, CharacterSet.class, $$$methodRef$$$17, null, (int)var19_19);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, CharacterSet.class, $$$methodRef$$$17, null, null);
            }
            return (int)var19_19;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, CharacterSet.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] stringToUTF(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, CharacterSet.class, $$$methodRef$$$18, null, string);
            }
            char[] chararr = str.toCharArray();
            int maxNbBytes = chararr.length * 3;
            byte[] bytearr = null;
            byte[] rbytearr = null;
            bytearr = new byte[maxNbBytes];
            int byte_len = CharacterSet.convertJavaCharsToUTFBytes(chararr, 0, bytearr, 0, chararr.length);
            rbytearr = new byte[byte_len];
            System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
            bytearr = null;
            byte[] byArray = rbytearr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, CharacterSet.class, $$$methodRef$$$18, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, CharacterSet.class, $$$methodRef$$$18, null, null);
            }
            return rbytearr;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, CharacterSet.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToUTFBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char c2;
            void bytes_begin;
            void chars_count;
            void chars_offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, CharacterSet.class, $$$methodRef$$$19, null, cArray, n2, byArray, n3, n4);
            }
            void chars_begin = chars_offset;
            void chars_end = chars_offset + chars_count;
            void byte_index = bytes_begin;
            for (void i2 = chars_begin; i2 < chars_end; ++i2) {
                char[] chars;
                c2 = chars[i2];
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    bytes[byte_index++] = (byte)c2;
                    continue;
                }
                if (c2 > '\u07ff') {
                    bytes[byte_index++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                    continue;
                }
                bytes[byte_index++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
            }
            char c3 = c2 = byte_index - bytes_begin;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, CharacterSet.class, $$$methodRef$$$19, null, c3);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, CharacterSet.class, $$$methodRef$$$19, null, null);
            }
            return c3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, CharacterSet.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int UTFStringLength(byte[] byArray, int n2, int n3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, CharacterSet.class, $$$methodRef$$$20, null, byArray, n2, n3);
            }
            int strlen = 0;
            void bytes_index = offset;
            void bytes_end = offset + count;
            while (bytes_index < bytes_end) {
                byte[] bytes;
                byte b2 = bytes[bytes_index];
                if (b2 >= 0) {
                    ++bytes_index;
                    ++strlen;
                    continue;
                }
                if ((b2 = (byte)(b2 << 2)) >= 0) {
                    if (bytes_index + true >= bytes_end) {
                        bytes_index = bytes_end;
                        continue;
                    }
                    ++strlen;
                    bytes_index += 2;
                    continue;
                }
                if ((b2 = (byte)(b2 << 1)) >= 0) {
                    if (bytes_index + 2 >= bytes_end) {
                        bytes_index = bytes_end;
                        continue;
                    }
                    ++strlen;
                    bytes_index += 3;
                    continue;
                }
                if ((b2 = (byte)(b2 << 1)) >= 0) {
                    if (bytes_index + 3 >= bytes_end) {
                        bytes_index = bytes_end;
                        continue;
                    }
                    strlen += 2;
                    bytes_index += 4;
                    continue;
                }
                ++bytes_index;
                ++strlen;
            }
            int n4 = strlen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, CharacterSet.class, $$$methodRef$$$20, null, n4);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, CharacterSet.class, $$$methodRef$$$20, null, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, CharacterSet.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final int stringUTFLength(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, CharacterSet.class, $$$methodRef$$$21, null, string);
            }
            char[] carr = s2.toCharArray();
            int n2 = CharacterSet.charArrayUTF8Length(carr);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, CharacterSet.class, $$$methodRef$$$21, null, n2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, CharacterSet.class, $$$methodRef$$$21, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, CharacterSet.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    static final int charArrayUTF8Length(char[] cArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char[] carr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, CharacterSet.class, $$$methodRef$$$22, null, new Object[]{cArray});
            }
            int utflen = 0;
            for (char c2 : carr) {
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c2 > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            int n2 = utflen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, CharacterSet.class, $$$methodRef$$$22, null, n2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, CharacterSet.class, $$$methodRef$$$22, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, CharacterSet.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String AL32UTF8ToString(byte[] byArray, int n2, int n3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nbytes;
            void offset;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, CharacterSet.class, $$$methodRef$$$23, null, byArray, n2, n3);
            }
            String string = CharacterSet.AL32UTF8ToString(bytes, (int)offset, (int)nbytes, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, CharacterSet.class, $$$methodRef$$$23, null, string);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, CharacterSet.class, $$$methodRef$$$23, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, CharacterSet.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String AL32UTF8ToString(byte[] byArray, int n2, int n3, boolean bl) {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, CharacterSet.class, $$$methodRef$$$24, null, byArray, n2, n3, bl);
            }
            char[] chars = null;
            try {
                void useReplacementCharacter;
                void nbytes;
                void offset;
                byte[] bytes;
                chars = CharacterSet.AL32UTF8ToJavaChar(bytes, (int)offset, (int)nbytes, (boolean)useReplacementCharacter);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            String string = new String(chars);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, CharacterSet.class, $$$methodRef$$$24, null, string);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, CharacterSet.class, $$$methodRef$$$24, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, CharacterSet.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final char[] AL32UTF8ToJavaChar(byte[] byArray, int n2, int n3, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char[] rchars;
            block7: {
                char[] cArray;
                if (bl2) {
                    ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, CharacterSet.class, $$$methodRef$$$25, null, byArray, n2, n3, bl);
                }
                char[] chars = null;
                try {
                    void useReplacementCharacter;
                    void offset;
                    byte[] bytes;
                    void count;
                    chars = new char[count];
                    int[] countArr = new int[]{count};
                    int clen = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, (int)offset, chars, 0, countArr, (boolean)useReplacementCharacter);
                    rchars = new char[clen];
                    System.arraycopy(chars, 0, rchars, 0, clen);
                    chars = null;
                    cArray = rchars;
                    if (!bl2) break block7;
                }
                catch (SQLException e2) {
                    CharacterSet.failUTFConversion();
                    char[] cArray2 = new char[]{};
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, CharacterSet.class, $$$methodRef$$$25, null, cArray2);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, CharacterSet.class, $$$methodRef$$$25, null, null);
                    }
                    return cArray2;
                }
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, CharacterSet.class, $$$methodRef$$$25, null, cArray);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, CharacterSet.class, $$$methodRef$$$25, null, null);
            }
            return rchars;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, CharacterSet.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertAL32UTF8BytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void convertWithReplacement;
            void countArr;
            void offsetChars;
            void chars;
            void offsetBytes;
            byte[] bytes;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, CharacterSet.class, $$$methodRef$$$26, null, byArray, n2, cArray, n3, nArray, bl);
            }
            int n4 = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, (int)offsetBytes, (char[])chars, (int)offsetChars, (int[])countArr, (boolean)convertWithReplacement, ((void)chars).length - offsetChars);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, CharacterSet.class, $$$methodRef$$$26, null, n4);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, CharacterSet.class, $$$methodRef$$$26, null, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, CharacterSet.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertAL32UTF8BytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, boolean bl, int n4) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int w2;
            void charSize;
            void offsetChars;
            void offsetBytes;
            void countArr;
            void convertWithReplacement;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, CharacterSet.class, $$$methodRef$$$27, null, byArray, n2, cArray, n3, nArray, bl, n4);
            }
            CharacterConverterBehavior ccb = convertWithReplacement != false ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            void count = countArr[0];
            countArr[0] = false;
            void bytes_index = offsetBytes;
            void bytes_end = offsetBytes + count;
            void chars_index = offsetChars;
            void charsLength = offsetChars + charSize;
            while (bytes_index < bytes_end) {
                char c2;
                byte bb;
                void chars;
                byte[] bytes;
                byte c3 = bytes[bytes_index++];
                int b2 = c3 & 0xF0;
                if (c3 >= 0) {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = (char)(c3 & 0xFFFFFFFF);
                        if (bytes_end > bytes.length || charsLength > ((void)chars).length || bytes_index >= bytes_end || chars_index >= charsLength || bytes_index < 0 || chars_index < 0) continue;
                        while (bytes_index < bytes_end && chars_index < charsLength && (bb = bytes[bytes_index]) >= 0) {
                            chars[chars_index] = (char)(bb & 0xFFFFFFFF);
                            ++chars_index;
                            ++bytes_index;
                        }
                        continue;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                bb = c3;
                if ((bb = (byte)(bb << 2)) >= 0) {
                    if (bytes_index >= bytes_end) {
                        countArr[0] = true;
                        ccb.onFailConversion();
                        break;
                    }
                    c2 = CharacterSet.conv2ByteUTFtoUTF16(c3, bytes[bytes_index++]);
                    if (chars_index >= charsLength) {
                        countArr[0] = bytes_end - bytes_index + 3;
                        break;
                    }
                    chars[chars_index++] = c2;
                    ccb.onFailConversion(c2);
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (bytes_index + true >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + true;
                        ccb.onFailConversion();
                        break;
                    }
                    c2 = CharacterSet.conv3ByteAL32UTF8toUTF16(c3, bytes[bytes_index++], bytes[bytes_index++]);
                    if (chars_index >= charsLength) {
                        countArr[0] = bytes_end - bytes_index + 4;
                        break;
                    }
                    chars[chars_index++] = c2;
                    if (b2 == 244 || bytes[bytes_index - 2] == -65 || bytes[bytes_index - true] == -67) continue;
                    ccb.onFailConversion(c2);
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (bytes_index + 2 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + true;
                        ccb.onFailConversion();
                        break;
                    }
                    if (chars_index > charsLength - 2) {
                        countArr[0] = bytes_end - bytes_index + 2;
                        break;
                    }
                    if ((w2 = CharacterSet.conv4ByteAL32UTF8toUTF16(c3, bytes[bytes_index++], bytes[bytes_index++], bytes[bytes_index++], (char[])chars, (int)chars_index)) == 1) {
                        ccb.onFailConversion();
                        ++chars_index;
                        continue;
                    }
                    chars_index += 2;
                    continue;
                }
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                chars[chars_index++] = 65533;
                ccb.onFailConversion();
            }
            w2 = chars_index - offsetChars;
            void var19_19 = w2;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, CharacterSet.class, $$$methodRef$$$27, null, (int)var19_19);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, CharacterSet.class, $$$methodRef$$$27, null, null);
            }
            return (int)var19_19;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, CharacterSet.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] stringToAL32UTF8(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, CharacterSet.class, $$$methodRef$$$28, null, string);
            }
            char[] chararr = str.toCharArray();
            int maxNbBytes = chararr.length * 3;
            byte[] bytearr = null;
            byte[] rbytearr = null;
            bytearr = new byte[maxNbBytes];
            int byte_len = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chararr, 0, bytearr, 0, chararr.length);
            rbytearr = new byte[byte_len];
            System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
            bytearr = null;
            byte[] byArray = rbytearr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, CharacterSet.class, $$$methodRef$$$28, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, CharacterSet.class, $$$methodRef$$$28, null, null);
            }
            return rbytearr;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, CharacterSet.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToAL32UTF8Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int uuuuu;
            void bytes_begin;
            void chars_count;
            void chars_offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, CharacterSet.class, $$$methodRef$$$29, null, cArray, n2, byArray, n3, n4);
            }
            void chars_begin = chars_offset;
            void chars_end = chars_offset + chars_count;
            void byte_index = bytes_begin;
            for (void i2 = chars_begin; i2 < chars_end; ++i2) {
                char[] chars;
                char c2 = chars[i2];
                char c22 = '\u0000';
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    bytes[byte_index++] = (byte)c2;
                    continue;
                }
                if (CharacterSet.isHiSurrogate(c2)) {
                    if (i2 + true < chars_end && CharacterSet.isLoSurrogate(c22 = chars[i2 + true])) {
                        uuuuu = (c2 >>> 6 & 0xF) + 1;
                        bytes[byte_index++] = (byte)(uuuuu >>> 2 | 0xF0);
                        bytes[byte_index++] = (byte)((uuuuu & 3) << 4 | c2 >>> 2 & 0xF | 0x80);
                        bytes[byte_index++] = (byte)((c2 & 3) << 4 | c22 >>> 6 & 0xF | 0x80);
                        bytes[byte_index++] = (byte)(c22 & 0x3F | 0x80);
                        ++i2;
                        continue;
                    }
                    bytes[byte_index++] = -17;
                    bytes[byte_index++] = -65;
                    bytes[byte_index++] = -67;
                    continue;
                }
                if (c2 > '\u07ff') {
                    bytes[byte_index++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                    continue;
                }
                bytes[byte_index++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
            }
            uuuuu = byte_index - bytes_begin;
            void var13_13 = uuuuu;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, CharacterSet.class, $$$methodRef$$$29, null, (int)var13_13);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, CharacterSet.class, $$$methodRef$$$29, null, null);
            }
            return (int)var13_13;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, CharacterSet.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final int string32UTF8Length(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, CharacterSet.class, $$$methodRef$$$30, null, string);
            }
            int n2 = CharacterSet.charArray32UTF8Length(s2.toCharArray());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, CharacterSet.class, $$$methodRef$$$30, null, n2);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, CharacterSet.class, $$$methodRef$$$30, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, CharacterSet.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    static final int charArray32UTF8Length(char[] cArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char[] carr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, CharacterSet.class, $$$methodRef$$$31, null, new Object[]{cArray});
            }
            int utflen = 0;
            int slen = carr.length;
            for (int i2 = 0; i2 < slen; ++i2) {
                char c2 = carr[i2];
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c2 > '\u07ff') {
                    if (CharacterSet.isHiSurrogate(c2)) {
                        if (i2 + 1 >= slen) continue;
                        utflen += 4;
                        ++i2;
                        continue;
                    }
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            int n2 = utflen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, CharacterSet.class, $$$methodRef$$$31, null, n2);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, CharacterSet.class, $$$methodRef$$$31, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, CharacterSet.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String AL16UTF16BytesToString(byte[] byArray, int n2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] bytes;
            void nbytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, CharacterSet.class, $$$methodRef$$$32, null, byArray, n2);
            }
            char[] chars = new char[nbytes >>> 1];
            CharacterSet.AL16UTF16BytesToJavaChars(bytes, (int)nbytes, chars);
            String string = new String(chars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, CharacterSet.class, $$$methodRef$$$32, null, string);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, CharacterSet.class, $$$methodRef$$$32, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, CharacterSet.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int AL16UTF16BytesToJavaChars(byte[] byArray, int n2, char[] cArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int chars_i;
            void nbytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, CharacterSet.class, $$$methodRef$$$33, null, byArray, n2, cArray);
            }
            int charMax = nbytes >>> 1;
            int bytes_i = 0;
            for (chars_i = 0; chars_i < charMax; ++chars_i) {
                byte[] bytes;
                int hibyte = bytes[bytes_i] << 8;
                chars[chars_i] = (char)(hibyte | bytes[bytes_i + 1] & 0xFF);
                bytes_i += 2;
            }
            int n3 = chars_i;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, CharacterSet.class, $$$methodRef$$$33, null, n3);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, CharacterSet.class, $$$methodRef$$$33, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, CharacterSet.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertAL16UTF16BytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            void chars_offset;
            void convertWithReplacement;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, CharacterSet.class, $$$methodRef$$$34, null, byArray, n2, cArray, n3, n4, bl);
            }
            CharacterConverterBehavior ccb = convertWithReplacement != false ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            void chars_i = chars_offset;
            void bytes_i = offset;
            void bytes_end = offset + count;
            while (bytes_i + true < bytes_end) {
                byte[] bytes;
                int hibyte = bytes[bytes_i] << 8;
                char c2 = (char)(hibyte | bytes[bytes_i + true] & 0xFF);
                chars[chars_i++] = c2;
                bytes_i += 2;
            }
            void var14_13 = bytes_i = chars_i - chars_offset;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, CharacterSet.class, $$$methodRef$$$34, null, (int)var14_13);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, CharacterSet.class, $$$methodRef$$$34, null, null);
            }
            return (int)var14_13;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, CharacterSet.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertAL16UTF16LEBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void offset;
            void chars_offset;
            void convertWithReplacement;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, CharacterSet.class, $$$methodRef$$$35, null, byArray, n2, cArray, n3, n4, bl);
            }
            CharacterConverterBehavior ccb = convertWithReplacement != false ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            void chars_i = chars_offset;
            void bytes_i = offset;
            void bytes_end = offset + count;
            while (bytes_i + true < bytes_end) {
                byte[] bytes;
                int hibyte = bytes[bytes_i + true] << 8;
                int c2 = hibyte | bytes[bytes_i] & 0xFF;
                if (CharacterSet.isHiSurrogate((char)c2)) {
                    if ((bytes_i += 2) + true < bytes_end) {
                        char c22 = (char)((bytes[bytes_i + true] << 8) + (bytes[bytes_i] & 0xFF));
                        chars[chars_i++] = CharacterSet.isLoSurrogate(c22) ? c2 : 65533;
                        chars[chars_i++] = c22;
                    }
                } else {
                    chars[chars_i++] = c2;
                }
                bytes_i += 2;
            }
            void var14_14 = bytes_i = chars_i - chars_offset;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, CharacterSet.class, $$$methodRef$$$35, null, (int)var14_14);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, CharacterSet.class, $$$methodRef$$$35, null, null);
            }
            return (int)var14_14;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, CharacterSet.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] stringToAL16UTF16Bytes(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, CharacterSet.class, $$$methodRef$$$36, null, string);
            }
            char[] chars = str.toCharArray();
            int nchars = chars.length;
            byte[] bytes = new byte[nchars * 2];
            CharacterSet.javaCharsToAL16UTF16Bytes(chars, nchars, bytes);
            byte[] byArray = bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, CharacterSet.class, $$$methodRef$$$36, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, CharacterSet.class, $$$methodRef$$$36, null, null);
            }
            return bytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, CharacterSet.class, $$$methodRef$$$36, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int javaCharsToAL16UTF16Bytes(char[] cArray, int n2, byte[] byArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char[] chars;
            void bytes;
            void nchars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, CharacterSet.class, $$$methodRef$$$37, null, cArray, n2, byArray);
            }
            int charsMax = Math.min((int)nchars, ((void)bytes).length >>> 1);
            int n3 = CharacterSet.convertJavaCharsToAL16UTF16Bytes(chars, 0, (byte[])bytes, 0, charsMax);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, CharacterSet.class, $$$methodRef$$$37, null, n3);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, CharacterSet.class, $$$methodRef$$$37, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, CharacterSet.class, $$$methodRef$$$37, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToAL16UTF16Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes_offset;
            void chars_offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, CharacterSet.class, $$$methodRef$$$38, null, cArray, n2, byArray, n3, n4);
            }
            void chars_i = chars_offset;
            void bytes_i = bytes_offset;
            void char_end = chars_offset + nchars;
            while (chars_i < char_end) {
                char[] chars;
                bytes[bytes_i] = (byte)(chars[chars_i] >>> 8 & 0xFF);
                bytes[bytes_i + true] = (byte)(chars[chars_i] & 0xFF);
                ++chars_i;
                bytes_i += 2;
            }
            void var9_9 = bytes_i - bytes_offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, CharacterSet.class, $$$methodRef$$$38, null, (int)var9_9);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, CharacterSet.class, $$$methodRef$$$38, null, null);
            }
            return (int)var9_9;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, CharacterSet.class, $$$methodRef$$$38, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] stringToAL16UTF16LEBytes(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, CharacterSet.class, $$$methodRef$$$39, null, string);
            }
            char[] chars = str.toCharArray();
            byte[] bytes = new byte[chars.length * 2];
            CharacterSet.javaCharsToAL16UTF16LEBytes(chars, chars.length, bytes);
            byte[] byArray = bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, CharacterSet.class, $$$methodRef$$$39, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, CharacterSet.class, $$$methodRef$$$39, null, null);
            }
            return bytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, CharacterSet.class, $$$methodRef$$$39, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int javaCharsToAL16UTF16LEBytes(char[] cArray, int n2, byte[] byArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes;
            char[] chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, CharacterSet.class, $$$methodRef$$$40, null, cArray, n2, byArray);
            }
            int n3 = CharacterSet.convertJavaCharsToAL16UTF16LEBytes(chars, 0, (byte[])bytes, 0, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, CharacterSet.class, $$$methodRef$$$40, null, n3);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, CharacterSet.class, $$$methodRef$$$40, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, CharacterSet.class, $$$methodRef$$$40, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToAL16UTF16LEBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes_offset;
            void chars_offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, CharacterSet.class, $$$methodRef$$$41, null, cArray, n2, byArray, n3, n4);
            }
            void chars_i = chars_offset;
            void bytes_i = bytes_offset;
            void char_end = chars_offset + nchars;
            while (chars_i < char_end) {
                char[] chars;
                bytes[bytes_i] = (byte)(chars[chars_i] & 0xFF);
                bytes[bytes_i + true] = (byte)(chars[chars_i] >>> 8);
                ++chars_i;
                bytes_i += 2;
            }
            void var9_9 = bytes_i - bytes_offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, CharacterSet.class, $$$methodRef$$$41, null, (int)var9_9);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, CharacterSet.class, $$$methodRef$$$41, null, null);
            }
            return (int)var9_9;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, CharacterSet.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertASCIIBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes_offset;
            void count;
            void chars_offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, CharacterSet.class, $$$methodRef$$$42, null, byArray, n2, cArray, n3, n4);
            }
            void lastChar = chars_offset + count;
            void i2 = chars_offset;
            void j2 = bytes_offset;
            while (i2 < lastChar) {
                byte[] bytes;
                chars[i2] = (char)(0xFF & bytes[j2]);
                ++i2;
                ++j2;
            }
            void var9_9 = count;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, CharacterSet.class, $$$methodRef$$$42, null, (int)var9_9);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, CharacterSet.class, $$$methodRef$$$42, null, null);
            }
            return (int)var9_9;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, CharacterSet.class, $$$methodRef$$$42, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToASCIIBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes_offset;
            void bytes;
            void chars_offset;
            char[] chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, CharacterSet.class, $$$methodRef$$$43, null, cArray, n2, byArray, n3, n4);
            }
            CharacterSet.convertJavaCharsToASCIIBytes(chars, (int)chars_offset, (byte[])bytes, (int)bytes_offset, (int)nchars, false);
            void var6_6 = nchars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, CharacterSet.class, $$$methodRef$$$43, null, (int)var6_6);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, CharacterSet.class, $$$methodRef$$$43, null, null);
            }
            return (int)var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, CharacterSet.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToASCIIBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int nchars;
            void chars_offset;
            char[] chars;
            void strictConversion;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, CharacterSet.class, $$$methodRef$$$44, null, cArray, n2, byArray, n3, n4, bl);
            }
            if (strictConversion != false) {
                void bytes_offset;
                void bytes;
                if (asciiCharSet == null) {
                    asciiCharSet = CharacterSet.make(1);
                }
                byte[] tempBytes = asciiCharSet.convertWithReplacement(new String(chars, (int)chars_offset, nchars));
                System.arraycopy(tempBytes, 0, bytes, (int)bytes_offset, tempBytes.length);
                int n5 = tempBytes.length;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, CharacterSet.class, $$$methodRef$$$44, null, n5);
                    ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, CharacterSet.class, $$$methodRef$$$44, null, null);
                }
                return n5;
            }
            for (int i2 = 0; i2 < nchars; ++i2) {
                bytes[bytes_offset + i2] = (byte)chars[chars_offset + i2];
            }
            void var8_10 = nchars;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, CharacterSet.class, $$$methodRef$$$44, null, (int)var8_10);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, CharacterSet.class, $$$methodRef$$$44, null, null);
            }
            return (int)var8_10;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, CharacterSet.class, $$$methodRef$$$44, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertJavaCharsToISOLATIN1Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, CharacterSet.class, $$$methodRef$$$45, null, cArray, n2, byArray, n3, n4);
            }
            for (int i2 = 0; i2 < nchars; ++i2) {
                void chars_offset;
                char[] chars;
                char c2 = chars[chars_offset + i2];
                bytes[bytes_offset + i2] = c2 > '\u00ff' ? -65 : (byte)c2;
            }
            void var8_8 = nchars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, CharacterSet.class, $$$methodRef$$$45, null, (int)var8_8);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, CharacterSet.class, $$$methodRef$$$45, null, null);
            }
            return (int)var8_8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, CharacterSet.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] stringToASCII(String string) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, CharacterSet.class, $$$methodRef$$$46, null, string);
            }
            byte[] byArray = str.getBytes(StandardCharsets.US_ASCII);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, CharacterSet.class, $$$methodRef$$$46, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, CharacterSet.class, $$$methodRef$$$46, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, CharacterSet.class, $$$methodRef$$$46, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final long convertUTF32toUTF16(long l2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            long ucs4ch;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, CharacterSet.class, $$$methodRef$$$47, null, l2);
            }
            if (ucs4ch > 65535L) {
                long utf16str = 0xD8L | ucs4ch - 65536L >> 18 & 0xFFL;
                utf16str = ucs4ch - 65536L >> 10 & 0xFFL | utf16str << 8;
                utf16str = 0xDCL | (ucs4ch & 0x3FFL) >> 8 & 0xFFL | utf16str << 8;
                long l3 = utf16str = ucs4ch & 0xFFL | utf16str << 8;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, CharacterSet.class, $$$methodRef$$$47, null, l3);
                    ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, CharacterSet.class, $$$methodRef$$$47, null, null);
                }
                return l3;
            }
            long l4 = ucs4ch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, CharacterSet.class, $$$methodRef$$$47, null, l4);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, CharacterSet.class, $$$methodRef$$$47, null, null);
            }
            return l4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, CharacterSet.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean isHiSurrogate(char c2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char c3;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, CharacterSet.class, $$$methodRef$$$48, null, Character.valueOf(c2));
            }
            boolean bl3 = bl2 = (char)(c3 & 0xFC00) == '\ud800';
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, CharacterSet.class, $$$methodRef$$$48, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, CharacterSet.class, $$$methodRef$$$48, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, CharacterSet.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean isLoSurrogate(char c2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            char c3;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, CharacterSet.class, $$$methodRef$$$49, null, Character.valueOf(c2));
            }
            boolean bl3 = bl2 = (char)(c3 & 0xFC00) == '\udc00';
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, CharacterSet.class, $$$methodRef$$$49, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, CharacterSet.class, $$$methodRef$$$49, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, CharacterSet.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean check80toBF(byte by) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, CharacterSet.class, $$$methodRef$$$50, null, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFC0) == -128;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, CharacterSet.class, $$$methodRef$$$50, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, CharacterSet.class, $$$methodRef$$$50, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, CharacterSet.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean check80to8F(byte by) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, CharacterSet.class, $$$methodRef$$$51, null, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFF0) == -128;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, CharacterSet.class, $$$methodRef$$$51, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, CharacterSet.class, $$$methodRef$$$51, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, CharacterSet.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean check80to9F(byte by) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, CharacterSet.class, $$$methodRef$$$52, null, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFE0) == -128;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, CharacterSet.class, $$$methodRef$$$52, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, CharacterSet.class, $$$methodRef$$$52, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, CharacterSet.class, $$$methodRef$$$52, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean checkA0toBF(byte by) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, CharacterSet.class, $$$methodRef$$$53, null, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFE0) == -96;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, CharacterSet.class, $$$methodRef$$$53, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, CharacterSet.class, $$$methodRef$$$53, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, CharacterSet.class, $$$methodRef$$$53, null, throwable2);
            }
            throw throwable;
        }
    }

    static final boolean check90toBF(byte by) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, CharacterSet.class, $$$methodRef$$$54, null, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFC0) == -128 && (b2 & 0x30) != 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, CharacterSet.class, $$$methodRef$$$54, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, CharacterSet.class, $$$methodRef$$$54, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, CharacterSet.class, $$$methodRef$$$54, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            byte c3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, CharacterSet.class, $$$methodRef$$$55, null, by, by2);
            }
            if (c3 < -62 || c3 > -33 || !CharacterSet.check80toBF((byte)c2)) {
                char c4 = '\ufffd';
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, CharacterSet.class, $$$methodRef$$$55, null, Character.valueOf(c4));
                    ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, CharacterSet.class, $$$methodRef$$$55, null, null);
                }
                return '\ufffd';
            }
            char c5 = (char)((c3 & 0x1F) << 6 | c2 & 0x3F);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, CharacterSet.class, $$$methodRef$$$55, null, Character.valueOf(c5));
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, CharacterSet.class, $$$methodRef$$$55, null, null);
            }
            return c5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, CharacterSet.class, $$$methodRef$$$55, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c3;
            void c2;
            byte c4;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, CharacterSet.class, $$$methodRef$$$56, null, by, by2, by3);
            }
            if (!(c4 == -32 && CharacterSet.checkA0toBF((byte)c2) && CharacterSet.check80toBF((byte)c3) || c4 >= -31 && c4 <= -17 && CharacterSet.check80toBF((byte)c2) && CharacterSet.check80toBF((byte)c3))) {
                char c5 = '\ufffd';
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, CharacterSet.class, $$$methodRef$$$56, null, Character.valueOf(c5));
                    ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, CharacterSet.class, $$$methodRef$$$56, null, null);
                }
                return '\ufffd';
            }
            char c6 = (char)((c4 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, CharacterSet.class, $$$methodRef$$$56, null, Character.valueOf(c6));
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, CharacterSet.class, $$$methodRef$$$56, null, null);
            }
            return c6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, CharacterSet.class, $$$methodRef$$$56, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final char conv3ByteAL32UTF8toUTF16(byte by, byte by2, byte by3) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c3;
            void c2;
            byte c4;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, CharacterSet.class, $$$methodRef$$$57, null, by, by2, by3);
            }
            if (!(c4 == -32 && CharacterSet.checkA0toBF((byte)c2) && CharacterSet.check80toBF((byte)c3) || c4 >= -31 && c4 <= -20 && CharacterSet.check80toBF((byte)c2) && CharacterSet.check80toBF((byte)c3) || c4 == -19 && CharacterSet.check80to9F((byte)c2) && CharacterSet.check80toBF((byte)c3) || c4 >= -18 && c4 <= -17 && CharacterSet.check80toBF((byte)c2) && CharacterSet.check80toBF((byte)c3))) {
                char c5 = '\ufffd';
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, CharacterSet.class, $$$methodRef$$$57, null, Character.valueOf(c5));
                    ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, CharacterSet.class, $$$methodRef$$$57, null, null);
                }
                return '\ufffd';
            }
            char c6 = (char)((c4 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, CharacterSet.class, $$$methodRef$$$57, null, Character.valueOf(c6));
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, CharacterSet.class, $$$methodRef$$$57, null, null);
            }
            return c6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, CharacterSet.class, $$$methodRef$$$57, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int conv4ByteAL32UTF8toUTF16(byte by, byte by2, byte by3, byte by4, char[] cArray, int n2) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void c4;
            void c3;
            void c2;
            byte c5;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, CharacterSet.class, $$$methodRef$$$58, null, by, by2, by3, by4, cArray, n2);
            }
            boolean chars_count = false;
            if (!(c5 == -16 && CharacterSet.check90toBF((byte)c2) && CharacterSet.check80toBF((byte)c3) && CharacterSet.check80toBF((byte)c4) || c5 >= -15 && c5 <= -13 && CharacterSet.check80toBF((byte)c2) && CharacterSet.check80toBF((byte)c3) && CharacterSet.check80toBF((byte)c4) || c5 == -12 && CharacterSet.check80to8F((byte)c2) && CharacterSet.check80toBF((byte)c3) && CharacterSet.check80toBF((byte)c4))) {
                chars[cpos] = 65533;
                int n3 = 1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, CharacterSet.class, $$$methodRef$$$58, null, n3);
                    ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, CharacterSet.class, $$$methodRef$$$58, null, null);
                }
                return 1;
            }
            chars[cpos] = (char)((((c5 & 7) << 2 | c2 >>> 4 & 3) - 1 & 0xF) << 6 | (c2 & 0xF) << 2 | c3 >>> 4 & 3 | 0xD800);
            chars[cpos + true] = (char)((c3 & 0xF) << 6 | c4 & 0x3F | 0xDC00);
            int n4 = 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, CharacterSet.class, $$$methodRef$$$58, null, n4);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, CharacterSet.class, $$$methodRef$$$58, null, null);
            }
            return 2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, CharacterSet.class, $$$methodRef$$$58, null, throwable2);
            }
            throw throwable;
        }
    }

    static void failUTFConversion() throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, CharacterSet.class, $$$methodRef$$$59, null, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(55).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$59, Level.FINEST, CharacterSet.class, $$$methodRef$$$59, null, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, CharacterSet.class, $$$methodRef$$$59, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int encodedByteLength(String string) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, CharacterSet.class, $$$methodRef$$$60, this, string);
            }
            if (s2 == null || s2.length() == 0) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, CharacterSet.class, $$$methodRef$$$60, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, CharacterSet.class, $$$methodRef$$$60, this, null);
                }
                return 0;
            }
            int n3 = this.convertWithReplacement((String)s2).length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, CharacterSet.class, $$$methodRef$$$60, this, n3);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, CharacterSet.class, $$$methodRef$$$60, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, CharacterSet.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int encodedByteLength(char[] cArray) {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void carray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, CharacterSet.class, $$$methodRef$$$61, this, new Object[]{cArray});
            }
            if (carray == null || ((void)carray).length == 0) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, CharacterSet.class, $$$methodRef$$$61, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, CharacterSet.class, $$$methodRef$$$61, this, null);
                }
                return 0;
            }
            int n3 = this.convertWithReplacement(new String((char[])carray)).length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, CharacterSet.class, $$$methodRef$$$61, this, n3);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, CharacterSet.class, $$$methodRef$$$61, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, CharacterSet.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    public int toCharWithReplacement(byte[] byArray, int n2, char[] cArray, int n3, int n4) throws SQLException {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, CharacterSet.class, $$$methodRef$$$62, this, byArray, n2, cArray, n3, n4);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$62, Level.FINEST, CharacterSet.class, $$$methodRef$$$62, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, CharacterSet.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, CharacterSet.class, $$$methodRef$$$63, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, CharacterSet.class, $$$methodRef$$$63, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, CharacterSet.class, $$$methodRef$$$63, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, CharacterSet.class, $$$methodRef$$$63, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isUnknown() {
        boolean bl = (0x4000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, CharacterSet.class, $$$methodRef$$$64, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, CharacterSet.class, $$$methodRef$$$64, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, CharacterSet.class, $$$methodRef$$$64, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, CharacterSet.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$65 = CharacterSet.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$64 = CharacterSet.class.getDeclaredMethod("isUnknown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$63 = CharacterSet.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$62 = CharacterSet.class.getDeclaredMethod("toCharWithReplacement", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$61 = CharacterSet.class.getDeclaredMethod("encodedByteLength", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$60 = CharacterSet.class.getDeclaredMethod("encodedByteLength", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$59 = CharacterSet.class.getDeclaredMethod("failUTFConversion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$58 = CharacterSet.class.getDeclaredMethod("conv4ByteAL32UTF8toUTF16", Byte.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$57 = CharacterSet.class.getDeclaredMethod("conv3ByteAL32UTF8toUTF16", Byte.TYPE, Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$56 = CharacterSet.class.getDeclaredMethod("conv3ByteUTFtoUTF16", Byte.TYPE, Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$55 = CharacterSet.class.getDeclaredMethod("conv2ByteUTFtoUTF16", Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$54 = CharacterSet.class.getDeclaredMethod("check90toBF", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$53 = CharacterSet.class.getDeclaredMethod("checkA0toBF", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = CharacterSet.class.getDeclaredMethod("check80to9F", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = CharacterSet.class.getDeclaredMethod("check80to8F", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = CharacterSet.class.getDeclaredMethod("check80toBF", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = CharacterSet.class.getDeclaredMethod("isLoSurrogate", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = CharacterSet.class.getDeclaredMethod("isHiSurrogate", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = CharacterSet.class.getDeclaredMethod("convertUTF32toUTF16", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = CharacterSet.class.getDeclaredMethod("stringToASCII", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToISOLATIN1Bytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToASCIIBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToASCIIBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = CharacterSet.class.getDeclaredMethod("convertASCIIBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToAL16UTF16LEBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = CharacterSet.class.getDeclaredMethod("javaCharsToAL16UTF16LEBytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = CharacterSet.class.getDeclaredMethod("stringToAL16UTF16LEBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToAL16UTF16Bytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = CharacterSet.class.getDeclaredMethod("javaCharsToAL16UTF16Bytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = CharacterSet.class.getDeclaredMethod("stringToAL16UTF16Bytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = CharacterSet.class.getDeclaredMethod("convertAL16UTF16LEBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = CharacterSet.class.getDeclaredMethod("convertAL16UTF16BytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = CharacterSet.class.getDeclaredMethod("AL16UTF16BytesToJavaChars", byte[].class, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = CharacterSet.class.getDeclaredMethod("AL16UTF16BytesToString", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = CharacterSet.class.getDeclaredMethod("charArray32UTF8Length", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = CharacterSet.class.getDeclaredMethod("string32UTF8Length", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToAL32UTF8Bytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = CharacterSet.class.getDeclaredMethod("stringToAL32UTF8", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = CharacterSet.class.getDeclaredMethod("convertAL32UTF8BytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = CharacterSet.class.getDeclaredMethod("convertAL32UTF8BytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = CharacterSet.class.getDeclaredMethod("AL32UTF8ToJavaChar", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = CharacterSet.class.getDeclaredMethod("AL32UTF8ToString", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = CharacterSet.class.getDeclaredMethod("AL32UTF8ToString", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = CharacterSet.class.getDeclaredMethod("charArrayUTF8Length", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = CharacterSet.class.getDeclaredMethod("stringUTFLength", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = CharacterSet.class.getDeclaredMethod("UTFStringLength", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = CharacterSet.class.getDeclaredMethod("convertJavaCharsToUTFBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = CharacterSet.class.getDeclaredMethod("stringToUTF", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = CharacterSet.class.getDeclaredMethod("convertUTFBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = CharacterSet.class.getDeclaredMethod("convertUTFBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = CharacterSet.class.getDeclaredMethod("UTFToJavaCharWithReplacement", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = CharacterSet.class.getDeclaredMethod("UTFToJavaChar", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = CharacterSet.class.getDeclaredMethod("UTFToJavaChar", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = CharacterSet.class.getDeclaredMethod("UTFToString", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = CharacterSet.class.getDeclaredMethod("UTFToString", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = CharacterSet.class.getDeclaredMethod("need", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = CharacterSet.class.getDeclaredMethod("useOrCopy", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = CharacterSet.class.getDeclaredMethod("failCharacterConversion", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CharacterSet.class.getDeclaredMethod("convertUnshared", CharacterSet.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CharacterSet.class.getDeclaredMethod("convertWithReplacement", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CharacterSet.class.getDeclaredMethod("getRatioTo", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CharacterSet.class.getDeclaredMethod("getRep", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CharacterSet.class.getDeclaredMethod("getOracleId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSet.class.getDeclaredMethod("isWellFormed", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSet.class.getDeclaredMethod("isUnicode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSet.class.getDeclaredMethod("make", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        asciiCharSet = null;
        try {
            Class.forName("oracle.i18n.text.converter.CharacterConverterSJIS");
            CharacterSetWithConverter.ccFactory = new CharacterConverterFactoryOGS();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        factory = new CharacterSetFactoryDefault();
        CHARACTERSET_MAP = new ConcurrentHashMap();
    }

    private static class CharacterSetNamesMapHolder {
        private static final Map<Short, String> ID_TO_NAME_MAP;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private CharacterSetNamesMapHolder() {
        }

        private static final Map<Short, String> generateIdToNameMap() {
            Class<CharacterSet> characterSetClass = CharacterSet.class;
            Field[] fields = characterSetClass.getFields();
            HashMap<Short, String> tempCharacterSetNames = new HashMap<Short, String>();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                try {
                    String name = fields[i2].getName();
                    int suffixIndex = name.lastIndexOf("_CHARSET");
                    if (suffixIndex == -1 || (name = name.substring(0, suffixIndex)).equals("ASCII") || name.equals("ISO_LATIN_1") || name.equals("AR8MSAWIN") || name.equals("UNICODE_1") || name.equals("UNICODE_2")) continue;
                    short id = fields[i2].getShort(CharacterSet.class);
                    int mod = fields[i2].getModifiers();
                    if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
                    String temp = (String)tempCharacterSetNames.get(new Short(id));
                    if (temp != null) {
                        throw new RuntimeException("duplicate field name: " + name + " for id: " + id);
                    }
                    tempCharacterSetNames.put(new Short(id), name);
                    continue;
                }
                catch (Exception e2) {
                    throw new RuntimeException("Failed for field: " + fields[i2], e2);
                }
            }
            return tempCharacterSetNames;
        }

        static {
            try {
                $$$methodRef$$$1 = CharacterSetNamesMapHolder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = CharacterSetNamesMapHolder.class.getDeclaredMethod("generateIdToNameMap", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ID_TO_NAME_MAP = CharacterSetNamesMapHolder.generateIdToNameMap();
        }
    }

    static abstract class CharacterConverterBehavior {
        public static final char[] NULL_CHARS;
        public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final CharacterConverterBehavior REPORT_ERROR;
        public static final CharacterConverterBehavior REPLACEMENT;
        private final String m_name;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        public CharacterConverterBehavior(String name) {
            this.m_name = name;
        }

        public abstract void onFailConversion(char var1) throws SQLException;

        public abstract void onFailConversion() throws SQLException;

        static {
            try {
                $$$methodRef$$$0 = CharacterConverterBehavior.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NULL_CHARS = new char[1];
            REPORT_ERROR = new CharacterConverterBehavior("Report Error"){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public void onFailConversion() throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException(55).fillInStackTrace();
                }

                @Override
                public void onFailConversion(char c2) throws SQLException {
                    if (c2 == '\ufffd') {
                        throw (SQLException)DatabaseError.createSqlException(55).fillInStackTrace();
                    }
                }

                static {
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredConstructor(String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("onFailConversion", Character.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("onFailConversion", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            REPLACEMENT = new CharacterConverterBehavior("Replacement"){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public void onFailConversion() throws SQLException {
                }

                @Override
                public void onFailConversion(char c2) throws SQLException {
                }

                static {
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredConstructor(String.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("onFailConversion", Character.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("onFailConversion", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }
    }
}

