/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleTimeoutThreadPerVM
extends OracleTimeout
implements Monitor {
    private static final OracleTimeoutPollingThread watchdog;
    private OracleStatement statement;
    private long interruptAfter;
    private String name;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    OracleTimeoutThreadPerVM(String name) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$7, null, name);
            }
            this.monitorLock = this.newDefaultLock();
            this.name = name;
            this.interruptAfter = Long.MAX_VALUE;
            watchdog.addTimeout(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    static void stopWatchdog() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$0, null, new Object[0]);
                }
                try {
                    watchdog.interrupt();
                }
                catch (SecurityException e2) {
                    if (!bl) break block7;
                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$0, "stopWatchdog: " + e2.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void close() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$1, this, new Object[0]);
            }
            watchdog.removeTimeout(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setTimeout(long l2, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$2, this, l2, oracleStatement);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void milliseconds;
                void stmt;
                if (this.interruptAfter != Long.MAX_VALUE) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 131).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
                this.statement = stmt;
                this.interruptAfter = System.currentTimeMillis() + milliseconds;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$2, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    void cancelTimeout() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$3, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                this.statement = null;
                this.interruptAfter = Long.MAX_VALUE;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$3, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void interruptIfAppropriate(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block21: {
                OracleStatement s2;
                Monitor.CloseableLock lock;
                block19: {
                    block20: {
                        void now;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this, l2);
                        }
                        if (now < this.interruptAfter) {
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this);
                                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this, null);
                            }
                            return;
                        }
                        lock = this.acquireCloseableLock();
                        try {
                            s2 = this.statement;
                            if (now >= this.interruptAfter) {
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "CANCELING thread :" + this.name);
                                }
                                this.statement = null;
                                this.interruptAfter = Long.MAX_VALUE;
                                break block19;
                            }
                            if (lock != null) {
                                lock.close();
                            }
                            if (!bl) break block20;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this, null);
                    }
                    return;
                }
                if (lock != null) {
                    lock.close();
                }
                try {
                    s2.cancel();
                }
                catch (Throwable e2) {
                    if (!bl) break block21;
                    OracleLog.log($$$loggerRef$$$4, Level.INFO, this.getClass(), $$$methodRef$$$4, "statement cancel failed\n" + e2.getMessage() + "\n", e2);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$4, this, throwable4);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$5, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$5, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$5, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$6, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$6, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$6, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleTimeoutThreadPerVM.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = OracleTimeoutThreadPerVM.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("interruptIfAppropriate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("setTimeout", Long.TYPE, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTimeoutThreadPerVM.class.getDeclaredMethod("stopWatchdog", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        watchdog = new OracleTimeoutPollingThread();
    }
}

