/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.datasource.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.NonTxnReplayableArray;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
import oracle.jdbc.replay.driver.NonTxnReplayableRef;
import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
import oracle.jdbc.replay.driver.ReplayStatisticsMBeanImpl;
import oracle.jdbc.replay.driver.StatisticsTracker;
import oracle.jdbc.replay.driver.TxnReplayableArray;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableOpaque;
import oracle.jdbc.replay.driver.TxnReplayableOthers;
import oracle.jdbc.replay.driver.TxnReplayableRef;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableSqlxml;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.ReplayableConnection;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.HIGH_AVAILABILITY, Feature.CONN_POOL, Feature.APPLICATION_CONTINUITY})
public class OracleDataSource
implements oracle.jdbc.datasource.OracleDataSource,
oracle.jdbc.replay.internal.OracleDataSource,
Serializable,
Referenceable,
Monitor {
    static final long serialVersionUID = 3349652938965166731L;
    protected static final String DEFAULT_SERVICE_NAME = "SYS$USERS";
    protected PrintWriter logWriter;
    protected int loginTimeout;
    protected String databaseName;
    protected String serviceName;
    protected String dataSourceName;
    protected String description;
    protected String networkProtocol;
    protected int portNumber;
    protected String user;
    protected OpaqueString password;
    protected String serverName;
    protected String url;
    protected String driverType;
    protected String tnsEntry;
    protected int maxStatements;
    protected boolean implicitCachingEnabled;
    protected boolean explicitCachingEnabled;
    protected boolean maxStatementsSet;
    protected boolean implicitCachingEnabledSet;
    protected boolean explicitCachingEnabledSet;
    protected Properties connectionProperties;
    public boolean isOracleDataSource;
    private String roleName;
    private boolean urlExplicit;
    private boolean useDefaultConnection;
    protected transient OracleDriver driver;
    private final Monitor.CloseableLock monitorLock;
    private SSLContext sslContext;
    private boolean allowSingleShardTransaction;
    private OracleHostnameResolver hostnameResolver;
    private Supplier<? extends AccessToken> tokenSupplier;
    private static ProxyFactory PROXY_FACTORY;
    private static ProxyFactory NON_TXN_PROXY_FACTORY;
    private static final Monitor proxyFactoryLock;
    private ConnectionInitializationCallback connectionInitializationCallback;
    protected AtomicBoolean isFirstConnection;
    protected static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
    protected static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
    protected int reconnectDelay;
    protected int reconnectRetries;
    protected static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    protected static final int FAILOVER_TYPE_TRANSACTION = 8;
    protected static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    protected static final int FAILOVER_TYPE_AUTO = 32;
    protected boolean isTransactionReplayEnabled;
    protected boolean isAutoACEnabled;
    protected static final String SESSION_STATE_PROPERTY = "AUTH_SESSION_STATE_CONSISTENCY";
    protected boolean isReplayInDynamicMode;
    protected static final String FAILOVER_RESTORE_PROPERTY = "AUTH_FAILOVER_RESTORE";
    protected static final int FAILOVER_RESTORE_NONE = 0;
    protected static final int FAILOVER_RESTORE_LEVEL1 = 1;
    protected static final int FAILOVER_RESTORE_LEVEL2 = 2;
    protected static final int FAILOVER_RESTORE_AUTO = 3;
    protected ReplayableConnection.StateRestorationType stateRestorationType;
    protected boolean isStateRestorationAuto;
    protected static final String INITIATION_TIMEOUT_PROPERTY = "AUTH_FAILOVER_REPLAYTIMEOUT";
    protected int replayInitiationTimeout;
    protected static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";
    protected final String clientChecksum12x;
    protected final String clientChecksum11203x;
    protected static final String IGNORE_AC_CONTEXT_PROPERTY = "oracle.jdbc.ignoreReplayContextFromAuthentication";
    private static final String AC_11203_COMPATIBLE_SYSTEM_PROPERTY = "oracle.jdbc.AC11203Compatible";
    private static final String IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY = "oracle.jdbc.beginRequestAtConnectionCreation";
    protected static final String ENABLE_AC_SUPPORT_PROPERTY = "oracle.jdbc.enableACSupport";
    protected static final String REQUEST_SIZE_LIMIT_PROPERTY = "oracle.jdbc.replay.protectedRequestSizeLimit";
    private StatisticsTracker tracker;
    protected AtomicBoolean doneDumpOnMemoryPressure;
    private static final String registeredName = "com.oracle.jdbc:type=ReplayStatistics,name=";
    private static ObjectName mbeanName;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;

    public OracleDataSource() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$97, Level.FINEST, OracleDataSource.class, $$$methodRef$$$97, null, new Object[0]);
            }
            this.logWriter = null;
            this.loginTimeout = 0;
            this.databaseName = null;
            this.serviceName = null;
            this.dataSourceName = "OracleDataSource";
            this.description = null;
            this.networkProtocol = "tcp";
            this.portNumber = 0;
            this.user = null;
            this.password = null;
            this.serverName = null;
            this.url = null;
            this.driverType = null;
            this.tnsEntry = null;
            this.maxStatements = 0;
            this.implicitCachingEnabled = false;
            this.explicitCachingEnabled = false;
            this.maxStatementsSet = false;
            this.implicitCachingEnabledSet = false;
            this.explicitCachingEnabledSet = false;
            this.connectionProperties = null;
            this.isOracleDataSource = true;
            this.roleName = null;
            this.urlExplicit = false;
            this.useDefaultConnection = false;
            this.driver = new OracleDriver();
            this.monitorLock = this.newDefaultLock();
            this.connectionInitializationCallback = null;
            this.isFirstConnection = new AtomicBoolean(true);
            this.reconnectDelay = 10;
            this.reconnectRetries = 30;
            this.isTransactionReplayEnabled = false;
            this.isAutoACEnabled = false;
            this.isReplayInDynamicMode = true;
            this.stateRestorationType = ReplayableConnection.StateRestorationType.NONE;
            this.isStateRestorationAuto = false;
            this.replayInitiationTimeout = 300;
            this.clientChecksum12x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS.toString();
            this.clientChecksum11203x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL.toString();
            this.tracker = null;
            this.doneDumpOnMemoryPressure = new AtomicBoolean(false);
            this.tracker = new StatisticsTracker();
            ReplayStatisticsMBeanImpl.SOLE_INSTANCE.addTrackerForDS(this.tracker);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$97, Level.FINEST, OracleDataSource.class, $$$methodRef$$$97, null);
                ClioSupport.exiting($$$loggerRef$$$97, Level.FINEST, OracleDataSource.class, $$$methodRef$$$97, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$97, Level.FINEST, OracleDataSource.class, $$$methodRef$$$97, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, new Object[0]);
            }
            String localUser = null;
            OpaqueString localPassword = OpaqueString.NULL;
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                localUser = this.user;
                localPassword = this.password;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, throwable3);
                }
                throw throwable3;
            }
            Connection connection = this.getConnection(localUser, localPassword);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, connection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSource.class, $$$methodRef$$$0, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void password;
            void user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, string, "*****");
            }
            Connection connection = this.getConnection((String)user, OpaqueString.newOpaqueString((String)password));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, connection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSource.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection getConnection(String string, OpaqueString opaqueString) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _passwd;
            void _user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, string, opaqueString);
            }
            OracleConnectionBuilderImpl connectionBuilder = (OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)this.createConnectionBuilder().user((String)_user)).password((OpaqueString)_passwd);
            boolean useProxy = this.isACSupportPropertySet();
            Connection connection = this.getConnectionInternal(connectionBuilder, useProxy);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, connection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSource.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection getConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            Properties prop;
            void builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, oracleConnectionBuilderImpl);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                OracleDataSource.validateGSSCredentialConfiguration((OracleConnectionBuilderImpl)builder);
                this.makeURL();
                prop = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
                this.applyDataSourcePropertiesForGetConnectionWithBuilder(prop);
                OracleDataSource.applyBuilderProperties((OracleConnectionBuilderImpl)builder, prop);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, throwable3);
                }
                throw throwable3;
            }
            Connection conn = this.getPhysicalConnection(prop, (AbstractConnectionBuilder)builder);
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            Connection connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, connection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSource.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompletionStage<OracleConnection> getConnectionAsync(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            Properties prop;
            void builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, oracleConnectionBuilderImpl);
            }
            try {
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    OracleDataSource.validateGSSCredentialConfiguration((OracleConnectionBuilderImpl)builder);
                    this.makeURL();
                    prop = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
                    this.applyDataSourcePropertiesForGetConnectionWithBuilder(prop);
                    OracleDataSource.applyBuilderProperties((OracleConnectionBuilderImpl)builder, prop);
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException preConnectFailure) {
                CompletionStage<OracleConnection> completionStage = CompletionStageUtil.failedStage(preConnectFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, null);
                }
                return completionStage;
            }
            CompletionStage<OracleConnection> completionStage = this.getPhysicalConnectionAsync(prop, (AbstractConnectionBuilder)builder).thenApply(oracleConnection -> {
                boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
                try {
                    OracleConnection conn;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$96, Level.FINEST, OracleDataSource.class, $$$methodRef$$$96, null, oracleConnection);
                    }
                    if (conn == null) {
                        CompletionException completionException = new CompletionException(DatabaseError.createSqlException(67).fillInStackTrace());
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$96, Level.FINEST, OracleDataSource.class, $$$methodRef$$$96, null, completionException);
                        }
                        throw completionException;
                    }
                    OracleConnection oracleConnection2 = conn;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$96, Level.FINEST, OracleDataSource.class, $$$methodRef$$$96, null, oracleConnection2);
                        ClioSupport.exiting($$$loggerRef$$$96, Level.FINEST, OracleDataSource.class, $$$methodRef$$$96, null, null);
                    }
                    return oracleConnection2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$96, Level.FINEST, OracleDataSource.class, $$$methodRef$$$96, null, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSource.class, $$$methodRef$$$4, this, throwable4);
            }
            throw throwable;
        }
    }

    private static final void validateGSSCredentialConfiguration(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnectionBuilderImpl builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, null, oracleConnectionBuilderImpl);
            }
            if (builder.getGSSCredential() != null && (builder.getUser() != null || builder.getPassword() != null && builder.getPassword() != OpaqueString.NULL)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68, "GSSCredential and user/password cannot both be set in a connection builder.").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDataSource.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyDataSourcePropertiesForGetConnectionWithBuilder(@Blind(value=PropertiesBlinder.class) Properties properties) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (this.url != null) {
                prop.setProperty("connection_url", this.url);
            }
            if (this.loginTimeout != 0) {
                prop.setProperty("oracle.jdbc.loginTimeout", String.valueOf(this.loginTimeout));
            }
            if (this.maxStatementsSet) {
                prop.setProperty("stmt_cache_size", String.valueOf(this.maxStatements));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void applyBuilderProperties(OracleConnectionBuilderImpl oracleConnectionBuilderImpl, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connectionProperties;
            OracleConnectionBuilderImpl builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, null, oracleConnectionBuilderImpl, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            OpaqueString passwd = builder.getPassword();
            if (builder.getUser() != null && passwd != null && passwd != OpaqueString.NULL) {
                connectionProperties.setProperty("user", builder.getUser());
                connectionProperties.setProperty("password", passwd.get());
            }
            if (builder.getInstanceName() != null) {
                connectionProperties.setProperty("oracle.jdbc.targetInstanceName", builder.getInstanceName());
            }
            if (builder.getServiceName() != null && !builder.getServiceName().equalsIgnoreCase(DEFAULT_SERVICE_NAME)) {
                connectionProperties.setProperty("oracle.jdbc.targetServiceName", builder.getServiceName());
            }
            if (builder.getShardingKey() != null) {
                String b64EncodedShardingKey = builder.getShardingKey().encodeKeyinB64Format();
                connectionProperties.setProperty("oracle.jdbc.targetShardingKey", b64EncodedShardingKey);
            }
            if (builder.getSuperShardingKey() != null) {
                String b64EncodedSuperKey = builder.getSuperShardingKey().encodeKeyinB64Format();
                connectionProperties.setProperty("oracle.jdbc.targetSuperShardingKey", b64EncodedSuperKey);
            }
            if (builder.getReadOnlyInstanceAllowed()) {
                connectionProperties.setProperty("oracle.jdbc.readOnlyInstanceAllowed", String.valueOf(builder.getReadOnlyInstanceAllowed()));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDataSource.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyDataSourcePropertiesToBuilder(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, abstractConnectionBuilder);
            }
            if (builder == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, null);
                }
                return;
            }
            if (this.sslContext != null && builder.getSSLContext() == null) {
                builder.sslContext(this.sslContext);
            }
            if (this.allowSingleShardTransaction && !builder.getAllowSingleShardTransaction()) {
                builder.singleShardTransactionSupport(this.allowSingleShardTransaction);
            }
            if (this.hostnameResolver != null && builder.getHostnameResolver() == null) {
                builder.hostnameResolver(this.hostnameResolver);
            }
            this.configureTokenSupplier((AbstractConnectionBuilder<?, ?>)builder);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSource.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configureTokenSupplier(AbstractConnectionBuilder<?, ?> abstractConnectionBuilder) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            Supplier<? extends AccessToken> tokenSupplier;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, abstractConnectionBuilder);
            }
            if ((tokenSupplier = this.tokenSupplier) == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, null);
                }
                return;
            }
            if (this.isUserOrPasswordConfigured()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 1718, "DataSource configured with setTokenSupplier(Supplier) is also configured with a user name or password").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            if (builder == null || builder.getTokenSupplier() != null || builder.getUser() != null || builder.getPassword() != null && !builder.getPassword().isNull()) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, null);
                }
                return;
            }
            builder.setTokenSupplier(tokenSupplier);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSource.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean isUserOrPasswordConfigured() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    boolean bl3;
                    boolean bl4 = bl3 = this.user != null || this.password != null && !this.password.isNull() || this.connectionProperties != null && (this.connectionProperties.containsKey("user") || this.connectionProperties.containsKey("oracle.jdbc.user") || this.connectionProperties.containsKey("password") || this.connectionProperties.containsKey("oracle.jdbc.password"));
                    if (lock != null) {
                        lock.close();
                    }
                    bl2 = bl3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDataSource.class, $$$methodRef$$$10, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection getPhysicalConnection(@Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder abstractConnectionBuilder) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean localUseDefaultConnection;
            void builder;
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            String localUrl = prop.getProperty("connection_url", this.url);
            String localUser = prop.getProperty("user");
            boolean hasGSSCredential = builder != null && builder.getGSSCredential() != null;
            Properties localProps = this.createPropertiesForPhysicalConnection((Properties)prop, hasGSSCredential);
            if (bl) {
                this.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "OracleDataSource.getPhysicalConnection(prop): URL is" + localUrl + ", user: " + localUser);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                localUseDefaultConnection = this.useDefaultConnection;
                if (this.driver == null) {
                    this.driver = new OracleDriver();
                }
                this.applyDataSourcePropertiesToBuilder((AbstractConnectionBuilder<?, ?>)builder);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, throwable3);
                }
                throw throwable3;
            }
            Connection conn = localUseDefaultConnection ? this.driver.defaultConnection() : this.driver.connect(localUrl, localProps, (AbstractConnectionBuilder<?, ?>)builder);
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, sQLException);
                }
                throw sQLException;
            }
            this.initializeStatementCacheForPhysicalConnection((oracle.jdbc.internal.OracleConnection)conn, (Properties)prop);
            Connection connection = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, connection);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDataSource.class, $$$methodRef$$$11, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompletionStage<OracleConnection> getPhysicalConnectionAsync(@Blind(value=PropertiesBlinder.class) Properties properties, AbstractConnectionBuilder abstractConnectionBuilder) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), abstractConnectionBuilder);
            }
            String localUrl = prop.getProperty("connection_url", this.url);
            String localUser = prop.getProperty("user");
            boolean hasGSSCredential = builder != null && builder.getGSSCredential() != null;
            Properties localProps = this.createPropertiesForPhysicalConnection((Properties)prop, hasGSSCredential);
            if (bl) {
                this.debug($$$loggerRef$$$12, Level.FINEST, $$$methodRef$$$12, "OracleDataSource.getPhysicalConnection(prop): URL is" + localUrl + ", user: " + localUser);
            }
            if (this.useDefaultConnection) {
                CompletionStage<OracleConnection> completionStage = CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connections are not supported by the server-side internal driver"));
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, null);
                }
                return completionStage;
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                if (this.driver == null) {
                    this.driver = new OracleDriver();
                }
                try {
                    this.applyDataSourcePropertiesToBuilder((AbstractConnectionBuilder<?, ?>)builder);
                }
                catch (SQLException sqlException) {
                    CompletionStage<OracleConnection> completionStage = CompletionStageUtil.failedStage(sqlException);
                    if (lock != null) {
                        lock.close();
                    }
                    CompletionStage<OracleConnection> completionStage2 = completionStage;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, completionStage2);
                        ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, null);
                    }
                    return completionStage2;
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, throwable3);
                }
                throw throwable3;
            }
            CompletionStage<OracleConnection> completionStage = this.driver._INTERNAL_ORACLE_connectAsync(localUrl, localProps, (AbstractConnectionBuilder<?, ?>)builder).thenApply(CompletionStageUtil.normalCompletionHandler(arg_0 -> this.lambda$getPhysicalConnectionAsync$1((Properties)prop, arg_0)));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSource.class, $$$methodRef$$$12, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind(value=PropertiesBlinder.class)
    private final Properties createPropertiesForPhysicalConnection(@Blind(value=PropertiesBlinder.class) Properties properties, boolean bl) {
        boolean bl2 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void hasGSSCredential;
            String localLoginTimeout;
            String isReadOnlyInstanceAllowed;
            String superShardingKeyStr;
            String shardingKeyStr;
            String localServiceName;
            String localInstanceName;
            String localPassword;
            void internalProperties;
            Monitor.CloseableLock lock;
            block33: {
                void var16_8;
                block34: {
                    if (bl2) {
                        ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties), bl);
                    }
                    lock = this.acquireCloseableLock();
                    try {
                        if (this.connectionProperties != null) break block33;
                        void var5_5 = internalProperties;
                        if (lock != null) {
                            lock.close();
                        }
                        var16_8 = var5_5;
                        if (!bl2) break block34;
                    }
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        Throwable throwable3 = throwable;
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, throwable3);
                        }
                        throw throwable3;
                    }
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, TraceControllerImpl.blind(PropertiesBlinder.class, var16_8));
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, null);
                }
                return var16_8;
            }
            Properties physicalConnectionProperties = (Properties)this.connectionProperties.clone();
            if (lock != null) {
                lock.close();
            }
            String localUser = internalProperties.getProperty("user");
            if (localUser != null) {
                physicalConnectionProperties.setProperty("user", localUser);
            }
            if ((localPassword = internalProperties.getProperty("password")) != null) {
                physicalConnectionProperties.put("password", localPassword);
            }
            if ((localInstanceName = internalProperties.getProperty("oracle.jdbc.targetInstanceName")) != null) {
                physicalConnectionProperties.put("oracle.jdbc.targetInstanceName", localInstanceName);
            }
            if ((localServiceName = internalProperties.getProperty("oracle.jdbc.targetServiceName")) != null) {
                physicalConnectionProperties.put("oracle.jdbc.targetServiceName", localServiceName);
            }
            if ((shardingKeyStr = internalProperties.getProperty("oracle.jdbc.targetShardingKey")) != null) {
                physicalConnectionProperties.put("oracle.jdbc.targetShardingKey", shardingKeyStr);
            }
            if ((superShardingKeyStr = internalProperties.getProperty("oracle.jdbc.targetSuperShardingKey")) != null) {
                physicalConnectionProperties.put("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
            }
            if ("true".equalsIgnoreCase(isReadOnlyInstanceAllowed = internalProperties.getProperty("oracle.jdbc.readOnlyInstanceAllowed"))) {
                physicalConnectionProperties.put("oracle.jdbc.readOnlyInstanceAllowed", isReadOnlyInstanceAllowed);
            }
            if ((localLoginTimeout = internalProperties.getProperty("oracle.jdbc.loginTimeout")) == null) {
                localLoginTimeout = physicalConnectionProperties.getProperty("LoginTimeout");
            }
            if (localLoginTimeout != null) {
                physicalConnectionProperties.setProperty("oracle.jdbc.loginTimeout", localLoginTimeout);
            }
            if (hasGSSCredential == false) {
                Monitor.CloseableLock lock2 = this.acquireCloseableLock();
                try {
                    if (localUser == null && this.user != null) {
                        physicalConnectionProperties.put("user", this.user);
                    }
                    if (localPassword == null && this.password != null && this.password != OpaqueString.NULL) {
                        physicalConnectionProperties.put("password", this.password.get());
                    }
                    if (lock2 != null) {
                        lock2.close();
                    }
                }
                catch (Throwable throwable) {
                    if (lock2 != null) {
                        try {
                            lock2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    }
                    Throwable throwable5 = throwable;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, throwable5);
                    }
                    throw throwable5;
                }
            }
            Properties properties2 = physicalConnectionProperties;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable6 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSource.class, $$$methodRef$$$13, this, throwable6);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeStatementCacheForPhysicalConnection(oracle.jdbc.internal.OracleConnection oracleConnection, Properties properties) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void physicalConnection;
            void internalProperties;
            String cacheSizeProperty;
            int cacheSizePropertyValue;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, oracleConnection, properties);
            }
            int n2 = cacheSizePropertyValue = (cacheSizeProperty = internalProperties.getProperty("stmt_cache_size")) == null ? 0 : Integer.parseInt(cacheSizeProperty);
            if (cacheSizeProperty != null) {
                physicalConnection.setStatementCacheSize(cacheSizePropertyValue);
            }
            String enableExplicitProperty = internalProperties.getProperty("ExplicitStatementCachingEnabled");
            boolean enableExplicitPropertyValue = "true".equals(enableExplicitProperty);
            if (enableExplicitProperty != null) {
                physicalConnection.setExplicitCachingEnabled(enableExplicitPropertyValue);
            } else if (this.explicitCachingEnabled) {
                physicalConnection.setExplicitCachingEnabled(true);
            }
            String enableImplicitProperty = internalProperties.getProperty("ImplicitStatementCachingEnabled");
            boolean enableImplicitPropertyValue = "true".equals(enableImplicitProperty);
            if (enableImplicitProperty != null) {
                physicalConnection.setImplicitCachingEnabled(enableImplicitPropertyValue);
            } else if (this.implicitCachingEnabled) {
                physicalConnection.setImplicitCachingEnabled(true);
            }
            if (cacheSizePropertyValue > 0 && !enableExplicitPropertyValue && !enableImplicitPropertyValue) {
                physicalConnection.setImplicitCachingEnabled(true);
                physicalConnection.setExplicitCachingEnabled(true);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSource.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getLoginTimeout() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    int n3 = this.loginTimeout;
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, n2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDataSource.class, $$$methodRef$$$15, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLoginTimeout(int n2) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, n2);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void timeout;
                this.loginTimeout = timeout;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDataSource.class, $$$methodRef$$$16, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLogWriter(PrintWriter printWriter) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, printWriter);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void pw;
                this.logWriter = pw;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDataSource.class, $$$methodRef$$$17, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            PrintWriter printWriter;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    PrintWriter printWriter2 = this.logWriter;
                    if (lock != null) {
                        lock.close();
                    }
                    printWriter = printWriter2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, printWriter);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, null);
            }
            return printWriter;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDataSource.class, $$$methodRef$$$18, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTNSEntryName(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void dbname;
                this.tnsEntry = dbname;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDataSource.class, $$$methodRef$$$19, this, throwable4);
            }
            throw throwable;
        }
    }

    public String getTNSEntryName() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.tnsEntry;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, string);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDataSource.class, $$$methodRef$$$20, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDataSourceName(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void dsname;
                this.dataSourceName = dsname;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDataSource.class, $$$methodRef$$$21, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getDataSourceName() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.dataSourceName;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, string);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDataSource.class, $$$methodRef$$$22, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getDatabaseName() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.databaseName;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, string);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDataSource.class, $$$methodRef$$$23, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDatabaseName(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void dbname;
                this.databaseName = dbname;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDataSource.class, $$$methodRef$$$24, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setServiceName(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void svcname;
                this.serviceName = svcname;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDataSource.class, $$$methodRef$$$25, this, throwable4);
            }
            throw throwable;
        }
    }

    public String getServiceName() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.serviceName;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, string);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDataSource.class, $$$methodRef$$$26, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setServerName(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void sn;
                this.serverName = sn;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDataSource.class, $$$methodRef$$$27, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getServerName() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.serverName;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, string);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDataSource.class, $$$methodRef$$$28, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setURL(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void url;
                this.url = url;
                if (this.url != null) {
                    this.urlExplicit = true;
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDataSource.class, $$$methodRef$$$29, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getURL() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block12: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    if (!this.urlExplicit) {
                        this.makeURL();
                    }
                    String string2 = this.url;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, string);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDataSource.class, $$$methodRef$$$30, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUser(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void userName;
                this.user = userName;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDataSource.class, $$$methodRef$$$31, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getUser() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, new Object[0]);
            }
            String string = this.user;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, string);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDataSource.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setPassword(OpaqueString opaqueString) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, opaqueString);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void os;
                this.password = os;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleDataSource.class, $$$methodRef$$$33, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPassword(@Blind String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, "*****");
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void pd;
                this.setPassword(OpaqueString.newOpaqueString((String)pd));
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleDataSource.class, $$$methodRef$$$34, this, throwable4);
            }
            throw throwable;
        }
    }

    protected OpaqueString getPassword() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, new Object[0]);
            }
            OpaqueString opaqueString = this.password;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, opaqueString);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, null);
            }
            return opaqueString;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleDataSource.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getDescription() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.description;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, string);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleDataSource.class, $$$methodRef$$$36, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDescription(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void des;
                this.description = des;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleDataSource.class, $$$methodRef$$$37, this, throwable4);
            }
            throw throwable;
        }
    }

    public String getDriverType() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.driverType;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, string);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleDataSource.class, $$$methodRef$$$38, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDriverType(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void dt;
                this.driverType = dt;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleDataSource.class, $$$methodRef$$$39, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public String getNetworkProtocol() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    String string2 = this.networkProtocol;
                    if (lock != null) {
                        lock.close();
                    }
                    string = string2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, string);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleDataSource.class, $$$methodRef$$$40, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNetworkProtocol(String string) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, string);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void np;
                this.networkProtocol = np;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleDataSource.class, $$$methodRef$$$41, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPortNumber(int n2) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, n2);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void pn;
                this.portNumber = pn;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleDataSource.class, $$$methodRef$$$42, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public int getPortNumber() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    int n3 = this.portNumber;
                    if (lock != null) {
                        lock.close();
                    }
                    n2 = n3;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, n2);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleDataSource.class, $$$methodRef$$$43, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            Reference reference;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.datasource.impl.OracleDataSourceFactory", null);
                    this.addRefProperties(ref);
                    Reference reference2 = ref;
                    if (lock != null) {
                        lock.close();
                    }
                    reference = reference2;
                    if (!bl) break block11;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, reference);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, null);
            }
            return reference;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleDataSource.class, $$$methodRef$$$44, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addRefProperties(Reference reference) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void ref;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this, reference);
            }
            if (this.url != null) {
                ref.add(new StringRefAddr("url", this.url));
            }
            if (this.user != null) {
                ref.add(new StringRefAddr("userName", this.user));
            }
            if (this.password != null && this.password != OpaqueString.NULL) {
                ref.add(new StringRefAddr("passWord", this.password.get()));
            }
            if (this.description != null) {
                ref.add(new StringRefAddr("description", this.description));
            }
            if (this.driverType != null) {
                ref.add(new StringRefAddr("driverType", this.driverType));
            }
            if (this.serverName != null) {
                ref.add(new StringRefAddr("serverName", this.serverName));
            }
            if (this.databaseName != null) {
                ref.add(new StringRefAddr("databaseName", this.databaseName));
            }
            if (this.serviceName != null) {
                ref.add(new StringRefAddr("serviceName", this.serviceName));
            }
            if (this.networkProtocol != null) {
                ref.add(new StringRefAddr("networkProtocol", this.networkProtocol));
            }
            if (this.portNumber != 0) {
                ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
            }
            if (this.tnsEntry != null) {
                ref.add(new StringRefAddr("tnsentryname", this.tnsEntry));
            }
            if (this.connectionProperties != null && this.connectionProperties.size() > 0) {
                ref.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
            }
            if (this.maxStatementsSet) {
                ref.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
            }
            if (this.implicitCachingEnabledSet) {
                ref.add(new StringRefAddr("implicitCachingEnabled", this.implicitCachingEnabled ? "true" : "false"));
            }
            if (this.explicitCachingEnabledSet) {
                ref.add(new StringRefAddr("explicitCachingEnabled", this.explicitCachingEnabled ? "true" : "false"));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleDataSource.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void makeURL() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, new Object[0]);
            }
            if (this.urlExplicit) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this);
                    ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, null);
                }
                return;
            }
            if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, sQLException);
                }
                throw sQLException;
            }
            if (this.driverType.equals("kprb")) {
                this.useDefaultConnection = true;
                this.url = "jdbc:oracle:kprb:@";
                if (bl) {
                    this.debug($$$loggerRef$$$46, Level.FINEST, $$$methodRef$$$46, "OracleDataSource.makeURL(): useDefaultConnection=" + this.useDefaultConnection + ", url=" + this.url);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this);
                    ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, null);
                }
                return;
            }
            if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
                this.url = "jdbc:oracle:oci:@";
                if (bl) {
                    this.debug($$$loggerRef$$$46, Level.FINEST, $$$methodRef$$$46, "OracleDataSource.makeURL(): url=" + this.url);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this);
                    ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, null);
                }
                return;
            }
            if (this.tnsEntry != null) {
                this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
                if (bl) {
                    this.debug($$$loggerRef$$$46, Level.FINEST, $$$methodRef$$$46, "OracleDataSource.makeURL(): url=" + this.url);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this);
                    ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, null);
                }
                return;
            }
            if (this.serviceName != null) {
                this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
            } else {
                this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
                DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
            }
            if (bl) {
                this.debug($$$loggerRef$$$46, Level.FINEST, $$$methodRef$$$46, "OracleDataSource.makeURL(): url=" + this.url);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSource.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void trace(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, string);
            }
            if (bl) {
                void s2;
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "OracleDataSource.trace(" + (String)s2 + "): logWriter=" + this.logWriter);
            }
            if (this.logWriter != null && bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "OracleDataSource.trace(s): logWriter is not null");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleDataSource.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxStatements(int n2) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void max;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, n2);
            }
            if (max < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, sQLException);
                }
                throw sQLException;
            }
            this.maxStatementsSet = true;
            this.maxStatements = max;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSource.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, new Object[0]);
            }
            int n2 = this.maxStatements;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, n2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleDataSource.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, bl);
            }
            this.implicitCachingEnabledSet = true;
            this.implicitCachingEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSource.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, new Object[0]);
            }
            boolean bl2 = this.implicitCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleDataSource.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this, bl);
            }
            this.explicitCachingEnabledSet = true;
            this.explicitCachingEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSource.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, new Object[0]);
            }
            boolean bl2 = this.explicitCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleDataSource.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void properties2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            if (properties2 == null || properties2.size() == 0) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this);
                    ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, null);
                }
                return;
            }
            if (this.connectionProperties == null || this.connectionProperties.size() == 0) {
                this.connectionProperties = (Properties)properties2.clone();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this);
                    ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, null);
                }
                return;
            }
            Enumeration<?> keys = properties2.propertyNames();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                this.connectionProperties.put(key, properties2.get(key));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSource.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRoleName(String string) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void roleName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this, string);
            }
            this.roleName = roleName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleDataSource.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getRoleName() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, new Object[0]);
            }
            String string = this.roleName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, string);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, OracleDataSource.class, $$$methodRef$$$56, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getConnectionProperties() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, new Object[0]);
            }
            Properties properties = OracleDataSource.filterConnectionProperties(this.connectionProperties);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleDataSource.class, $$$methodRef$$$57, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getConnectionProperty(String string) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string2;
            void propertyName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, string);
            }
            if (OracleDataSource.isSensitiveProperty((String)propertyName)) {
                String string3 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, string3);
                    ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, null);
                }
                return null;
            }
            String string4 = string2 = this.connectionProperties == null ? null : this.connectionProperties.getProperty((String)propertyName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, string2);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, null);
            }
            return string4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSource.class, $$$methodRef$$$58, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnectionProperty(String string, String string2) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void name;
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, string, string2);
            }
            if (value == null || value.equals("")) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            if (this.connectionProperties == null) {
                this.connectionProperties = new Properties();
            }
            this.connectionProperties.setProperty((String)name, (String)value);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, OracleDataSource.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public static final Properties filterConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties properties) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            Properties prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties));
            }
            Properties result = null;
            if (prop != null) {
                result = (Properties)prop.clone();
                Enumeration<?> enu = result.propertyNames();
                Object c2 = null;
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    if (!OracleDataSource.isSensitiveProperty(key)) continue;
                    result.remove(key);
                }
            }
            Properties properties2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, null, TraceControllerImpl.blind(PropertiesBlinder.class, properties2));
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, null, null);
            }
            return properties2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, OracleDataSource.class, $$$methodRef$$$60, null, throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isSensitiveProperty(String string) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            String name;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, string);
            }
            if (name == null) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, bl2);
                    ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, null);
                }
                return false;
            }
            switch (name) {
                case "oracle.jdbc.passwordAuthentication": {
                    boolean bl3 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, bl3);
                        ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, null);
                    }
                    return false;
                }
                case "oracle.jdbc.accessToken": {
                    boolean bl4 = true;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, bl4);
                        ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, null);
                    }
                    return true;
                }
            }
            boolean bl5 = name.matches(".*[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd].*");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, bl5);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, null);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, OracleDataSource.class, $$$methodRef$$$61, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, objectOutputStream);
            }
            out.defaultWriteObject();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this);
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, OracleDataSource.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, this, objectInputStream);
            }
            in.defaultReadObject();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, this);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, OracleDataSource.class, $$$methodRef$$$63, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, clazz);
            }
            if (iface.isInterface()) {
                boolean bl2 = iface.isInstance(this);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, null);
                }
                return bl2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, OracleDataSource.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, clazz);
            }
            if (iface.isInterface() && iface.isInstance(this)) {
                OracleDataSource oracleDataSource = this;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, oracleDataSource);
                    ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, null);
                }
                return (T)oracleDataSource;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, OracleDataSource.class, $$$methodRef$$$65, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, new Object[0]);
            }
            Logger logger = Logger.getLogger("oracle");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, logger);
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, OracleDataSource.class, $$$methodRef$$$66, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setSSLContext(SSLContext sSLContext) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, sSLContext);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void sslContext;
                this.sslContext = sslContext;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this);
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$67, Level.FINEST, OracleDataSource.class, $$$methodRef$$$67, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSingleShardTransactionSupport(boolean bl) throws SQLException {
        boolean bl2 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, bl);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void allow;
                this.allowSingleShardTransaction = allow;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, throwable3);
                }
                throw throwable3;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this);
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$68, Level.FINEST, OracleDataSource.class, $$$methodRef$$$68, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setHostnameResolver(OracleHostnameResolver oracleHostnameResolver) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, oracleHostnameResolver);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void hostnameResolver;
                this.hostnameResolver = hostnameResolver;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this);
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$69, Level.FINEST, OracleDataSource.class, $$$methodRef$$$69, this, throwable4);
            }
            throw throwable;
        }
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, new Object[0]);
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$70, Level.FINEST, OracleDataSource.class, $$$methodRef$$$70, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, new Object[0]);
            }
            OracleConnectionBuilderImpl oracleConnectionBuilderImpl = new OracleConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;
                private static Executable $$$methodRef$$$5;
                private static Logger $$$loggerRef$$$5;
                private static Executable $$$methodRef$$$6;
                private static Logger $$$loggerRef$$$6;
                private static Executable $$$methodRef$$$7;
                private static Logger $$$loggerRef$$$7;

                @Override
                public Flow.Publisher<OracleConnection> buildConnectionPublisherOracle() throws SQLException {
                    this.ensureMutableState();
                    this.verifyBuildConfiguration();
                    return new ConnectionPublisher(this, OracleDataSource.this);
                }

                @Override
                public CompletionStage<OracleConnection> buildAsyncOracle() throws SQLException {
                    this.ensureMutableState();
                    this.verifyBuildConfiguration();
                    CompletableFuture<OracleConnection> connectionFuture = new CompletableFuture<OracleConnection>();
                    OracleDataSource.this.getConnectionAsync(this).whenComplete((connection, error) -> {
                        if (error == null) {
                            connectionFuture.complete((OracleConnection)connection);
                        } else {
                            Throwable errorCause = CompletionStageUtil.unwrapCompletionException(error);
                            connectionFuture.completeExceptionally(errorCause);
                        }
                    });
                    return connectionFuture;
                }

                @Override
                public oracle.jdbc.internal.OracleConnection build() throws SQLException {
                    boolean bl;
                    boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
                    if (bl) {
                        OracleDataSource.this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleDataSource.OracleConnectionBuilder.build(): URL is" + OracleDataSource.this.url);
                    }
                    this.ensureMutableState();
                    this.verifyBuildConfiguration();
                    boolean useProxy = OracleDataSource.this.isACSupportPropertySet();
                    return (oracle.jdbc.internal.OracleConnection)OracleDataSource.this.getConnectionInternal(this, useProxy);
                }

                static {
                    try {
                        $$$methodRef$$$7 = 1.class.getDeclaredConstructor(OracleDataSource.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$6 = 1.class.getDeclaredMethod("lambda$buildAsyncOracle$0", CompletableFuture.class, OracleConnection.class, Throwable.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$5 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$4 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("buildAsyncOracle", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("buildConnectionPublisherOracle", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, oracleConnectionBuilderImpl);
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, null);
            }
            return oracleConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$71, Level.FINEST, OracleDataSource.class, $$$methodRef$$$71, this, throwable2);
            }
            throw throwable;
        }
    }

    private final boolean isACSupportPropertySet() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            String tempval;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, this, new Object[0]);
            }
            if ((tempval = OracleDataSource.getSystemProperty(ENABLE_AC_SUPPORT_PROPERTY, null)) == null) {
                tempval = this.getConnectionProperty(ENABLE_AC_SUPPORT_PROPERTY);
            }
            if (tempval == null) {
                tempval = "true";
            }
            boolean bl3 = bl2 = tempval != null && tempval.equalsIgnoreCase("true");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$72, Level.FINEST, OracleDataSource.class, $$$methodRef$$$72, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Connection getConnectionNoProxy(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, oracleConnectionBuilderImpl);
            }
            int retries = 1;
            Connection conn = null;
            Exception exc = null;
            do {
                block20: {
                    Connection connection;
                    block21: {
                        try {
                            void connBuilder;
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$73, Level.FINER, this.getClass(), $$$methodRef$$$73, "Reconnecting: RETRY {0}", retries);
                            }
                            exc = null;
                            connBuilder.instanceName(null);
                            conn = this.getConnectionInternal((OracleConnectionBuilderImpl)connBuilder, false);
                            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)conn;
                            if (oconn.isDRCPEnabled()) {
                                oconn.attachServerConnection();
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$73, Level.FINEST, this.getClass(), $$$methodRef$$$73, "DRCP attach completed");
                                }
                            }
                            if (conn == null || exc != null) break block20;
                            connection = conn;
                            if (!bl) break block21;
                        }
                        catch (Exception e2) {
                            block22: {
                                Connection connection2;
                                block23: {
                                    try {
                                        conn = null;
                                        exc = e2;
                                        if (bl) {
                                            OracleLog.log($$$loggerRef$$$73, Level.FINER, this.getClass(), $$$methodRef$$$73, "Reconnect FAILED, exception: {0}", e2);
                                        }
                                        if (conn == null || exc != null) break block22;
                                        connection2 = conn;
                                        if (!bl) break block23;
                                    }
                                    catch (Throwable throwable) {
                                        if (conn != null && exc == null) {
                                            Connection connection3 = conn;
                                            if (bl) {
                                                ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, connection3);
                                                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, null);
                                            }
                                            return connection3;
                                        }
                                        ++retries;
                                        Throwable throwable2 = throwable;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, throwable2);
                                        }
                                        throw throwable2;
                                    }
                                    ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, connection2);
                                    ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, null);
                                }
                                return connection2;
                            }
                            ++retries;
                        }
                        ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, connection);
                        ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, null);
                    }
                    return connection;
                }
                ++retries;
                try {
                    if (this.reconnectDelay <= 0) continue;
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$73, Level.FINER, this.getClass(), $$$methodRef$$$73, "Reconnecting: DELAY for {0} seconds", this.reconnectDelay);
                    }
                    Thread.sleep(this.reconnectDelay * 1000);
                }
                catch (InterruptedException sleepExc) {
                    if (!bl) continue;
                    OracleLog.log($$$loggerRef$$$73, Level.FINER, this.getClass(), $$$methodRef$$$73, "Reconnect threw exception during DELAY: {0}", sleepExc);
                }
            } while (retries <= this.reconnectRetries);
            Connection connection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, connection);
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$73, Level.FINEST, OracleDataSource.class, $$$methodRef$$$73, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Connection getConnectionInternal(OracleConnectionBuilderImpl oracleConnectionBuilderImpl, boolean bl) throws SQLException {
        boolean bl2 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            void useProxy;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$74, Level.FINEST, OracleDataSource.class, $$$methodRef$$$74, this, oracleConnectionBuilderImpl, bl);
            }
            Connection conn = null;
            if (this.isFirstConnection.get()) {
                this.setupACSpecificProperties((boolean)useProxy);
            }
            conn = this.getConnection((OracleConnectionBuilderImpl)builder);
            if (useProxy != false) {
                conn = this.enableACAndProxifyIfNecessary(conn, (OracleConnectionBuilderImpl)builder);
            }
            this.isFirstConnection.set(false);
            Connection connection = conn;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$74, Level.FINEST, OracleDataSource.class, $$$methodRef$$$74, this, connection);
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, OracleDataSource.class, $$$methodRef$$$74, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$74, Level.FINEST, OracleDataSource.class, $$$methodRef$$$74, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setupACSpecificProperties(boolean bl) throws SQLException {
        boolean bl2 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void useProxy;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, this, bl);
            }
            if (useProxy != false) {
                this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum12x);
            } else {
                this.setConnectionProperty(IGNORE_AC_CONTEXT_PROPERTY, "true");
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, this);
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$75, Level.FINEST, OracleDataSource.class, $$$methodRef$$$75, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Connection enableACAndProxifyIfNecessary(Connection var1_1, OracleConnectionBuilderImpl var2_2) throws SQLException {
        var16_3 = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (var16_3) {
                ClioSupport.entering(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, new Object[]{var1_1, var2_2});
            }
            useProxy = true;
            dbVersion = 0;
            oconn = (oracle.jdbc.internal.OracleConnection)conn;
            sessionProperties = oconn.getServerSessionInfo();
            failoverDelay = sessionProperties.getProperty("AUTH_FAILOVER_DELAY");
            if (failoverDelay != null && !"".equals(failoverDelay)) {
                _delay = Integer.parseInt(failoverDelay);
                if (_delay > 0) {
                    this.reconnectDelay = _delay;
                } else if (var16_3) {
                    OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.CONFIG, this.getClass(), OracleDataSource.$$$methodRef$$$76, "Server FAILOVER_DELAY: {0}, using driver default {1} seconds instead", new Object[]{_delay, 10});
                }
            }
            if ((failoverRetries = sessionProperties.getProperty("AUTH_FAILOVER_RETRIES")) != null && !"".equals(failoverRetries)) {
                _retries = Integer.parseInt(failoverRetries);
                if (_retries > 0) {
                    this.reconnectRetries = _retries;
                } else if (var16_3) {
                    OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.CONFIG, this.getClass(), OracleDataSource.$$$methodRef$$$76, "Server FAILOVER_RETRIES: {0}, using driver default {1} instead", new Object[]{_retries, 18});
                }
            }
            if ((failoverType = sessionProperties.getProperty("AUTH_FAILOVER_TYPE")) != null && !"".equals(failoverType)) {
                try {
                    wiredValue = Integer.parseInt(failoverType);
                }
                catch (NumberFormatException exc) {
                    wiredValue = 0;
                }
                this.isAutoACEnabled = (wiredValue & 32) == 32;
                this.isTransactionReplayEnabled = this.isAutoACEnabled != false || (wiredValue & 8) == 8;
                v0 = this.isReplayInDynamicMode = (wiredValue & 16) == 0;
            }
            if ((failoverRestore = sessionProperties.getProperty("AUTH_FAILOVER_RESTORE")) != null && !"".equals(failoverRestore) && "thin".equals(oconn.getProtocolType())) {
                _restore = Integer.parseInt(failoverRestore);
                this.stateRestorationType = ReplayableConnection.StateRestorationType.values()[_restore];
                if (this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.NONE) > 0) {
                    v1 = this.isStateRestorationAuto = this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.LEVEL2) >= 0;
                    if (this.isAutoACEnabled && !this.isStateRestorationAuto) {
                        if (var16_3) {
                            OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.WARNING, this.getClass(), OracleDataSource.$$$methodRef$$$76, "AC is disabled on {0}, because FAILOVER_TYPE at server is AUTO, while FAILOVER_RESTORE is not", conn);
                        }
                        useProxy = false;
                    }
                } else if (var16_3) {
                    OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.CONFIG, this.getClass(), OracleDataSource.$$$methodRef$$$76, "Server FAILOVER_RESTORE: {0}, disabling driver AC state restoration", _restore);
                }
            }
            if ((initiationTimeout = sessionProperties.getProperty("AUTH_FAILOVER_REPLAYTIMEOUT")) != null && !"".equals(initiationTimeout)) {
                this.replayInitiationTimeout = Integer.parseInt(initiationTimeout);
            }
            if ((dbVersion = oconn.getVersionNumber()) < 11203) {
                if (var16_3) {
                    OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.WARNING, this.getClass(), OracleDataSource.$$$methodRef$$$76, "AC is disabled on {0}, because server version does not support AC.", conn);
                }
                useProxy = false;
            } else if (dbVersion >= 12100 && !this.isTransactionReplayEnabled) {
                if (var16_3) {
                    OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.WARNING, this.getClass(), OracleDataSource.$$$methodRef$$$76, "AC is disabled on {0}, because FAILOVER_TYPE service attribute is not set to TRANSACTION in server", conn);
                }
                useProxy = false;
            } else if (dbVersion >= 11203 && dbVersion < 12100) {
                enableAC11203 = "true".equalsIgnoreCase(OracleDataSource.getSystemProperty("oracle.jdbc.AC11203Compatible", "false"));
                if (enableAC11203) {
                    conn.close();
                    this.setConnectionProperty("oracle.jdbc.calculateChecksum", this.clientChecksum11203x);
                    conn = this.getConnection((OracleConnectionBuilderImpl)connBuilder);
                    lock = OracleDataSource.proxyFactoryLock.acquireCloseableLock();
                    try {
                        OracleDataSource.PROXY_FACTORY = OracleDataSource.NON_TXN_PROXY_FACTORY;
                        if (lock == null) ** GOTO lbl83
                        lock.close();
                    }
                    catch (Throwable var14_21) {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable var15_23) {
                                var14_21.addSuppressed(var15_23);
                            }
                        }
                        var18_24 = var14_21;
                        if (var16_3) {
                            ClioSupport.throwing(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, var18_24);
                        }
                        throw var18_24;
                    }
                } else {
                    if (var16_3) {
                        OracleLog.log(OracleDataSource.$$$loggerRef$$$76, Level.WARNING, this.getClass(), OracleDataSource.$$$methodRef$$$76, "AC is disabled on {0}, because server version does not support AC.", conn);
                    }
                    useProxy = false;
                }
            }
lbl83:
            // 7 sources

            if (useProxy) {
                connProxy = (Connection)OracleDataSource.PROXY_FACTORY.proxyFor(conn);
                rconn = (ReplayableConnection)connProxy;
                rconn.initialize(this, (OracleConnectionBuilderImpl)connBuilder);
                if (dbVersion >= 12100) {
                    rconn.setReplayInitiationTimeout(this.replayInitiationTimeout);
                    rconn.setAutoAC(this.isAutoACEnabled);
                    rconn.setSessionStateConsistency(this.isReplayInDynamicMode == false);
                    rconn.setSessionStateRestoration(this.stateRestorationType);
                }
                ((oracle.jdbc.internal.OracleConnection)conn).getReplayContext();
                enableImplicitBeginRequest = "true".equalsIgnoreCase(OracleDataSource.getSystemProperty("oracle.jdbc.beginRequestAtConnectionCreation", "true"));
                if (this.isAutoACEnabled && enableImplicitBeginRequest && !oconn.isDRCPEnabled()) {
                    rconn.beginRequest();
                }
                var17_26 = connProxy;
                if (var16_3) {
                    ClioSupport.returning(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, var17_26);
                    ClioSupport.exiting(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, null);
                }
                return var17_26;
            }
            var17_27 = conn;
            if (var16_3) {
                ClioSupport.returning(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, var17_27);
                ClioSupport.exiting(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, null);
            }
            return var17_27;
        }
        catch (Throwable v2) {
            var18_25 = v2;
            if (var16_3) {
                ClioSupport.exiting(OracleDataSource.$$$loggerRef$$$76, Level.FINEST, OracleDataSource.class, OracleDataSource.$$$methodRef$$$76, this, var18_25);
            }
            throw v2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cbk;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$77, Level.FINEST, OracleDataSource.class, $$$methodRef$$$77, this, connectionInitializationCallback);
            }
            if (cbk == null) {
                SQLException sQLException = DatabaseError.createSqlException(68);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$77, Level.FINEST, OracleDataSource.class, $$$methodRef$$$77, this, sQLException);
                }
                throw sQLException;
            }
            this.connectionInitializationCallback = cbk;
            if (bl) {
                OracleLog.log($$$loggerRef$$$77, Level.CONFIG, this.getClass(), $$$methodRef$$$77, "Connection Initialization Callback registered: {0}", cbk);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$77, Level.FINEST, OracleDataSource.class, $$$methodRef$$$77, this);
                ClioSupport.exiting($$$loggerRef$$$77, Level.FINEST, OracleDataSource.class, $$$methodRef$$$77, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$77, Level.FINEST, OracleDataSource.class, $$$methodRef$$$77, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cbk;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$78, Level.FINEST, OracleDataSource.class, $$$methodRef$$$78, this, connectionInitializationCallback);
            }
            if (cbk == null || this.connectionInitializationCallback != cbk) {
                SQLException sQLException = DatabaseError.createSqlException(68);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$78, Level.FINEST, OracleDataSource.class, $$$methodRef$$$78, this, sQLException);
                }
                throw sQLException;
            }
            this.connectionInitializationCallback = null;
            if (bl) {
                OracleLog.log($$$loggerRef$$$78, Level.CONFIG, this.getClass(), $$$methodRef$$$78, "Connection Initialization Callback removed: {0}", cbk);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$78, Level.FINEST, OracleDataSource.class, $$$methodRef$$$78, this);
                ClioSupport.exiting($$$loggerRef$$$78, Level.FINEST, OracleDataSource.class, $$$methodRef$$$78, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$78, Level.FINEST, OracleDataSource.class, $$$methodRef$$$78, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$79, Level.FINEST, OracleDataSource.class, $$$methodRef$$$79, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$79, Level.FINEST, this.getClass(), $$$methodRef$$$79, "connection initialization callback obtained: {0}", this.connectionInitializationCallback);
            }
            ConnectionInitializationCallback connectionInitializationCallback = this.connectionInitializationCallback;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$79, Level.FINEST, OracleDataSource.class, $$$methodRef$$$79, this, connectionInitializationCallback);
                ClioSupport.exiting($$$loggerRef$$$79, Level.FINEST, OracleDataSource.class, $$$methodRef$$$79, this, null);
            }
            return connectionInitializationCallback;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$79, Level.FINEST, OracleDataSource.class, $$$methodRef$$$79, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ReplayStatistics getReplayStatistics() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$80, Level.FINEST, OracleDataSource.class, $$$methodRef$$$80, this, new Object[0]);
            }
            ReplayStatistics replayStatistics = this.tracker.getReplayStatistics();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$80, Level.FINEST, OracleDataSource.class, $$$methodRef$$$80, this, replayStatistics);
                ClioSupport.exiting($$$loggerRef$$$80, Level.FINEST, OracleDataSource.class, $$$methodRef$$$80, this, null);
            }
            return replayStatistics;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$80, Level.FINEST, OracleDataSource.class, $$$methodRef$$$80, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clearDoneDumpOnMemoryPressure() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$81, Level.FINEST, OracleDataSource.class, $$$methodRef$$$81, this, new Object[0]);
            }
            this.doneDumpOnMemoryPressure.set(false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$81, Level.FINEST, OracleDataSource.class, $$$methodRef$$$81, this);
                ClioSupport.exiting($$$loggerRef$$$81, Level.FINEST, OracleDataSource.class, $$$methodRef$$$81, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$81, Level.FINEST, OracleDataSource.class, $$$methodRef$$$81, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String getReplayStatisticsString() {
        if (this.doneDumpOnMemoryPressure.compareAndSet(false, true)) {
            return null;
        }
        return this.tracker.getReplayStatisticsString();
    }

    @Override
    public void clearReplayStatistics() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$82, Level.FINEST, OracleDataSource.class, $$$methodRef$$$82, this, new Object[0]);
            }
            this.tracker.clearReplayStatistics();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$82, Level.FINEST, OracleDataSource.class, $$$methodRef$$$82, this);
                ClioSupport.exiting($$$loggerRef$$$82, Level.FINEST, OracleDataSource.class, $$$methodRef$$$82, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$82, Level.FINEST, OracleDataSource.class, $$$methodRef$$$82, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateReplayStatistics(oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void newStats;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$83, Level.FINEST, OracleDataSource.class, $$$methodRef$$$83, this, replayStatistics);
            }
            this.tracker.updateReplayStatistics(this.getDataSourceName(), (oracle.jdbc.replay.internal.ReplayStatistics)newStats);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$83, Level.FINEST, OracleDataSource.class, $$$methodRef$$$83, this);
                ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, OracleDataSource.class, $$$methodRef$$$83, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$83, Level.FINEST, OracleDataSource.class, $$$methodRef$$$83, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static String getSystemProperty(String string, String string2) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultValue;
            String property;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$84, Level.FINEST, OracleDataSource.class, $$$methodRef$$$84, null, string, string2);
            }
            if (property != null) {
                final String propStr = property;
                void propDefVal = defaultValue;
                final String[] rets = new String[]{defaultValue};
                AccessController.doPrivileged(new PrivilegedAction((String)propDefVal){
                    final /* synthetic */ String val$propDefVal;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    {
                        this.val$propDefVal = string2;
                    }

                    public Object run() {
                        rets[0] = System.getProperty(propStr, this.val$propDefVal);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 2.class.getDeclaredConstructor(String[].class, String.class, String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                String string3 = rets[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$84, Level.FINEST, OracleDataSource.class, $$$methodRef$$$84, null, string3);
                    ClioSupport.exiting($$$loggerRef$$$84, Level.FINEST, OracleDataSource.class, $$$methodRef$$$84, null, null);
                }
                return string3;
            }
            void var6_7 = defaultValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$84, Level.FINEST, OracleDataSource.class, $$$methodRef$$$84, null, var6_7);
                ClioSupport.exiting($$$loggerRef$$$84, Level.FINEST, OracleDataSource.class, $$$methodRef$$$84, null, null);
            }
            return var6_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$84, Level.FINEST, OracleDataSource.class, $$$methodRef$$$84, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getRequestSizeLimit() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$85, Level.FINEST, OracleDataSource.class, $$$methodRef$$$85, this, new Object[0]);
            }
            int limit = Integer.MAX_VALUE;
            String tempval = OracleDataSource.getSystemProperty(REQUEST_SIZE_LIMIT_PROPERTY, null);
            if (tempval == null) {
                tempval = this.getConnectionProperty(REQUEST_SIZE_LIMIT_PROPERTY);
            }
            if (tempval == null) {
                tempval = Integer.toString(Integer.MAX_VALUE);
            }
            try {
                limit = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$85, Level.WARNING, this.getClass(), $$$methodRef$$$85, "Request-size-limit property is set to an incorrect value with number format problem");
                }
                limit = Integer.MAX_VALUE;
            }
            int n2 = limit;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$85, Level.FINEST, OracleDataSource.class, $$$methodRef$$$85, this, n2);
                ClioSupport.exiting($$$loggerRef$$$85, Level.FINEST, OracleDataSource.class, $$$methodRef$$$85, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$85, Level.FINEST, OracleDataSource.class, $$$methodRef$$$85, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ProxyFactory getProxyFactory() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$86, Level.FINEST, OracleDataSource.class, $$$methodRef$$$86, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$86, Level.FINEST, this.getClass(), $$$methodRef$$$86, "PROXY FACTORY obtained: {0}", PROXY_FACTORY);
            }
            ProxyFactory proxyFactory = PROXY_FACTORY;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$86, Level.FINEST, OracleDataSource.class, $$$methodRef$$$86, this, proxyFactory);
                ClioSupport.exiting($$$loggerRef$$$86, Level.FINEST, OracleDataSource.class, $$$methodRef$$$86, this, null);
            }
            return proxyFactory;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$86, Level.FINEST, OracleDataSource.class, $$$methodRef$$$86, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static void registerMBean() {
        block14: {
            try {
                MBeanServer mbs = null;
                try {
                    Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    Object factory = cls.newInstance();
                    Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (NoClassDefFoundError ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (ClassNotFoundException ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (NoSuchMethodException ex) {
                    Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InstantiationException ex) {
                    Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not create an instance.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", ex);
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    ClassLoader loader = ReplayStatisticsMBeanImpl.class.getClassLoader();
                    String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                    int count = 0;
                    while (true) {
                        String nameSuffix = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        mbeanName = new ObjectName(registeredName + nameSuffix);
                        try {
                            mbs.registerMBean(ReplayStatisticsMBeanImpl.SOLE_INSTANCE, mbeanName);
                            break block14;
                        }
                        catch (InstanceAlreadyExistsException ex) {
                            Logger.getLogger("oracle.jdbc.internal.replay").log(Level.INFO, "AC statistics MBean with the same name already registered.");
                            continue;
                        }
                        break;
                    }
                }
                Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Unable to find an MBeanServer so no MBears are registered.");
            }
            catch (JMException ex) {
                Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Error while registering Oracle JDBC AC statistics MBean.", ex);
            }
            catch (Throwable ex) {
                Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Error while registering Oracle JDBC AC statistics MBean.", ex);
            }
        }
    }

    @Supports(value={Feature.PLATFORM})
    public static void unregisterMBean() {
        boolean bl = (0x80000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$87, Level.FINEST, OracleDataSource.class, $$$methodRef$$$87, null, new Object[0]);
            }
            try {
                MBeanServer mbs = null;
                try {
                    Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                    Object factory = cls.newInstance();
                    Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                    mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
                }
                catch (Throwable ex) {
                    mbs = ManagementFactory.getPlatformMBeanServer();
                }
                if (mbs != null) {
                    try {
                        ClassLoader loader = ReplayStatisticsMBeanImpl.class.getClassLoader();
                        String loaderName = loader == null ? "nullLoader" : loader.getClass().getName();
                        int count = 0;
                        String nameSuffix = loaderName + "@" + Integer.toHexString((loader == null ? 0 : loader.hashCode()) + count++);
                        mbeanName = new ObjectName(registeredName + nameSuffix);
                        mbs.unregisterMBean(mbeanName);
                    }
                    catch (Throwable ex) {
                        Logger.getLogger("oracle.jdbc.internal.replay").log(Level.INFO, "Unabled to unregister Oracle JDBC AC statistics MBean: " + ex.getMessage());
                    }
                } else {
                    Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Unable to find an MBeanServer to unregister Oracle JDBC AC statistics MBean.");
                }
            }
            catch (Throwable ex) {
                Logger.getLogger("oracle.jdbc.internal.replay").log(Level.WARNING, "Error while unregistering Oracle JDBC AC statistics MBean.", ex);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$87, Level.FINEST, OracleDataSource.class, $$$methodRef$$$87, null);
                ClioSupport.exiting($$$loggerRef$$$87, Level.FINEST, OracleDataSource.class, $$$methodRef$$$87, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$87, Level.FINEST, OracleDataSource.class, $$$methodRef$$$87, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void cleanup() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$88, Level.FINEST, OracleDataSource.class, $$$methodRef$$$88, null, new Object[0]);
            }
            OracleDataSource.unregisterMBean();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$88, Level.FINEST, OracleDataSource.class, $$$methodRef$$$88, null);
                ClioSupport.exiting($$$loggerRef$$$88, Level.FINEST, OracleDataSource.class, $$$methodRef$$$88, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$88, Level.FINEST, OracleDataSource.class, $$$methodRef$$$88, null, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$89, Level.FINEST, OracleDataSource.class, $$$methodRef$$$89, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$89, Level.FINEST, OracleDataSource.class, $$$methodRef$$$89, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$89, Level.FINEST, OracleDataSource.class, $$$methodRef$$$89, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$89, Level.FINEST, OracleDataSource.class, $$$methodRef$$$89, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTokenSupplier(Supplier<? extends AccessToken> supplier) {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tokenSupplier;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$90, Level.FINEST, OracleDataSource.class, $$$methodRef$$$90, this, supplier);
            }
            this.tokenSupplier = (Supplier)Objects.requireNonNull(tokenSupplier, "tokenSuplier is null");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$90, Level.FINEST, OracleDataSource.class, $$$methodRef$$$90, this);
                ClioSupport.exiting($$$loggerRef$$$90, Level.FINEST, OracleDataSource.class, $$$methodRef$$$90, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$90, Level.FINEST, OracleDataSource.class, $$$methodRef$$$90, this, throwable2);
            }
            throw throwable;
        }
    }

    private final OracleDataSource createCopyForConnectionPublisher() throws SQLException {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$91, Level.FINEST, OracleDataSource.class, $$$methodRef$$$91, this, new Object[0]);
            }
            OracleDataSource copy = new OracleDataSource();
            copy.implicitCachingEnabled = this.implicitCachingEnabled;
            copy.explicitCachingEnabled = this.explicitCachingEnabled;
            copy.connectionProperties = this.connectionProperties == null ? null : (Properties)this.connectionProperties.clone();
            copy.user = this.user;
            copy.password = this.password == null ? null : OpaqueString.newOpaqueString(this.password.get());
            copy.url = this.url;
            copy.useDefaultConnection = this.useDefaultConnection;
            copy.driver = null;
            copy.dataSourceName = this.dataSourceName;
            copy.loginTimeout = this.loginTimeout;
            copy.maxStatementsSet = this.maxStatementsSet;
            copy.urlExplicit = this.urlExplicit;
            copy.driverType = this.driverType;
            copy.networkProtocol = this.networkProtocol;
            copy.tnsEntry = this.tnsEntry;
            copy.serviceName = this.serviceName;
            copy.portNumber = this.portNumber;
            copy.serverName = this.serverName;
            OracleDataSource oracleDataSource = copy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$91, Level.FINEST, OracleDataSource.class, $$$methodRef$$$91, this, oracleDataSource);
                ClioSupport.exiting($$$loggerRef$$$91, Level.FINEST, OracleDataSource.class, $$$methodRef$$$91, this, null);
            }
            return oracleDataSource;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$91, Level.FINEST, OracleDataSource.class, $$$methodRef$$$91, this, throwable2);
            }
            throw throwable;
        }
    }

    private static Logger logger() {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$92, Level.FINEST, OracleDataSource.class, $$$methodRef$$$92, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.datasource.impl");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$92, Level.FINEST, OracleDataSource.class, $$$methodRef$$$92, null, logger);
                ClioSupport.exiting($$$loggerRef$$$92, Level.FINEST, OracleDataSource.class, $$$methodRef$$$92, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$92, Level.FINEST, OracleDataSource.class, $$$methodRef$$$92, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ oracle.jdbc.internal.OracleConnection lambda$getPhysicalConnectionAsync$1(Properties properties, Connection connection) throws Exception {
        boolean bl = (0x40000104000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prop;
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$95, Level.FINEST, OracleDataSource.class, $$$methodRef$$$95, this, properties, connection);
            }
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$95, Level.FINEST, OracleDataSource.class, $$$methodRef$$$95, this, sQLException);
                }
                throw sQLException;
            }
            oracle.jdbc.internal.OracleConnection oraConn = (oracle.jdbc.internal.OracleConnection)conn;
            this.initializeStatementCacheForPhysicalConnection(oraConn, (Properties)prop);
            oracle.jdbc.internal.OracleConnection oracleConnection = oraConn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$95, Level.FINEST, OracleDataSource.class, $$$methodRef$$$95, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$95, Level.FINEST, OracleDataSource.class, $$$methodRef$$$95, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$95, Level.FINEST, OracleDataSource.class, $$$methodRef$$$95, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$97 = OracleDataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$96 = OracleDataSource.class.getDeclaredMethod("lambda$getConnectionAsync$0", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$95 = OracleDataSource.class.getDeclaredMethod("lambda$getPhysicalConnectionAsync$1", Properties.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$94 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$93 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$92 = OracleDataSource.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$91 = OracleDataSource.class.getDeclaredMethod("createCopyForConnectionPublisher", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$90 = OracleDataSource.class.getDeclaredMethod("setTokenSupplier", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$89 = OracleDataSource.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$88 = OracleDataSource.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$87 = OracleDataSource.class.getDeclaredMethod("unregisterMBean", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$86 = OracleDataSource.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$85 = OracleDataSource.class.getDeclaredMethod("getRequestSizeLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$84 = OracleDataSource.class.getDeclaredMethod("getSystemProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$83 = OracleDataSource.class.getDeclaredMethod("updateReplayStatistics", oracle.jdbc.replay.internal.ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$82 = OracleDataSource.class.getDeclaredMethod("clearReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$81 = OracleDataSource.class.getDeclaredMethod("clearDoneDumpOnMemoryPressure", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$80 = OracleDataSource.class.getDeclaredMethod("getReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$79 = OracleDataSource.class.getDeclaredMethod("getConnectionInitializationCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$78 = OracleDataSource.class.getDeclaredMethod("unregisterConnectionInitializationCallback", ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$77 = OracleDataSource.class.getDeclaredMethod("registerConnectionInitializationCallback", ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$76 = OracleDataSource.class.getDeclaredMethod("enableACAndProxifyIfNecessary", Connection.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$75 = OracleDataSource.class.getDeclaredMethod("setupACSpecificProperties", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$74 = OracleDataSource.class.getDeclaredMethod("getConnectionInternal", OracleConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$73 = OracleDataSource.class.getDeclaredMethod("getConnectionNoProxy", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$72 = OracleDataSource.class.getDeclaredMethod("isACSupportPropertySet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$71 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$70 = OracleDataSource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$69 = OracleDataSource.class.getDeclaredMethod("setHostnameResolver", OracleHostnameResolver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$68 = OracleDataSource.class.getDeclaredMethod("setSingleShardTransactionSupport", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$67 = OracleDataSource.class.getDeclaredMethod("setSSLContext", SSLContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$66 = OracleDataSource.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$65 = OracleDataSource.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$64 = OracleDataSource.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$63 = OracleDataSource.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$62 = OracleDataSource.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$61 = OracleDataSource.class.getDeclaredMethod("isSensitiveProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$60 = OracleDataSource.class.getDeclaredMethod("filterConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$59 = OracleDataSource.class.getDeclaredMethod("setConnectionProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$58 = OracleDataSource.class.getDeclaredMethod("getConnectionProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$57 = OracleDataSource.class.getDeclaredMethod("getConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$56 = OracleDataSource.class.getDeclaredMethod("getRoleName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$55 = OracleDataSource.class.getDeclaredMethod("setRoleName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$54 = OracleDataSource.class.getDeclaredMethod("setConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$53 = OracleDataSource.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$52 = OracleDataSource.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$51 = OracleDataSource.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$50 = OracleDataSource.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$49 = OracleDataSource.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$48 = OracleDataSource.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$47 = OracleDataSource.class.getDeclaredMethod("trace", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$46 = OracleDataSource.class.getDeclaredMethod("makeURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$45 = OracleDataSource.class.getDeclaredMethod("addRefProperties", Reference.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$44 = OracleDataSource.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$43 = OracleDataSource.class.getDeclaredMethod("getPortNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$42 = OracleDataSource.class.getDeclaredMethod("setPortNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$41 = OracleDataSource.class.getDeclaredMethod("setNetworkProtocol", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$40 = OracleDataSource.class.getDeclaredMethod("getNetworkProtocol", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$39 = OracleDataSource.class.getDeclaredMethod("setDriverType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$38 = OracleDataSource.class.getDeclaredMethod("getDriverType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = OracleDataSource.class.getDeclaredMethod("setDescription", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = OracleDataSource.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = OracleDataSource.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = OracleDataSource.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = OracleDataSource.class.getDeclaredMethod("setPassword", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = OracleDataSource.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = OracleDataSource.class.getDeclaredMethod("setUser", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = OracleDataSource.class.getDeclaredMethod("getURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = OracleDataSource.class.getDeclaredMethod("setURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = OracleDataSource.class.getDeclaredMethod("getServerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = OracleDataSource.class.getDeclaredMethod("setServerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = OracleDataSource.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = OracleDataSource.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = OracleDataSource.class.getDeclaredMethod("setDatabaseName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = OracleDataSource.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = OracleDataSource.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = OracleDataSource.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = OracleDataSource.class.getDeclaredMethod("getTNSEntryName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = OracleDataSource.class.getDeclaredMethod("setTNSEntryName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = OracleDataSource.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = OracleDataSource.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = OracleDataSource.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = OracleDataSource.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = OracleDataSource.class.getDeclaredMethod("initializeStatementCacheForPhysicalConnection", oracle.jdbc.internal.OracleConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = OracleDataSource.class.getDeclaredMethod("createPropertiesForPhysicalConnection", Properties.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = OracleDataSource.class.getDeclaredMethod("getPhysicalConnectionAsync", Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = OracleDataSource.class.getDeclaredMethod("getPhysicalConnection", Properties.class, AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = OracleDataSource.class.getDeclaredMethod("isUserOrPasswordConfigured", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = OracleDataSource.class.getDeclaredMethod("configureTokenSupplier", AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = OracleDataSource.class.getDeclaredMethod("applyDataSourcePropertiesToBuilder", AbstractConnectionBuilder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = OracleDataSource.class.getDeclaredMethod("applyBuilderProperties", OracleConnectionBuilderImpl.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = OracleDataSource.class.getDeclaredMethod("applyDataSourcePropertiesForGetConnectionWithBuilder", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = OracleDataSource.class.getDeclaredMethod("validateGSSCredentialConfiguration", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = OracleDataSource.class.getDeclaredMethod("getConnectionAsync", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = OracleDataSource.class.getDeclaredMethod("getConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = OracleDataSource.class.getDeclaredMethod("getConnection", String.class, OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = OracleDataSource.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = OracleDataSource.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        PROXY_FACTORY = null;
        NON_TXN_PROXY_FACTORY = null;
        proxyFactoryLock = Monitor.newInstance();
        try (Monitor.CloseableLock lock = proxyFactoryLock.acquireCloseableLock();){
            if (PROXY_FACTORY == null) {
                NON_TXN_PROXY_FACTORY = ProxyFactory.createProxyFactory(NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class);
                PROXY_FACTORY = ProxyFactory.createProxyFactory(TxnReplayableBase.class, TxnReplayableConnection.class, TxnReplayableStatement.class, TxnReplayableResultSet.class, TxnReplayableArray.class, TxnReplayableBfile.class, TxnReplayableBlob.class, TxnReplayableClob.class, TxnReplayableNClob.class, TxnReplayableOpaque.class, TxnReplayableRef.class, TxnReplayableSqlxml.class, TxnReplayableStruct.class, TxnReplayableOthers.class);
            }
        }
        mbeanName = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Object run() {
                OracleDataSource.registerMBean();
                return null;
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.datasource.impl.OracleDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class ConnectionPublisher
    implements Flow.Publisher<OracleConnection> {
        private final OracleConnectionBuilderImpl builder;
        private final OracleDataSource dataSource;
        private final AtomicBoolean hasSubscriber = new AtomicBoolean(false);
        private static final Flow.Subscription REJECTED_SUBSCRIPTION;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private ConnectionPublisher(OracleConnectionBuilderImpl builder, OracleDataSource dataSource) throws SQLException {
            this.builder = new OracleConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;
                private static Executable $$$methodRef$$$4;
                private static Logger $$$loggerRef$$$4;

                @Override
                public oracle.jdbc.internal.OracleConnection build() {
                    throw new IllegalStateException();
                }

                static {
                    try {
                        $$$methodRef$$$4 = 1.class.getDeclaredConstructor(ConnectionPublisher.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$3 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$2 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            this.builder.copy(builder);
            this.dataSource = dataSource.createCopyForConnectionPublisher();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super OracleConnection> subscriber) {
            Objects.requireNonNull(subscriber);
            if (this.hasSubscriber.compareAndSet(false, true)) {
                this.acceptSubscriber(subscriber);
            } else {
                this.rejectSubscriber(subscriber);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void acceptSubscriber(Flow.Subscriber<? super OracleConnection> subscriber) {
            void subscriber2;
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            ConnectionSubscription connectionSubscription = new ConnectionSubscription((Flow.Subscriber<? super OracleConnection>)subscriber2);
            try {
                subscriber2.onSubscribe(connectionSubscription);
            }
            catch (Throwable onSubscribeFailure) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$1, Level.FINEST, ConnectionPublisher.class, $$$methodRef$$$1, "Subscriber.onSubscribe threw an exception", onSubscribeFailure);
                }
                connectionSubscription.cancel();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void rejectSubscriber(Flow.Subscriber<? super OracleConnection> subscriber) {
            block2: {
                boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                try {
                    void subscriber2;
                    subscriber2.onSubscribe(REJECTED_SUBSCRIPTION);
                    subscriber2.onError(new IllegalStateException("This publisher does not support multiple subscribers."));
                }
                catch (Throwable subscriberFailure) {
                    if (!bl) break block2;
                    OracleLog.log($$$loggerRef$$$2, Level.FINEST, ConnectionPublisher.class, $$$methodRef$$$2, "Subscriber threw an exception", subscriberFailure);
                }
            }
        }

        static {
            try {
                $$$methodRef$$$3 = ConnectionPublisher.class.getDeclaredConstructor(OracleConnectionBuilderImpl.class, OracleDataSource.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ConnectionPublisher.class.getDeclaredMethod("rejectSubscriber", Flow.Subscriber.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ConnectionPublisher.class.getDeclaredMethod("acceptSubscriber", Flow.Subscriber.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ConnectionPublisher.class.getDeclaredMethod("subscribe", Flow.Subscriber.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            REJECTED_SUBSCRIPTION = new Flow.Subscription(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public void request(long n2) {
                }

                @Override
                public void cancel() {
                }

                static {
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("cancel", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("request", Long.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
        }

        private final class ConnectionSubscription
        implements Flow.Subscription {
            private final Flow.Subscriber<? super OracleConnection> connectionSubscriber;
            private final AtomicBoolean hasDemand = new AtomicBoolean(false);
            private final Monitor emissionLock = Monitor.newInstance();
            private volatile boolean isCancelled = false;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;

            private ConnectionSubscription(Flow.Subscriber<? super OracleConnection> connectionSubscriber) {
                this.connectionSubscriber = connectionSubscriber;
            }

            @Override
            public final void request(long nConnections) {
                if (this.isCancelled) {
                    return;
                }
                if (nConnections < 1L) {
                    this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + nConnections));
                } else if (this.hasDemand.compareAndSet(false, true)) {
                    this.publishConnectionAsync();
                }
            }

            @Override
            public final void cancel() {
                this.isCancelled = true;
            }

            private final void publishConnectionAsync() {
                ConnectionPublisher.this.dataSource.getConnectionAsync(ConnectionPublisher.this.builder).whenComplete((physicalConnection, failure) -> {
                    if (failure == null) {
                        this.emitConnection((OracleConnection)physicalConnection);
                    } else {
                        this.emitError(CompletionStageUtil.unwrapCompletionException(failure));
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            private final void emitConnection(OracleConnection oracleConnection) {
                block10: {
                    boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                    try (Monitor.CloseableLock lock = this.emissionLock.acquireCloseableLock();){
                        void connection;
                        if (!this.isCancelled) {
                            this.cancel();
                            this.connectionSubscriber.onNext((OracleConnection)connection);
                            this.connectionSubscriber.onComplete();
                        } else {
                            this.closeDroppedConnection((OracleConnection)connection);
                        }
                    }
                    catch (Throwable onNextFailure) {
                        if (!bl) break block10;
                        OracleLog.log($$$loggerRef$$$3, Level.FINEST, ConnectionSubscription.class, $$$methodRef$$$3, "Subscriber threw an exception", onNextFailure);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void emitError(Throwable throwable) {
                block9: {
                    boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                    try (Monitor.CloseableLock lock = this.emissionLock.acquireCloseableLock();){
                        if (!this.isCancelled) {
                            void error;
                            this.cancel();
                            this.connectionSubscriber.onError((Throwable)error);
                        }
                    }
                    catch (Throwable onErrorFailure) {
                        if (!bl) break block9;
                        OracleLog.log($$$loggerRef$$$4, Level.FINEST, ConnectionSubscription.class, $$$methodRef$$$4, "Subscriber.onError(Throwable) threw an exception", onErrorFailure);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void closeDroppedConnection(OracleConnection oracleConnection) {
                block2: {
                    boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                    try {
                        void droppedConnection;
                        droppedConnection.closeAsyncOracle().subscribe(new Flow.Subscriber<Void>(){
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;
                            private static Executable $$$methodRef$$$2;
                            private static Logger $$$loggerRef$$$2;
                            private static Executable $$$methodRef$$$3;
                            private static Logger $$$loggerRef$$$3;
                            private static Executable $$$methodRef$$$4;
                            private static Logger $$$loggerRef$$$4;
                            private static Executable $$$methodRef$$$5;
                            private static Logger $$$loggerRef$$$5;

                            @Override
                            public void onSubscribe(Flow.Subscription subscription) {
                                subscription.request(1L);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void onError(Throwable throwable) {
                                boolean bl;
                                boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
                                if (bl) {
                                    void error;
                                    OracleLog.log($$$loggerRef$$$1, Level.FINEST, 1.class, $$$methodRef$$$1, "Failure when closing a dropped connection:", (Throwable)error);
                                }
                            }

                            @Override
                            public void onNext(Void success) {
                            }

                            @Override
                            public void onComplete() {
                            }

                            static {
                                try {
                                    $$$methodRef$$$5 = 1.class.getDeclaredConstructor(ConnectionSubscription.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                try {
                                    $$$methodRef$$$4 = 1.class.getDeclaredMethod("onNext", Object.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                try {
                                    $$$methodRef$$$3 = 1.class.getDeclaredMethod("onComplete", new Class[0]);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                try {
                                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("onNext", Void.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                try {
                                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("onError", Throwable.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                try {
                                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            }
                        });
                    }
                    catch (SQLException closeFailure) {
                        if (!bl) break block2;
                        OracleLog.log($$$loggerRef$$$5, Level.FINEST, ConnectionSubscription.class, $$$methodRef$$$5, "Failure when closing a dropped connection:", closeFailure);
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$7 = ConnectionSubscription.class.getDeclaredConstructor(ConnectionPublisher.class, Flow.Subscriber.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$6 = ConnectionSubscription.class.getDeclaredMethod("lambda$publishConnectionAsync$0", OracleConnection.class, Throwable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$5 = ConnectionSubscription.class.getDeclaredMethod("closeDroppedConnection", OracleConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$4 = ConnectionSubscription.class.getDeclaredMethod("emitError", Throwable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = ConnectionSubscription.class.getDeclaredMethod("emitConnection", OracleConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = ConnectionSubscription.class.getDeclaredMethod("publishConnectionAsync", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = ConnectionSubscription.class.getDeclaredMethod("cancel", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = ConnectionSubscription.class.getDeclaredMethod("request", Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }
    }
}

