/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OldUpdatableResultSet;
import oracle.jdbc.driver.OracleParameterMetaDataParser;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleSqlReadOnly;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class OracleSql {
    static final int UNINITIALIZED = -1;
    static final String[] EMPTY_LIST;
    static final int MAX_IDENTIFIER_LENGTH = 258;
    static final Pattern CONNECTION_VALIDATION_SQL_PATTERN;
    DBConversion conversion;
    String originalSql;
    String parameterSql;
    String utickSql;
    String processedSql;
    String rowidSql;
    String actualSql;
    byte[] sqlBytes;
    OracleStatement.SqlKind sqlKind;
    byte sqlKindByte;
    int parameterCount;
    int returningIntoParameterCount;
    boolean currentConvertNcharLiterals;
    boolean currentProcessEscapes;
    boolean includeRowid;
    String[] parameterList;
    char[] currentParameter;
    int bindParameterCount;
    String[] bindParameterList;
    int cachedBindParameterCount;
    String[] cachedBindParameterList;
    String cachedParameterSql;
    String cachedUtickSql;
    String cachedProcessedSql;
    String cachedRowidSql;
    String cachedActualSql;
    byte[] cachedSqlBytes;
    int selectEndIndex;
    int orderByStartIndex;
    int orderByEndIndex;
    int whereStartIndex;
    int whereEndIndex;
    int forUpdateStartIndex;
    int forUpdateEndIndex;
    int[] ncharLiteralLocation;
    int lastNcharLiteralLocation;
    static final String paramPrefix = "rowid";
    int paramSuffix;
    private boolean isConnectionValidationSql;
    StringBuffer stringBufferForScrollableStatement;
    private static final int cMax = 127;
    private static final int[][] TRANSITION;
    private static final int[][] ACTION;
    private static final int NO_ACTION = 0;
    private static final int DELETE_ACTION = 1;
    private static final int INSERT_ACTION = 2;
    private static final int MERGE_ACTION = 3;
    private static final int UPDATE_ACTION = 4;
    private static final int PLSQL_ACTION = 5;
    private static final int CALL_ACTION = 6;
    private static final int SELECT_ACTION = 7;
    private static final int ORDER_ACTION = 10;
    private static final int ORDER_BY_ACTION = 11;
    private static final int WHERE_ACTION = 9;
    private static final int FOR_ACTION = 12;
    private static final int FOR_UPDATE_ACTION = 13;
    private static final int OTHER_ACTION = 8;
    private static final int QUESTION_ACTION = 14;
    private static final int PARAMETER_ACTION = 15;
    private static final int END_PARAMETER_ACTION = 16;
    private static final int START_NCHAR_LITERAL_ACTION = 17;
    private static final int END_NCHAR_LITERAL_ACTION = 18;
    private static final int SAVE_DELIMITER_ACTION = 19;
    private static final int LOOK_FOR_DELIMITER_ACTION = 20;
    private static final int ALTER_SESSION_ACTION = 21;
    private static final int RETURNING_ACTION = 22;
    private static final int INTO_ACTION = 23;
    private static final int START_JSON_ACTION = 24;
    private static final int END_JSON_ACTION = 25;
    private static final int INITIAL_STATE = 0;
    private static final int RESTART_STATE = 67;
    static final int J_NESTED_CLOSE = 204;
    private static final OracleSqlReadOnly.ODBCAction[][] ODBC_ACTION;
    private static final boolean DEBUG_CBI = false;
    int current_argument;
    int i;
    int length;
    char currentChar;
    boolean first;
    String odbc_sql;
    StringBuffer oracle_sql;
    StringBuffer token_buffer;
    private static final Pattern DATABASE_OBJECT_NAME_RULE;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;

    protected OracleSql(DBConversion conv) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, OracleSql.class, $$$methodRef$$$54, null, conv);
            }
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.sqlKindByte = (byte)-1;
            this.parameterCount = -1;
            this.returningIntoParameterCount = -1;
            this.currentConvertNcharLiterals = true;
            this.currentProcessEscapes = true;
            this.includeRowid = false;
            this.parameterList = EMPTY_LIST;
            this.currentParameter = null;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.cachedBindParameterCount = -1;
            this.cachedBindParameterList = null;
            this.selectEndIndex = -1;
            this.orderByStartIndex = -1;
            this.orderByEndIndex = -1;
            this.whereStartIndex = -1;
            this.whereEndIndex = -1;
            this.forUpdateStartIndex = -1;
            this.forUpdateEndIndex = -1;
            this.ncharLiteralLocation = new int[513];
            this.lastNcharLiteralLocation = -1;
            this.paramSuffix = 0;
            this.stringBufferForScrollableStatement = null;
            this.conversion = conv;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleSql.class, $$$methodRef$$$54, null);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleSql.class, $$$methodRef$$$54, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleSql.class, $$$methodRef$$$54, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void newSql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleSql.class, $$$methodRef$$$0, this, string);
            }
            if (newSql == null || newSql.length() == 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleSql.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            this.originalSql = newSql;
            this.utickSql = null;
            this.processedSql = null;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.parameterCount = -1;
            this.parameterList = EMPTY_LIST;
            this.includeRowid = false;
            this.parameterSql = this.originalSql;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.cachedBindParameterCount = -1;
            this.cachedBindParameterList = null;
            this.cachedParameterSql = null;
            this.cachedActualSql = null;
            this.cachedProcessedSql = null;
            this.cachedRowidSql = null;
            this.cachedSqlBytes = null;
            this.selectEndIndex = -1;
            this.orderByStartIndex = -1;
            this.orderByEndIndex = -1;
            this.whereStartIndex = -1;
            this.whereEndIndex = -1;
            this.forUpdateStartIndex = -1;
            this.forUpdateEndIndex = -1;
            Matcher m2 = CONNECTION_VALIDATION_SQL_PATTERN.matcher(this.originalSql);
            this.isConnectionValidationSql = m2.matches();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleSql.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleSql.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleSql.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    String getOriginalSql() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleSql.class, $$$methodRef$$$1, this, new Object[0]);
            }
            String string = this.originalSql;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleSql.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleSql.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleSql.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean isConnectionValidationSql() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleSql.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = this.isConnectionValidationSql;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleSql.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSql.class, $$$methodRef$$$2, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleSql.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean setNamedParameters(int n2, String[] stringArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int paramCount;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleSql.class, $$$methodRef$$$3, this, n2, stringArray);
            }
            boolean needToParse = false;
            if (paramCount == 0) {
                this.bindParameterCount = -1;
                needToParse = this.bindParameterCount != this.cachedBindParameterCount;
            } else {
                void paramList;
                this.bindParameterCount = paramCount;
                this.bindParameterList = paramList;
                boolean bl2 = needToParse = this.bindParameterCount != this.cachedBindParameterCount || this.cachedBindParameterList == null;
                if (!needToParse) {
                    for (int i2 = 0; i2 < paramCount; ++i2) {
                        if (this.bindParameterList[i2] == this.cachedBindParameterList[i2]) continue;
                        needToParse = true;
                        break;
                    }
                }
                if (needToParse) {
                    if (this.bindParameterCount != this.getParameterCount()) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 197).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleSql.class, $$$methodRef$$$3, this, sQLException);
                        }
                        throw sQLException;
                    }
                    char[] sqlArray = this.originalSql.toCharArray();
                    StringBuffer strBuf = new StringBuffer();
                    int j2 = 0;
                    for (int i3 = 0; i3 < sqlArray.length; ++i3) {
                        if (sqlArray[i3] != '?') {
                            strBuf.append(sqlArray[i3]);
                            continue;
                        }
                        strBuf.append(this.bindParameterList[j2++]);
                        strBuf.append("=>" + this.nextArgument());
                    }
                    this.parameterSql = strBuf.toString();
                    this.actualSql = null;
                    this.utickSql = null;
                    this.processedSql = null;
                    this.rowidSql = null;
                    this.sqlBytes = null;
                } else {
                    this.parameterSql = this.cachedParameterSql;
                    this.actualSql = this.cachedActualSql;
                    this.utickSql = this.cachedUtickSql;
                    this.processedSql = this.cachedProcessedSql;
                    this.rowidSql = this.cachedRowidSql;
                    this.sqlBytes = this.cachedSqlBytes;
                }
            }
            this.cachedBindParameterList = null;
            this.cachedParameterSql = null;
            this.cachedActualSql = null;
            this.cachedUtickSql = null;
            this.cachedProcessedSql = null;
            this.cachedRowidSql = null;
            this.cachedSqlBytes = null;
            boolean bl3 = needToParse;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleSql.class, $$$methodRef$$$3, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSql.class, $$$methodRef$$$3, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleSql.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetNamedParameters() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleSql.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.cachedBindParameterCount = this.bindParameterCount;
            if (this.bindParameterCount != -1) {
                if (this.cachedBindParameterList == null || this.cachedBindParameterList == this.bindParameterList || this.cachedBindParameterList.length < this.bindParameterCount) {
                    this.cachedBindParameterList = new String[this.bindParameterCount];
                }
                System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
                this.cachedParameterSql = this.parameterSql;
                this.cachedActualSql = this.actualSql;
                this.cachedUtickSql = this.utickSql;
                this.cachedProcessedSql = this.processedSql;
                this.cachedRowidSql = this.rowidSql;
                this.cachedSqlBytes = this.sqlBytes;
                this.bindParameterCount = -1;
                this.bindParameterList = null;
                this.parameterSql = this.originalSql;
                this.actualSql = null;
                this.utickSql = null;
                this.processedSql = null;
                this.rowidSql = null;
                this.sqlBytes = null;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleSql.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSql.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleSql.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getSql(boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void desiredConvertNcharLiterals;
            void desiredProcessEscapes;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleSql.class, $$$methodRef$$$5, this, bl, bl2);
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (desiredProcessEscapes != this.currentProcessEscapes || desiredConvertNcharLiterals != this.currentConvertNcharLiterals) {
                if (desiredConvertNcharLiterals != this.currentConvertNcharLiterals) {
                    this.utickSql = null;
                }
                this.processedSql = null;
                this.rowidSql = null;
                this.actualSql = null;
                this.sqlBytes = null;
            }
            this.currentConvertNcharLiterals = desiredConvertNcharLiterals;
            this.currentProcessEscapes = desiredProcessEscapes;
            if (this.actualSql == null) {
                if (this.utickSql == null) {
                    String string = this.utickSql = this.currentConvertNcharLiterals ? this.convertNcharLiterals(this.parameterSql) : this.parameterSql;
                }
                if (this.processedSql == null) {
                    String string = this.processedSql = this.currentProcessEscapes ? this.parse(this.utickSql) : this.utickSql;
                }
                if (this.rowidSql == null) {
                    this.rowidSql = this.includeRowid ? this.addRowid(this.processedSql) : this.processedSql;
                }
                this.actualSql = this.rowidSql;
            }
            String string = this.actualSql;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleSql.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleSql.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleSql.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    String getRevisedSql() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleSql.class, $$$methodRef$$$6, this, new Object[0]);
            }
            String result = null;
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            result = this.removeOrderByForUpdate(this.parameterSql);
            String string = this.addRowid(result);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleSql.class, $$$methodRef$$$6, this, string);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleSql.class, $$$methodRef$$$6, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleSql.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String removeForUpdate(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void revisedSql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleSql.class, $$$methodRef$$$7, this, string);
            }
            if (this.forUpdateStartIndex != -1) {
                String string2 = revisedSql.substring(0, this.forUpdateStartIndex);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleSql.class, $$$methodRef$$$7, this, string2);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleSql.class, $$$methodRef$$$7, this, null);
                }
                return string2;
            }
            void var3_4 = revisedSql;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleSql.class, $$$methodRef$$$7, this, var3_4);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleSql.class, $$$methodRef$$$7, this, null);
            }
            return var3_4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleSql.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    String removeOrderByForUpdate(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String revisedSql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleSql.class, $$$methodRef$$$8, this, string);
            }
            if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
                revisedSql = revisedSql.substring(0, this.orderByStartIndex);
            } else if (this.forUpdateStartIndex != -1) {
                revisedSql = revisedSql.substring(0, this.forUpdateStartIndex);
            }
            void var3_3 = revisedSql;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleSql.class, $$$methodRef$$$8, this, var3_3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleSql.class, $$$methodRef$$$8, this, null);
            }
            return var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleSql.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void appendForUpdate(StringBuffer stringBuffer) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void stringBuffer2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleSql.class, $$$methodRef$$$9, this, stringBuffer);
            }
            if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
                stringBuffer2.append(this.originalSql.substring(this.orderByStartIndex));
            } else if (this.forUpdateStartIndex != -1) {
                stringBuffer2.append(this.originalSql.substring(this.forUpdateStartIndex));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleSql.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleSql.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleSql.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getInsertSqlForUpdatableResultSet(List<String> list) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void names;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleSql.class, $$$methodRef$$$10, this, list);
            }
            String originalSql = this.getOriginalSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(originalSql.length() + 30 + names.size() * 10);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("insert into (");
            this.stringBufferForScrollableStatement.append(this.removeOrderByForUpdate(originalSql));
            this.stringBufferForScrollableStatement.append(") (");
            String sep = "";
            for (String n2 : names) {
                this.stringBufferForScrollableStatement.append(sep);
                this.stringBufferForScrollableStatement.append("\"");
                this.stringBufferForScrollableStatement.append(n2);
                this.stringBufferForScrollableStatement.append("\"");
                sep = ", ";
            }
            this.stringBufferForScrollableStatement.append(") values ( ");
            sep = "";
            for (String n2 : names) {
                this.stringBufferForScrollableStatement.append(sep);
                sep = ", ";
                if (needEscapeProcessing) {
                    this.stringBufferForScrollableStatement.append("?");
                    continue;
                }
                this.stringBufferForScrollableStatement.append(":" + this.generateParameterName());
            }
            this.stringBufferForScrollableStatement.append(")");
            this.paramSuffix = 0;
            String string = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleSql.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleSql.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleSql.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    String getRefetchSqlForScrollableResultSet(OracleResultSet oracleResultSet, int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleSql.class, $$$methodRef$$$11, this, oracleResultSet, n2);
            }
            SQLException sQLException = new SQLException("no longer used");
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleSql.class, $$$methodRef$$$11, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleSql.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    String getRefetchSql() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleSql.class, $$$methodRef$$$12, this, new Object[0]);
            }
            String sql = this.removeForUpdate(this.parameterSql);
            StringBuilder s2 = new StringBuilder(sql.length() + 240);
            s2.append("WITH \"__JDBC_ROWIDS__\" AS (SELECT COLUMN_VALUE ID, ROWNUM NUM FROM TABLE(");
            s2.append((String)(this.generatedSqlNeedEscapeProcessing() ? "?" : ":" + this.generateParameterName()));
            s2.append("))\n");
            s2.append("SELECT \"__JDBC_ORIGINAL__\".*\n");
            s2.append("FROM (");
            s2.append(this.addRowid(sql));
            s2.append(") \"__JDBC_ORIGINAL__\", \"__JDBC_ROWIDS__\"\n");
            s2.append("WHERE \"__JDBC_ORIGINAL__\".\"__Oracle_JDBC_internal_ROWID__\"(+) = \"__JDBC_ROWIDS__\".ID\n");
            s2.append("ORDER BY \"__JDBC_ROWIDS__\".NUM");
            this.paramSuffix = 0;
            String string = s2.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleSql.class, $$$methodRef$$$12, this, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleSql.class, $$$methodRef$$$12, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleSql.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getUpdateSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleSql.class, $$$methodRef$$$13, this, updatableResultSet, n2, objectArray, nArray);
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("update (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") set ");
            if (rowBuffer != null) {
                int numberOfColumnsChanged;
                for (int i2 = 0; i2 < numberOfColumnsChanged; ++i2) {
                    void indexColsChanged;
                    void updatableResultSet2;
                    if (i2 > 0) {
                        this.stringBufferForScrollableStatement.append(", ");
                    }
                    this.stringBufferForScrollableStatement.append("\"");
                    this.stringBufferForScrollableStatement.append(updatableResultSet2.getInternalMetadata().getColumnName((int)(indexColsChanged[i2] + true)));
                    this.stringBufferForScrollableStatement.append("\"");
                    if (needEscapeProcessing) {
                        this.stringBufferForScrollableStatement.append(" = ?");
                        continue;
                    }
                    this.stringBufferForScrollableStatement.append(" = :" + this.generateParameterName());
                }
            }
            this.stringBufferForScrollableStatement.append(" WHERE ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            this.paramSuffix = 0;
            String string = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleSql.class, $$$methodRef$$$13, this, string);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleSql.class, $$$methodRef$$$13, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleSql.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    String getDeleteSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleSql.class, $$$methodRef$$$14, this, updatableResultSet);
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("delete from (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") where ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            this.paramSuffix = 0;
            String string = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleSql.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleSql.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleSql.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getInsertSqlForUpdatableResultSet(OldUpdatableResultSet oldUpdatableResultSet) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void updatableResultSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleSql.class, $$$methodRef$$$15, this, oldUpdatableResultSet);
            }
            String originalSql = this.getOriginalSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(originalSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("insert into (");
            this.stringBufferForScrollableStatement.append(this.removeOrderByForUpdate(originalSql));
            this.stringBufferForScrollableStatement.append(") values ( ");
            for (int i2 = 0; i2 < updatableResultSet.getColumnCount(); ++i2) {
                if (i2 != 0) {
                    this.stringBufferForScrollableStatement.append(", ");
                }
                if (needEscapeProcessing) {
                    this.stringBufferForScrollableStatement.append("?");
                    continue;
                }
                this.stringBufferForScrollableStatement.append(":" + this.generateParameterName());
            }
            this.stringBufferForScrollableStatement.append(")");
            this.paramSuffix = 0;
            String string = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleSql.class, $$$methodRef$$$15, this, string);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleSql.class, $$$methodRef$$$15, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleSql.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getUpdateSqlForUpdatableResultSet(OldUpdatableResultSet oldUpdatableResultSet, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void rowBuffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleSql.class, $$$methodRef$$$16, this, oldUpdatableResultSet, n2, objectArray, nArray);
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("update (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") set ");
            if (rowBuffer != null) {
                int numberOfColumnsChanged;
                for (int i2 = 0; i2 < numberOfColumnsChanged; ++i2) {
                    void indexColsChanged;
                    void updatableResultSet;
                    if (i2 > 0) {
                        this.stringBufferForScrollableStatement.append(", ");
                    }
                    this.stringBufferForScrollableStatement.append("\"");
                    this.stringBufferForScrollableStatement.append(updatableResultSet.getInternalMetadata().getColumnName((int)(indexColsChanged[i2] + true)));
                    this.stringBufferForScrollableStatement.append("\"");
                    if (needEscapeProcessing) {
                        this.stringBufferForScrollableStatement.append(" = ?");
                        continue;
                    }
                    this.stringBufferForScrollableStatement.append(" = :" + this.generateParameterName());
                }
            }
            this.stringBufferForScrollableStatement.append(" WHERE ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            this.paramSuffix = 0;
            String string = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleSql.class, $$$methodRef$$$16, this, string);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleSql.class, $$$methodRef$$$16, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleSql.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    String getDeleteSqlForUpdatableResultSet(OldUpdatableResultSet oldUpdatableResultSet) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleSql.class, $$$methodRef$$$17, this, oldUpdatableResultSet);
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("delete from (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") where ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            this.paramSuffix = 0;
            String string = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleSql.class, $$$methodRef$$$17, this, string);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleSql.class, $$$methodRef$$$17, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleSql.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    final boolean generatedSqlNeedEscapeProcessing() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleSql.class, $$$methodRef$$$18, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.parameterCount > 0 && this.parameterList == EMPTY_LIST;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleSql.class, $$$methodRef$$$18, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleSql.class, $$$methodRef$$$18, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleSql.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    byte[] getSqlBytes(boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void desiredProcessEscapes;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleSql.class, $$$methodRef$$$19, this, bl, bl2);
            }
            if (this.sqlBytes == null || desiredProcessEscapes != this.currentProcessEscapes) {
                void desiredConvertNcharLiterals;
                this.sqlBytes = this.conversion.StringToCharBytes(this.getSql((boolean)desiredProcessEscapes, (boolean)desiredConvertNcharLiterals));
            }
            byte[] byArray = this.sqlBytes;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleSql.class, $$$methodRef$$$19, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleSql.class, $$$methodRef$$$19, this, null);
            }
            return this.sqlBytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleSql.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    OracleStatement.SqlKind getSqlKind() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleSql.class, $$$methodRef$$$20, this, new Object[0]);
            }
            if (this.parameterSql == null) {
                OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleSql.class, $$$methodRef$$$20, this, (Object)sqlKind);
                    ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleSql.class, $$$methodRef$$$20, this, null);
                }
                return sqlKind;
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            OracleStatement.SqlKind sqlKind = this.sqlKind;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleSql.class, $$$methodRef$$$20, this, (Object)sqlKind);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleSql.class, $$$methodRef$$$20, this, null);
            }
            return sqlKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleSql.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    protected int getParameterCount() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleSql.class, $$$methodRef$$$21, this, new Object[0]);
            }
            if (this.parameterCount == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            int n2 = this.parameterCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleSql.class, $$$methodRef$$$21, this, n2);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleSql.class, $$$methodRef$$$21, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleSql.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    protected String[] getParameterList() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleSql.class, $$$methodRef$$$22, this, new Object[0]);
            }
            if (this.parameterCount == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            String[] stringArray = this.parameterList;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleSql.class, $$$methodRef$$$22, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleSql.class, $$$methodRef$$$22, this, null);
            }
            return this.parameterList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleSql.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setIncludeRowid(boolean bl) {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void enable;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleSql.class, $$$methodRef$$$23, this, bl);
            }
            if (enable != this.includeRowid) {
                this.includeRowid = enable;
                this.rowidSql = null;
                this.actualSql = null;
                this.sqlBytes = null;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleSql.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleSql.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleSql.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleSql.class, $$$methodRef$$$24, this, new Object[0]);
            }
            String string2 = string = this.parameterSql == null ? "null" : this.parameterSql;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleSql.class, $$$methodRef$$$24, this, string);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleSql.class, $$$methodRef$$$24, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleSql.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String hexUnicode(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, n2);
            }
            String hex = Integer.toHexString((int)c2);
            switch (hex.length()) {
                case 0: {
                    String string = "\\0000";
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, string);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, null);
                    }
                    return "\\0000";
                }
                case 1: {
                    String string = "\\000" + hex;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, string);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, null);
                    }
                    return string;
                }
                case 2: {
                    String string = "\\00" + hex;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, string);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, null);
                    }
                    return string;
                }
                case 3: {
                    String string = "\\0" + hex;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, string);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, null);
                    }
                    return string;
                }
                case 4: {
                    String string = "\\" + hex;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, string);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, null);
                    }
                    return string;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Unexpected case in OracleSql.hexUnicode: " + (int)c2).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleSql.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String convertNcharLiterals(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleSql.class, $$$methodRef$$$26, this, string);
            }
            if (this.lastNcharLiteralLocation <= 2) {
                void var9_3 = sql;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleSql.class, $$$methodRef$$$26, this, var9_3);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleSql.class, $$$methodRef$$$26, this, null);
                }
                return var9_3;
            }
            Object buf = "";
            int i2 = 0;
            block2: while (true) {
                int end = this.ncharLiteralLocation[i2++];
                int start = this.ncharLiteralLocation[i2++];
                buf = (String)buf + sql.substring(end, start);
                if (i2 >= this.lastNcharLiteralLocation) break;
                end = this.ncharLiteralLocation[i2];
                buf = (String)buf + "u'";
                int j2 = start + 2;
                while (true) {
                    if (j2 >= end) continue block2;
                    char c2 = sql.charAt(j2);
                    buf = c2 == '\\' ? (String)buf + "\\\\" : (c2 < '\u0080' ? (String)buf + c2 : (String)buf + this.hexUnicode(c2));
                    ++j2;
                }
                break;
            }
            Object object = buf;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleSql.class, $$$methodRef$$$26, this, object);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleSql.class, $$$methodRef$$$26, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleSql.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void computeBasicInfo(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleSql.class, $$$methodRef$$$27, this, string);
            }
            this.parameterCount = 0;
            boolean seenReturning = false;
            boolean inReturningInto = false;
            this.returningIntoParameterCount = 0;
            this.lastNcharLiteralLocation = 0;
            this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = 0;
            int delimiter = 0;
            int currentParameterLength = 0;
            ArrayDeque<Character> jsonDelimiter = new ArrayDeque<Character>();
            int s2 = 0;
            int len = sql.length();
            int temp_orderByStartIndex = -1;
            int temp_forUpdateStartIndex = -1;
            int stop = len + 1;
            for (int i2 = 0; i2 < stop; ++i2) {
                int unicodeChar = i2 < len ? (int)sql.charAt(i2) : 32;
                this.currentChar = (char)unicodeChar;
                if (unicodeChar > 127) {
                    this.currentChar = Character.isLetterOrDigit((char)unicodeChar) ? (char)88 : (char)32;
                }
                switch (ACTION[s2][this.currentChar]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.sqlKind = OracleStatement.SqlKind.DELETE;
                        break;
                    }
                    case 2: {
                        this.sqlKind = OracleStatement.SqlKind.INSERT;
                        break;
                    }
                    case 3: {
                        this.sqlKind = OracleStatement.SqlKind.MERGE;
                        break;
                    }
                    case 4: {
                        this.sqlKind = OracleStatement.SqlKind.UPDATE;
                        break;
                    }
                    case 5: {
                        this.sqlKind = OracleStatement.SqlKind.PLSQL_BLOCK;
                        break;
                    }
                    case 6: {
                        this.sqlKind = OracleStatement.SqlKind.CALL_BLOCK;
                        break;
                    }
                    case 7: {
                        this.sqlKind = OracleStatement.SqlKind.SELECT;
                        this.selectEndIndex = i2;
                        break;
                    }
                    case 8: {
                        this.sqlKind = OracleStatement.SqlKind.OTHER;
                        break;
                    }
                    case 9: {
                        this.whereStartIndex = i2 - 5;
                        this.whereEndIndex = i2;
                        break;
                    }
                    case 10: {
                        temp_orderByStartIndex = i2 - 5;
                        break;
                    }
                    case 11: {
                        this.orderByStartIndex = temp_orderByStartIndex;
                        this.orderByEndIndex = i2;
                        break;
                    }
                    case 12: {
                        temp_forUpdateStartIndex = i2 - 3;
                        break;
                    }
                    case 13: {
                        this.forUpdateStartIndex = temp_forUpdateStartIndex;
                        this.forUpdateEndIndex = i2;
                        if (this.sqlKind != OracleStatement.SqlKind.SELECT) break;
                        this.sqlKind = OracleStatement.SqlKind.SELECT_FOR_UPDATE;
                        break;
                    }
                    case 21: {
                        this.sqlKind = OracleStatement.SqlKind.ALTER_SESSION;
                        break;
                    }
                    case 14: {
                        ++this.parameterCount;
                        if (!inReturningInto) break;
                        ++this.returningIntoParameterCount;
                        break;
                    }
                    case 15: {
                        if (this.currentParameter == null) {
                            this.currentParameter = new char[258];
                        }
                        if (currentParameterLength >= this.currentParameter.length) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 134, new String(this.currentParameter)).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, OracleSql.class, $$$methodRef$$$27, this, sQLException);
                            }
                            throw sQLException;
                        }
                        this.currentParameter[currentParameterLength++] = unicodeChar;
                        break;
                    }
                    case 16: {
                        String[] newList;
                        if (currentParameterLength <= 0) break;
                        if (this.parameterList == EMPTY_LIST) {
                            this.parameterList = new String[Math.max(8, this.parameterCount * 4)];
                        } else if (this.parameterList.length <= this.parameterCount) {
                            newList = new String[this.parameterList.length * 4];
                            System.arraycopy(this.parameterList, 0, newList, 0, this.parameterList.length);
                            this.parameterList = newList;
                        }
                        this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, currentParameterLength).intern();
                        currentParameterLength = 0;
                        ++this.parameterCount;
                        if (!inReturningInto) break;
                        ++this.returningIntoParameterCount;
                        break;
                    }
                    case 17: {
                        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = i2 - 1;
                        if (this.lastNcharLiteralLocation < this.ncharLiteralLocation.length) break;
                        this.growNcharLiteralLocation(this.ncharLiteralLocation.length << 2);
                        break;
                    }
                    case 18: {
                        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = i2;
                        if (this.lastNcharLiteralLocation < this.ncharLiteralLocation.length) break;
                        this.growNcharLiteralLocation(this.ncharLiteralLocation.length << 2);
                        break;
                    }
                    case 19: {
                        if (unicodeChar == 91) {
                            delimiter = 93;
                            break;
                        }
                        if (unicodeChar == 123) {
                            delimiter = 125;
                            break;
                        }
                        if (unicodeChar == 60) {
                            delimiter = 62;
                            break;
                        }
                        if (unicodeChar == 40) {
                            delimiter = 41;
                            break;
                        }
                        delimiter = unicodeChar;
                        break;
                    }
                    case 20: {
                        if (unicodeChar != delimiter) break;
                        ++s2;
                        break;
                    }
                    case 22: {
                        seenReturning = true;
                        break;
                    }
                    case 23: {
                        if (!seenReturning) break;
                        inReturningInto = true;
                        break;
                    }
                    case 24: {
                        jsonDelimiter.push(Character.valueOf(unicodeChar == 123 ? (char)'}' : ']'));
                        break;
                    }
                    case 25: {
                        String[] newList;
                        if (jsonDelimiter.isEmpty()) break;
                        if (((Character)jsonDelimiter.peek()).charValue() == unicodeChar) {
                            jsonDelimiter.pop();
                            if (!jsonDelimiter.isEmpty()) {
                                s2 = 204;
                            }
                        }
                        if (currentParameterLength <= 0) break;
                        if (this.parameterList == EMPTY_LIST) {
                            this.parameterList = new String[Math.max(8, this.parameterCount * 4)];
                        } else if (this.parameterList.length <= this.parameterCount) {
                            newList = new String[this.parameterList.length * 4];
                            System.arraycopy(this.parameterList, 0, newList, 0, this.parameterList.length);
                            this.parameterList = newList;
                        }
                        this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, currentParameterLength).intern();
                        currentParameterLength = 0;
                        ++this.parameterCount;
                        if (!inReturningInto) break;
                        ++this.returningIntoParameterCount;
                    }
                }
                s2 = TRANSITION[s2][this.currentChar];
            }
            if (this.lastNcharLiteralLocation + 2 >= this.ncharLiteralLocation.length) {
                this.growNcharLiteralLocation(this.lastNcharLiteralLocation + 2);
            }
            this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = len;
            this.ncharLiteralLocation[this.lastNcharLiteralLocation] = len;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleSql.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleSql.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleSql.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void growNcharLiteralLocation(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void size;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleSql.class, $$$methodRef$$$28, this, n2);
            }
            int[] temp = new int[size];
            System.arraycopy(this.ncharLiteralLocation, 0, temp, 0, this.ncharLiteralLocation.length);
            this.ncharLiteralLocation = null;
            this.ncharLiteralLocation = temp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleSql.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleSql.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleSql.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String addRowid(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            String result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleSql.class, $$$methodRef$$$29, this, string);
            }
            if (this.selectEndIndex == -1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 88).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, OracleSql.class, $$$methodRef$$$29, this, sQLException);
                }
                throw sQLException;
            }
            String string2 = result = "select rowid as \"__Oracle_JDBC_internal_ROWID__\"," + sql.substring(this.selectEndIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleSql.class, $$$methodRef$$$29, this, string2);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleSql.class, $$$methodRef$$$29, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleSql.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String parse(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void os;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleSql.class, $$$methodRef$$$30, this, string);
            }
            this.first = true;
            this.current_argument = 1;
            this.i = 0;
            this.odbc_sql = os;
            this.length = this.odbc_sql.length();
            if (this.oracle_sql == null) {
                this.oracle_sql = new StringBuffer(this.length);
                this.token_buffer = new StringBuffer(32);
            } else {
                this.oracle_sql.ensureCapacity(this.length);
            }
            this.oracle_sql.delete(0, this.oracle_sql.length());
            this.skipSpace();
            this.handleODBC(ParseMode.NORMAL);
            if (this.i < this.length) {
                Integer index = this.i;
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33, index).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleSql.class, $$$methodRef$$$30, this, sQLException);
                }
                throw sQLException;
            }
            String string2 = this.oracle_sql.substring(0, this.oracle_sql.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleSql.class, $$$methodRef$$$30, this, string2);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleSql.class, $$$methodRef$$$30, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleSql.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleODBC(ParseMode parseMode) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void mode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, new Object[]{parseMode});
            }
            int s2 = mode == ParseMode.NORMAL ? 0 : 67;
            char delimiter = '\u0000';
            int parenDepth = 0;
            ArrayDeque<Character> jsonDelimiter = new ArrayDeque<Character>();
            while (this.i < this.length) {
                char unicodeChar = this.i < this.length ? (char)this.odbc_sql.charAt(this.i) : (char)' ';
                this.currentChar = unicodeChar;
                if (unicodeChar > '\u007f') {
                    this.currentChar = Character.isLetterOrDigit(unicodeChar) ? (char)88 : (char)32;
                }
                switch (ODBC_ACTION[s2][this.currentChar]) {
                    case NONE: {
                        break;
                    }
                    case COPY: {
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case QUESTION: {
                        this.oracle_sql.append(this.nextArgument());
                        this.oracle_sql.append(' ');
                        break;
                    }
                    case SAVE_DELIMITER: {
                        delimiter = unicodeChar == '[' ? (char)']' : (unicodeChar == '{' ? (char)'}' : (unicodeChar == '<' ? (char)'>' : (unicodeChar == '(' ? (char)')' : unicodeChar)));
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case LOOK_FOR_DELIMITER: {
                        if (unicodeChar == delimiter) {
                            ++s2;
                        }
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case FUNCTION: {
                        this.handleFunction();
                        break;
                    }
                    case CALL: {
                        this.handleCall();
                        break;
                    }
                    case TIME: {
                        this.handleTime();
                        break;
                    }
                    case TIMESTAMP: {
                        this.handleTimestamp();
                        break;
                    }
                    case DATE: {
                        this.handleDate();
                        break;
                    }
                    case ESCAPE: {
                        this.handleEscape();
                        break;
                    }
                    case SCALAR_FUNCTION: {
                        this.handleScalarFunction();
                        break;
                    }
                    case OUTER_JOIN: {
                        this.handleOuterJoin();
                        break;
                    }
                    case UNKNOWN_ESCAPE: {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, (Object)this.i).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, sQLException);
                        }
                        throw sQLException;
                    }
                    case END_ODBC_ESCAPE: {
                        if (mode == ParseMode.SCALAR) {
                            s2 = TRANSITION[s2][this.currentChar];
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this);
                                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, null);
                            }
                            return;
                        }
                    }
                    case COMMA: {
                        if (mode == ParseMode.LOCATE_1 && parenDepth > 1) {
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        if (mode == ParseMode.LOCATE_1) {
                            s2 = TRANSITION[s2][this.currentChar];
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this);
                                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, null);
                            }
                            return;
                        }
                        if (mode == ParseMode.LOCATE_2) break;
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case OPEN_PAREN: {
                        if (mode == ParseMode.LOCATE_1) {
                            if (parenDepth > 0) {
                                this.oracle_sql.append(unicodeChar);
                            }
                            ++parenDepth;
                            break;
                        }
                        if (mode == ParseMode.LOCATE_2) {
                            ++parenDepth;
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case CLOSE_PAREN: {
                        if (mode == ParseMode.LOCATE_1) {
                            --parenDepth;
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        if (mode == ParseMode.LOCATE_2 && parenDepth > 1) {
                            --parenDepth;
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        if (mode == ParseMode.LOCATE_2) {
                            ++this.i;
                            s2 = TRANSITION[s2][this.currentChar];
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this);
                                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, null);
                            }
                            return;
                        }
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case BEGIN: {
                        this.first = false;
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case LIMIT: {
                        this.handleLimit();
                        break;
                    }
                    case START_JSON: {
                        jsonDelimiter.push(Character.valueOf(unicodeChar == '{' ? (char)'}' : ']'));
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case END_JSON: {
                        if (jsonDelimiter.isEmpty()) break;
                        if (((Character)jsonDelimiter.peek()).charValue() == unicodeChar) {
                            jsonDelimiter.pop();
                            if (!jsonDelimiter.isEmpty()) {
                                s2 = 204;
                            }
                        }
                        this.oracle_sql.append(unicodeChar);
                    }
                }
                s2 = TRANSITION[s2][this.currentChar];
                ++this.i;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleSql.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleFunction() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleSql.class, $$$methodRef$$$32, this, new Object[0]);
            }
            boolean need_block = this.first;
            this.first = false;
            if (need_block) {
                this.oracle_sql.append("BEGIN ");
            }
            this.appendChar(this.oracle_sql, '?');
            this.skipSpace();
            if (this.currentChar != '=') {
                String s2 = this.i + ". Expecting \"=\" got \"" + this.currentChar + "\"";
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33, s2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, OracleSql.class, $$$methodRef$$$32, this, sQLException);
                }
                throw sQLException;
            }
            ++this.i;
            this.skipSpace();
            if (!this.odbc_sql.startsWith("call", this.i)) {
                String s3 = this.i + ". Expecting \"call\"";
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33, s3).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, OracleSql.class, $$$methodRef$$$32, this, sQLException);
                }
                throw sQLException;
            }
            this.i += 4;
            this.oracle_sql.append(" := ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            if (need_block) {
                this.oracle_sql.append("; END;");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleSql.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleSql.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleSql.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleCall() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleSql.class, $$$methodRef$$$33, this, new Object[0]);
            }
            boolean need_block = this.first;
            this.first = false;
            if (need_block) {
                this.oracle_sql.append("BEGIN ");
            }
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.skipSpace();
            if (need_block) {
                this.oracle_sql.append("; END;");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleSql.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleSql.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleSql.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleTimestamp() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleSql.class, $$$methodRef$$$34, this, new Object[0]);
            }
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleSql.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleSql.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleSql.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleTime() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleSql.class, $$$methodRef$$$35, this, new Object[0]);
            }
            this.skipSpace();
            this.oracle_sql.append("TO_DATE('1-JAN-1970 '||TO_CHAR(TO_DATE(");
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(",'HH24:MI:SS'),'HH24:MI:SS'),'DD-MON-YYYY HH24:MI:SS')");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleSql.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleSql.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleSql.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleDate() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleSql.class, $$$methodRef$$$36, this, new Object[0]);
            }
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(", 'YYYY-MM-DD')");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleSql.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleSql.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleSql.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleEscape() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleSql.class, $$$methodRef$$$37, this, new Object[0]);
            }
            this.oracle_sql.append("ESCAPE ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleSql.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleSql.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleSql.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleLimit() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleSql.class, $$$methodRef$$$38, this, new Object[0]);
            }
            this.oracle_sql.append("ROWNUM <= ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleSql.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleSql.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleSql.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleScalarFunction() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, new Object[0]);
            }
            this.token_buffer.delete(0, this.token_buffer.length());
            ++this.i;
            this.skipSpace();
            while (this.i < this.length && (Character.isJavaIdentifierPart(this.currentChar = this.odbc_sql.charAt(this.i)) || this.currentChar == '?')) {
                this.token_buffer.append(this.currentChar);
                ++this.i;
            }
            String functionName = this.token_buffer.substring(0, this.token_buffer.length()).toUpperCase().intern();
            if (functionName == "ABS") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ACOS") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ASIN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ATAN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ATAN2") {
                this.usingFunctionName(functionName);
            } else if (functionName == "CEILING") {
                this.usingFunctionName("CEIL");
            } else if (functionName == "COS") {
                this.usingFunctionName(functionName);
            } else {
                if (functionName == "COT") {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                    }
                    throw sQLException;
                }
                if (functionName == "DEGREES") {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                    }
                    throw sQLException;
                }
                if (functionName == "EXP") {
                    this.usingFunctionName(functionName);
                } else if (functionName == "FLOOR") {
                    this.usingFunctionName(functionName);
                } else if (functionName == "LOG") {
                    this.usingFunctionName("LN");
                } else if (functionName == "LOG10") {
                    this.replacingFunctionPrefix("LOG ( 10, ");
                } else if (functionName == "MOD") {
                    this.usingFunctionName(functionName);
                } else if (functionName == "PI") {
                    this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
                } else if (functionName == "POWER") {
                    this.usingFunctionName(functionName);
                } else {
                    if (functionName == "RADIANS") {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (functionName == "RAND") {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (functionName == "ROUND") {
                        this.usingFunctionName(functionName);
                    } else if (functionName == "SIGN") {
                        this.usingFunctionName(functionName);
                    } else if (functionName == "SIN") {
                        this.usingFunctionName(functionName);
                    } else if (functionName == "SQRT") {
                        this.usingFunctionName(functionName);
                    } else if (functionName == "TAN") {
                        this.usingFunctionName(functionName);
                    } else if (functionName == "TRUNCATE") {
                        this.usingFunctionName("TRUNC");
                    } else if (functionName == "ASCII") {
                        this.usingFunctionName(functionName);
                    } else if (functionName == "CHAR") {
                        this.usingFunctionName("CHR");
                    } else if (functionName == "CHAR_LENGTH") {
                        this.usingFunctionName("LENGTH");
                    } else if (functionName == "CHARACTER_LENGTH") {
                        this.usingFunctionName("LENGTH");
                    } else if (functionName == "CONCAT") {
                        this.usingFunctionName(functionName);
                    } else {
                        if (functionName == "DIFFERENCE") {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (functionName == "INSERT") {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (functionName == "LCASE") {
                            this.usingFunctionName("LOWER");
                        } else {
                            if (functionName == "LEFT") {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                }
                                throw sQLException;
                            }
                            if (functionName == "LENGTH") {
                                this.usingFunctionName(functionName);
                            } else if (functionName == "LOCATE") {
                                StringBuffer savedOracleSql = this.oracle_sql;
                                this.oracle_sql = new StringBuffer();
                                this.handleODBC(ParseMode.LOCATE_1);
                                StringBuffer arg1 = this.oracle_sql;
                                this.oracle_sql = savedOracleSql;
                                this.oracle_sql.append("INSTR(");
                                this.handleODBC(ParseMode.LOCATE_2);
                                this.oracle_sql.append(',');
                                this.oracle_sql.append(arg1);
                                this.oracle_sql.append(')');
                                this.handleODBC(ParseMode.SCALAR);
                            } else if (functionName == "LTRIM") {
                                this.usingFunctionName(functionName);
                            } else if (functionName == "OCTET_LENGTH") {
                                this.usingFunctionName("LENGTHB");
                            } else {
                                if (functionName == "POSITION") {
                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                    }
                                    throw sQLException;
                                }
                                if (functionName == "REPEAT") {
                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                    if (bl) {
                                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                    }
                                    throw sQLException;
                                }
                                if (functionName == "REPLACE") {
                                    this.usingFunctionName(functionName);
                                } else {
                                    if (functionName == "RIGHT") {
                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                    if (functionName == "RTRIM") {
                                        this.usingFunctionName(functionName);
                                    } else if (functionName == "SOUNDEX") {
                                        this.usingFunctionName(functionName);
                                    } else {
                                        if (functionName == "SPACE") {
                                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                            }
                                            throw sQLException;
                                        }
                                        if (functionName == "SUBSTRING") {
                                            this.usingFunctionName("SUBSTR");
                                        } else if (functionName == "UCASE") {
                                            this.usingFunctionName("UPPER");
                                        } else if (functionName == "CURRENT_DATE") {
                                            this.replacingFunctionPrefix("(CURRENT_DATE");
                                        } else {
                                            if (functionName == "CURRENT_TIME") {
                                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                if (bl) {
                                                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                }
                                                throw sQLException;
                                            }
                                            if (functionName == "CURRENT_TIMESTAMP") {
                                                this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
                                            } else if (functionName == "CURDATE") {
                                                this.replacingFunctionPrefix("(CURRENT_DATE");
                                            } else if (functionName == "CURTIME") {
                                                this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
                                            } else {
                                                if (functionName == "DAYNAME") {
                                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                    if (bl) {
                                                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                    }
                                                    throw sQLException;
                                                }
                                                if (functionName == "DAYOFMONTH") {
                                                    this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
                                                } else {
                                                    if (functionName == "DAYOFWEEK") {
                                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                        if (bl) {
                                                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                        }
                                                        throw sQLException;
                                                    }
                                                    if (functionName == "DAYOFYEAR") {
                                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                        if (bl) {
                                                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                        }
                                                        throw sQLException;
                                                    }
                                                    if (functionName == "EXTRACT") {
                                                        this.usingFunctionName("EXTRACT");
                                                    } else if (functionName == "HOUR") {
                                                        this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
                                                    } else if (functionName == "MINUTE") {
                                                        this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
                                                    } else if (functionName == "MONTH") {
                                                        this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
                                                    } else {
                                                        if (functionName == "MONTHNAME") {
                                                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                            if (bl) {
                                                                ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                            }
                                                            throw sQLException;
                                                        }
                                                        if (functionName == "NOW") {
                                                            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
                                                        } else {
                                                            if (functionName == "QUARTER") {
                                                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                if (bl) {
                                                                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                }
                                                                throw sQLException;
                                                            }
                                                            if (functionName == "SECOND") {
                                                                this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
                                                            } else {
                                                                if (functionName == "TIMESTAMPADD") {
                                                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                    if (bl) {
                                                                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                    }
                                                                    throw sQLException;
                                                                }
                                                                if (functionName == "TIMESTAMPDIFF") {
                                                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                    if (bl) {
                                                                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                    }
                                                                    throw sQLException;
                                                                }
                                                                if (functionName == "WEEK") {
                                                                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                    if (bl) {
                                                                        ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                    }
                                                                    throw sQLException;
                                                                }
                                                                if (functionName == "YEAR") {
                                                                    this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
                                                                } else {
                                                                    if (functionName == "DATABASE") {
                                                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                        if (bl) {
                                                                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                        }
                                                                        throw sQLException;
                                                                    }
                                                                    if (functionName == "IFNULL") {
                                                                        this.usingFunctionName("NVL");
                                                                    } else if (functionName == "USER") {
                                                                        this.replacingFunctionPrefix("(USER");
                                                                    } else {
                                                                        if (functionName == "CONVERT") {
                                                                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                            if (bl) {
                                                                                ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                            }
                                                                            throw sQLException;
                                                                        }
                                                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName).fillInStackTrace();
                                                                        if (bl) {
                                                                            ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, sQLException);
                                                                        }
                                                                        throw sQLException;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleSql.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void usingFunctionName(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void newName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OracleSql.class, $$$methodRef$$$40, this, string);
            }
            this.oracle_sql.append((String)newName);
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OracleSql.class, $$$methodRef$$$40, this);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleSql.class, $$$methodRef$$$40, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleSql.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void replacingFunctionPrefix(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void newPrefix;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OracleSql.class, $$$methodRef$$$41, this, string);
            }
            this.skipSpace();
            if (this.i < this.length && (this.currentChar = this.odbc_sql.charAt(this.i)) == '(') {
                ++this.i;
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, OracleSql.class, $$$methodRef$$$41, this, sQLException);
                }
                throw sQLException;
            }
            this.oracle_sql.append((String)newPrefix);
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OracleSql.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleSql.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleSql.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    void handleOuterJoin() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OracleSql.class, $$$methodRef$$$42, this, new Object[0]);
            }
            this.oracle_sql.append(" ( ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(" ) ");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OracleSql.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleSql.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleSql.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    String nextArgument() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OracleSql.class, $$$methodRef$$$43, this, new Object[0]);
            }
            String result = ":" + this.current_argument;
            ++this.current_argument;
            String string = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OracleSql.class, $$$methodRef$$$43, this, string);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleSql.class, $$$methodRef$$$43, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleSql.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void appendChar(StringBuffer stringBuffer, char c2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void oracle_sql;
            void c3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OracleSql.class, $$$methodRef$$$44, this, stringBuffer, Character.valueOf(c2));
            }
            if (c3 == 63) {
                oracle_sql.append(this.nextArgument());
            } else {
                oracle_sql.append((char)c3);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OracleSql.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleSql.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleSql.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    void skipSpace() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, OracleSql.class, $$$methodRef$$$45, this, new Object[0]);
            }
            while (this.i < this.length && (this.currentChar = this.odbc_sql.charAt(this.i)) == ' ') {
                ++this.i;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, OracleSql.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleSql.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleSql.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    String generateParameterName() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String newParameter;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, OracleSql.class, $$$methodRef$$$46, this, new Object[0]);
            }
            if (this.parameterCount == 0 || this.parameterList == null) {
                String string = paramPrefix + this.paramSuffix++;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleSql.class, $$$methodRef$$$46, this, string);
                    ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleSql.class, $$$methodRef$$$46, this, null);
                }
                return string;
            }
            block2: while (true) {
                newParameter = paramPrefix + this.paramSuffix++;
                for (int i2 = 0; i2 < this.parameterList.length; ++i2) {
                    if (newParameter.equals(this.parameterList[i2])) continue block2;
                }
                break;
            }
            String string = newParameter;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleSql.class, $$$methodRef$$$46, this, string);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleSql.class, $$$methodRef$$$46, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleSql.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    static boolean isValidPlsqlWarning(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String setting;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, OracleSql.class, $$$methodRef$$$47, null, string);
            }
            boolean bl2 = setting.matches("('\\s*([a-zA-Z0-9:,\\(\\)\\s])*')\\s*(,\\s*'([a-zA-Z0-9:,\\(\\)\\s])*')*");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, OracleSql.class, $$$methodRef$$$47, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleSql.class, $$$methodRef$$$47, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleSql.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isValidObjectName(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String name;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, OracleSql.class, $$$methodRef$$$48, null, string);
            }
            if (!($assertionsDisabled || name != null && name.length() > 0)) {
                AssertionError assertionError = new AssertionError((Object)"name is null or empty");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$48, Level.FINEST, OracleSql.class, $$$methodRef$$$48, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            boolean bl2 = DATABASE_OBJECT_NAME_RULE.matcher(name).matches();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, OracleSql.class, $$$methodRef$$$48, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleSql.class, $$$methodRef$$$48, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleSql.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String[] cases;
            String[] args;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null, new Object[]{stringArray});
            }
            if (args.length < 2) {
                System.err.println("ERROR: incorrect usage. OracleSql (-transition <file> | <process_escapes> <convert_nchars> { <sql> } )");
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null);
                    ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null, null);
                }
                return;
            }
            if (args[0].equals("-dump")) {
                OracleSql.dumpTransitionMatrix(args[1]);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null);
                    ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null, null);
                }
                return;
            }
            boolean escapes = args[0].equals("true");
            boolean nchar = args[1].equals("true");
            if (args.length > 2) {
                cases = new String[args.length - 2];
                System.arraycopy(args, 2, cases, 0, cases.length);
            } else {
                cases = new String[]{"select ? from dual", "insert into dual values (?)", "delete from dual", "update dual set dummy = ?", "merge tab into dual", " select ? from dual where ? = ?", "select ?from dual where?=?for update", "select '?', n'?', q'???', q'{?}', q'{cat's}' from dual", "select'?',n'?',q'???',q'{?}',q'{cat's}'from dual", "select--line\n? from dual", "select --line\n? from dual", "--line\nselect ? from dual", " --line\nselect ? from dual", "--line\n select ? from dual", "begin proc4in4out (:x1, :x2, :x3, :x4); end;", "{CALL tkpjpn01(:pin, :pinout, :pout)}", "select :NumberBindVar as the_number from dual", "select {fn locate(bob(carol(),ted(alice,sue)), 'xfy')} from dual", "CREATE USER vijay6 IDENTIFIED BY \"vjay?\"", "ALTER SESSION SET TIME", "SELECT ename FROM emp WHERE hiredate BETWEEN {ts'1980-12-17'} AND {ts '1981-09-28'} "};
            }
            for (String testCase : cases) {
                try {
                    int i2;
                    System.out.println("\n\n-----------------------");
                    System.out.println(testCase);
                    System.out.println();
                    OracleSql o2 = new OracleSql(null);
                    o2.initialize(testCase);
                    String sql = o2.getSql(escapes, nchar);
                    System.out.println(o2.sqlKind + ", " + o2.parameterCount);
                    String[] p2 = o2.getParameterList();
                    if (p2 == EMPTY_LIST) {
                        System.out.println("parameterList is empty");
                    } else {
                        for (i2 = 0; i2 < p2.length; ++i2) {
                            System.out.println("parameterList[" + i2 + "] = " + p2[i2]);
                        }
                    }
                    if (o2.getSqlKind().isDML()) {
                        int c2 = o2.getReturnParameterCount();
                        if (c2 == -1) {
                            System.out.println("no return parameters");
                        } else {
                            System.out.println(c2 + " return parameters");
                        }
                    }
                    if (o2.lastNcharLiteralLocation == 2) {
                        System.out.println("No NCHAR literals");
                    } else {
                        System.out.println("NCHAR Literals");
                        i2 = 1;
                        while (i2 < o2.lastNcharLiteralLocation - 1) {
                            System.out.println(testCase.substring(o2.ncharLiteralLocation[i2++], o2.ncharLiteralLocation[i2++]));
                        }
                    }
                    System.out.println("Keywords");
                    if (o2.selectEndIndex == -1) {
                        System.out.println("no select");
                    } else {
                        System.out.println("'" + testCase.substring(o2.selectEndIndex - 6, o2.selectEndIndex) + "'");
                    }
                    if (o2.orderByStartIndex == -1) {
                        System.out.println("no order by");
                    } else {
                        System.out.println("'" + testCase.substring(o2.orderByStartIndex, o2.orderByEndIndex) + "'");
                    }
                    if (o2.whereStartIndex == -1) {
                        System.out.println("no where");
                    } else {
                        System.out.println("'" + testCase.substring(o2.whereStartIndex, o2.whereEndIndex) + "'");
                    }
                    if (o2.forUpdateStartIndex == -1) {
                        System.out.println("no for update");
                    } else {
                        System.out.println("'" + testCase.substring(o2.forUpdateStartIndex, o2.forUpdateEndIndex) + "'");
                    }
                    System.out.println("isPlsqlOrCall(): " + o2.getSqlKind().isPlsqlOrCall());
                    System.out.println("isDML(): " + o2.getSqlKind().isDML());
                    System.out.println("isSELECT(): " + o2.getSqlKind().isSELECT());
                    System.out.println("isOTHER(): " + o2.getSqlKind().isOTHER());
                    System.out.println("\"" + sql + "\"");
                    System.out.println("\"" + o2.getRevisedSql() + "\"");
                    System.out.println("\"" + o2.getRefetchSql() + "\"");
                    String[] sArray = new String[]{sql};
                    OracleParameterMetaDataParser.main(sArray);
                }
                catch (Exception e2) {
                    System.out.println(e2);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleSql.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final void dumpTransitionMatrix(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, OracleSql.class, $$$methodRef$$$50, null, string);
            }
            try {
                String fileName;
                PrintWriter f2 = new PrintWriter(fileName);
                f2.print(",");
                for (int c2 = 0; c2 < 128; ++c2) {
                    f2.print("'" + (String)(c2 < 32 ? "0x" + Integer.toHexString(c2) : Character.toString((char)c2)) + (c2 < 127 ? "'," : "'"));
                }
                f2.println();
                int[][] m2 = OracleSqlReadOnly.TRANSITION;
                String[] n2 = OracleSqlReadOnly.PARSER_STATE_NAME;
                for (int s2 = 0; s2 < TRANSITION.length; ++s2) {
                    f2.print(n2[s2] + ",");
                    for (int c3 = 0; c3 < m2[s2].length; ++c3) {
                        f2.print(n2[m2[s2][c3]] + (c3 < 127 ? "," : ""));
                    }
                    f2.println();
                }
                f2.close();
            }
            catch (Throwable e2) {
                System.err.println(e2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleSql.class, $$$methodRef$$$50, null);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleSql.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleSql.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, OracleSql.class, $$$methodRef$$$51, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, OracleSql.class, $$$methodRef$$$51, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleSql.class, $$$methodRef$$$51, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleSql.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    int getReturnParameterCount() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, OracleSql.class, $$$methodRef$$$52, this, new Object[0]);
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (!this.sqlKind.isDML()) {
                int n2 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleSql.class, $$$methodRef$$$52, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleSql.class, $$$methodRef$$$52, this, null);
                }
                return -1;
            }
            int n3 = this.returningIntoParameterCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleSql.class, $$$methodRef$$$52, this, n3);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleSql.class, $$$methodRef$$$52, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleSql.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getSubstrPos(String string, String string2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int posEnd;
            void token;
            void sSQL;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, OracleSql.class, $$$methodRef$$$53, this, string, string2);
            }
            int retVal = -1;
            int posStart = sSQL.indexOf((String)token);
            if (posStart >= 1 && Character.isWhitespace(sSQL.charAt(posStart - 1)) && (posEnd = posStart + token.length()) < sSQL.length() && Character.isWhitespace(sSQL.charAt(posEnd))) {
                retVal = posStart;
            }
            int n2 = retVal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, OracleSql.class, $$$methodRef$$$53, this, n2);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleSql.class, $$$methodRef$$$53, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleSql.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$54 = OracleSql.class.getDeclaredConstructor(DBConversion.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleSql.class.getDeclaredMethod("getSubstrPos", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleSql.class.getDeclaredMethod("getReturnParameterCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleSql.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleSql.class.getDeclaredMethod("dumpTransitionMatrix", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleSql.class.getDeclaredMethod("main", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleSql.class.getDeclaredMethod("isValidObjectName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleSql.class.getDeclaredMethod("isValidPlsqlWarning", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleSql.class.getDeclaredMethod("generateParameterName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleSql.class.getDeclaredMethod("skipSpace", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleSql.class.getDeclaredMethod("appendChar", StringBuffer.class, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleSql.class.getDeclaredMethod("nextArgument", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleSql.class.getDeclaredMethod("handleOuterJoin", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleSql.class.getDeclaredMethod("replacingFunctionPrefix", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleSql.class.getDeclaredMethod("usingFunctionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleSql.class.getDeclaredMethod("handleScalarFunction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleSql.class.getDeclaredMethod("handleLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleSql.class.getDeclaredMethod("handleEscape", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleSql.class.getDeclaredMethod("handleDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleSql.class.getDeclaredMethod("handleTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleSql.class.getDeclaredMethod("handleTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleSql.class.getDeclaredMethod("handleCall", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleSql.class.getDeclaredMethod("handleFunction", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleSql.class.getDeclaredMethod("handleODBC", ParseMode.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleSql.class.getDeclaredMethod("parse", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleSql.class.getDeclaredMethod("addRowid", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleSql.class.getDeclaredMethod("growNcharLiteralLocation", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleSql.class.getDeclaredMethod("computeBasicInfo", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleSql.class.getDeclaredMethod("convertNcharLiterals", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleSql.class.getDeclaredMethod("hexUnicode", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleSql.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleSql.class.getDeclaredMethod("setIncludeRowid", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleSql.class.getDeclaredMethod("getParameterList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleSql.class.getDeclaredMethod("getParameterCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleSql.class.getDeclaredMethod("getSqlKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleSql.class.getDeclaredMethod("getSqlBytes", Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleSql.class.getDeclaredMethod("generatedSqlNeedEscapeProcessing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleSql.class.getDeclaredMethod("getDeleteSqlForUpdatableResultSet", OldUpdatableResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleSql.class.getDeclaredMethod("getUpdateSqlForUpdatableResultSet", OldUpdatableResultSet.class, Integer.TYPE, Object[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleSql.class.getDeclaredMethod("getInsertSqlForUpdatableResultSet", OldUpdatableResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleSql.class.getDeclaredMethod("getDeleteSqlForUpdatableResultSet", UpdatableResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleSql.class.getDeclaredMethod("getUpdateSqlForUpdatableResultSet", UpdatableResultSet.class, Integer.TYPE, Object[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleSql.class.getDeclaredMethod("getRefetchSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleSql.class.getDeclaredMethod("getRefetchSqlForScrollableResultSet", OracleResultSet.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleSql.class.getDeclaredMethod("getInsertSqlForUpdatableResultSet", List.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleSql.class.getDeclaredMethod("appendForUpdate", StringBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleSql.class.getDeclaredMethod("removeOrderByForUpdate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleSql.class.getDeclaredMethod("removeForUpdate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleSql.class.getDeclaredMethod("getRevisedSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleSql.class.getDeclaredMethod("getSql", Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleSql.class.getDeclaredMethod("resetNamedParameters", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleSql.class.getDeclaredMethod("setNamedParameters", Integer.TYPE, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleSql.class.getDeclaredMethod("isConnectionValidationSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleSql.class.getDeclaredMethod("getOriginalSql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleSql.class.getDeclaredMethod("initialize", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        EMPTY_LIST = new String[0];
        CONNECTION_VALIDATION_SQL_PATTERN = Pattern.compile("\\A\\s*/\\*\\+\\s*CLIENT_CONNECTION_VALIDATION\\s*\\*/.*", 2);
        TRANSITION = OracleSqlReadOnly.TRANSITION;
        ACTION = OracleSqlReadOnly.ACTION;
        ODBC_ACTION = OracleSqlReadOnly.ODBC_ACTION;
        DATABASE_OBJECT_NAME_RULE = Pattern.compile("\"[^\"\\u0000]+\"|\\p{L}[\\p{L}\\p{N}_$#@]*");
    }

    static final class ParseMode
    extends Enum<ParseMode> {
        public static final /* enum */ ParseMode NORMAL;
        public static final /* enum */ ParseMode SCALAR;
        public static final /* enum */ ParseMode LOCATE_1;
        public static final /* enum */ ParseMode LOCATE_2;
        private static final /* synthetic */ ParseMode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ParseMode[] values() {
            return (ParseMode[])$VALUES.clone();
        }

        public static ParseMode valueOf(String name) {
            return Enum.valueOf(ParseMode.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = ParseMode.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ParseMode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ParseMode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NORMAL = new ParseMode();
            SCALAR = new ParseMode();
            LOCATE_1 = new ParseMode();
            LOCATE_2 = new ParseMode();
            $VALUES = new ParseMode[]{NORMAL, SCALAR, LOCATE_1, LOCATE_2};
        }
    }
}

