/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OpaqueAccessToken;
import oracle.jdbc.driver.OpaquePrivateKey;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.TcpsNTAdapter;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5Logon;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

@Supports(value={Feature.CONNECT})
@DefaultLogger(value="oracle.jdbc")
final class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] enableTempLobRefCnt;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName;
    byte[] driverName;
    String ressourceManagerId;
    boolean bUseO5Logon;
    int verifierType;
    static final int ZTVT_ORCL_7 = 2361;
    static final int ZTVT_SSH1 = 6949;
    static final int ZTVT_NTV = 7809;
    static final int ZTVT_SMD5 = 59694;
    static final int ZTVT_MD5 = 40674;
    static final int ZTVT_SH1 = 45394;
    static final int ZTVT_SHA512 = 18453;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_SESSION_QCACHE = 0x800000;
    static final int KPZ_LOGON_SYSBKP = 0x1000000;
    static final int KPZ_LOGON_SYSDGD = 0x2000000;
    static final int KPZ_LOGON_SYSKMT = 0x4000000;
    static final int KPZ_CPW_AUTH = 16;
    static final int KPZ_OPASSWD_ENCRYPTED = 32;
    static final int KPZ_NPASSWD_ENCRYPTED = 64;
    static final int KPZ_NPASSWD_OBFUSCATE = 65536;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_NEWPASSWORD = "AUTH_NEWPASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_DB_ID = "AUTH_DB_ID";
    static final String AUTH_QCACHE_MAXSIZE = "AUTH_QCACHE_MAXSIZE";
    static final String AUTH_QCACHE_CACHELAG = "AUTH_QCACHE_CACHELAG";
    static final String AUTH_GLOBALLY_UNIQUE_DBID = "AUTH_GLOBALLY_UNIQUE_DBID";
    static final String AUTH_QCACHE_CACHEID = "AUTH_QCACHE_CACHEID";
    static final String AUTH_QCACHE_REGID = "AUTH_QCACHE_REGID";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SC_DB_DOMAIN = "AUTH_SC_DB_DOMAIN";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXNLSCOMP = "AUTH_NLS_LXNLSCOMP";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
    static final String AUTH_KPPL_CONN_CLASS = "AUTH_KPPL_CONN_CLASS";
    static final String AUTH_KPPL_PURITY = "AUTH_KPPL_PURITY";
    static final String AUTH_KPPL_TAG = "AUTH_KPPL_TAG";
    static final String AUTH_KPPL_IS_MULTIPROP_TAG = "AUTH_KPPL_IS_MULTIPROP_TAG";
    static final String AUTH_KPPL_FIXUP_CB = "AUTH_KPPL_FIXUP_CB";
    static final String AUTH_KPPL_WAIT = "AUTH_KPPL_WAIT";
    static final String AUTH_PBKDF2_SPEEDY_KEY = "AUTH_PBKDF2_SPEEDY_KEY";
    private static final String AUTH_TOKEN = "AUTH_TOKEN";
    private static final String AUTH_HEADER = "AUTH_HEADER";
    private static final String AUTH_SIGNATURE = "AUTH_SIGNATURE";
    static final String KPPL_PURITY_DEFAULT = "0";
    static final String KPPL_PURITY_NEW = "1";
    static final String KPPL_PURITY_SELF = "2";
    static final String SESS_PURITY_DEFAULT = "DEFAULT";
    static final String SESS_PURITY_NEW = "NEW";
    static final String SESS_PURITY_SELF = "SELF";
    static final String[][] KPPL_PURITY;
    static final String AUTH_CONNECT_STRING = "AUTH_CONNECT_STRING";
    static final String DRIVER_NAME_DEFAULT = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_AUDIT_BANNER = "AUTH_AUDIT_BANNER";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    public static final int AUTH_FLAG_O5LOGON = 0;
    public static final int AUTH_FLAG_NONO5LOGON = 1;
    private static final DateTimeFormatter AUTH_HEADER_DATE_FORMATTER;
    String sessionTimeZone;
    private T4CKvaldfList keyValList;
    private byte[] user;
    private long logonMode;
    private byte[][] outKeys;
    private byte[][] outValues;
    private int[] outFlags;
    private int outNbPairs;
    private byte[] PBKDF2Salt;
    private int PBKDF2VgenCount;
    private int PBKDF2SderCount;
    O5Logon o5logonHelper;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;

    T4CTTIoauthenticate(T4CConnection _conn, String _ressourceManagerId) throws SQLException {
        super(_conn, (byte)3);
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$58, null, _conn, _ressourceManagerId);
            }
            this.editionName = null;
            this.isSessionTZ = true;
            this.sessionTimeZone = null;
            this.keyValList = null;
            this.user = null;
            this.outKeys = null;
            this.outValues = null;
            this.outFlags = new int[0];
            this.outNbPairs = 0;
            this.o5logonHelper = null;
            this.ressourceManagerId = _ressourceManagerId;
            this.setSessionFields(_conn);
            this.isSessionTZ = true;
            this.bUseO5Logon = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$58, null);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$58, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$58, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.user != null && this.user.length > 0) {
                this.meg.marshalPTR();
                this.meg.marshalSB4(this.user.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSB4(0);
            }
            this.meg.marshalUB4(this.logonMode);
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.keyValList.size());
            this.meg.marshalPTR();
            this.meg.marshalPTR();
            if (this.user != null && this.user.length > 0) {
                this.meg.marshalCHR(this.user);
            }
            this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doOAUTH(byte[] byArray, @Blind byte[] byArray2, @Blind byte[] byArray3, long l2, String string, boolean bl, byte[] byArray4, byte[] byArray5, byte[][] byArray6, int n2, int n3, byte[] byArray7) throws IOException, SQLException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void speedyKey;
            void gl_serial_nb;
            void gl_session_id;
            void proxyRoles;
            void proxyCertificate;
            void proxyDN;
            void proxyAuthentication;
            void authenticationAdaptor;
            void llogonMode;
            void lnewPassword;
            void lpassword;
            void luser;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this, new Object[]{byArray, "*****", "*****", l2, string, bl, byArray4, byArray5, byArray6, n2, n3, byArray7});
            }
            this.prepareForOAUTH((byte[])luser, (byte[])lpassword, (byte[])lnewPassword, (long)llogonMode, (String)authenticationAdaptor, (boolean)proxyAuthentication, (byte[])proxyDN, (byte[])proxyCertificate, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, (byte[])speedyKey);
            this.doRPC();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private CompletionStage<Void> doOAUTHAsync(byte[] byArray, @Blind byte[] byArray2, @Blind byte[] byArray3, long l2, String string, boolean bl, byte[] byArray4, byte[] byArray5, byte[][] byArray6, int n2, int n3, byte[] byArray7) {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, new Object[]{byArray, "*****", "*****", l2, string, bl, byArray4, byArray5, byArray6, n2, n3, byArray7});
            }
            try {
                void speedyKey;
                void gl_serial_nb;
                void gl_session_id;
                void proxyRoles;
                void proxyCertificate;
                void proxyDN;
                void proxyAuthentication;
                void authenticationAdaptor;
                void llogonMode;
                void lnewPassword;
                void lpassword;
                void luser;
                this.prepareForOAUTH((byte[])luser, (byte[])lpassword, (byte[])lnewPassword, (long)llogonMode, (String)authenticationAdaptor, (boolean)proxyAuthentication, (byte[])proxyDN, (byte[])proxyCertificate, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, (byte[])speedyKey);
            }
            catch (SQLException preRPCFailure) {
                CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(preRPCFailure);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, null);
                }
                return completionStage;
            }
            CompletionStage<Void> completionStage = this.doRPCAsync();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareForOAUTH(byte[] byArray, @Blind byte[] byArray2, @Blind byte[] byArray3, long l2, String string, boolean bl, byte[] byArray4, byte[] byArray5, byte[][] byArray6, int n2, int n3, byte[] byArray7) throws SQLException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void gl_serial_nb;
            void gl_session_id;
            void proxyRoles;
            void proxyCertificate;
            void proxyDN;
            void speedyKey;
            void lnewPassword;
            void proxyAuthentication;
            void authenticationAdaptor;
            void lpassword;
            void llogonMode;
            void luser;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this, new Object[]{byArray, "*****", "*****", l2, string, bl, byArray4, byArray5, byArray6, n2, n3, byArray7});
            }
            this.setFunCode((short)115);
            this.user = luser;
            this.keyValList = new T4CKvaldfList(this.meg.conv);
            this.initializeLogonModeForOAUTH((byte[])luser, (long)llogonMode, (byte[])lpassword, (String)authenticationAdaptor, (boolean)proxyAuthentication);
            if (lnewPassword != null) {
                this.initializeForOAUTHWithNewPassword((byte[])lnewPassword);
            }
            this.setPasswordKeyValsForOAUTH((byte[])lpassword, (byte[])speedyKey);
            this.setProxyLogonKeyValsForOAUTH((byte[])proxyDN, (byte[])proxyCertificate, (byte[][])proxyRoles);
            this.setVSessionKeyValsForOAUTH();
            this.setInternalNameKeyValsForOAUTH();
            this.setAlterSessionKeyValsForOAUTH();
            this.setDriverIdentityKeyValsForOAUTH();
            this.setSessionIdentityKeyValsForOAUTH((int)gl_session_id, (int)gl_serial_nb);
            this.setDRCPKeyValsForOAUTH();
            this.setResultSetCacheKeyValsForOAUTH();
            this.setMiscellaneousKeyValsForOAUTH();
            this.resetStateBeforeCall();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeLogonModeForOAUTH(byte[] byArray, long l2, @Blind byte[] byArray2, String string, boolean bl) {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void authenticationAdaptor;
            void lpassword;
            void luser;
            void proxyAuthentication;
            void llogonMode;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this, byArray, l2, "*****", string, bl);
            }
            this.logonMode = llogonMode | 1L;
            if (this.connection.isResultSetCacheEnabled) {
                this.logonMode |= 0x800000L;
            }
            if (proxyAuthentication != false) {
                this.logonMode |= 0x400L;
            }
            if (luser != null && ((void)luser).length != 0 && lpassword != null && authenticationAdaptor != "RADIUS") {
                this.logonMode |= 0x100L;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeForOAUTHWithNewPassword(@Blind byte[] byArray) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void lnewPassword;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, "*****");
            }
            this.logonMode |= 0x12L;
            this.logonMode ^= 1L;
            this.keyValList.add(AUTH_NEWPASSWORD, (byte[])lnewPassword);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setPasswordKeyValsForOAUTH(@Blind byte[] byArray, byte[] byArray2) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void speedyKey;
            void lpassword;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this, "*****", byArray2);
            }
            if (lpassword != null) {
                this.keyValList.add(AUTH_PASSWORD, (byte[])lpassword);
            }
            if (speedyKey != null) {
                this.keyValList.add(AUTH_PBKDF2_SPEEDY_KEY, (byte[])speedyKey);
            }
            if (this.bUseO5Logon && this.encryptedKB != null) {
                this.keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setProxyLogonKeyValsForOAUTH(byte[] byArray, byte[] byArray2, byte[][] byArray3) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyCertificate;
            void proxyDN;
            void proxyRoles;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, new Object[]{byArray, byArray2, byArray3});
            }
            if (proxyRoles != null) {
                for (int i2 = 0; i2 < ((void)proxyRoles).length; ++i2) {
                    this.keyValList.add(AUTH_INITIAL_CLIENT_ROLE, (byte[])proxyRoles[i2]);
                }
            }
            if (proxyDN != null) {
                this.keyValList.add(AUTH_CLIENT_DN, (byte[])proxyDN);
            }
            if (proxyCertificate != null) {
                this.keyValList.add(AUTH_CLIENT_CERTIFICATE, (byte[])proxyCertificate);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setVSessionKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.keyValList.add(AUTH_TERMINAL, this.terminal);
            if (this.programName != null) {
                this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
            }
            if (this.clientname != null) {
                this.keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
            }
            this.keyValList.add(AUTH_MACHINE, this.machine);
            this.keyValList.add(AUTH_PID, this.processID);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setInternalNameKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (!this.ressourceManagerId.equals("0000")) {
                byte[] key = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
                key[key.length - 1] = 0;
                this.keyValList.add(key, this.internalName);
                key = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
                key[key.length - 1] = 0;
                this.keyValList.add(key, this.externalName);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setDriverIdentityKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (this.editionName != null) {
                this.keyValList.add(AUTH_ORA_EDITION, this.editionName);
            }
            this.keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.driverName);
            this.keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setMiscellaneousKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, new Object[0]);
            }
            this.keyValList.add(SESSION_CLIENT_LOBATTR, this.enableTempLobRefCnt);
            this.keyValList.add(AUTH_CONNECT_STRING, this.meg.conv.StringToCharBytes(this.connection.net().getConnectionString()));
            this.keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
            this.keyValList.add(AUTH_ACL, this.aclValue);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setAlterSessionKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setSessionIdentityKeyValsForOAUTH(int n2, int n3) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void gl_serial_nb;
            void gl_session_id;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, n2, n3);
            }
            if (gl_session_id != -1) {
                this.keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString((int)gl_session_id)));
            }
            if (gl_serial_nb != -1) {
                this.keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString((int)gl_serial_nb)));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setDRCPKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, new Object[0]);
            }
            if (this.connection.drcpEnabled) {
                if (this.connection.drcpConnectionClass != null && this.connection.drcpConnectionClass != "") {
                    this.keyValList.add(AUTH_KPPL_CONN_CLASS, this.meg.conv.StringToCharBytes(this.connection.drcpConnectionClass));
                }
                this.keyValList.add(AUTH_KPPL_PURITY, this.meg.conv.StringToCharBytes(this.getKPPLPurity()));
                if (this.connection.drcpTagName != null) {
                    this.keyValList.add(AUTH_KPPL_TAG, this.meg.conv.StringToCharBytes(this.connection.drcpTagName));
                    if (this.connection.useDRCPMultipletag) {
                        this.keyValList.add(AUTH_KPPL_IS_MULTIPROP_TAG, this.meg.conv.StringToCharBytes("TRUE"));
                    }
                }
                if (this.connection.drcpPLSQLCallback != null && this.connection.drcpPLSQLCallback.length() > 0 && this.connection.getTTCVersion() >= 8) {
                    this.keyValList.add(AUTH_KPPL_FIXUP_CB, this.meg.conv.StringToCharBytes(this.connection.drcpPLSQLCallback));
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void setResultSetCacheKeyValsForOAUTH() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (this.connection.isResultSetCacheActive()) {
                this.keyValList.add(AUTH_QCACHE_CACHEID, this.connection.getResultSetCacheIdAsNibbles());
                this.keyValList.add(AUTH_QCACHE_REGID, this.meg.conv.StringToCharBytes(Long.toString(this.connection.getResultSetCacheRegistrationId())));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void resetStateBeforeCall() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, this, new Object[0]);
            }
            this.outNbPairs = 0;
            this.outKeys = null;
            this.outValues = null;
            this.outFlags = new int[0];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOSESSKEY(String string, long l2) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void llogonMode;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$17, this, string, l2);
            }
            this.initializeForOSESSKEY((String)userName, (long)llogonMode);
            this.doRPC();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Void> doOSESSKEYAsync(String string, long l2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$18, this, string, l2);
            }
            try {
                void llogonMode;
                void userName;
                this.initializeForOSESSKEY((String)userName, (long)llogonMode);
            }
            catch (SQLException preRPCFailure) {
                CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(preRPCFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$18, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$18, this, null);
                }
                return completionStage;
            }
            CompletionStage<Void> completionStage = this.doRPCAsync();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$18, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$18, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeForOSESSKEY(String string, long l2) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void llogonMode;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$19, this, string, l2);
            }
            this.setFunCode((short)118);
            this.user = this.meg.conv.StringToCharBytes((String)userName);
            this.logonMode = llogonMode | 1L;
            this.keyValList = new T4CKvaldfList(this.meg.conv);
            this.keyValList.add(AUTH_TERMINAL, this.terminal);
            if (this.programName != null) {
                this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
            }
            this.keyValList.add(AUTH_MACHINE, this.machine);
            this.keyValList.add(AUTH_PID, this.processID);
            this.keyValList.add(AUTH_SID, this.sysUserName);
            this.resetStateBeforeCall();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRPA() throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$20, this, new Object[0]);
            }
            this.outNbPairs = this.meg.unmarshalUB2();
            this.outKeys = new byte[this.outNbPairs][];
            this.outValues = new byte[this.outNbPairs][];
            this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void processError() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$21, this, new Object[0]);
            }
            if (this.getFunCode() == 118) {
                if (this.oer.getRetCode() != 28035L || this.connection.net().getAuthenticationAdaptorName() != "RADIUS") {
                    this.oer.processError();
                }
            } else {
                super.processError();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void processRPA() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, new Object[0]);
            }
            if (this.getFunCode() == 115) {
                Properties connectionValues = new Properties();
                for (int i2 = 0; i2 < this.outNbPairs; ++i2) {
                    String keyStr = this.meg.conv.CharBytesToString(this.outKeys[i2], this.outKeys[i2].length).trim();
                    String valueStr = "";
                    if (this.outValues[i2] != null) {
                        valueStr = this.meg.conv.CharBytesToString(this.outValues[i2], this.outValues[i2].length).trim();
                    }
                    if (this.connection.isUsingCustomHostnameResolver() && "AUTH_ONS_CONFIG".equals(keyStr)) continue;
                    connectionValues.setProperty(keyStr, valueStr);
                }
                String versionNoStr = connectionValues.getProperty(AUTH_VERSION_NO);
                if (versionNoStr != null) {
                    try {
                        int serverVersionInt = new Integer(versionNoStr);
                        if (bl) {
                            this.debug($$$loggerRef$$$22, Level.FINEST, $$$methodRef$$$22, "Server version at connection:" + this.versionIntToString(serverVersionInt));
                        }
                    }
                    catch (NumberFormatException serverVersionInt) {
                        // empty catch block
                    }
                }
                connectionValues.setProperty("SERVER_HOST", connectionValues.getProperty(AUTH_SC_SERVER_HOST, ""));
                connectionValues.setProperty("INSTANCE_NAME", connectionValues.getProperty(AUTH_SC_INSTANCE_NAME, ""));
                connectionValues.setProperty("DATABASE_NAME", connectionValues.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
                connectionValues.setProperty("SERVICE_NAME", connectionValues.getProperty(AUTH_SC_SERVICE_NAME, ""));
                connectionValues.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
                if (this.connection.sessionProperties != null) {
                    this.connection.sessionProperties.putAll((Map<?, ?>)connectionValues);
                } else {
                    this.connection.sessionProperties = connectionValues;
                }
            } else if (this.getFunCode() == 118) {
                Properties connectionValues = new Properties();
                for (int i3 = 0; i3 < this.outNbPairs; ++i3) {
                    String keyStr = this.meg.conv.CharBytesToString(this.outKeys[i3], this.outKeys[i3].length).trim();
                    String valueStr = "";
                    if (this.outValues[i3] != null) {
                        valueStr = this.meg.conv.CharBytesToString(this.outValues[i3], this.outValues[i3].length).trim();
                    }
                    if (keyStr.compareTo(AUTH_GLOBALLY_UNIQUE_DBID) != 0 && keyStr.compareTo(AUTH_QCACHE_MAXSIZE) != 0 && keyStr.compareTo(AUTH_QCACHE_CACHELAG) != 0) continue;
                    connectionValues.setProperty(keyStr, valueStr);
                }
                if (this.connection.sessionProperties != null) {
                    this.connection.sessionProperties.putAll((Map<?, ?>)connectionValues);
                } else {
                    this.connection.sessionProperties = connectionValues;
                }
                if (this.connection.net().getAuthenticationAdaptorName() != "RADIUS") {
                    if (this.outKeys == null || this.outKeys.length < 1) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                    int indexOfSessKey = -1;
                    int indexOfVfrDat = -1;
                    int indexOfPBKDF2Salt = -1;
                    int indexOfPBKDF2VgenCount = -1;
                    int indexOfPBKDF2SderCount = -1;
                    try {
                        for (int i4 = 0; i4 < this.outKeys.length; ++i4) {
                            String sKey = new String(this.outKeys[i4], "US-ASCII");
                            if (sKey.equals(AUTH_SESSKEY)) {
                                indexOfSessKey = i4;
                            } else if (sKey.equals(AUTH_VFR_DATA)) {
                                indexOfVfrDat = i4;
                            } else if (sKey.equals("AUTH_PBKDF2_CSK_SALT")) {
                                indexOfPBKDF2Salt = i4;
                            } else if (sKey.equals("AUTH_PBKDF2_VGEN_COUNT")) {
                                indexOfPBKDF2VgenCount = i4;
                            } else if (sKey.equals("AUTH_PBKDF2_SDER_COUNT")) {
                                indexOfPBKDF2SderCount = i4;
                            }
                            if (indexOfVfrDat == -1 || indexOfSessKey == -1 || indexOfPBKDF2Salt == -1 || indexOfPBKDF2VgenCount == -1 || indexOfPBKDF2SderCount == -1) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (indexOfSessKey == -1) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.encryptedSK = this.outValues[indexOfSessKey];
                    if (indexOfVfrDat != -1) {
                        this.bUseO5Logon = true;
                        this.salt = this.outValues[indexOfVfrDat];
                        this.verifierType = this.outFlags[indexOfVfrDat];
                        if (this.connection.allowedLogonVersion.equals("12a") && this.verifierType != 18453) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (this.connection.allowedLogonVersion.equals("12") && this.verifierType != 18453 && (this.verifierType != 6949 && this.verifierType != 45394 || !this.connection.hasServerCompileTimeCapability(4, 2))) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    if (indexOfPBKDF2Salt != -1) {
                        this.PBKDF2Salt = this.outValues[indexOfPBKDF2Salt];
                    }
                    if (indexOfPBKDF2VgenCount != -1) {
                        try {
                            this.PBKDF2VgenCount = Integer.parseInt(new String(this.outValues[indexOfPBKDF2VgenCount], "US-ASCII"));
                            if (this.PBKDF2VgenCount < 4096) {
                                this.PBKDF2VgenCount = 4096;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (indexOfPBKDF2SderCount != -1) {
                        try {
                            this.PBKDF2SderCount = Integer.parseInt(new String(this.outValues[indexOfPBKDF2SderCount], "US-ASCII"));
                            if (this.PBKDF2SderCount < 3) {
                                this.PBKDF2SderCount = 3;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAUTH(String string, @Blind String string2, @Blind String string3, long l2) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void logonMode;
            void newPasswordStr;
            void passwordStr;
            void userStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$23, this, string, "*****", "*****", l2);
            }
            this.doOAUTH((String)userStr, (String)passwordStr, (String)newPasswordStr, (long)logonMode, -1, -1, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Void> doOAUTHAsync(String string, @Blind String string2, @Blind String string3, long l2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void logonMode;
            void newPasswordStr;
            void passwordStr;
            void userStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$24, this, string, "*****", "*****", l2);
            }
            CompletionStage<Void> completionStage = this.doOAUTHAsync((String)userStr, (String)passwordStr, (String)newPasswordStr, (long)logonMode, -1, -1, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$24, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$24, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAUTH(String string, @Blind String string2, @Blind String string3, long l2, int n2, int n3, byte[][] byArray) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void logonMode;
            void userStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$25, this, new Object[]{string, "*****", "*****", l2, n2, n3, byArray});
            }
            String authenticationAdaptor = this.connection.net().getAuthenticationAdaptorName();
            if (userStr != null && userStr.length() != 0) {
                void passwordStr;
                byte[] user = this.meg.conv.StringToCharBytes((String)userStr);
                boolean isRadiusAuthentication = "RADIUS".equals(authenticationAdaptor);
                this.validateKeySizeForOAUTH(isRadiusAuthentication);
                if (passwordStr != null) {
                    String sanitizedPassword = this.sanitizeInputCredential((String)passwordStr);
                    byte[] passwordNet = this.meg.conv.StringToCharBytes(sanitizedPassword);
                    if (isRadiusAuthentication) {
                        this.doOAUTHWithRadiusAuthentication(passwordNet, user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                    } else {
                        String sanitizedUser = this.sanitizeInputCredential((String)userStr);
                        if (this.bUseO5Logon) {
                            void newPasswordStr;
                            this.doOAUTHWithO5Logon(sanitizedUser, sanitizedPassword, passwordNet, (String)newPasswordStr, user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                        } else {
                            this.doOAUTHWithO3Logon(sanitizedUser, sanitizedPassword, passwordNet, user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                        }
                    }
                } else {
                    this.doOAUTHWithoutPassword(user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                }
            } else {
                this.doOAUTHWithoutUser((long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                if ("KERBEROS5".equals(authenticationAdaptor)) {
                    this.connection.net().doKeyFoldinForExternalAuth();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Void> doOAUTHAsync(String string, @Blind String string2, @Blind String string3, long l2, int n2, int n3, byte[][] byArray) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void logonMode;
            void userStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, new Object[]{string, "*****", "*****", l2, n2, n3, byArray});
            }
            String authenticationAdaptor = this.connection.net().getAuthenticationAdaptorName();
            if (userStr != null && userStr.length() != 0) {
                void passwordStr;
                byte[] user;
                try {
                    user = this.meg.conv.StringToCharBytes((String)userStr);
                }
                catch (SQLException encodingException) {
                    CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(encodingException);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                        ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                    }
                    return completionStage;
                }
                boolean isRadiusAuthentication = "RADIUS".equals(authenticationAdaptor);
                try {
                    this.validateKeySizeForOAUTH(isRadiusAuthentication);
                }
                catch (SQLException validationException) {
                    CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(validationException);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                        ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                    }
                    return completionStage;
                }
                if (passwordStr != null) {
                    byte[] passwordNet;
                    String sanitizedPassword = this.sanitizeInputCredential((String)passwordStr);
                    try {
                        passwordNet = this.meg.conv.StringToCharBytes(sanitizedPassword);
                    }
                    catch (SQLException encodingException) {
                        CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(encodingException);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                            ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                        }
                        return completionStage;
                    }
                    if (isRadiusAuthentication) {
                        CompletionStage<Void> completionStage = this.doOAUTHWithRadiusAuthenticationAsync(passwordNet, user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                            ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                        }
                        return completionStage;
                    }
                    String sanitizedUser = this.sanitizeInputCredential((String)userStr);
                    if (this.bUseO5Logon) {
                        void newPasswordStr;
                        CompletionStage<Void> completionStage = this.doOAUTHWithO5LogonAsync(sanitizedUser, sanitizedPassword, passwordNet, (String)newPasswordStr, user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                            ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                        }
                        return completionStage;
                    }
                    CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported with databases  older than version 12"));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                        ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                    }
                    return completionStage;
                }
                CompletionStage<Void> completionStage = this.doOAUTHWithoutPasswordAsync(user, (long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
                }
                return completionStage;
            }
            CompletionStage<Void> completionStage = this.doOAUTHWithoutUserAsync((long)logonMode, authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
            if ("KERBEROS5".equals(authenticationAdaptor)) {
                completionStage = completionStage.thenRun(() -> {
                    boolean bl = (8L & TraceControllerImpl.feature) != 0L;
                    try {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$57, this, new Object[0]);
                        }
                        this.connection.net().doKeyFoldinForExternalAuth();
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$57, this);
                            ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$57, this, null);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$57, this, throwable2);
                        }
                        throw throwable;
                    }
                });
            }
            CompletionStage<Void> completionStage2 = completionStage;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, completionStage2);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, null);
            }
            return completionStage2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateKeySizeForOAUTH(boolean bl) throws SQLException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void isRadiusAuthentication;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$27, this, bl);
            }
            if (isRadiusAuthentication == false && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$27, this, sQLException);
                }
                throw sQLException;
            }
            if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$27, this, sQLException);
                }
                throw sQLException;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeInputCredential(@Blind String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void credential;
            String trimCredential;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$28, this, "*****");
            }
            if ((trimCredential = credential.trim()).startsWith("\"") && trimCredential.endsWith("\"")) {
                String string2 = this.removeQuotes(trimCredential);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$28, this, string2);
                    ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$28, this, null);
                }
                return string2;
            }
            String string3 = trimCredential;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$28, this, string3);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$28, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doOAUTHWithO5Logon(String string, @Blind String string2, @Blind byte[] byArray, @Blind String string3, byte[] byArray2, long l2, String string4, int n2, int n3, byte[][] byArray3) throws SQLException, IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            byte[] encryptedPk;
            byte[] newPassword;
            byte[] o5logonnewpassword;
            int[] encryptedNewPasswordLength;
            byte[] newPasswordNet;
            String sanitizedNewPassword;
            void newPasswordStr;
            boolean isNewPasswordSpecified;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$29, this, new Object[]{string, "*****", "*****", "*****", byArray2, l2, string4, n2, n3, byArray3});
            }
            this.lazyLoadO5LogonHelper();
            this.validateO5VerifierType();
            int[] encryptedPasswordLength = new int[1];
            byte[] o5logonpassword = new byte[256];
            for (int k2 = 0; k2 < 256; ++k2) {
                o5logonpassword[k2] = 0;
            }
            boolean bl2 = isNewPasswordSpecified = newPasswordStr != null;
            if (isNewPasswordSpecified) {
                sanitizedNewPassword = this.sanitizeInputCredential((String)newPasswordStr);
                newPasswordNet = this.meg.conv.StringToCharBytes(sanitizedNewPassword);
                encryptedNewPasswordLength = new int[1];
                o5logonnewpassword = new byte[256];
                for (int k3 = 0; k3 < 256; ++k3) {
                    o5logonnewpassword[k3] = 0;
                }
            } else {
                sanitizedNewPassword = null;
                newPasswordNet = null;
                encryptedNewPasswordLength = null;
                o5logonnewpassword = null;
            }
            int[] encryptedPkLength = new int[1];
            byte[] encryptedPkTemp = new byte[256];
            this.encryptedKB = new byte[this.encryptedSK.length];
            for (int k4 = 0; k4 < this.encryptedKB.length; ++k4) {
                this.encryptedKB[k4] = 1;
            }
            try {
                void passwordNet;
                void sanitizedPassword;
                void sanitizedUser;
                this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, (String)sanitizedUser, (String)sanitizedPassword, sanitizedNewPassword, (byte[])passwordNet, newPasswordNet, this.encryptedSK, this.encryptedKB, o5logonpassword, o5logonnewpassword, encryptedPasswordLength, encryptedNewPasswordLength, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, encryptedPkTemp, encryptedPkLength);
            }
            catch (Exception k4) {
                // empty catch block
            }
            byte[] password = new byte[encryptedPasswordLength[0]];
            System.arraycopy(o5logonpassword, 0, password, 0, encryptedPasswordLength[0]);
            if (isNewPasswordSpecified) {
                newPassword = new byte[encryptedNewPasswordLength[0]];
                System.arraycopy(o5logonnewpassword, 0, newPassword, 0, encryptedNewPasswordLength[0]);
            } else {
                newPassword = null;
            }
            if (this.verifierType == 18453 && this.connection.hasServerCompileTimeCapability(4, 32)) {
                encryptedPk = new byte[encryptedPkLength[0]];
                System.arraycopy(encryptedPkTemp, 0, encryptedPk, 0, encryptedPkLength[0]);
            } else {
                encryptedPk = null;
            }
            this.doOAUTH((byte[])user, password, newPassword, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, encryptedPk);
            this.validateO5ServerResponse();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompletionStage<Void> doOAUTHWithO5LogonAsync(String string, @Blind String string2, @Blind byte[] byArray, @Blind String string3, byte[] byArray2, long l2, String string4, int n2, int n3, byte[][] byArray3) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            byte[] encryptedPk;
            byte[] newPassword;
            byte[] o5logonnewpassword;
            int[] encryptedNewPasswordLength;
            byte[] newPasswordNet;
            String sanitizedNewPassword;
            void newPasswordStr;
            boolean isNewPasswordSpecified;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, new Object[]{string, "*****", "*****", "*****", byArray2, l2, string4, n2, n3, byArray3});
            }
            this.lazyLoadO5LogonHelper();
            try {
                this.validateO5VerifierType();
            }
            catch (SQLException validationFailure) {
                CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(validationFailure);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, null);
                }
                return completionStage;
            }
            int[] encryptedPasswordLength = new int[1];
            byte[] o5logonpassword = new byte[256];
            for (int k2 = 0; k2 < 256; ++k2) {
                o5logonpassword[k2] = 0;
            }
            boolean bl2 = isNewPasswordSpecified = newPasswordStr != null;
            if (isNewPasswordSpecified) {
                sanitizedNewPassword = this.sanitizeInputCredential((String)newPasswordStr);
                try {
                    newPasswordNet = this.meg.conv.StringToCharBytes(sanitizedNewPassword);
                }
                catch (SQLException encodingFailure) {
                    CompletionStage<Void> completionStage = CompletionStageUtil.failedStage(encodingFailure);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, completionStage);
                        ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, null);
                    }
                    return completionStage;
                }
                encryptedNewPasswordLength = new int[1];
                o5logonnewpassword = new byte[256];
                for (int k3 = 0; k3 < 256; ++k3) {
                    o5logonnewpassword[k3] = 0;
                }
            } else {
                sanitizedNewPassword = null;
                newPasswordNet = null;
                encryptedNewPasswordLength = null;
                o5logonnewpassword = null;
            }
            int[] encryptedPkLength = new int[1];
            byte[] encryptedPkTemp = new byte[256];
            this.encryptedKB = new byte[this.encryptedSK.length];
            for (int k4 = 0; k4 < this.encryptedKB.length; ++k4) {
                this.encryptedKB[k4] = 1;
            }
            try {
                void passwordNet;
                void sanitizedPassword;
                void sanitizedUser;
                this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, (String)sanitizedUser, (String)sanitizedPassword, sanitizedNewPassword, (byte[])passwordNet, newPasswordNet, this.encryptedSK, this.encryptedKB, o5logonpassword, o5logonnewpassword, encryptedPasswordLength, encryptedNewPasswordLength, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, encryptedPkTemp, encryptedPkLength);
            }
            catch (Exception k4) {
                // empty catch block
            }
            byte[] password = new byte[encryptedPasswordLength[0]];
            System.arraycopy(o5logonpassword, 0, password, 0, encryptedPasswordLength[0]);
            if (isNewPasswordSpecified) {
                newPassword = new byte[encryptedNewPasswordLength[0]];
                System.arraycopy(o5logonnewpassword, 0, newPassword, 0, encryptedNewPasswordLength[0]);
            } else {
                newPassword = null;
            }
            if (this.verifierType == 18453 && this.connection.hasServerCompileTimeCapability(4, 32)) {
                encryptedPk = new byte[encryptedPkLength[0]];
                System.arraycopy(encryptedPkTemp, 0, encryptedPk, 0, encryptedPkLength[0]);
            } else {
                encryptedPk = null;
            }
            CompletionStage<Void> completionStage = this.doOAUTHAsync((byte[])user, password, newPassword, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, encryptedPk).thenRun(() -> {
                boolean bl = (8L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$56, this, new Object[0]);
                    }
                    try {
                        this.validateO5ServerResponse();
                    }
                    catch (SQLException validationFailure) {
                        CompletionException completionException = new CompletionException(validationFailure);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$56, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$56, this, completionException);
                        }
                        throw completionException;
                    }
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$56, this);
                        ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$56, this, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$56, this, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void lazyLoadO5LogonHelper() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$31, this, new Object[0]);
            }
            if (this.o5logonHelper == null) {
                this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void validateO5VerifierType() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$32, this, new Object[0]);
            }
            if (this.verifierType != 2361 && this.verifierType != 40674 && this.verifierType != 59694 && this.verifierType != 45394 && this.verifierType != 6949 && this.verifierType != 18453) {
                if (bl) {
                    this.debug($$$loggerRef$$$32, Level.FINEST, $$$methodRef$$$32, "T4CTTIoauthenticate.marshalOauth: verifierType = " + this.verifierType);
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 451).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$32, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void validateO5ServerResponse() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$33, this, new Object[0]);
            }
            String b64SvrResponse = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
            try {
                this.lazyLoadO5LogonHelper();
                if (!this.o5logonHelper.validateServerIdentity(b64SvrResponse)) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$33, this, sQLException);
                    }
                    throw sQLException;
                }
                this.connection.net().setAuthSessionKey(this.o5logonHelper.getO5LogonKey());
            }
            catch (Exception e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$33, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doOAUTHWithO3Logon(String string, @Blind String string2, @Blind byte[] byArray, byte[] byArray2, long l2, String string3, int n2, int n3, byte[][] byArray3) throws SQLException, IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            void passwordNet;
            void sanitizedPassword;
            void sanitizedUser;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$34, this, new Object[]{string, "*****", "*****", byArray2, l2, string3, n2, n3, byArray3});
            }
            O3LoginClientHelper loginHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte, this.connection.thinUseJCEAPI);
            byte[] sessionKey = loginHelper.getSessionKey((String)sanitizedUser, (String)sanitizedPassword, this.encryptedSK);
            if (bl) {
                this.debug($$$loggerRef$$$34, Level.FINEST, $$$methodRef$$$34, "T4CTTIoauthenticate: sessionKey = " + T4CMAREngine.toHex(sessionKey));
            }
            byte[] paddedPwd = null;
            byte pwdPadLen = ((void)passwordNet).length % 8 > 0 ? (byte)((byte)(8 - ((void)passwordNet).length % 8)) : (byte)0;
            paddedPwd = new byte[((void)passwordNet).length + pwdPadLen];
            System.arraycopy(passwordNet, 0, paddedPwd, 0, ((void)passwordNet).length);
            byte[] ePwdOnSessKey = loginHelper.getEPasswd(sessionKey, paddedPwd);
            byte[] password = new byte[2 * paddedPwd.length + 1];
            if (password.length < 2 * ePwdOnSessKey.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$34, this, sQLException);
                }
                throw sQLException;
            }
            RepConversion.bArray2Nibbles(ePwdOnSessKey, password);
            password[password.length - 1] = RepConversion.nibbleToHex(pwdPadLen);
            this.doOAUTH((byte[])user, password, null, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, null);
            this.connection.net().setAuthSessionKey(sessionKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doOAUTHWithRadiusAuthentication(@Blind byte[] byArray, byte[] byArray2, long l2, String string, int n2, int n3, byte[][] byArray3) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            byte[] password;
            void passwordNet;
            boolean isTLSConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$35, this, new Object[]{"*****", byArray2, l2, string, n2, n3, byArray3});
            }
            if (isTLSConnection = this.connection.net().getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter) {
                password = passwordNet;
            } else {
                byte[] paddedPwd = null;
                int pwdPadLen = (((void)passwordNet).length + 1) % 8 > 0 ? (int)((byte)(8 - (((void)passwordNet).length + 1) % 8)) : 0;
                paddedPwd = new byte[((void)passwordNet).length + 1 + pwdPadLen];
                System.arraycopy(passwordNet, 0, paddedPwd, 0, ((void)passwordNet).length);
                byte[] opwd = AuthenticationService.obfuscatePasswordForRadius(paddedPwd);
                password = new byte[opwd.length * 2];
                for (int i2 = 0; i2 < opwd.length; ++i2) {
                    byte b1 = (byte)((opwd[i2] & 0xF0) >> 4);
                    byte b2 = (byte)(opwd[i2] & 0xF);
                    password[i2 * 2] = (byte)(b1 < 10 ? b1 + 48 : b1 - 10 + 97);
                    password[i2 * 2 + 1] = (byte)(b2 < 10 ? b2 + 48 : b2 - 10 + 97);
                }
            }
            this.doOAUTH((byte[])user, password, null, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, null);
            this.doKeyFoldinForRadius((byte[])passwordNet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doKeyFoldinForRadius(byte[] byArray) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$36, this, new Object[]{byArray});
            }
            try {
                if (!this.connection.net().getSessionAttributes().profile.useWeakCrypto() && (this.connection.net().getSessionAttributes().isEncryptionActive || this.connection.net().getSessionAttributes().isChecksumActive)) {
                    void pwd;
                    this.connection.net().setAuthSessionKey(MessageDigest.getInstance("MD5").digest((byte[])pwd));
                }
            }
            catch (Exception e2) {
                RuntimeException runtimeException = new RuntimeException("Unable to get foldin key for RADIUS");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$36, this, runtimeException);
                }
                throw runtimeException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompletionStage<Void> doOAUTHWithRadiusAuthenticationAsync(@Blind byte[] byArray, byte[] byArray2, long l2, String string, int n2, int n3, byte[][] byArray3) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            byte[] password;
            void passwordNet;
            boolean isTLSConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$37, this, new Object[]{"*****", byArray2, l2, string, n2, n3, byArray3});
            }
            if (isTLSConnection = this.connection.net().getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter) {
                password = passwordNet;
            } else {
                byte[] paddedPwd = null;
                int pwdPadLen = (((void)passwordNet).length + 1) % 8 > 0 ? (int)((byte)(8 - (((void)passwordNet).length + 1) % 8)) : 0;
                paddedPwd = new byte[((void)passwordNet).length + 1 + pwdPadLen];
                System.arraycopy(passwordNet, 0, paddedPwd, 0, ((void)passwordNet).length);
                byte[] opwd = AuthenticationService.obfuscatePasswordForRadius(paddedPwd);
                password = new byte[opwd.length * 2];
                for (int i2 = 0; i2 < opwd.length; ++i2) {
                    byte b1 = (byte)((opwd[i2] & 0xF0) >> 4);
                    byte b2 = (byte)(opwd[i2] & 0xF);
                    password[i2 * 2] = (byte)(b1 < 10 ? b1 + 48 : b1 - 10 + 97);
                    password[i2 * 2 + 1] = (byte)(b2 < 10 ? b2 + 48 : b2 - 10 + 97);
                }
            }
            CompletionStage<Void> completionStage = this.doOAUTHAsync((byte[])user, password, null, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, null).thenRun(() -> this.lambda$doOAUTHWithRadiusAuthenticationAsync$2((byte[])passwordNet));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$37, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$37, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doOAUTHWithoutUser(long l2, String string, int n2, int n3, byte[][] byArray) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$38, this, new Object[]{l2, string, n2, n3, byArray});
            }
            this.doOAUTHWithoutPassword(null, (long)logonMode, (String)authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompletionStage<Void> doOAUTHWithoutUserAsync(long l2, String string, int n2, int n3, byte[][] byArray) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$39, this, new Object[]{l2, string, n2, n3, byArray});
            }
            CompletionStage<Void> completionStage = this.doOAUTHWithoutPasswordAsync(null, (long)logonMode, (String)authenticationAdaptor, (int)gl_session_id, (int)gl_serial_nb, (byte[][])proxyRoles);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$39, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$39, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doOAUTHWithoutPassword(byte[] byArray, long l2, String string, int n2, int n3, byte[][] byArray2) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$40, this, new Object[]{byArray, l2, string, n2, n3, byArray2});
            }
            this.doOAUTH((byte[])user, null, null, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$40, this);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$40, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompletionStage<Void> doOAUTHWithoutPasswordAsync(byte[] byArray, long l2, String string, int n2, int n3, byte[][] byArray2) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void authenticationAdaptor;
            void logonMode;
            void user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$41, this, new Object[]{byArray, l2, string, n2, n3, byArray2});
            }
            CompletionStage<Void> completionStage = this.doOAUTHAsync((byte[])user, null, null, (long)logonMode, (String)authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$41, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$41, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAUTH(int n2, @Blind(value=PropertiesBlinder.class) Properties properties, int n3, int n4) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void gl_serial_nb;
            void gl_session_id;
            void type;
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$42, this, n2, TraceControllerImpl.blind(PropertiesBlinder.class, properties), n3, n4);
            }
            byte[] dn = null;
            byte[] certificate = null;
            byte[][] roles = null;
            byte[] proxyClientUser = null;
            if (prop.containsKey("PROXY_ROLES")) {
                String[] strRoles = (String[])prop.get("PROXY_ROLES");
                roles = new byte[strRoles.length][];
                for (int i2 = 0; i2 < strRoles.length; ++i2) {
                    roles[i2] = this.meg.conv.StringToCharBytes(strRoles[i2]);
                }
            }
            if (type == true) {
                String _userStr = prop.getProperty("PROXY_USER_NAME");
                String _passwd = prop.getProperty("PROXY_USER_PASSWORD");
                if (_passwd != null && _passwd.length() != 0) {
                    this.doOAUTH(_userStr, _passwd, null, 0L, (int)gl_session_id, (int)gl_serial_nb, roles);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$42, this);
                        ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$42, this, null);
                    }
                    return;
                }
                proxyClientUser = this.meg.conv.StringToCharBytes(_userStr);
            } else if (type == 2) {
                String _dnStr = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                dn = this.meg.conv.StringToCharBytes(_dnStr);
            } else {
                try {
                    certificate = (byte[])prop.get("PROXY_CERTIFICATE");
                    StringBuffer sb = new StringBuffer();
                    for (int i3 = 0; i3 < certificate.length; ++i3) {
                        String str = Integer.toHexString(0xFF & certificate[i3]);
                        int length = str.length();
                        if (length == 0) {
                            sb.append("00");
                            continue;
                        }
                        if (length == 1) {
                            sb.append('0');
                            sb.append(str);
                            continue;
                        }
                        sb.append(str);
                    }
                    certificate = this.meg.conv.StringToCharBytes(sb.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.doOAUTH(proxyClientUser, null, null, 0L, null, true, dn, certificate, roles, (int)gl_session_id, (int)gl_serial_nb, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final void doOAUTH(@Blind AccessToken accessToken, long l2) throws SQLException, IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void accessToken2;
            void logonMode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, "*****", l2);
            }
            if (logonMode != 0L) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "internal_logon and prelim_auth are not supported with token-based authentication").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, sQLException);
                }
                throw sQLException;
            }
            if (!this.connection.isTLSEnabled()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "TLS (ie: TCPS) must be enabled for token-based authentication").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, sQLException);
                }
                throw sQLException;
            }
            if (!this.connection.isDnMatchingEnabled()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Distinguished Name (DN) matching must be enabled for token-based authentication").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, sQLException);
                }
                throw sQLException;
            }
            if (!(accessToken2 instanceof OpaqueAccessToken)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Unsupported AccessToken type: " + accessToken2.getClass() + ". Only instances created by oracle.jdbc.AccessToken are supported").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, sQLException);
                }
                throw sQLException;
            }
            OpaqueAccessToken opaqueAccessToken = (OpaqueAccessToken)accessToken2;
            if (opaqueAccessToken.expiration().isBefore(OffsetDateTime.now())) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 25708, opaqueAccessToken.expiration()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, sQLException);
                }
                throw sQLException;
            }
            this.connection.suspendLogging();
            try {
                this.prepareForOAUTH(null, null, null, (long)logonMode, null, false, null, null, null, -1, -1, null);
                this.setTokenKeyValsForOAUTH(opaqueAccessToken);
                try {
                    this.doRPC();
                    this.keyValList = null;
                    this.meg.clearWriteBuffer();
                }
                catch (Throwable throwable) {
                    this.keyValList = null;
                    this.meg.clearWriteBuffer();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable) {
                this.connection.resumeLogging();
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, throwable3);
                }
                throw throwable3;
            }
            this.connection.resumeLogging();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$43, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void setTokenKeyValsForOAUTH(OpaqueAccessToken opaqueAccessToken) throws SQLException, IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void accessToken;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this, opaqueAccessToken);
            }
            char[] token = accessToken.token().getChars();
            try {
                this.keyValList.add(AUTH_TOKEN, this.meg.conv.javaCharsToCHARBytes(token));
            }
            catch (Throwable throwable) {
                Arrays.fill(token, '\u0000');
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this, throwable2);
                }
                throw throwable2;
            }
            Arrays.fill(token, '\u0000');
            OpaquePrivateKey signingKey = accessToken.privateKey();
            if (signingKey != null) {
                try {
                    byte[] header = this.meg.conv.StringToCharBytes(this.generateTokenHeader());
                    byte[] signedHeader = signingKey.map(privateKey -> {
                        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
                        try {
                            byte[] header;
                            void key;
                            if (bl) {
                                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$54, null, header, privateKey);
                            }
                            Signature signature = Signature.getInstance("SHA256withRSA");
                            signature.initSign((PrivateKey)key);
                            signature.update(header);
                            byte[] byArray2 = signature.sign();
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$54, null, byArray2);
                                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$54, null, null);
                            }
                            return byArray2;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (bl) {
                                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$54, null, throwable2);
                            }
                            throw throwable;
                        }
                    });
                    try {
                        this.keyValList.add(AUTH_HEADER, header);
                        this.keyValList.add(AUTH_SIGNATURE, this.meg.conv.StringToCharBytes(Base64.getEncoder().encodeToString(signedHeader)));
                    }
                    catch (Throwable throwable) {
                        Arrays.fill(signedHeader, (byte)0);
                        Throwable throwable3 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this, throwable3);
                        }
                        throw throwable3;
                    }
                    Arrays.fill(signedHeader, (byte)0);
                }
                catch (GeneralSecurityException signingFailure) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Failed to generate a signature using private key. See cause for more details.", (Throwable)signingFailure).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$44, this, throwable4);
            }
            throw throwable;
        }
    }

    @Blind
    private String generateTokenHeader() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            SocketAddress socketAddress;
            String serviceName;
            SessionAtts sessionAtts;
            ConnOption connOption;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, new Object[0]);
            }
            if ((connOption = (sessionAtts = this.meg.net.getSessionAttributes()).getcOption()) == null) {
                SQLException sQLException = this.tokenHeaderFailure();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            String string = serviceName = connOption.service_name != null ? connOption.service_name : connOption.getOriginalConnOption().service_name;
            if (serviceName == null) {
                SQLException sQLException = this.tokenHeaderFailure();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            SocketChannel socketChannel = sessionAtts.getNTAdapter().getSocketChannel();
            if (socketChannel == null) {
                SQLException sQLException = this.tokenHeaderFailure();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            try {
                socketAddress = socketChannel.getRemoteAddress();
            }
            catch (IOException ioException) {
                SQLException sQLException = this.tokenHeaderFailure();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            if (!(socketAddress instanceof InetSocketAddress)) {
                SQLException sQLException = this.tokenHeaderFailure();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress == null) {
                SQLException sQLException = this.tokenHeaderFailure();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            String string2 = String.format("date: %s\n(request-target): %s\nhost: %s:%d", ZonedDateTime.now(ZoneOffset.UTC).format(AUTH_HEADER_DATE_FORMATTER), serviceName, inetAddress.getHostAddress(), inetSocketAddress.getPort());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, "*****");
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    private SQLException tokenHeaderFailure() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$46, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1718, "Failed to generate a header message for proof of possesion").fillInStackTrace();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$46, this, sQLException);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$46, this, null);
            }
            return sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSessionFields(T4CConnection t4CConnection) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$47, this, t4CConnection);
            }
            String terminalStr = this.connection.thinVsessionTerminal;
            String machineStr = this.connection.thinVsessionMachine;
            String osuserStr = this.connection.thinVsessionOsuser;
            String programStr = this.connection.thinVsessionProgram;
            String processStr = this.connection.thinVsessionProcess;
            String internalNameStr = this.connection.thinVsessionIname;
            Object externalNameStr = this.connection.thinVsessionEname;
            String clientNameStr = this.connection.proxyClientName;
            Object driverNameStr = this.connection.driverNameAttribute;
            String editionStr = this.connection.editionName;
            byte[] byArray = this.enableTempLobRefCnt = this.connection.enableTempLobRefCnt ? this.meg.conv.StringToCharBytes(Integer.toString(1)) : this.meg.conv.StringToCharBytes(Integer.toString(0));
            if (machineStr == null) {
                try {
                    machineStr = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception e2) {
                    machineStr = "jdbcclient";
                }
            }
            if (externalNameStr == null) {
                externalNameStr = "jdbc_" + this.ressourceManagerId;
            }
            if (driverNameStr == null) {
                driverNameStr = "jdbcthin : " + BuildInfo.getDriverVersion();
            }
            this.terminal = this.meg.conv.StringToCharBytes(terminalStr);
            this.machine = this.meg.conv.StringToCharBytes(machineStr);
            this.sysUserName = this.meg.conv.StringToCharBytes(osuserStr);
            this.programName = this.meg.conv.StringToCharBytes(programStr);
            this.processID = this.meg.conv.StringToCharBytes(processStr);
            this.internalName = this.meg.conv.StringToCharBytes(internalNameStr);
            this.externalName = this.meg.conv.StringToCharBytes((String)externalNameStr);
            if (clientNameStr != null) {
                this.clientname = this.meg.conv.StringToCharBytes(clientNameStr);
            }
            if (editionStr != null) {
                this.editionName = this.meg.conv.StringToCharBytes(editionStr);
            }
            this.driverName = this.meg.conv.StringToCharBytes((String)driverNameStr);
            TimeZone tz = TimeZone.getDefault();
            Object defaultTimeZone = tz.getID();
            if (!ZONEIDMAP.isValidRegion((String)defaultTimeZone) || !conn.timezoneAsRegion) {
                int tzOffset = tz.getOffset(System.currentTimeMillis());
                int hr = tzOffset / 3600000;
                int mi = Math.abs(tzOffset / 60000 % 60);
                defaultTimeZone = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
            }
            this.sessionTimeZone = defaultTimeZone;
            conn.sessionTimeZone = defaultTimeZone;
            String nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault(Locale.Category.FORMAT));
            String alterNLSLanguage = null;
            if (nlslanguage != null) {
                alterNLSLanguage = " NLS_LANGUAGE='" + nlslanguage + "' ";
            }
            String nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault(Locale.Category.FORMAT));
            String alterNLSTerritory = null;
            if (nlsterritory != null) {
                alterNLSTerritory = " NLS_TERRITORY='" + nlsterritory + "' ";
            }
            if (alterNLSLanguage != null || alterNLSTerritory != null || this.isSessionTZ) {
                String doAlter = "ALTER SESSION SET " + (String)(this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + (String)(alterNLSLanguage != null ? alterNLSLanguage : "") + (String)(alterNLSTerritory != null ? alterNLSTerritory : "");
                if (bl) {
                    this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: alter session = " + doAlter);
                }
                this.alterSession = this.meg.conv.StringToCharBytes(doAlter);
                this.alterSession[this.alterSession.length - 1] = 0;
            }
            this.aclValue = this.meg.conv.StringToCharBytes("4400");
            if (bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: terminalStr = " + terminalStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: machineStr = " + machineStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: osuserStr = " + osuserStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: programStr = " + programStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: processStr = " + processStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$47, Level.FINEST, $$$methodRef$$$47, "T4CTTIoauthenticate.setSessionFields: PrxyClientStr = " + clientNameStr);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String removeQuotes(@Blind String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String result;
            int i2;
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$48, this, "*****");
            }
            int first = 0;
            int last = str.length() - 1;
            for (i2 = 0; i2 < str.length(); ++i2) {
                if (str.charAt(i2) == '\"') continue;
                first = i2;
                break;
            }
            for (i2 = str.length() - 1; i2 >= 0; --i2) {
                if (str.charAt(i2) == '\"') continue;
                last = i2;
                break;
            }
            String string2 = result = str.substring(first, last + 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$48, this, string2);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$48, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int versionStringToInt(String string) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void driverVersion;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$49, this, string);
            }
            String[] versionElements = driverVersion.split("\\.");
            int versionNumber = Integer.parseInt(versionElements[0].replaceAll("\\D", "")) & 0xFF;
            int releaseUpdate = Integer.parseInt(versionElements[1].replaceAll("\\D", "")) & 0xFF;
            int releaseUpdateRevision = Integer.parseInt(versionElements[2].replaceAll("\\D", "")) & 0xF;
            int increment = Integer.parseInt(versionElements[3].replaceAll("\\D", "")) & 0xFF;
            int extension = Integer.parseInt(versionElements[4].replaceAll("\\D", "")) & 0xF;
            int numericVersion = 0;
            numericVersion = this.connection.getTTCVersion() >= 10 ? versionNumber << 24 | releaseUpdate << 16 | releaseUpdateRevision << 12 | increment << 4 | extension : versionNumber << 24 | releaseUpdate << 20 | releaseUpdateRevision << 12 | increment << 4 | extension;
            int n2 = numericVersion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$49, this, n2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$49, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String versionIntToString(int n2) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String version;
            void versionInt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$50, this, n2);
            }
            if (this.connection.getTTCVersion() >= 10) {
                int versionNumber = (versionInt & 0xFF000000) >> 24 & 0xFF;
                int releaseUpdate = (versionInt & 0xFF0000) >> 16 & 0xFF;
                int releaseUpdateRevision = (versionInt & 0xF000) >> 12 & 0xF;
                int increment = (versionInt & 0xFF0) >> 4 & 0xFF;
                int extension = versionInt & 0xF;
                version = versionNumber + "." + releaseUpdate + "." + releaseUpdateRevision + "." + increment + "." + extension;
            } else {
                int versionNumber = (versionInt & 0xFF000000) >> 24 & 0xFF;
                int releaseNumber = (versionInt & 0xF00000) >> 20 & 0xF;
                int updateNumber = (versionInt & 0xFF000) >> 12 & 0xFF;
                int portingReleaseNumber = (versionInt & 0xF00) >> 8 & 0xF;
                int portingUpdateNumber = versionInt & 0xFF;
                version = versionNumber + "." + releaseNumber + "." + updateNumber + "." + portingReleaseNumber + "." + portingUpdateNumber;
            }
            String string = version;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$50, this, string);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$50, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    private String getKPPLPurity() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$51, this, new Object[0]);
            }
            for (String[] purity : KPPL_PURITY) {
                if (!this.connection.drcpConnectionPurity.equalsIgnoreCase(purity[0])) continue;
                String string = purity[1];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$51, this, string);
                    ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$51, this, null);
                }
                return string;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 297).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$51, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$51, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$52, this, new Object[0]);
            }
            T4CConnection t4CConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$52, this, t4CConnection);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$52, this, null);
            }
            return t4CConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getDerivedKeyJdbc(byte[] byArray, int n2) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void dhKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$53, this, byArray, n2);
            }
            int mode = this.verifierType == 2361 ? (mode |= 1) : (mode |= 0);
            if (this.o5logonHelper == null) {
                this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
            }
            byte[] byArray2 = this.o5logonHelper.getDerivedKey((byte[])dhKey, mode);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$53, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$53, this, null);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$doOAUTHWithRadiusAuthenticationAsync$2(byte[] byArray) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void passwordNet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$55, this, new Object[]{byArray});
            }
            this.doKeyFoldinForRadius((byte[])passwordNet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$55, this);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$55, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$58 = T4CTTIoauthenticate.class.getDeclaredConstructor(T4CConnection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = T4CTTIoauthenticate.class.getDeclaredMethod("lambda$doOAUTHAsync$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = T4CTTIoauthenticate.class.getDeclaredMethod("lambda$doOAUTHWithO5LogonAsync$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = T4CTTIoauthenticate.class.getDeclaredMethod("lambda$doOAUTHWithRadiusAuthenticationAsync$2", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = T4CTTIoauthenticate.class.getDeclaredMethod("lambda$setTokenKeyValsForOAUTH$3", byte[].class, PrivateKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = T4CTTIoauthenticate.class.getDeclaredMethod("getDerivedKeyJdbc", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = T4CTTIoauthenticate.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = T4CTTIoauthenticate.class.getDeclaredMethod("getKPPLPurity", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = T4CTTIoauthenticate.class.getDeclaredMethod("versionIntToString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = T4CTTIoauthenticate.class.getDeclaredMethod("versionStringToInt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = T4CTTIoauthenticate.class.getDeclaredMethod("removeQuotes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = T4CTTIoauthenticate.class.getDeclaredMethod("setSessionFields", T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = T4CTTIoauthenticate.class.getDeclaredMethod("tokenHeaderFailure", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = T4CTTIoauthenticate.class.getDeclaredMethod("generateTokenHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = T4CTTIoauthenticate.class.getDeclaredMethod("setTokenKeyValsForOAUTH", OpaqueAccessToken.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", AccessToken.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", Integer.TYPE, Properties.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithoutPasswordAsync", byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithoutPassword", byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithoutUserAsync", Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithoutUser", Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithRadiusAuthenticationAsync", byte[].class, byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T4CTTIoauthenticate.class.getDeclaredMethod("doKeyFoldinForRadius", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithRadiusAuthentication", byte[].class, byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithO3Logon", String.class, String.class, byte[].class, byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T4CTTIoauthenticate.class.getDeclaredMethod("validateO5ServerResponse", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CTTIoauthenticate.class.getDeclaredMethod("validateO5VerifierType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CTTIoauthenticate.class.getDeclaredMethod("lazyLoadO5LogonHelper", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithO5LogonAsync", String.class, String.class, byte[].class, String.class, byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHWithO5Logon", String.class, String.class, byte[].class, String.class, byte[].class, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CTTIoauthenticate.class.getDeclaredMethod("sanitizeInputCredential", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CTTIoauthenticate.class.getDeclaredMethod("validateKeySizeForOAUTH", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHAsync", String.class, String.class, String.class, Long.TYPE, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", String.class, String.class, String.class, Long.TYPE, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHAsync", String.class, String.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", String.class, String.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CTTIoauthenticate.class.getDeclaredMethod("processRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CTTIoauthenticate.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CTTIoauthenticate.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CTTIoauthenticate.class.getDeclaredMethod("initializeForOSESSKEY", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CTTIoauthenticate.class.getDeclaredMethod("doOSESSKEYAsync", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CTTIoauthenticate.class.getDeclaredMethod("doOSESSKEY", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CTTIoauthenticate.class.getDeclaredMethod("resetStateBeforeCall", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CTTIoauthenticate.class.getDeclaredMethod("setResultSetCacheKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CTTIoauthenticate.class.getDeclaredMethod("setDRCPKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIoauthenticate.class.getDeclaredMethod("setSessionIdentityKeyValsForOAUTH", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIoauthenticate.class.getDeclaredMethod("setAlterSessionKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIoauthenticate.class.getDeclaredMethod("setMiscellaneousKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIoauthenticate.class.getDeclaredMethod("setDriverIdentityKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIoauthenticate.class.getDeclaredMethod("setInternalNameKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIoauthenticate.class.getDeclaredMethod("setVSessionKeyValsForOAUTH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIoauthenticate.class.getDeclaredMethod("setProxyLogonKeyValsForOAUTH", byte[].class, byte[].class, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoauthenticate.class.getDeclaredMethod("setPasswordKeyValsForOAUTH", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoauthenticate.class.getDeclaredMethod("initializeForOAUTHWithNewPassword", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoauthenticate.class.getDeclaredMethod("initializeLogonModeForOAUTH", byte[].class, Long.TYPE, byte[].class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoauthenticate.class.getDeclaredMethod("prepareForOAUTH", byte[].class, byte[].class, byte[].class, Long.TYPE, String.class, Boolean.TYPE, byte[].class, byte[].class, byte[][].class, Integer.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTHAsync", byte[].class, byte[].class, byte[].class, Long.TYPE, String.class, Boolean.TYPE, byte[].class, byte[].class, byte[][].class, Integer.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", byte[].class, byte[].class, byte[].class, Long.TYPE, String.class, Boolean.TYPE, byte[].class, byte[].class, byte[][].class, Integer.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoauthenticate.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        KPPL_PURITY = new String[][]{{SESS_PURITY_DEFAULT, KPPL_PURITY_DEFAULT}, {SESS_PURITY_NEW, KPPL_PURITY_NEW}, {SESS_PURITY_SELF, KPPL_PURITY_SELF}};
        AUTH_HEADER_DATE_FORMATTER = DateTimeFormatter.ofPattern("E, dd MMM uuuu HH:mm:ss 'GMT'", Locale.US);
    }
}

