/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OraclePooledConnection
implements oracle.jdbc.datasource.OraclePooledConnection,
Serializable,
Monitor {
    static final long serialVersionUID = -203725628718322873L;
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String isClearMetaData = "stmt_cache_clear_metadata";
    public static final String ImplicitStatementCachingEnabled = "ImplicitStatementCachingEnabled";
    public static final String ExplicitStatementCachingEnabled = "ExplicitStatementCachingEnabled";
    public static final String LoginTimeout = "LoginTimeout";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    private Hashtable eventListeners;
    private SQLException sqlException;
    protected boolean autoCommit;
    protected transient OracleConnection logicalHandle;
    protected transient OracleConnection physicalConn;
    protected transient OracleConnection replayConn;
    private Hashtable connectionProperty;
    public int closeOption;
    private OracleCloseCallback closeCallback;
    private Object privateData;
    protected transient OracleDriver oracleDriver;
    boolean localTxnCommitOnClose;
    private final Monitor.CloseableLock monitorLock;
    public static final String NO_IMPLICIT_BEGIN_REQUEST_PROPERTY = "oracle.jdbc.noImplicitBeginRequest";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;

    public OraclePooledConnection() {
        this((Connection)null);
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, null);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(String url) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, null, url);
            }
            this.eventListeners = null;
            this.sqlException = null;
            this.autoCommit = true;
            this.logicalHandle = null;
            this.physicalConn = null;
            this.replayConn = null;
            this.connectionProperty = null;
            this.closeOption = 0;
            this.closeCallback = null;
            this.privateData = null;
            this.oracleDriver = new OracleDriver();
            this.localTxnCommitOnClose = false;
            this.monitorLock = this.newDefaultLock();
            Connection conn = this.oracleDriver.connect(url, new Properties());
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, null, sQLException);
                }
                throw sQLException;
            }
            this.initialize(conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, null);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(String url, String user, @Blind String passwd) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, null, url, user, "*****");
            }
            this.eventListeners = null;
            this.sqlException = null;
            this.autoCommit = true;
            this.logicalHandle = null;
            this.physicalConn = null;
            this.replayConn = null;
            this.connectionProperty = null;
            this.closeOption = 0;
            this.closeCallback = null;
            this.privateData = null;
            this.oracleDriver = new OracleDriver();
            this.localTxnCommitOnClose = false;
            this.monitorLock = this.newDefaultLock();
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            Connection conn = this.oracleDriver.connect(url, props);
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, null, sQLException);
                }
                throw sQLException;
            }
            this.initialize(conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, null);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(Connection pc) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, null, pc);
            }
            this.eventListeners = null;
            this.sqlException = null;
            this.autoCommit = true;
            this.logicalHandle = null;
            this.physicalConn = null;
            this.replayConn = null;
            this.connectionProperty = null;
            this.closeOption = 0;
            this.closeCallback = null;
            this.privateData = null;
            this.oracleDriver = new OracleDriver();
            this.localTxnCommitOnClose = false;
            this.monitorLock = this.newDefaultLock();
            this.initialize(pc);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, null);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(Connection pc, boolean ac2) {
        this(pc);
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, null, pc, ac2);
            }
            this.autoCommit = ac2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, null);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(Connection connection) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this, connection);
            }
            this.physicalConn = (OracleConnection)pc;
            this.eventListeners = new Hashtable(10);
            this.closeCallback = null;
            this.privateData = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, connectionEventListener);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                if (this.eventListeners == null) {
                    this.sqlException = new SQLException("Listener Hashtable Null");
                } else {
                    void cel;
                    this.eventListeners.put(cel, cel);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                if (this.closeCallback != null) {
                    this.closeCallback.beforeClose(this.physicalConn, this.privateData);
                }
                if (this.physicalConn != null) {
                    block17: {
                        try {
                            this.physicalConn.close();
                        }
                        catch (SQLException ea) {
                            if (!bl) break block17;
                            this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OraclePooledConnection.close():" + this.physicalConn + ": Error while closing the connection " + ea.getMessage());
                        }
                    }
                    this.physicalConn = null;
                }
                if (this.closeCallback != null) {
                    this.closeCallback.afterClose(this.privateData);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            block18: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, new Object[0]);
                }
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    if (this.physicalConn == null) {
                        this.sqlException = new SQLException("Physical Connection doesn't exist");
                        this.callListener(102);
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, sQLException);
                        }
                        throw sQLException;
                    }
                    try {
                        if (this.logicalHandle != null) {
                            this.logicalHandle.closeInternal(false);
                        }
                        OracleConnection pconn = this.replayConn != null ? this.replayConn : this.physicalConn;
                        this.logicalHandle = (OracleConnection)pconn.getLogicalConnection(this, this.autoCommit);
                        String propVal = OraclePooledConnection.getSystemProperty(NO_IMPLICIT_BEGIN_REQUEST_PROPERTY, "false");
                        if (propVal.equalsIgnoreCase("false") && !pconn.isDRCPEnabled()) {
                            pconn.beginRequest();
                        }
                    }
                    catch (SQLException se) {
                        this.sqlException = se;
                        this.callListener(102);
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(8, "OraclePooledConnection.getConnection() - SQLException Ocurred:" + se.getMessage()).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, sQLException);
                        }
                        throw sQLException;
                    }
                    OracleConnection oracleConnection2 = this.logicalHandle;
                    if (lock != null) {
                        lock.close();
                    }
                    oracleConnection = oracleConnection2;
                    if (!bl) break block18;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getSystemProperty(String string, String string2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultValue;
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, string, string2);
            }
            if (str != null) {
                final String fstr = str;
                void fdefaultValue = defaultValue;
                final String[] rets = new String[]{defaultValue};
                AccessController.doPrivileged(new PrivilegedAction((String)fdefaultValue){
                    final /* synthetic */ String val$fdefaultValue;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    {
                        this.val$fdefaultValue = string2;
                    }

                    public Object run() {
                        rets[0] = System.getProperty(fstr, this.val$fdefaultValue);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(String[].class, String.class, String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                String string3 = rets[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, string3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, null);
                }
                return string3;
            }
            void var6_7 = defaultValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, var6_7);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, null);
            }
            return var6_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getLogicalHandle() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.logicalHandle;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public Connection getPhysicalHandle() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, new Object[0]);
            }
            OracleConnection oracleConnection2 = oracleConnection = this.replayConn != null ? this.replayConn : this.physicalConn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, null);
            }
            return oracleConnection2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public void setLastAccessedTime(long l2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this, l2);
            }
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this, unsupportedOperationException);
            }
            throw unsupportedOperationException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public long getLastAccessedTime() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, new Object[0]);
            }
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, unsupportedOperationException);
            }
            throw unsupportedOperationException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public void registerImplicitCacheConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this, connectionEventListener);
            }
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this, unsupportedOperationException);
            }
            throw unsupportedOperationException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, oracleCloseCallback, object);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void privData;
                void occ;
                this.closeCallback = occ;
                this.privateData = privData;
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, connectionEventListener);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                if (this.eventListeners == null) {
                    this.sqlException = new SQLException("Listener Hashtable Null");
                } else {
                    void cel;
                    this.eventListeners.remove(cel);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, throwable4);
            }
            throw throwable;
        }
    }

    public void logicalClose() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.logicalClose(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logicalClose(boolean bl) {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void isUsable;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this, bl);
            }
            this.callListener(isUsable != false ? 101 : 102);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callListener(int n2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void callcode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$14, Level.FINEST, $$$methodRef$$$14, "OraclePooledConnection.callListener(" + (int)callcode + "): eventListeners=" + this.eventListeners);
            }
            if (this.eventListeners == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, null);
                }
                return;
            }
            Enumeration listeners = this.eventListeners.keys();
            ConnectionEvent ce = new ConnectionEvent(this, this.sqlException);
            while (listeners.hasMoreElements()) {
                ConnectionEventListener listKey = (ConnectionEventListener)listeners.nextElement();
                ConnectionEventListener cev = (ConnectionEventListener)this.eventListeners.get(listKey);
                if (callcode == 101) {
                    cev.connectionClosed(ce);
                    continue;
                }
                if (callcode != 102) continue;
                cev.connectionErrorOccurred(ce);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setStmtCacheSize(int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, n2);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void size;
                this.setStmtCacheSize((int)size, false);
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, n2, bl);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                void size;
                if (size < 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, sQLException);
                    }
                    throw sQLException;
                }
                if (this.physicalConn != null) {
                    void clearMetaData;
                    this.physicalConn.setStmtCacheSize((int)size, (boolean)clearMetaData);
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, throwable3);
                }
                throw throwable3;
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, throwable4);
            }
            throw throwable;
        }
    }

    public int getStmtCacheSize() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block15: {
                Monitor.CloseableLock lock;
                block13: {
                    int n3;
                    block14: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, new Object[0]);
                        }
                        lock = this.acquireCloseableLock();
                        try {
                            if (this.physicalConn == null) break block13;
                            int n4 = this.physicalConn.getStmtCacheSize();
                            if (lock != null) {
                                lock.close();
                            }
                            n3 = n4;
                            if (!bl) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            Throwable throwable3 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, throwable3);
                            }
                            throw throwable3;
                        }
                        ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, null);
                    }
                    return n3;
                }
                int n5 = 0;
                if (lock != null) {
                    lock.close();
                }
                n2 = n5;
                if (!bl) break block15;
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, n2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatementCacheSize(int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, n2);
            }
            if (this.physicalConn != null) {
                void size;
                this.physicalConn.setStatementCacheSize((int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$19, Level.FINEST, $$$methodRef$$$19, "OraclePooledConnection.getStatementCacheSize(): physicalConn=" + this.physicalConn);
            }
            if (this.physicalConn != null) {
                int n2 = this.physicalConn.getStatementCacheSize();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, null);
                }
                return n2;
            }
            int n3 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, n3);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this, bl);
            }
            if (bl2) {
                this.debug($$$loggerRef$$$20, Level.FINEST, $$$methodRef$$$20, "OraclePooledConnection.setImplicitCachingEnabled(" + (boolean)cache + "): physicalConn=" + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.setImplicitCachingEnabled((boolean)cache);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$21, Level.FINEST, $$$methodRef$$$21, "OraclePooledConnection.getImplicitCachingEnabled(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                boolean bl2 = this.physicalConn.getImplicitCachingEnabled();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this, bl);
            }
            if (bl2) {
                this.debug($$$loggerRef$$$22, Level.FINEST, $$$methodRef$$$22, "OraclePooledConnection.setExplicitCachingEnabled(" + (boolean)cache + ") : physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.setExplicitCachingEnabled((boolean)cache);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$23, Level.FINEST, $$$methodRef$$$23, "OraclePooledConnection.getExplicitCachingEnabled(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                boolean bl2 = this.physicalConn.getExplicitCachingEnabled();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$24, Level.FINEST, $$$methodRef$$$24, "OraclePooledConnection.purgeImplicitCache(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.purgeImplicitCache();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$25, Level.FINEST, $$$methodRef$$$25, "OraclePooledConnection.purgeExplicitCache(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.purgeExplicitCache();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, string);
            }
            if (bl) {
                this.debug($$$loggerRef$$$26, Level.FINEST, $$$methodRef$$$26, "OraclePooledConnection.getStatementWithKey(key): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                void key;
                PreparedStatement preparedStatement = this.physicalConn.getStatementWithKey((String)key);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, preparedStatement);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, null);
                }
                return preparedStatement;
            }
            PreparedStatement preparedStatement = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, preparedStatement);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CallableStatement getCallWithKey(String string) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, string);
            }
            if (bl) {
                this.debug($$$loggerRef$$$27, Level.FINEST, $$$methodRef$$$27, "OraclePooledConnection.getCallWithKey(key): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                void key;
                CallableStatement callableStatement = this.physicalConn.getCallWithKey((String)key);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, callableStatement);
                    ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, null);
                }
                return callableStatement;
            }
            CallableStatement callableStatement = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, callableStatement);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isStatementCacheInitialized() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, new Object[0]);
            }
            if (this.physicalConn != null) {
                boolean bl2 = this.physicalConn.isStatementCacheInitialized();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setProperties(Hashtable hashtable) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, hashtable);
            }
            this.connectionProperty = prop;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block11: {
                void out;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this, objectOutputStream);
                }
                out.defaultWriteObject();
                try {
                    this.physicalConn.getPropertyForPooledConnection(this);
                    if (this.eventListeners != null) {
                        this.connectionProperty.put(event_listener_string, this.eventListeners);
                    }
                    if (this.sqlException != null) {
                        this.connectionProperty.put(sql_exception_string, this.sqlException);
                    }
                    this.connectionProperty.put(pool_auto_commit_string, "" + this.autoCommit);
                    if (this.closeCallback != null) {
                        this.connectionProperty.put(close_callback_string, this.closeCallback);
                    }
                    if (this.privateData != null) {
                        this.connectionProperty.put(private_data, this.privateData);
                    }
                    out.writeObject(this.connectionProperty);
                    this.physicalConn.close();
                }
                catch (SQLException ea) {
                    if (!bl) break block11;
                    this.debug($$$loggerRef$$$31, Level.FINEST, $$$methodRef$$$31, "OraclePooledConnection : writeObject(ObjectInputStream) - Exception Occurred :" + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block13: {
                void in;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this, objectInputStream);
                }
                in.defaultReadObject();
                this.connectionProperty = (Hashtable)in.readObject();
                try {
                    Properties prop = (Properties)this.connectionProperty.get(connection_properties_string);
                    String l_url = prop.getProperty(url_string);
                    this.oracleDriver = new OracleDriver();
                    Connection conn = this.oracleDriver.connect(l_url, prop);
                    this.initialize(conn);
                    this.eventListeners = (Hashtable)this.connectionProperty.get(event_listener_string);
                    this.sqlException = (SQLException)this.connectionProperty.get(sql_exception_string);
                    this.autoCommit = ((String)this.connectionProperty.get(pool_auto_commit_string)).equals("true");
                    this.closeCallback = (OracleCloseCallback)this.connectionProperty.get(close_callback_string);
                    this.privateData = this.connectionProperty.get(private_data);
                    Map l_map = (Map)this.connectionProperty.get(object_type_map);
                    if (l_map != null) {
                        ((OracleConnection)conn).setTypeMap(l_map);
                    }
                    String l_tmp = prop.getProperty(transaction_isolation);
                    conn.setTransactionIsolation(Integer.parseInt(l_tmp));
                    l_tmp = prop.getProperty(statement_cache_size);
                    int l_statementCacheSize = Integer.parseInt(l_tmp);
                    if (l_statementCacheSize != -1) {
                        this.setStatementCacheSize(l_statementCacheSize);
                        l_tmp = prop.getProperty(implicit_caching_enabled);
                        if (l_tmp != null && l_tmp.equalsIgnoreCase("true")) {
                            this.setImplicitCachingEnabled(true);
                        } else {
                            this.setImplicitCachingEnabled(false);
                        }
                        l_tmp = prop.getProperty(explicit_caching_enabled);
                        if (l_tmp != null && l_tmp.equalsIgnoreCase("true")) {
                            this.setExplicitCachingEnabled(true);
                        } else {
                            this.setExplicitCachingEnabled(false);
                        }
                    }
                    this.physicalConn.setAutoCommit(((String)prop.get(connect_auto_commit_string)).equals("true"));
                }
                catch (Exception ea) {
                    if (!bl) break block13;
                    this.debug($$$loggerRef$$$32, Level.FINEST, $$$methodRef$$$32, "OraclePooledConnection : readObject(ObjectInputStream) - Exception Occurred :" + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, this, statementEventListener);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, statementEventListener);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, oracleConnection);
            }
            this.physicalConn = rconn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timeout;
            void superShardingKey;
            void shardingKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, oracleShardingKey, oracleShardingKey2, n2);
            }
            boolean bl2 = this.physicalConn.setShardingKeyIfValid((OracleShardingKey)shardingKey, (OracleShardingKey)superShardingKey, (int)timeout);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setShardingKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void superShardingKey;
            void shardingKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this, oracleShardingKey, oracleShardingKey2);
            }
            this.physicalConn.setShardingKey((OracleShardingKey)shardingKey, (OracleShardingKey)superShardingKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$44 = OraclePooledConnection.class.getDeclaredConstructor(Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OraclePooledConnection.class.getDeclaredConstructor(Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OraclePooledConnection.class.getDeclaredConstructor(String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OraclePooledConnection.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OraclePooledConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OraclePooledConnection.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OraclePooledConnection.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OraclePooledConnection.class.getDeclaredMethod("setShardingKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OraclePooledConnection.class.getDeclaredMethod("setShardingKeyIfValid", OracleShardingKey.class, OracleShardingKey.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OraclePooledConnection.class.getDeclaredMethod("setConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OraclePooledConnection.class.getDeclaredMethod("removeStatementEventListener", StatementEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OraclePooledConnection.class.getDeclaredMethod("addStatementEventListener", StatementEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OraclePooledConnection.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OraclePooledConnection.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OraclePooledConnection.class.getDeclaredMethod("getXAResource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OraclePooledConnection.class.getDeclaredMethod("setProperties", Hashtable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OraclePooledConnection.class.getDeclaredMethod("isStatementCacheInitialized", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OraclePooledConnection.class.getDeclaredMethod("getCallWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OraclePooledConnection.class.getDeclaredMethod("getStatementWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OraclePooledConnection.class.getDeclaredMethod("purgeExplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OraclePooledConnection.class.getDeclaredMethod("purgeImplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OraclePooledConnection.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OraclePooledConnection.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OraclePooledConnection.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OraclePooledConnection.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OraclePooledConnection.class.getDeclaredMethod("getStatementCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OraclePooledConnection.class.getDeclaredMethod("setStatementCacheSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OraclePooledConnection.class.getDeclaredMethod("getStmtCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OraclePooledConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OraclePooledConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OraclePooledConnection.class.getDeclaredMethod("callListener", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OraclePooledConnection.class.getDeclaredMethod("logicalClose", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OraclePooledConnection.class.getDeclaredMethod("logicalClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OraclePooledConnection.class.getDeclaredMethod("removeConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OraclePooledConnection.class.getDeclaredMethod("registerCloseCallback", OracleCloseCallback.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OraclePooledConnection.class.getDeclaredMethod("registerImplicitCacheConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OraclePooledConnection.class.getDeclaredMethod("getLastAccessedTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OraclePooledConnection.class.getDeclaredMethod("setLastAccessedTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OraclePooledConnection.class.getDeclaredMethod("getPhysicalHandle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OraclePooledConnection.class.getDeclaredMethod("getLogicalHandle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OraclePooledConnection.class.getDeclaredMethod("getSystemProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OraclePooledConnection.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OraclePooledConnection.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OraclePooledConnection.class.getDeclaredMethod("addConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OraclePooledConnection.class.getDeclaredMethod("initialize", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

