/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import jdk.net.Sockets;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    private static final int[] SUPPORTED_SOCKET_OPTIONS;
    private static Proxy DEFAULT_SOCKS_PROXY;
    protected final SecuredLogger securedLogger;
    private final String addressInfo;
    private final OracleHostnameResolver hostnameResolver;
    NetStatImpl netStat = null;
    Boolean useNio;
    int port;
    String host;
    String protocol;
    String uri;
    NVNavigator nav;
    NVPair nvpAddr;
    protected SocketChannelWrapper socketChannel;
    Iterator<InetAddress> inetAddresses = null;
    protected Socket socket;
    protected int sockTimeout;
    protected final Properties socketOptions;
    protected Proxy proxy = null;
    protected boolean isRemoteDNS = true;
    protected int connectTimeout = 0;
    SocketFactory sockFactory;
    private volatile boolean isRegisteredEver = false;
    private static Hashtable<String, InetAddress[]> inetaddressesCache;
    private static Hashtable<String, Integer> circularOffsets;
    private static final Monitor CIRCULAR_OFFSETS_MONITOR;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;

    public TcpNTAdapter(String address, @Blind(value=PropertiesBlinder.class) Properties socketOptions, OracleHostnameResolver hostnameResolver) throws NLException {
        this.socketOptions = socketOptions;
        this.addressInfo = address;
        this.hostnameResolver = hostnameResolver;
        this.useNio = Boolean.parseBoolean((String)socketOptions.get(20));
        this.isRemoteDNS = Boolean.parseBoolean((String)socketOptions.getOrDefault((Object)39, "false"));
        this.connectTimeout = Integer.parseInt((String)socketOptions.getOrDefault((Object)2, "0"));
        this.securedLogger = null;
        this.netStat = new NetStatImpl();
        this.initializeAddressValues(address);
        this.initializeProxy();
    }

    private void initializeAddressValues(String address) throws NLException {
        this.nav = new NVNavigator();
        this.nvpAddr = new NVFactory().createNVPair(address);
        NVPair nvpHost = this.nav.findNVPair(this.nvpAddr, "HOST");
        NVPair nvpPort = this.nav.findNVPair(this.nvpAddr, "PORT");
        NVPair nvpProtocol = this.nav.findNVPair(this.nvpAddr, "PROTOCOL");
        if (nvpHost == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nvpHost.getAtom();
        if (nvpPort != null) {
            try {
                this.port = Integer.parseInt(nvpPort.getAtom());
            }
            catch (Exception e2) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(e2);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        if (nvpProtocol != null) {
            this.protocol = nvpProtocol.getAtom();
        }
    }

    protected void initializeProxy() {
        this.proxy = this.socketOptions.containsKey(36) && this.socketOptions.containsKey(37) ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress((String)this.socketOptions.get(36), Integer.parseInt((String)this.socketOptions.get(37)))) : DEFAULT_SOCKS_PROXY;
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        this.sockFactory = new MetricsEnabledSocketFactory(dmsParent);
        if (this.isRemoteDNS && this.proxy != null) {
            this.doRemoteDNSLookupConnect(dmsParent);
        } else {
            this.doLocalDNSLookupConnect(dmsParent);
        }
        this.setSocketOptions();
    }

    protected void doLocalDNSLookupConnect(DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        if (this.inetAddresses == null) {
            this.inetAddresses = this.resolveInetAddresses();
        }
        while (true) {
            InetAddress inet = this.inetAddresses.next();
            try {
                this.establishSocket(new InetSocketAddress(inet, this.port), dmsParent);
            }
            catch (InterruptedIOException interruptException) {
                DownHostsCache.getInstance().markDownHost(inet, this.port);
                throw interruptException;
            }
            catch (IOException ea) {
                DownHostsCache.getInstance().markDownHost(inet, this.port);
                if (this.inetAddresses.hasNext()) continue;
                this.resetInetAddress();
                throw ea;
                if (this.inetAddresses.hasNext()) continue;
            }
            break;
        }
    }

    protected void doRemoteDNSLookupConnect(DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        InetSocketAddress inetAddr = InetSocketAddress.createUnresolved(this.host, this.port);
        this.establishSocket(inetAddr, dmsParent);
    }

    protected void establishSocket(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        long socketConnectStartTime = System.currentTimeMillis();
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel = new TimeoutSocketChannel(inetAddr, this.connectTimeout, this.netStat, this.proxy, this.securedLogger);
                this.socket = this.socketChannel.socket();
            } else {
                this.socket = this.sockFactory.createSocket();
                this.socket.connect(inetAddr, this.connectTimeout);
            }
            this.setReadTimeoutIfRequired(this.socketOptions);
        }
        catch (TimeoutInterruptHandler.IOReadTimeoutException timeoutException) {
            this.trySocketClose();
            throw new IOException(this.describeConnectionFailure(timeoutException, socketConnectStartTime, inetAddr), timeoutException);
        }
        catch (InterruptedIOException interruptException) {
            this.trySocketClose();
            InterruptedIOException describedInterruptException = new InterruptedIOException(this.describeConnectionFailure(interruptException, socketConnectStartTime, inetAddr));
            describedInterruptException.initCause(interruptException);
            throw describedInterruptException;
        }
        catch (IOException ioException) {
            this.trySocketClose();
            throw new IOException(this.describeConnectionFailure(ioException, socketConnectStartTime, inetAddr), ioException);
        }
    }

    private void trySocketClose() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String describeConnectionFailure(IOException connectionError, long connectStartTime, InetSocketAddress inetAddr) {
        return String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", connectionError.getMessage(), System.currentTimeMillis() - connectStartTime, inetAddr.getHostString(), this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.inetAddresses, this.useNio);
    }

    @Override
    public CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with proxies"));
        }
        this.sockFactory = new MetricsEnabledSocketFactory(dmsParent);
        try {
            if (this.inetAddresses == null) {
                this.inetAddresses = this.resolveInetAddresses();
            }
        }
        catch (UnknownHostException unknownHostFailure) {
            return CompletionStageUtil.failedStage(unknownHostFailure);
        }
        return this.chainAsyncConnectionAttempts(outboundTimeout, asyncExecutor).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
            this.setSocketOptions();
            return nil;
        }));
    }

    private final CompletionStage<Void> chainAsyncConnectionAttempts(AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        InetAddress inet = this.inetAddresses.next();
        InetSocketAddress inetAddr = new InetSocketAddress(inet, this.port);
        long socketConnectStartTime = System.currentTimeMillis();
        this.netStat = new NetStatImpl();
        return TimeoutSocketChannel.openAsync(inetAddr, this.connectTimeout, this.netStat, this.securedLogger, outboundTimeout, asyncExecutor).thenApply(CompletionStageUtil.normalCompletionHandler(connectedChannel -> {
            this.socketChannel = connectedChannel;
            this.socket = this.socketChannel.socket();
            this.setReadTimeoutIfRequired(this.socketOptions);
            return true;
        })).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, ea -> {
            this.trySocketClose();
            DownHostsCache.getInstance().markDownHost(inet, this.port);
            if (this.inetAddresses.hasNext()) {
                return false;
            }
            String newExMessage = this.describeConnectionFailure((IOException)ea, socketConnectStartTime, inetAddr);
            this.resetInetAddress();
            IOException newEx = new IOException(newExMessage, ea);
            throw newEx;
        })).thenCompose(isConnected -> isConnected != false ? CompletionStageUtil.VOID_COMPLETED_FUTURE : this.chainAsyncConnectionAttempts(outboundTimeout, asyncExecutor));
    }

    protected final Iterator<InetAddress> resolveInetAddresses() throws UnknownHostException {
        InetAddress[] resolvedAddresses = null;
        resolvedAddresses = this.hostnameResolver != null ? this.hostnameResolver.getAllByName(this.host) : InetAddress.getAllByName(this.host);
        boolean forceDNSLoadBalancing = Boolean.parseBoolean((String)this.socketOptions.get(18));
        if (forceDNSLoadBalancing && resolvedAddresses.length > 1) {
            resolvedAddresses = TcpNTAdapter.getAddressesInCircularOrder(this.host, resolvedAddresses);
        }
        DownHostsCache.getInstance().reorderAddresses(resolvedAddresses, this.port);
        return new InetAddressIterator(resolvedAddresses);
    }

    @Override
    public final boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.inetAddresses.hasNext();
    }

    @Override
    public final void resetInetAddress() {
        this.inetAddresses = null;
    }

    @Override
    public NetStat getNetStat() {
        return this.netStat;
    }

    final void setSocketOptions() throws IOException {
        for (int option : SUPPORTED_SOCKET_OPTIONS) {
            Integer key = option;
            String value = (String)this.socketOptions.get(key);
            if (value == null) continue;
            this.setOption(option, value);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel.disconnect();
            } else if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (option) {
            case 0: {
                this.setTcpNoDelay((String)value);
                break;
            }
            case 1: {
                this.setTcpKeepAlive((String)value);
                break;
            }
            case 3: 
            case 101: {
                this.setTcpReadTimeout((String)value);
                break;
            }
            case 33: {
                this.setTcpKeepAliveIdleTime((String)value);
                break;
            }
            case 34: {
                this.setTcpKeepAliveProbeInterval((String)value);
                break;
            }
            case 35: {
                this.setTcpKeepAliveProbeCount((String)value);
                break;
            }
        }
    }

    private final void setTcpNoDelay(String setting) throws IOException {
        this.socket.setTcpNoDelay(setting.equals("YES"));
    }

    private final void setTcpKeepAlive(String setting) throws IOException {
        if (setting.equals("YES")) {
            this.socket.setKeepAlive(true);
        }
    }

    private final void setTcpReadTimeout(String timeoutMillis) throws IOException {
        this.sockTimeout = Integer.parseInt(timeoutMillis);
        if (!this.useNio.booleanValue()) {
            this.socket.setSoTimeout(this.sockTimeout);
        } else {
            this.socketChannel.setSoTimeout(this.sockTimeout);
        }
    }

    private final void setTcpKeepAliveIdleTime(String idleTimeSeconds) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPIDLE", Integer.class), Integer.valueOf(idleTimeSeconds));
    }

    private final void setTcpKeepAliveProbeInterval(String intervalSeconds) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPINTERVAL", Integer.class), Integer.valueOf(intervalSeconds));
    }

    private final void setTcpKeepAliveProbeCount(String count) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPCOUNT", Integer.class), Integer.valueOf(count));
    }

    private final <T> SocketOption<T> getSocketOptionByNameAndType(String name, Class<T> type) throws IOException {
        Set<SocketOption<?>> supportedOptions = this.useNio != false ? this.socketChannel.supportedOptions() : Sockets.supportedOptions(this.socket.getClass());
        SocketOption namedOption = supportedOptions.stream().filter(option -> name.equals(option.name())).findFirst().orElseThrow(() -> new IOException("Socket option " + name + " is not supported by SocketChannels opened in this JVM"));
        if (!namedOption.type().equals(type)) {
            throw new IOException("Unexpected type for socket option " + name + ". SocketOption.type() to returns " + namedOption.type() + " Expected type is: " + type);
        }
        return namedOption;
    }

    private final <T> void setSocketOption(SocketOption<T> option, T value) throws IOException {
        if (this.useNio.booleanValue()) {
            this.socketChannel.setOption((SocketOption)option, (Object)value);
        } else {
            Sockets.setOption(this.socket, option, value);
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (option) {
            case 101: {
                return "" + this.sockTimeout;
            }
            case 3: {
                if (!this.useNio.booleanValue()) {
                    return Integer.toString(this.socket.getSoTimeout());
                }
                return this.socketChannel.getSoTimeout();
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket != null) {
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket.close();
        }
        this.abortTcpMultiplexerRegistration();
    }

    private final void abortTcpMultiplexerRegistration() {
        if (!this.useNio.booleanValue()) {
            return;
        }
        if (this.socketChannel == null) {
            return;
        }
        if (!this.isRegisteredEver) {
            return;
        }
        this.cancelNonBlockingRegistration(new IOException("Connection aborted"));
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties prop) throws IOException, NetException {
        String tmp = (String)prop.get("oracle.net.READ_TIMEOUT");
        if (tmp == null) {
            tmp = (String)prop.get(3);
        }
        if (tmp == null) {
            tmp = "0";
        }
        this.setOption(3, tmp);
    }

    public String getAddressInfo() {
        return this.addressInfo;
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    static final InetAddress[] getAddressesInCircularOrder(String hostname, InetAddress[] inetAddressesFromJVM) {
        try (Monitor.CloseableLock lock = CIRCULAR_OFFSETS_MONITOR.acquireCloseableLock();){
            InetAddress[] cachedAddresses = inetaddressesCache.get(hostname);
            Integer offset = circularOffsets.get(hostname);
            if (cachedAddresses == null || !TcpNTAdapter.areEquals(cachedAddresses, inetAddressesFromJVM)) {
                offset = new Integer(0);
                cachedAddresses = inetAddressesFromJVM;
                inetaddressesCache.put(hostname, inetAddressesFromJVM);
                circularOffsets.put(hostname, offset);
            }
            InetAddress[] addrb = TcpNTAdapter.getCopyAddresses(cachedAddresses, offset);
            circularOffsets.put(hostname, new Integer((offset + 1) % cachedAddresses.length));
            InetAddress[] inetAddressArray = addrb;
            return inetAddressArray;
        }
    }

    private static final boolean areEquals(InetAddress[] add1, InetAddress[] add2) {
        if (add1.length != add2.length) {
            return false;
        }
        for (int i2 = 0; i2 < add1.length; ++i2) {
            if (add1[i2].equals(add2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] add, int nbOfRotation) {
        InetAddress[] addcp = new InetAddress[add.length];
        for (int i2 = 0; i2 < add.length; ++i2) {
            addcp[i2] = add[(i2 + nbOfRotation) % add.length];
        }
        return addcp;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCP;
    }

    @Override
    public final void registerForNonBlockingRead(Consumer<Throwable> onReady) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingRead(onReady);
    }

    @Override
    public final void registerForNonBlockingWrite(Consumer<Throwable> onReady) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingWrite(onReady);
    }

    @Override
    public final void cancelNonBlockingRegistration(Throwable onReadyError) {
        TcpMultiplexer.cancelRegistration(this.socketChannel.getUnderlyingChannel(), onReadyError);
    }

    @Override
    @Blind
    public Properties getSqlNetOptions() {
        return (Properties)this.socketOptions.clone();
    }

    static {
        try {
            $$$methodRef$$$52 = TcpNTAdapter.class.getDeclaredConstructor(String.class, Properties.class, OracleHostnameResolver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = TcpNTAdapter.class.getDeclaredMethod("lambda$connectAsync$0", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = TcpNTAdapter.class.getDeclaredMethod("lambda$chainAsyncConnectionAttempts$1", TimeoutSocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = TcpNTAdapter.class.getDeclaredMethod("lambda$chainAsyncConnectionAttempts$2", InetAddress.class, Long.TYPE, InetSocketAddress.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = TcpNTAdapter.class.getDeclaredMethod("lambda$chainAsyncConnectionAttempts$3", AsyncOutboundTimeoutHandler.class, Executor.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = TcpNTAdapter.class.getDeclaredMethod("lambda$getSocketOptionByNameAndType$4", String.class, SocketOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = TcpNTAdapter.class.getDeclaredMethod("lambda$getSocketOptionByNameAndType$5", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = TcpNTAdapter.class.getDeclaredMethod("getSqlNetOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = TcpNTAdapter.class.getDeclaredMethod("cancelNonBlockingRegistration", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = TcpNTAdapter.class.getDeclaredMethod("registerForNonBlockingWrite", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = TcpNTAdapter.class.getDeclaredMethod("registerForNonBlockingRead", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = TcpNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = TcpNTAdapter.class.getDeclaredMethod("getSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = TcpNTAdapter.class.getDeclaredMethod("getInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = TcpNTAdapter.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = TcpNTAdapter.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = TcpNTAdapter.class.getDeclaredMethod("getCopyAddresses", InetAddress[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = TcpNTAdapter.class.getDeclaredMethod("areEquals", InetAddress[].class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = TcpNTAdapter.class.getDeclaredMethod("getAddressesInCircularOrder", String.class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = TcpNTAdapter.class.getDeclaredMethod("getAddressInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = TcpNTAdapter.class.getDeclaredMethod("setReadTimeoutIfRequired", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = TcpNTAdapter.class.getDeclaredMethod("isCharacteristicUrgentSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = TcpNTAdapter.class.getDeclaredMethod("sendUrgentByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = TcpNTAdapter.class.getDeclaredMethod("abortTcpMultiplexerRegistration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = TcpNTAdapter.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = TcpNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = TcpNTAdapter.class.getDeclaredMethod("setSocketOption", SocketOption.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = TcpNTAdapter.class.getDeclaredMethod("getSocketOptionByNameAndType", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAliveProbeCount", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAliveProbeInterval", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAliveIdleTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TcpNTAdapter.class.getDeclaredMethod("setTcpReadTimeout", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TcpNTAdapter.class.getDeclaredMethod("setTcpKeepAlive", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TcpNTAdapter.class.getDeclaredMethod("setTcpNoDelay", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TcpNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TcpNTAdapter.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpNTAdapter.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpNTAdapter.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpNTAdapter.class.getDeclaredMethod("setSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpNTAdapter.class.getDeclaredMethod("getNetStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpNTAdapter.class.getDeclaredMethod("resetInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpNTAdapter.class.getDeclaredMethod("hasMoreInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpNTAdapter.class.getDeclaredMethod("resolveInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpNTAdapter.class.getDeclaredMethod("chainAsyncConnectionAttempts", AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpNTAdapter.class.getDeclaredMethod("connectAsync", DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpNTAdapter.class.getDeclaredMethod("describeConnectionFailure", IOException.class, Long.TYPE, InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpNTAdapter.class.getDeclaredMethod("trySocketClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpNTAdapter.class.getDeclaredMethod("establishSocket", InetSocketAddress.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpNTAdapter.class.getDeclaredMethod("doRemoteDNSLookupConnect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpNTAdapter.class.getDeclaredMethod("doLocalDNSLookupConnect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpNTAdapter.class.getDeclaredMethod("connect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpNTAdapter.class.getDeclaredMethod("initializeProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpNTAdapter.class.getDeclaredMethod("initializeAddressValues", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        SUPPORTED_SOCKET_OPTIONS = new int[]{0, 1, 33, 34, 35};
        DEFAULT_SOCKS_PROXY = null;
        try {
            String globalProxyHost = System.getProperty("socksProxyHost", null);
            if (globalProxyHost != null) {
                DEFAULT_SOCKS_PROXY = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(globalProxyHost, Integer.parseInt(System.getProperty("socksProxyPort", "1080"))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        inetaddressesCache = new Hashtable();
        circularOffsets = new Hashtable();
        CIRCULAR_OFFSETS_MONITOR = Monitor.newInstance();
    }

    private final class InetAddressIterator
    implements Iterator<InetAddress> {
        private final InetAddress[] addresses;
        private int addressIndex = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        private InetAddressIterator(InetAddress[] addresses) {
            this.addresses = addresses;
        }

        @Override
        public boolean hasNext() {
            return this.addressIndex < this.addresses.length;
        }

        @Override
        public InetAddress next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.addresses[this.addressIndex++];
        }

        public String toString() {
            return "(" + this.addressIndex + "/" + this.addresses.length + ")";
        }

        static {
            try {
                $$$methodRef$$$4 = InetAddressIterator.class.getDeclaredConstructor(TcpNTAdapter.class, InetAddress[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = InetAddressIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = InetAddressIterator.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InetAddressIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InetAddressIterator.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

