/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.ProxyHelper;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;
    private final SecuredLogger securedLogger;
    private final Proxy proxy;
    private final InetSocketAddress serverAddress;
    private volatile boolean isTimeoutExpired = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    private TimeoutSocketChannel(InetSocketAddress serverAddress, NetStatImpl netStat, Proxy proxy, SecuredLogger securedLogger) {
        super((SocketChannel)null);
        this.serverAddress = serverAddress;
        this.securedLogger = securedLogger;
        this.netStat = netStat;
        this.proxy = proxy;
    }

    public TimeoutSocketChannel(InetSocketAddress serverAddress, int connectTimeout, NetStatImpl netStat, Proxy proxy, SecuredLogger securedLogger) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this(serverAddress, netStat, proxy, securedLogger);
        this.connect(serverAddress, connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(InetSocketAddress socketAddress, int connectTimeout) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this.scheduleInterrupt(connectTimeout, false);
        try {
            if (this.proxy == null) {
                this.socketChannel = SocketChannel.open(socketAddress);
            } else {
                this.socketChannel = SocketChannel.open(this.proxy.address());
                ProxyHelper.connectViaProxy(this.proxy, this.serverAddress, this.socketChannel);
            }
            this.socketChannel.configureBlocking(true);
        }
        catch (ClosedByInterruptException e2) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
    }

    static CompletionStage<TimeoutSocketChannel> openAsync(InetSocketAddress serverAddress, int connectTimeout, NetStatImpl netStat, SecuredLogger securedLogger, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        TimeoutSocketChannel newChannel = new TimeoutSocketChannel(serverAddress, netStat, null, securedLogger);
        return newChannel.connectAsync(connectTimeout, outboundTimeout, asyncExecutor).thenApply(nil -> newChannel);
    }

    private final CompletionStage<Void> connectAsync(int connectTimeout, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous proxy connection is not supported"));
        }
        try {
            SocketChannel newChannel = SocketChannel.open();
            outboundTimeout.setChannel(newChannel);
            this.socketChannel = newChannel;
            this.socketChannel.configureBlocking(false);
            if (this.socketChannel.connect(this.serverAddress)) {
                this.socketChannel.configureBlocking(true);
                return CompletionStageUtil.completedStage(null);
            }
        }
        catch (IOException initializationFailure) {
            return CompletionStageUtil.failedStage(initializationFailure);
        }
        AsyncConnectTask connectTask = new AsyncConnectTask(asyncExecutor);
        connectTask.start();
        CompletionStage<Void> connectStage = connectTask.getConnectStage();
        if (connectTimeout > 0) {
            TimerTask keyCancellingTask = TimeoutInterruptHandler.scheduleTask(() -> connectTask.setTimeoutExpired(), connectTimeout);
            return connectStage.whenComplete((nil, err) -> keyCancellingTask.cancel());
        }
        return connectStage;
    }

    void setNetStat(NetStatImpl netStat) {
        this.netStat = netStat;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), true);
        int read = -1;
        try {
            read = this.socketChannel.read(dst);
            if (this.netStat != null) {
                this.netStat.incrementBytesReceived(read);
            }
        }
        catch (ClosedByInterruptException ce) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), false);
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int writeBytes = this.socketChannel.write(src);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(writeBytes);
            }
            int n2 = writeBytes;
            return n2;
        }
        catch (ClosedByInterruptException e2) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    private void scheduleInterrupt(int timeout, boolean enableInterruptAttn) {
        if (timeout > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, timeout, Thread.currentThread(), this, enableInterruptAttn);
        }
    }

    private final void interruptNow(boolean enableInterruptAttn) {
        this.interruptTask = enableInterruptAttn ? new TimeoutInterruptHandler.InterruptTask(Thread.currentThread(), Integer.MAX_VALUE, this) : new TimeoutInterruptHandler.InterruptTask(Thread.currentThread(), Integer.MAX_VALUE, null);
        this.interruptTask.run();
    }

    private void handleInterrupt() throws InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
        }
        throw new InterruptedIOException("Socket read interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    @Override
    final void registerForNonBlockingRead(Consumer<Throwable> onReadReady) throws IOException {
        if (this.soTimeout > 0) {
            AtomicBoolean isRegistered = new AtomicBoolean(false);
            TimerTask cancelTask = this.scheduleRegistrationCancel(isRegistered);
            try {
                TcpMultiplexer.registerForReadEvent(this.socketChannel, err -> {
                    cancelTask.cancel();
                    onReadReady.accept((Throwable)err);
                });
                isRegistered.set(true);
            }
            catch (IOException registrationException) {
                cancelTask.cancel();
                throw registrationException;
            }
        } else {
            TcpMultiplexer.registerForReadEvent(this.socketChannel, onReadReady);
        }
    }

    @Override
    final void registerForNonBlockingWrite(Consumer<Throwable> onWriteReady) throws IOException {
        if (this.soTimeout > 0) {
            AtomicBoolean isRegistered = new AtomicBoolean(false);
            TimerTask cancelTask = this.scheduleRegistrationCancel(isRegistered);
            try {
                TcpMultiplexer.registerForWriteEvent(this.socketChannel, err -> {
                    cancelTask.cancel();
                    onWriteReady.accept((Throwable)err);
                });
                isRegistered.set(true);
            }
            catch (IOException registrationException) {
                cancelTask.cancel();
                throw registrationException;
            }
        } else {
            TcpMultiplexer.registerForWriteEvent(this.socketChannel, onWriteReady);
        }
    }

    private TimerTask scheduleRegistrationCancel(AtomicBoolean isRegistered) {
        return TimeoutInterruptHandler.scheduleTask(() -> {
            while (!isRegistered.get() && !Thread.currentThread().isInterrupted()) {
            }
            this.isTimeoutExpired = true;
            TcpMultiplexer.cancelRegistration(this.socketChannel, null);
        }, this.soTimeout);
    }

    static {
        try {
            $$$methodRef$$$26 = TimeoutSocketChannel.class.getDeclaredConstructor(InetSocketAddress.class, Integer.TYPE, NetStatImpl.class, Proxy.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = TimeoutSocketChannel.class.getDeclaredConstructor(InetSocketAddress.class, NetStatImpl.class, Proxy.class, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$openAsync$0", TimeoutSocketChannel.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$connectAsync$1", AsyncConnectTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$connectAsync$2", TimerTask.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$registerForNonBlockingRead$3", TimerTask.class, Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$registerForNonBlockingWrite$4", TimerTask.class, Consumer.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TimeoutSocketChannel.class.getDeclaredMethod("lambda$scheduleRegistrationCancel$5", AtomicBoolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TimeoutSocketChannel.class.getDeclaredMethod("scheduleRegistrationCancel", AtomicBoolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TimeoutSocketChannel.class.getDeclaredMethod("registerForNonBlockingWrite", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TimeoutSocketChannel.class.getDeclaredMethod("registerForNonBlockingRead", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TimeoutSocketChannel.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimeoutSocketChannel.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimeoutSocketChannel.class.getDeclaredMethod("handleInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimeoutSocketChannel.class.getDeclaredMethod("interruptNow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimeoutSocketChannel.class.getDeclaredMethod("scheduleInterrupt", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimeoutSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimeoutSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimeoutSocketChannel.class.getDeclaredMethod("getSoTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimeoutSocketChannel.class.getDeclaredMethod("setSoTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimeoutSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimeoutSocketChannel.class.getDeclaredMethod("setNetStat", NetStatImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimeoutSocketChannel.class.getDeclaredMethod("connectAsync", Integer.TYPE, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimeoutSocketChannel.class.getDeclaredMethod("openAsync", InetSocketAddress.class, Integer.TYPE, NetStatImpl.class, SecuredLogger.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimeoutSocketChannel.class.getDeclaredMethod("connect", InetSocketAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private class AsyncConnectTask
    implements Consumer<Throwable> {
        private final Executor asyncExecutor;
        private final Monitor cancellationLock = Monitor.newInstance();
        private final CompletableFuture<Void> connectFuture = new CompletableFuture();
        private boolean isTimeoutExpired = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        private AsyncConnectTask(Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
        }

        private void start() {
            try {
                TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
            }
            catch (IOException registrationFailure) {
                this.connectFuture.completeExceptionally(registrationFailure);
            }
        }

        @Override
        public void accept(Throwable err) {
            this.asyncExecutor.execute(() -> this.handleReadiness(err));
        }

        private final void handleReadiness(Throwable err) {
            try (Monitor.CloseableLock lock = this.cancellationLock.acquireCloseableLock();){
                if (err != null) {
                    this.connectFuture.completeExceptionally(err);
                } else if (!this.isTimeoutExpired) {
                    TimeoutSocketChannel.this.socketChannel.configureBlocking(false);
                    if (TimeoutSocketChannel.this.socketChannel.finishConnect()) {
                        TimeoutSocketChannel.this.socketChannel.configureBlocking(true);
                        this.connectFuture.complete(null);
                    } else {
                        TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
                    }
                }
            }
            catch (IOException connectFailure) {
                this.connectFuture.completeExceptionally(connectFailure);
            }
        }

        private final void setTimeoutExpired() {
            this.isTimeoutExpired = true;
            try (Monitor.CloseableLock lock = this.cancellationLock.acquireCloseableLock();){
                TimeoutInterruptHandler.IOReadTimeoutException timeoutException = new TimeoutInterruptHandler.IOReadTimeoutException("Socket connect timed out");
                this.asyncExecutor.execute(() -> this.connectFuture.completeExceptionally(timeoutException));
                try {
                    TcpMultiplexer.cancelRegistration(TimeoutSocketChannel.this.socketChannel, timeoutException);
                    TimeoutSocketChannel.this.socketChannel.close();
                }
                catch (IOException closeException) {
                    this.connectFuture.completeExceptionally(timeoutException);
                }
            }
        }

        private final CompletionStage<Void> getConnectStage() {
            return this.connectFuture;
        }

        static {
            try {
                $$$methodRef$$$8 = AsyncConnectTask.class.getDeclaredConstructor(TimeoutSocketChannel.class, Executor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = AsyncConnectTask.class.getDeclaredMethod("lambda$accept$0", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = AsyncConnectTask.class.getDeclaredMethod("lambda$setTimeoutExpired$1", TimeoutInterruptHandler.IOReadTimeoutException.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = AsyncConnectTask.class.getDeclaredMethod("accept", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = AsyncConnectTask.class.getDeclaredMethod("getConnectStage", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = AsyncConnectTask.class.getDeclaredMethod("setTimeoutExpired", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = AsyncConnectTask.class.getDeclaredMethod("handleReadiness", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AsyncConnectTask.class.getDeclaredMethod("accept", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AsyncConnectTask.class.getDeclaredMethod("start", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

